-- File: tkz_elements_functions_vectors.lua
-- Copyright (c) 2026 Alain Matthes
-- SPDX-License-Identifier: LPPL-1.3c
-- Maintainer: Alain Matthes


function scale_(v, d)
	return v.tail + point(d * v.norm * math.cos(v.slope), d * v.norm * math.sin(v.slope))
end

-- Retourne la nouvelle TÊTE du vecteur, pas le vecteur scalaire
function scaled_head_(v, d)
	return v.tail + d * (v.head - v.tail)
end

