/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterManager;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.util.ImageParameters;

public class PDInlinedImage {
    private static final Log LOG = LogFactory.getLog(PDInlinedImage.class);
    private ImageParameters params;
    private byte[] imageData;

    public ImageParameters getImageParameters() {
        return this.params;
    }

    public void setImageParameters(ImageParameters imageParams) {
        this.params = imageParams;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] value) {
        this.imageData = value;
    }

    public BufferedImage createImage() throws IOException {
        return this.createImage(null);
    }

    public BufferedImage createImage(Map colorSpaces) throws IOException {
        DataBuffer byteBuffer;
        byte[] finalData;
        List filters;
        COSArray decode;
        ColorModel colorModel;
        PDColorSpace pcs = this.params.getColorSpace(colorSpaces);
        if (pcs != null) {
            colorModel = pcs.createColorModel(this.params.getBitsPerComponent());
        } else {
            byte[] transparentColors = new byte[]{-1, -1};
            byte[] colors = new byte[]{0, -1};
            colorModel = new IndexColorModel(1, 2, colors, colors, colors, transparentColors);
        }
        boolean invert = false;
        COSBase dictObj = this.params.getDictionary().getDictionaryObject(COSName.DECODE, COSName.D);
        if (dictObj != null && dictObj instanceof COSArray && (decode = (COSArray)dictObj).getInt(0) == 1) {
            if (this.params.getBitsPerComponent() == 1) {
                invert = true;
            } else {
                LOG.warn((Object)"decode array is not implemented for BPC > 1");
            }
        }
        if ((filters = this.params.getFilters()) == null || filters.isEmpty()) {
            finalData = this.getImageData();
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(this.getImageData());
            ByteArrayOutputStream out = new ByteArrayOutputStream(this.getImageData().length);
            FilterManager filterManager = new FilterManager();
            for (int i = 0; i < filters.size(); ++i) {
                out.reset();
                Filter filter = filterManager.getFilter((String)filters.get(i));
                filter.decode(in, out, this.params.getDictionary(), i);
                in = new ByteArrayInputStream(out.toByteArray());
            }
            finalData = out.toByteArray();
        }
        WritableRaster raster = colorModel.createCompatibleWritableRaster(this.params.getWidth(), this.params.getHeight());
        DataBuffer rasterBuffer = raster.getDataBuffer();
        if (rasterBuffer instanceof DataBufferByte) {
            byteBuffer = (DataBufferByte)rasterBuffer;
            byte[] data = ((DataBufferByte)byteBuffer).getData();
            System.arraycopy(finalData, 0, data, 0, data.length);
            if (invert) {
                this.invertBitmap(data);
            }
        } else if (rasterBuffer instanceof DataBufferInt) {
            byteBuffer = (DataBufferInt)rasterBuffer;
            int[] data = ((DataBufferInt)byteBuffer).getData();
            for (int i = 0; i < finalData.length; ++i) {
                data[i] = (finalData[i] + 256) % 256;
                if (!invert) continue;
                data[i] = ~data[i] & 0xFF;
            }
        }
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        image.setData(raster);
        return image;
    }

    private void invertBitmap(byte[] bufferData) {
        int c = bufferData.length;
        for (int i = 0; i < c; ++i) {
            bufferData[i] = (byte)(~bufferData[i] & 0xFF);
        }
    }
}

