%%
%% This is file `deutschesmuseum.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% deutschesmuseum.dtx  (with options: `class')
%% 
%% IMPORTANT NOTICE:
%% 
%% For the copyright see the source file.
%% 
%% Any modified versions of this file must be renamed
%% with new filenames distinct from deutschesmuseum.cls.
%% 
%% For distribution of the original source see the terms
%% for copying and modification in the file deutschesmuseum.dtx.
%% 
%% This generated file may be distributed as long as the
%% original source files, as listed above, are part of the
%% same distribution. (The sources need not necessarily be
%% in the same archive or directory.)
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{deutschesmuseum}
[2026/02/04 v1.7 Typesetting books for Deutsches Museum]
\newif\ifdeutschesmuseum@cfonts
\deutschesmuseum@cfontstrue
\DeclareOption{cfonts}{\deutschesmuseum@cfontstrue}
\DeclareOption{nocfonts}{\deutschesmuseum@cfontsfalse}
\newif\ifdeutschesmuseum@garamondmath
\deutschesmuseum@garamondmathtrue
\DeclareOption{garamondmath}{\deutschesmuseum@garamondmathtrue}
\DeclareOption{nogaramondmath}{\deutschesmuseum@garamondmathfalse}
\newif\ifdeutschesmuseum@folios
\deutschesmuseum@foliosfalse
\DeclareOption{folios}{\deutschesmuseum@foliostrue}
\DeclareOption{nofolios}{\deutschesmuseum@foliosfalse}
\long\def\deutschesmuseum@size@warning#1{%
  \ClassWarning{deutschesmuseum}{Size-changing option #1 will not be
    honored}}%
\DeclareOption{8pt}{\deutschesmuseum@size@warning{\CurrentOption}}%
\DeclareOption{9pt}{\deutschesmuseum@size@warning{\CurrentOption}}%
\DeclareOption{10pt}{\deutschesmuseum@size@warning{\CurrentOption}}%
\DeclareOption{11pt}{\deutschesmuseum@size@warning{\CurrentOption}}%
\DeclareOption{12pt}{\deutschesmuseum@size@warning{\CurrentOption}}%
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{amsart}}
\ProcessOptions\relax
\LoadClass{amsart}
\RequirePackage[breaklinks,colorlinks,linkcolor=black,citecolor=black,
pagecolor=black,urlcolor=black,hyperindex=false]{hyperref}
\RequirePackage{multicol}
\usepackage{fontspec}
\ifdeutschesmuseum@cfonts
  \setmainfont{GaramondBQ}[
  Extension = .otf,
  UprightFont = *-Regular,
  BoldFont    = *-Bold,
  ItalicFont  = *-Italic,
  BoldItalicFont = *-MediumItalic]
  \newfontfamily\FuturaPTLight{futura-pt_light}[
  Extension = .otf,
  UprightFont = *,
  ItalicFont = *-oblique,
  BoldFont = futura-pt_medium,
  BoldItalicFont = futura-pt_medium-oblique]
  \newfontfamily\FuturaPTMedium{futura-pt_medium}[
  Extension = .otf,
  UprightFont = *,
  ItalicFont = *-oblique]
  \newfontfamily\FuturaPTCondMedium{futura-pt_cond-medium}[
  Extension = .otf,
  UprightFont = *,
  ItalicFont = *-oblique]
  \newcommand{\foliofont}{\FuturaPTLight\fontsize{9pt}{11pt}\selectfont}
  \newcommand{\hIfont}{\FuturaPTCondMedium\fontsize{14pt}{16pt}\selectfont}
  \newcommand{\hIIfont}{\FuturaPTCondMedium\fontsize{12.5pt}{12pt}\selectfont}
  \newcommand{\hIIIfont}{\FuturaPTCondMedium\fontsize{12.5pt}{12pt}\selectfont}
  \newcommand{\hIVfont}{\FuturaPTCondMedium\fontsize{11pt}{12pt}\selectfont}
  \newcommand{\fnmarkfont}{\FuturaPTMedium\fontsize{10pt}{11pt}\selectfont}
  \newcommand{\fnmarktextfont}{\FuturaPTMedium\fontsize{8pt}{10pt}\selectfont}
  \newcommand{\fnfont}{\FuturaPTLight\fontsize{8pt}{10pt}\selectfont}
\else
  \setmainfont{EBGaramond}[
  Extension = .otf,
  UprightFont = *-Regular,
  BoldFont    = *-Bold,
  ItalicFont  = *-Italic,
  BoldItalicFont = *-BoldItalic]
  \newfontfamily\LatoLight{Lato-Light}[
  Extension = .ttf,
  UprightFont = *,
  ItalicFont = *Italic,
  BoldFont = Lato-Medium,
  BoldItalicFont = Lato-MediumItalic]
  \newfontfamily\LatoMedium{Lato-Medium}[
  Extension = .ttf,
  UprightFont = *,
  ItalicFont = *Italic]
  \newcommand{\foliofont}{\LatoLight\fontsize{9pt}{11pt}\selectfont}
  \newcommand{\hIfont}{\LatoMedium\fontsize{14pt}{16pt}\selectfont}
  \newcommand{\hIIfont}{\LatoMedium\fontsize{12.5pt}{12pt}\selectfont}
  \newcommand{\hIIIfont}{\LatoMedium\fontsize{11pt}{12pt}\selectfont}
  \newcommand{\hIVfont}{\LatoMedium\fontsize{10pt}{12pt}\selectfont}
  \newcommand{\fnmarkfont}{\LatoMedium\fontsize{10pt}{11pt}\selectfont}
  \newcommand{\fnmarktextfont}{\LatoMedium\fontsize{8pt}{10pt}\selectfont}
  \newcommand{\fnfont}{\LatoLight\fontsize{8pt}{10pt}\selectfont}
\fi
\let\bibfont\fnfont
\ifdeutschesmuseum@garamondmath
  \RequirePackage[math-style=ISO, bold-style=ISO]{unicode-math}
  \setmathfont{Garamond-Math.otf}[StylisticSet={7,9}]
\else
  \RequirePackage{amssymb}
\fi
 \def\@typesizes{%
    \or{5}{6}\or{5}{6}\or{6}{7}\or{7}{8}\or{8}{10}%
    \or{9.25}{11}% normalsize
    \or{10}{12}\or{\@xipt}{13}\or{\@xiipt}{14}%
    \or{\@xivpt}{17}\or{\@xviipt}{20}}%
  \normalsize \linespacing=\baselineskip
\usepackage[paperwidth=155mm, paperheight=220mm, includeheadfoot,
headheight=15pt, headsep=0.35in,
inner=20mm, outer=17mm, top=8.3mm, bottom=14.1mm]{geometry}
\setlength\parskip{0pt}
\setlength\parindent{5mm}
\renewcommand{\arraystretch}{0.9}
\renewenvironment{quotation}{\list{}{%
    \leftmargin5mm \listparindent\normalparindent
    \itemindent\z@
    \rightmargin\leftmargin \parsep\z@ \@plus\p@}%
  \item[]%
}{%
  \vspace\baselineskip
  \endlist
}
\let\endquotation=\endlist % for efficiency
\renewenvironment{quote}{%
  \list{}{\rightmargin5mm\leftmargin\rightmargin}\item[]%
}{%
  \vspace\baselineskip
  \endlist
}
\RequirePackage{xcolor}
\definecolor{DeutschesMuseumRed}{cmyk}{0.36,0.87,0.61,0.33}
\newcommand\subtitle[1]{\def\@subtitle{#1}\def\shorttitle{#1}}
\subtitle{}
\renewcommand\maketitle{%
  \@afterindentfalse
  \ifx\@empty\shortauthors \let\shortauthors\shorttitle
  \else \andify\shortauthors
  \fi
  \par
  \@topnum\z@ % this prevents figures from falling at the top of page
  \thispagestyle{firstpage}%
  \ifx\@title\@empty
  \else{\noindent\color{DeutschesMuseumRed}\hIfont\@title\par}\fi
  \ifx\@subtitle\@empty\else
     {\vspace\baselineskip\noindent\hIIfont\@subtitle\par}%
  \fi
  {\noindent\author@andify\authors\normalsize\normalfont\itshape\authors\vspace\baselineskip\par}%
  \@afterheading
}
\renewenvironment{abstract}{\par\vspace{2.5ex}\section*{\abstractname}}{}
\renewcommand\section{%
  \@startsection{section}{1}{\z@}{-2\baselineskip}{\baselineskip}{\hIIIfont}}
\renewcommand\subsection{%
  \@startsection{subsection}{2}{\z@}{-\baselineskip}{1sp}{\hIVfont}}
\def\footnoterule{}
\def\@makefnmark{\textsuperscript{{\color{DeutschesMuseumRed}\fnmarktextfont\@thefnmark}}}
\def\@makefntext{{\color{DeutschesMuseumRed}\fnmarktextfont\@thefnmark}\quad
  \fnfont}
\RequirePackage{fancyhdr}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
\fancypagestyle{firstpage}{\fancyhf{}%
  \fancyhead[RO]{\ifdeutschesmuseum@folios\foliofont\thepage\fi}%
  \fancyhead[LE]{\ifdeutschesmuseum@folios\foliofont\thepage\fi}%
}
\fancypagestyle{standard}{%
  \fancyhf{}%
  \fancyhead[RO]{\ifdeutschesmuseum@folios\foliofont\shorttitle\quad\thepage\fi}%
  \fancyhead[LE]{\ifdeutschesmuseum@folios\foliofont\thepage\quad\shortauthors\fi}%
}
\RequirePackage{caption}
\DeclareCaptionFont{capfont}{\foliofont}
\captionsetup{font=capfont, textfont=capfont,
labelfont={capfont,bf}, labelsep=quad, justification=centering}
\captionsetup[figure]{name=Fig.}
\captionsetup[table]{name=Table, position=top}
\RequirePackage{natbib}
\RenewDocumentCommand{\cite}{O{}O{}m}{\footnote{\citealt[#1][#2]{#3}}}
\renewcommand\bibsection{}
\renewcommand\refname{Bibliography}
\def\bibpreamble{\setlength\multicolsep{\z@}\begin{multicols}{2}[\section*{\refname}]}
\def\bibcleanup{\vskip-\lastskip\end{multicols}}%
\pagestyle{standard}
\normalsize
\normalfont
\endinput
%%
%% End of file `deutschesmuseum.cls'.
