/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/ajalt/mordant/terminal/PrintTerminalCursor;", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "(Lcom/github/ajalt/mordant/terminal/Terminal;)V", "clearScreen", "", "clearScreenAfterCursor", "csi", "command", "", "down", "count", "", "hide", "showOnExit", "", "left", "print", "text", "right", "setPosition", "x", "y", "show", "startOfLine", "up", "mordant"})
public final class PrintTerminalCursor
implements TerminalCursor {
    private final Terminal terminal;

    @Override
    public void up(int count) {
        block1: {
            block0: {
                if (count >= 0) break block0;
                this.down(-count);
                break block1;
            }
            if (count <= 0) break block1;
            this.csi("" + count + 'A');
        }
    }

    @Override
    public void down(int count) {
        block1: {
            block0: {
                if (count >= 0) break block0;
                this.up(-count);
                break block1;
            }
            if (count <= 0) break block1;
            this.csi("" + count + 'B');
        }
    }

    @Override
    public void right(int count) {
        block1: {
            block0: {
                if (count >= 0) break block0;
                this.left(-count);
                break block1;
            }
            if (count <= 0) break block1;
            this.csi("" + count + 'C');
        }
    }

    @Override
    public void left(int count) {
        block1: {
            block0: {
                if (count >= 0) break block0;
                this.right(-count);
                break block1;
            }
            if (count <= 0) break block1;
            this.csi("" + count + 'D');
        }
    }

    @Override
    public void startOfLine() {
        this.print("\r");
    }

    @Override
    public void setPosition(int x, int y) {
        boolean bl = x >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid cursor column " + x + "; value cannot be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = y >= 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Invalid cursor column " + y + "; value cannot be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.csi("" + (y + 1) + ';' + (x + 1) + 'H');
    }

    @Override
    public void show() {
        this.csi("?25h");
    }

    @Override
    public void hide(boolean showOnExit) {
        if (showOnExit) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                final /* synthetic */ PrintTerminalCursor this$0;

                public final void run() {
                    this.this$0.show();
                }
                {
                    this.this$0 = printTerminalCursor;
                }
            }));
        }
        this.csi("?25l");
    }

    @Override
    public void clearScreen() {
        this.csi("2J");
    }

    @Override
    public void clearScreenAfterCursor() {
        this.csi("0J");
    }

    private final void csi(String command) {
        this.print("\u001b[" + command);
    }

    private final void print(String text) {
        this.terminal.rawPrint(text);
    }

    public PrintTerminalCursor(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter(terminal, "terminal");
        this.terminal = terminal;
    }
}

