---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, résumé, deux colonnes, pleine largeur
---

# Comment obtenir un résumé en pleine largeur dans un document à deux colonnes ?

Dans de nombreux documents formels, 
il est exigé que le résumé d'un article apparaisse sur toute la largeur de la page 
alors même que l'ensemble de l'article est présenté sur deux colonnes. 
Plusieurs solutions existent.


## Avec des commandes de base

Une première solution revient à utiliser le code suivant :

```
\documentclass[french,twocolumn]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}

  \title{Un texte incontournable\thanks{En typographie.}}

\begin{document}

\twocolumn[
  \begin{@twocolumnfalse}
    \maketitle
    \begin{abstract}
      Le texte qui suit, le \emph{Lorem ipsum}, permet de vérifier la mise 
      en page d'un texte. Afin d'éviter d'attirer l'attention du relecteur,
      il n'a pas de sens. 
    \end{abstract}
  \end{@twocolumnfalse}
  ]

\lipsum[1-4]
\end{document}
```

Malheureusement, avec ce code, la commande `\thanks` ne fonctionne pas. 
Toutefois, si vous avez besoin de notes de bas de page ayant numérotation spécifique, 
vous pouvez les obtenir avec le code suivant. 
Il se base sur la décomposition de la commande de note de bas de page, 
décrit à la question "[](/3_composition/texte/pages/footnotes/inserer_une_note_de_bas_de_page)".

```
\documentclass[french,twocolumn]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}

  \title{Un texte incontournable\thanks{}}

\begin{document}

\twocolumn[
  \begin{@twocolumnfalse}
    \maketitle
    \begin{abstract}
      Le texte qui suit, le \emph{Lorem ipsum}, permet de vérifier la mise 
      en page d'un texte. Afin d'éviter d'attirer l'attention du relecteur,
      il n'a pas de sens. 
    \end{abstract}
  \end{@twocolumnfalse}
  ]
{ % Ajout de la note en base de page.
  \renewcommand{\thefootnote}%
    {\fnsymbol{footnote}}
  \footnotetext[1]{En typographie.}
}

\lipsum[1-4]
\end{document}
```


## Avec l'extension <ctanpkg:abstract>

Entre autres fonctionnalités, l'extension <ctanpkg:abstract> fournit une commande `\saythanks` 
et un environnement `onecolabstract` qui suppriment le recours à des détournements de la commande `\thanks` 
et des notes de bas de page. En voici un exemple :

```
\documentclass[french,twocolumn]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}
  \usepackage{abstract}
  
  \title{Un texte incontournable\thanks{En typographie.}}

\begin{document}

\twocolumn[
  \maketitle             % titre en pleine largeur
  \begin{onecolabstract} % résumé en pleine largeur
    Le texte qui suit, le \emph{Lorem ipsum}, permet de vérifier la mise 
    en page d'un texte. Afin d'éviter d'attirer l'attention du relecteur,
    il n'a pas de sens. 
  \end{onecolabstract}
]
\saythanks               % pour saisir l'équivalent de \thanks

\lipsum[1-4]
\end{document}
```


## Avec la classe <ctanpkg:memoir>

La classe <ctanpkg:memoir> dispose de toutes les fonctionnalités de l'extension <ctanpkg:abstract>.

:::{sources}
[1-column abstract in 2-column document](faquk:FAQ-onecolabs)
:::