---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, symbole, flèche, 
              flèches
---

# Comment obtenir des flèches ?

Ces symboles sont listés dans le document 
[The comprehensive LaTeX symbol list](texdoc:symbols-a4).


## Avec les commandes de base

De nombreux symboles de flèches sont disponibles par défaut. Pour vous aider 
à vous en rappeler, les 6 premières lignes du tableau suivant respectent 
une logique simple :

- la commande finit par `arrow` ;
- si la flèche va vers la gauche, la commande contient `left`. Si elle va 
  vers la droite, la commande contient `right` ;
- si la flèche est longue, la commande commence par `long` ;
- si la flèche est double, la commande commence par une lettre majuscule.

| Symbole              | Commandes            |   | Symbole               | Commandes             |
|----------------------|----------------------|---|-----------------------|-----------------------|
| $\gets$              | `\gets`,`\leftarrow` |   | $\longleftarrow$      | `\longleftarrow`      |
| $\Leftarrow$         | `\Leftarrow`         |   | $\Longleftarrow$      | `\Longleftarrow`      |
| $\to$                | `\to`,`\rightarrow`  |   | $\longrightarrow$     | `\longrightarrow`     |
| $\Rightarrow$        | `\Rightarrow`        |   | $\Longrightarrow$     | `\Longrightarrow`     |
| $\leftrightarrow$    | `\leftrightarrow`    |   | $\longleftrightarrow$ | `\longleftrightarrow` |
| $\Leftrightarrow$    | `\Leftrightarrow`    |   | $\Longleftrightarrow$ | `\Longleftrightarrow` |
| $\uparrow$           | `\uparrow`           |   | $\Uparrow$            | `\Uparrow`            |
| $\downarrow$         | `\downarrow`         |   | $\Downarrow$          | `\Downarrow`          |
| $\updownarrow$       | `\updownarrow`       |   | $\Updownarrow$        | `\Updownarrow`        |
| $\nearrow$           | `\nearrow`           |   | $\searrow$            | `\searrow`            |
| $\swarrow$           | `\swarrow`           |   | $\nwarrow$            | `\nwarrow`            |
| $\mapsto$            | `\mapsto`            |   | $\longmapsto$         | `\longmapsto`         |
| $\hookleftarrow$     | `\hookleftarrow`     |   | $\hookrightarrow$     | `\hookrightarrow`     |
| $\leftharpoonup$     | `\leftharpoonup`     |   | $\rightharpoonup$     | `\rightharpoonup`     |
| $\leftharpoondown$   | `\leftharpoondown`   |   | $\rightharpoondown$   | `\rightharpoondown`   |
| $\rightleftharpoons$ | `\rightleftharpoons` |   |                       |                       |


## Avec l'extension <ctanpkg:amssymb>

L'extension <ctanpkg:amssymb> propose des compléments aux commandes de base.

| Symbole                | Commandes              |   | Symbole              | Commandes            |
|------------------------|------------------------|---|----------------------|----------------------|
| $\dashleftarrow$       | `\dashleftarrow`       |   | $\dashrightarrow$    | `\dashrightarrow`    |
| $\leftarrowtail$       | `\leftarrowtail`       |   | $\rightarrowtail$    | `\rightarrowtail`    |
| $\twoheadleftarrow$    | `\twoheadleftarrow`    |   | $\twoheadrightarrow$ | `\twoheadrightarrow` |
| $\Lsh$                 | `\Lsh`                 |   | $\Rsh$               | `\Rsh`               |
| $\leftrightsquigarrow$ | `\leftrightsquigarrow` |   | $\rightsquigarrow$   | `\rightsquigarrow`   |
| $\circlearrowleft$     | `\circlearrowleft`     |   | $\circlearrowright$  | `\circlearrowright`  |
| $\curvearrowleft$      | `\curvearrowleft`      |   | $\curvearrowright$   | `\curvearrowright`   |
| $\looparrowleft$       | `\looparrowleft`       |   | $\looparrowright$    | `\looparrowright`    |
| $\Lleftarrow$          | `\Lleftarrow`          |   | $\Rrightarrow$       | `\Rrightarrow`       |
| $\leftleftarrows$      | `\leftleftarrows`      |   | $\rightrightarrows$  | `\rightrightarrows`  |
| $\leftrightarrows$     | `\leftrightarrows`     |   | $\rightleftarrows$   | `\rightleftarrows`   |
| $\nleftarrow$          | `\nleftarrow`          |   | $\nrightarrow$       | `\nrightarrow`       |
| $\nLeftarrow$          | `\nLeftarrow`          |   | $\nRightarrow$       | `\nRightarrow`       |
| $\nleftrightarrow$     | `\nleftrightarrow`     |   | $\upuparrows$        | `\upuparrows`        |
| $\nLeftrightarrow$     | `\nLeftrightarrow`     |   | $\downdownarrows$    | `\downdownarrows`    |

Vous pourrez noter les commandes suivantes proviennent en fait de <ctanpkg:amsfonts>
(qui est chargée par <ctanpkg:amssymb>): `\dashleftarrow`, `\dashrightarrow`
(et `\dasharrow` comme alias) ainsi que `\rightsquigarrow`.


### Le cas particulier de `\leadsto`

Méfiez-vous de la commande `\leadsto`. Elle correspond à des symboles
différents selon les extensions que vous utilisez :

- <ctanpkg:amsfonts> définit `\leadsto` comme un alias de `\rightsquigarrow`,
  donc le $\rightsquigarrow$ du tableau ci-dessus ;
- l'extension <ctanpkg:latexsym> fournit également une commande `\leadsto`
  mais le glyphe associé diffère sensiblement du `\leadsto` 
  de <ctanpkg:amsfonts>.  Le glyphe de <ctanpkg:latexsym> ressemble au rendu
  habituel du caractère Unicode U+2933, à savoir ⤳, différent de
  $\rightsquigarrow$.
- L'extension <ctanpkg:unicode-math> associe `\rightsquigarrow` au caractère
  Unicode $⇝$ (U+21DD) et `\rightcurvedarrow` au caractère Unicode $⤳$ 
  (U+2933), et ne définit pas de `\leadsto`.  Les voici en mode texte 
  (plus commode pour copier coller depuis l'HTML): ⇝ (le rendu peut
  dépendre sensiblement de la police) et ⤳.  Encore faut-il bien sûr 
  que la police mathématique fournisse ces caractères.  *Latin Modern Math* 
  ne fournit que `\rightsquigarrow` (avec un rendu particulier) 
  et pas `\rightcurvedarrow`.

Notez que HTML+MathJax donne un rendu identique pour `\leadsto` et
`\rightsquigarrow` ($\rightsquigarrow$), suivant donc la convention 
de <ctanpkg:amsfonts> plutôt que celle de <ctanpkg:latexsym>. De plus,
HTML+MathJax (par défaut) ne reconnaît pas la commande `\rightcurvedarrow`.
Vous pouvez utiliser directement le caractère Unicode.