/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UndefAction;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class Undefined
extends Primitive {
    private UndefAction action = UndefAction.ERROR;
    public static final byte ACTION_ERROR = 0;
    public static final byte ACTION_WARN = 1;
    public static final byte ACTION_MESSAGE = 2;
    public static final byte ACTION_IGNORE = 3;

    public Undefined() {
        this("undefined", UndefAction.ERROR);
    }

    @Deprecated
    public Undefined(String string, byte by) {
        super(string);
        switch (by) {
            case 0: {
                this.setAction(UndefAction.ERROR);
                break;
            }
            case 1: {
                this.setAction(UndefAction.WARN);
                break;
            }
            case 2: {
                this.setAction(UndefAction.MESSAGE);
                break;
            }
            case 3: {
                this.setAction(UndefAction.IGNORE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid undefined action " + by);
            }
        }
    }

    public Undefined(String string, UndefAction undefAction) {
        super(string);
        this.setAction(undefAction);
    }

    @Override
    public Object clone() {
        return new Undefined(this.getName(), this.action);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        switch (this.action) {
            case ERROR: {
                throw new TeXSyntaxException(teXParser, "tex.error.undefined", this.getName());
            }
            case WARN: {
                teXParser.warningMessage("tex.error.undefined", this.getName());
                break;
            }
            case MESSAGE: {
                teXParser.message("tex.error.undefined", this.getName());
            }
        }
    }

    public void setAction(UndefAction undefAction) {
        this.action = undefAction;
    }

    @Deprecated
    public void setAction(byte by) {
        switch (by) {
            case 0: {
                this.setAction(UndefAction.ERROR);
                break;
            }
            case 1: {
                this.setAction(UndefAction.WARN);
                break;
            }
            case 2: {
                this.setAction(UndefAction.MESSAGE);
                break;
            }
            case 3: {
                this.setAction(UndefAction.IGNORE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid undefined action " + by);
            }
        }
    }

    public UndefAction getAction() {
        return this.action;
    }
}

