/*
 * Decompiled with CFR 0.152.
 */
package nts.tfm;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import nts.tfm.BadTeXFmException;
import nts.tfm.FixWord;
import nts.tfm.IndexMultimap;
import nts.tfm.TeXFm;
import nts.tfm.TeXFmDiagnostic;
import nts.tfm.TeXMathExtFm;
import nts.tfm.TeXMathSymFm;

class TeXFmLoader {
    protected static final byte NO_TAG = 0;
    protected static final byte LIG_TAG = 1;
    protected static final byte LIST_TAG = 2;
    protected static final byte EXT_TAG = 3;
    protected static final byte VANILLA = 0;
    protected static final byte MATHSY = 1;
    protected static final byte MATHEX = 2;
    protected static final int CODING_SIZE = 10;
    protected static final int FAMILY_SIZE = 5;
    private static final String WD = "Width";
    private static final String HT = "Height";
    private static final String DP = "Depth";
    private static final String IC = "Italic correction";
    private static final String KR = "Kern";
    protected static final FixWord zeroFixWord = FixWord.valueOf(0);
    protected static final short NO_CHAR_CODE = -1;
    protected static final int NO_INDEX = -1;
    protected static final int BOUNDARY_LABEL = -1;
    TeXFmDiagnostic diagnostic;
    protected InputStream input;
    protected int fileLength;
    protected int headerLength;
    protected short firstCharCode;
    protected int charCount;
    protected int widthCount;
    protected int heightCount;
    protected int depthCount;
    protected int italicCount;
    protected int ligAuxLen;
    protected int kernCount;
    protected int extAuxCnt;
    protected int paramCount;
    protected int checkSum;
    protected FixWord designSize;
    protected String codingScheme = null;
    protected String family = null;
    protected int face = -1;
    protected boolean sevenBitSafe = false;
    protected int[] headerRest = null;
    protected int restIndex = 0;
    protected byte fontType;
    protected AuxCharInfo[] charAuxTab;
    protected FixWord[] widthTable;
    protected FixWord[] heightTable;
    protected FixWord[] depthTable;
    protected FixWord[] italicTable;
    protected AuxLigKern[] ligAuxTab;
    protected FixWord[] kernTable;
    protected AuxExtRecipe[] extAuxTab;
    protected FixWord[] paramTable;
    protected short boundaryChar = (short)-1;
    protected int boundaryStart = -1;
    protected IndexMultimap labels = new IndexMultimap();
    protected TeXFm.LigKern[] ligKernTable;
    protected TeXFm.CharInfo[] charTable;
    protected TeXFm metric;

    protected static void abort(String s, TeXFmDiagnostic dg) throws BadTeXFmException {
        if (dg != null) {
            dg.fatal(s);
        }
        throw new BadTeXFmException(s);
    }

    protected void abort(String s) throws BadTeXFmException {
        TeXFmLoader.abort(s, this.diagnostic);
    }

    protected void bad(String s) throws BadTeXFmException {
        if (this.diagnostic != null) {
            this.diagnostic.error(s);
        }
        if (this.diagnostic == null || this.diagnostic.abortOnError()) {
            throw new BadTeXFmException(s);
        }
    }

    protected void warning(String s) {
        if (this.diagnostic != null) {
            this.diagnostic.warning(s);
        }
    }

    protected void readLengths() throws IOException {
        this.fileLength = this.readFileLength();
        this.headerLength = this.readLength();
        this.firstCharCode = this.readLength();
        short lastChar = this.readLength();
        this.widthCount = this.readLength();
        this.heightCount = this.readLength();
        this.depthCount = this.readLength();
        this.italicCount = this.readLength();
        this.ligAuxLen = this.readLength();
        this.kernCount = this.readLength();
        this.extAuxCnt = this.readLength();
        this.paramCount = this.readLength();
        if (this.headerLength < 2) {
            this.abort("The header length is only " + this.headerLength + "!");
        }
        if (this.firstCharCode > lastChar + 1 || lastChar > 255) {
            this.abort("The character code range " + this.firstCharCode + ".." + lastChar + "is illegal!");
        }
        this.charCount = lastChar + 1 - this.firstCharCode;
        if (this.charCount == 0) {
            this.firstCharCode = 0;
        }
        if (this.widthCount == 0 || this.heightCount == 0 || this.depthCount == 0 || this.italicCount == 0) {
            this.abort("Incomplete subfiles for character dimensions!");
        }
        if (this.extAuxCnt > 256) {
            this.abort("There are " + this.extAuxCnt + " extensible recipes!");
        }
        if (this.fileLength != 6 + this.headerLength + this.charCount + this.widthCount + this.heightCount + this.depthCount + this.italicCount + this.ligAuxLen + this.kernCount + this.extAuxCnt + this.paramCount) {
            this.abort("Subfile sizes don't add up to the stated total!");
        }
    }

    protected int readFileLength() throws IOException {
        short i = this.readByte();
        if (i < 0) {
            this.abort("The input file is empty!");
        }
        if (i > 127) {
            this.abort("The first byte of the input file exceeds 127!");
        }
        int len = i << 8;
        i = this.readByte();
        if (i < 0) {
            this.abort("The input file is only one byte long!");
        }
        if ((len += i) == 0) {
            this.abort("The file claims to have length zero, but that's impossible!");
        }
        if (len < 6) {
            this.abort("The file claims to have length " + len + " words, but it must be at least 6 words long!");
        }
        return len;
    }

    protected void readHeader() throws IOException {
        int rest = this.headerLength;
        this.checkSum = this.readWord();
        FixWord dSize = this.readFixWord();
        if ((rest -= 2) >= 10) {
            this.codingScheme = this.readBCPL(40);
            this.fontType = TeXFmLoader.getFontType(this.codingScheme);
            if ((rest -= 10) >= 5) {
                this.family = this.readBCPL(20);
                if ((rest -= 5) >= 1) {
                    this.sevenBitSafe = this.readByte() > 127;
                    this.input.skip(2L);
                    this.face = this.readByte();
                    if (--rest > 0) {
                        this.headerRest = new int[rest];
                        this.restIndex = this.headerLength - rest;
                        int i = 0;
                        while (i < rest) {
                            this.headerRest[i] = this.readWord();
                            ++i;
                        }
                    }
                }
            }
        }
        if (dSize.lessThan(0)) {
            dSize = this.badDesignSize(dSize, "negative");
        } else if (dSize.lessThan(1)) {
            dSize = this.badDesignSize(dSize, "too small");
        }
        this.designSize = dSize;
    }

    protected static byte getFontType(String s) {
        if (s.startsWith("TEX MATH SY")) {
            return 1;
        }
        if (s.startsWith("TEX MATH EX")) {
            return 2;
        }
        return 0;
    }

    protected String readBCPL(int size) throws IOException {
        int len = this.readByte();
        if (len >= size) {
            this.bad("String is too long; I've shortened it drastically.");
            len = 1;
        }
        size -= len + 1;
        StringBuffer buf = new StringBuffer(len);
        while (len-- > 0) {
            int c = this.readByte();
            if (c == 40 || c == 41) {
                this.bad("Parenthesis in string has been changed to slash.");
                c = 47;
            } else if (32 > c || c > 126) {
                this.bad("Nonstandard ASCII code has been blotted out.");
                c = 63;
            } else {
                c = Character.toUpperCase((char)c);
            }
            buf.append((char)c);
        }
        this.input.skip(size);
        return buf.toString();
    }

    protected FixWord badDesignSize(FixWord dSize, String s) throws BadTeXFmException {
        this.bad("Design size " + s + "!\nI've set it to 10 points.");
        return FixWord.valueOf(10);
    }

    protected boolean charExists(short c) {
        return (c = (short)(c - this.firstCharCode)) >= 0 && c < this.charCount && this.charAuxTab[c].exists();
    }

    protected void readTables() throws IOException {
        this.charAuxTab = AuxCharInfo.readTable(this.input, this.diagnostic, this.charCount);
        this.widthTable = this.readFixWords(this.widthCount);
        this.heightTable = this.readFixWords(this.heightCount);
        this.depthTable = this.readFixWords(this.depthCount);
        this.italicTable = this.readFixWords(this.italicCount);
        this.ligAuxTab = AuxLigKern.readTable(this.input, this.diagnostic, this.ligAuxLen);
        this.kernTable = this.readFixWords(this.kernCount);
        this.extAuxTab = AuxExtRecipe.readTable(this.input, this.diagnostic, this.extAuxCnt);
        this.paramTable = this.readFixWords(this.paramCount);
        if (this.input.read() >= 0) {
            this.warning("There's some extra junk at the end of the TFM file,\nbut I'll proceed as if it weren't there.");
        }
    }

    protected void checkTables() throws BadTeXFmException {
        this.checkParams();
        this.checkZeroDimen(this.widthTable, "width");
        this.checkZeroDimen(this.heightTable, "height");
        this.checkZeroDimen(this.depthTable, "depth");
        this.checkZeroDimen(this.italicTable, "italic");
        this.checkDimens(this.widthTable, 0, this.widthCount, WD);
        this.checkDimens(this.heightTable, 0, this.heightCount, HT);
        this.checkDimens(this.depthTable, 0, this.depthCount, DP);
        this.checkDimens(this.italicTable, 0, this.italicCount, IC);
        this.checkDimens(this.kernTable, 0, this.kernCount, KR);
    }

    protected void checkParams() throws BadTeXFmException {
        this.checkDimens(this.paramTable, 1, this.paramCount, "Parameter");
        switch (this.fontType) {
            case 1: {
                if (this.paramCount == 22) break;
                this.warning("Unusual number of fontdimen parameters for a math symbols font (" + this.paramCount + " not 22).");
                break;
            }
            case 2: {
                if (this.paramCount == 13) break;
                this.warning("Unusual number of fontdimen parameters for an extension font (" + this.paramCount + " not 13).");
                break;
            }
        }
    }

    protected void checkDimens(FixWord[] table, int beg, int end, String what) throws BadTeXFmException {
        while (beg < end) {
            if (!table[beg].lessThan(16) || !table[beg].moreThan(-16)) {
                this.bad(what + " " + beg + " is too big;\nI have set it to zero.");
                table[beg] = zeroFixWord;
            }
            ++beg;
        }
    }

    protected void checkZeroDimen(FixWord[] table, String what) throws BadTeXFmException {
        if (!table[0].isZero()) {
            this.bad(what + "[0] should be zero.");
        } else {
            table[0] = FixWord.ZERO;
        }
    }

    protected void makeLigTable() throws BadTeXFmException {
        if (this.ligAuxLen > 0) {
            this.setupBoundary();
        }
        this.buildLabels();
        this.promoteActivity();
        this.buildLigKernTable();
    }

    protected void setupBoundary() throws BadTeXFmException {
        AuxLigKern alk = this.ligAuxTab[0];
        if (alk.meansBoundary()) {
            this.boundaryChar = alk.nextChar();
            alk.activity = 1;
        }
        if ((alk = this.ligAuxTab[this.ligAuxLen - 1]).meansBoundary()) {
            int start = alk.restartIndex();
            alk.activity = 1;
            if (start < this.ligAuxLen) {
                this.ligAuxTab[start].activity = (byte)2;
                this.labels.add(start, -1);
            } else {
                this.bad(" Ligature/kern starting index for boundarychar is too large;\nso I removed it.");
            }
        }
    }

    protected void buildLabels() throws BadTeXFmException {
        int i = 0;
        while (i < this.charCount) {
            if (this.charAuxTab[i].tag() == 1) {
                int start = this.ligAuxStart(this.charAuxTab[i].ligStart());
                if (start < this.ligAuxLen) {
                    this.labels.add(start, i);
                    this.ligAuxTab[start].activity = (byte)2;
                } else {
                    this.bad(" Ligature/kern starting index for character '" + this.octCharNum(i) + "\n is too large;\n" + "so I removed it.");
                    this.charAuxTab[i].resetTag();
                }
            }
            ++i;
        }
    }

    protected int ligAuxStart(int start) {
        AuxLigKern alk;
        if (start < this.ligAuxLen && (alk = this.ligAuxTab[start]).meansRestart() && (start = alk.restartIndex()) < this.ligAuxLen && alk.activity == 0) {
            alk.activity = 1;
        }
        return start;
    }

    protected void promoteActivity() throws BadTeXFmException {
        int ligKernLength = 0;
        int i = 0;
        while (i < this.ligAuxLen) {
            AuxLigKern alk = this.ligAuxTab[i];
            if (alk.activity == 2 && !alk.meansStop()) {
                int next = alk.nextIndex(i);
                if (next < this.ligAuxLen) {
                    this.ligAuxTab[next].activity = (byte)2;
                } else {
                    this.bad("Ligature/kern step " + i + " skips too far;\nI made it stop.");
                    alk.makeStop();
                }
            }
            if (alk.activity != 1) {
                ++ligKernLength;
            }
            ++i;
        }
        this.ligKernTable = new TeXFm.LigKern[ligKernLength];
    }

    protected void buildLigKernTable() throws BadTeXFmException {
        int currIns = 0;
        int i = 0;
        while (i < this.ligAuxLen) {
            this.setLigStarts(i, currIns);
            AuxLigKern alk = this.ligAuxTab[i];
            if (alk.activity != 1) {
                if (!alk.meansRestart()) {
                    this.checkLigKern(alk);
                    int skip = this.getSkip(i);
                    this.ligKernTable[currIns++] = alk.meansKern() ? this.makeKern(alk, skip) : this.makeLig(alk, skip);
                } else if (alk.restartIndex() > this.ligAuxLen) {
                    this.bad("Ligature unconditional stop command address is too big.");
                }
            }
            ++i;
        }
    }

    protected void setLigStarts(int pos, int start) {
        IndexMultimap.Enum lab = this.labels.forKey(pos);
        while (lab.hasMore()) {
            int c = lab.next();
            if (c == -1) {
                this.boundaryStart = start;
                continue;
            }
            this.charAuxTab[c].lig_kern_start = start;
        }
    }

    protected void checkLigKern(AuxLigKern alk) throws BadTeXFmException {
        if (!this.charExists(alk.nextChar()) && alk.nextChar() != this.boundaryChar) {
            this.bad_char(alk.nextChar(), (alk.meansKern() ? KR : "Ligature") + " step for");
            alk.setNextChar(this.firstCharCode);
        }
    }

    protected void bad_char(short c, String s) throws BadTeXFmException {
        this.bad(s + " nonexistent character '" + Integer.toOctalString(c) + ".");
    }

    protected int getSkip(int pos) {
        AuxLigKern alk = this.ligAuxTab[pos];
        if (alk.meansStop()) {
            return -1;
        }
        int skip = 0;
        int next = alk.nextIndex(pos);
        while (++pos < next) {
            if (this.ligAuxTab[pos].activity == 1) continue;
            ++skip;
        }
        return skip;
    }

    protected TeXFm.LigKern makeLig(AuxLigKern alk, int skip) throws BadTeXFmException {
        if (!this.charExists(alk.ligChar())) {
            this.bad_char(alk.ligChar(), "Ligature step produces the");
            alk.setLigChar(this.firstCharCode);
        }
        boolean left = alk.leaveLeft();
        boolean right = alk.leaveRight();
        byte step = alk.stepOver();
        if (step > (left ? 1 : 0) + (right ? 1 : 0)) {
            this.warning("Ligature step with nonstandard code changed to LIG");
            right = false;
            left = false;
            step = 0;
        }
        return new TeXFm.Ligature(skip, alk.nextChar(), alk.ligChar(), left, right, step);
    }

    protected TeXFm.LigKern makeKern(AuxLigKern alk, int skip) throws BadTeXFmException {
        FixWord kern;
        int kernIdx = alk.kernIndex();
        if (kernIdx < this.kernTable.length) {
            FixWord fixWord = this.kernTable[kernIdx];
        } else {
            this.bad("Kern index too large.");
            kern = zeroFixWord;
        }
        return new TeXFm.Kerning(skip, alk.nextChar(), kern);
    }

    protected void checkExtens() throws BadTeXFmException {
        int i = 0;
        while (i < this.extAuxCnt) {
            AuxExtRecipe aer = this.extAuxTab[i];
            if (aer.top != 0) {
                this.checkExt(aer.top);
            }
            if (aer.mid != 0) {
                this.checkExt(aer.mid);
            }
            if (aer.bot != 0) {
                this.checkExt(aer.bot);
            }
            this.checkExt(aer.rep);
            ++i;
        }
    }

    protected void checkExt(short c) throws BadTeXFmException {
        if (!this.charExists(c)) {
            this.bad_char(c, "Extensible recipe involves the");
        }
    }

    protected void makeCharTable() throws BadTeXFmException {
        this.charTable = new TeXFm.CharInfo[this.charCount];
        int i = 0;
        while (i < this.charCount) {
            this.charTable[i] = this.charAuxTab[i].exists() ? this.makeCharInfo(i) : null;
            ++i;
        }
    }

    protected TeXFm.CharInfo makeCharInfo(int pos) throws BadTeXFmException {
        AuxCharInfo aci = this.charAuxTab[pos];
        FixWord wd = this.takeDimen(this.widthTable, aci.widthIndex(), pos, WD);
        FixWord ht = this.takeDimen(this.heightTable, aci.heightIndex(), pos, HT);
        FixWord dp = this.takeDimen(this.depthTable, aci.depthIndex(), pos, DP);
        FixWord ic = this.takeDimen(this.italicTable, aci.italicIndex(), pos, IC);
        switch (aci.tag()) {
            case 1: {
                return new TeXFm.LigCharInfo(wd, ht, dp, ic, aci.lig_kern_start);
            }
            case 2: {
                if (!this.validCharList(pos)) break;
                return new TeXFm.ListCharInfo(wd, ht, dp, ic, aci.biggerChar());
            }
            case 3: {
                if (aci.extenIndex() < this.extAuxCnt) {
                    AuxExtRecipe aer = this.extAuxTab[aci.extenIndex()];
                    return new TeXFm.ExtCharInfo(wd, ht, dp, ic, aer.top != 0 ? (short)aer.top : (short)-1, aer.mid != 0 ? (short)aer.mid : (short)-1, aer.bot != 0 ? (short)aer.bot : (short)-1, aer.rep);
                }
                this.range_error(pos, "Extensible");
                break;
            }
        }
        return new TeXFm.CharInfo(wd, ht, dp, ic);
    }

    protected FixWord takeDimen(FixWord[] table, int i, int pos, String what) throws BadTeXFmException {
        if (i < table.length) {
            return table[i];
        }
        this.range_error(pos, what);
        return zeroFixWord;
    }

    protected void range_error(int pos, String what) throws BadTeXFmException {
        this.bad(what + " index for character '" + this.octCharNum(pos) + " is too large;\nso I reset it to zero.");
    }

    protected String octCharNum(int pos) {
        return Integer.toOctalString(pos + this.firstCharCode);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean validCharList(int pos) throws BadTeXFmException {
        aci = this.charAuxTab[pos];
        next = aci.biggerChar();
        if (this.charExists(next)) ** GOTO lbl8
        this.bad_char(next, "Character list link to");
        aci.resetTag();
        return false;
lbl-1000:
        // 1 sources

        {
            next = aci.biggerChar();
lbl8:
            // 2 sources

            ** while ((next = (short)(next - this.firstCharCode)) < pos && (aci = this.charAuxTab[next]).tag() == 2)
        }
lbl9:
        // 1 sources

        if (next == pos) {
            this.bad("Cycle in a character list!\nCharacter '" + this.octCharNum(pos) + " now ends the list.");
            this.charAuxTab[pos].resetTag();
            return false;
        }
        return true;
    }

    public TeXFm getMetric() {
        return this.metric;
    }

    protected void makeMetric() {
        switch (this.fontType) {
            case 1: {
                this.metric = new TeXMathSymFm(this.checkSum, this.designSize, this.firstCharCode, this.charTable, this.boundaryChar, this.boundaryStart, this.ligKernTable, this.paramTable, this.codingScheme, this.family, this.face, this.sevenBitSafe, this.headerRest, this.restIndex);
                break;
            }
            case 2: {
                this.metric = new TeXMathExtFm(this.checkSum, this.designSize, this.firstCharCode, this.charTable, this.boundaryChar, this.boundaryStart, this.ligKernTable, this.paramTable, this.codingScheme, this.family, this.face, this.sevenBitSafe, this.headerRest, this.restIndex);
                break;
            }
            default: {
                this.metric = new TeXFm(this.checkSum, this.designSize, this.firstCharCode, this.charTable, this.boundaryChar, this.boundaryStart, this.ligKernTable, this.paramTable, this.codingScheme, this.family, this.face, this.sevenBitSafe, this.headerRest, this.restIndex);
                break;
            }
        }
    }

    protected final FixWord[] readFixWords(int count) throws IOException {
        FixWord[] table = new FixWord[count];
        int i = 0;
        while (i < count) {
            table[i] = this.readFixWord();
            ++i;
        }
        return table;
    }

    protected final FixWord readFixWord() throws IOException {
        int FIX_WORD_DENOMINATOR = 0x100000;
        return FixWord.valueOf(this.readWord(), 0x100000);
    }

    protected final int readWord() throws IOException {
        int i = this.readByte();
        i = (i << 8) + this.readByte();
        i = (i << 8) + this.readByte();
        return (i << 8) + this.readByte();
    }

    protected final short readLength() throws IOException {
        short i = this.readByte();
        if ((i & 0x80) != 0) {
            this.abort("One of the subfile sizes is negative!");
        }
        return (short)((i << 8) + this.readByte());
    }

    protected final short readByte() throws IOException {
        return TeXFmLoader.readByte(this.input, this.diagnostic);
    }

    protected static final short readByte(InputStream in, TeXFmDiagnostic dg) throws IOException {
        int i = in.read();
        if (i < 0) {
            TeXFmLoader.abort("The file has fewer bytes than it claims!", dg);
        }
        return (short)i;
    }

    protected TeXFmLoader(InputStream in, TeXFmDiagnostic dg) throws IOException {
        this.input = in;
        this.diagnostic = dg;
        try {
            this.readLengths();
            this.readHeader();
            this.readTables();
            this.checkTables();
            this.makeLigTable();
            this.checkExtens();
            this.makeCharTable();
            this.makeMetric();
        }
        finally {
            Object var4_3 = null;
            this.input.close();
        }
    }

    protected TeXFmLoader(InputStream in) throws IOException {
        this(in, null);
    }

    protected TeXFmLoader(String path, TeXFmDiagnostic dg) throws IOException {
        this(new BufferedInputStream(new FileInputStream(path)), dg);
    }

    protected TeXFmLoader(String path) throws IOException {
        this(path, null);
    }

    protected static class AuxCharInfo {
        private byte _width_index;
        private byte _height_depth_index;
        private byte _italic_index_tag;
        private byte _remainder;
        int lig_kern_start;

        boolean exists() {
            return this._width_index != 0;
        }

        int widthIndex() {
            return this._width_index & 0xFF;
        }

        int heightIndex() {
            return this._height_depth_index >> 4 & 0xF;
        }

        int depthIndex() {
            return this._height_depth_index & 0xF;
        }

        int italicIndex() {
            return this._italic_index_tag >> 2 & 0x3F;
        }

        byte tag() {
            return (byte)(this._italic_index_tag & 3);
        }

        void resetTag() {
            this._italic_index_tag = (byte)(this._italic_index_tag & 0xFFFFFFFC);
        }

        private short remainder() {
            return (short)(this._remainder & 0xFF);
        }

        int ligStart() {
            return this.remainder();
        }

        short biggerChar() {
            return this.remainder();
        }

        int extenIndex() {
            return this.remainder();
        }

        static final AuxCharInfo[] readTable(InputStream in, TeXFmDiagnostic dg, int count) throws IOException {
            AuxCharInfo[] table = new AuxCharInfo[count];
            int i = 0;
            while (i < count) {
                table[i] = new AuxCharInfo(in, dg);
                ++i;
            }
            return table;
        }

        AuxCharInfo(InputStream in, TeXFmDiagnostic dg) throws IOException {
            this._width_index = (byte)TeXFmLoader.readByte(in, dg);
            this._height_depth_index = (byte)TeXFmLoader.readByte(in, dg);
            this._italic_index_tag = (byte)TeXFmLoader.readByte(in, dg);
            this._remainder = (byte)TeXFmLoader.readByte(in, dg);
        }
    }

    protected static class AuxLigKern {
        private static final short BOUNDARY_FLAG = 255;
        private static final short STOP_FLAG = 128;
        private static final short KERN_FLAG = 128;
        static final byte UNREACHABLE = 0;
        static final byte PASS_THROUGH = 1;
        static final byte ACCESSIBLE = 2;
        private byte _skip_byte;
        private byte _next_char;
        private byte _op_byte;
        private byte _remainder;
        byte activity = 0;

        private short skip_byte() {
            return (short)(this._skip_byte & 0xFF);
        }

        private short op_byte() {
            return (short)(this._op_byte & 0xFF);
        }

        private short remainder() {
            return (short)(this._remainder & 0xFF);
        }

        boolean meansBoundary() {
            return this.skip_byte() == 255;
        }

        boolean meansRestart() {
            return this.skip_byte() > 128;
        }

        boolean meansStop() {
            return this.skip_byte() >= 128;
        }

        int nextIndex(int pos) {
            return pos + this.skip_byte() + 1;
        }

        void makeStop() {
            this._skip_byte = (byte)-128;
        }

        short nextChar() {
            return (short)(this._next_char & 0xFF);
        }

        void setNextChar(int c) {
            this._next_char = (byte)c;
        }

        int restartIndex() {
            return (this.op_byte() << 8) + this.remainder();
        }

        boolean meansKern() {
            return this.op_byte() >= 128;
        }

        int kernIndex() {
            return (this.op_byte() - 128 << 8) + this.remainder();
        }

        boolean leaveLeft() {
            return (this.op_byte() & 2) != 0;
        }

        boolean leaveRight() {
            return (this.op_byte() & 1) != 0;
        }

        byte stepOver() {
            return (byte)(this.op_byte() >>> 2);
        }

        short ligChar() {
            return this.remainder();
        }

        void setLigChar(short c) {
            this._remainder = (byte)c;
        }

        static final AuxLigKern[] readTable(InputStream in, TeXFmDiagnostic dg, int count) throws IOException {
            AuxLigKern[] table = new AuxLigKern[count];
            int i = 0;
            while (i < count) {
                table[i] = new AuxLigKern(in, dg);
                ++i;
            }
            return table;
        }

        AuxLigKern(InputStream in, TeXFmDiagnostic dg) throws IOException {
            this._skip_byte = (byte)TeXFmLoader.readByte(in, dg);
            this._next_char = (byte)TeXFmLoader.readByte(in, dg);
            this._op_byte = (byte)TeXFmLoader.readByte(in, dg);
            this._remainder = (byte)TeXFmLoader.readByte(in, dg);
        }
    }

    protected static class AuxExtRecipe {
        short top;
        short mid;
        short bot;
        short rep;

        static final AuxExtRecipe[] readTable(InputStream in, TeXFmDiagnostic dg, int count) throws IOException {
            AuxExtRecipe[] table = new AuxExtRecipe[count];
            int i = 0;
            while (i < count) {
                table[i] = new AuxExtRecipe(in, dg);
                ++i;
            }
            return table;
        }

        AuxExtRecipe(InputStream in, TeXFmDiagnostic dg) throws IOException {
            this.top = TeXFmLoader.readByte(in, dg);
            this.mid = TeXFmLoader.readByte(in, dg);
            this.bot = TeXFmLoader.readByte(in, dg);
            this.rep = TeXFmLoader.readByte(in, dg);
        }
    }
}

