/*
 * Decompiled with CFR 0.152.
 */
package nts.math;

import nts.base.Dimen;
import nts.base.Glue;
import nts.base.Num;
import nts.builder.Builder;
import nts.command.ActiveCharToken;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.Prim;
import nts.command.Token;
import nts.io.CharCode;
import nts.math.MathAction;
import nts.math.MathBuilder;
import nts.math.MathGroup;
import nts.math.MathPrim;
import nts.math.MathShiftToken;
import nts.noad.CharField;
import nts.noad.Delimiter;
import nts.noad.Field;
import nts.noad.Noad;
import nts.noad.OrdNoad;
import nts.noad.TreatField;
import nts.node.FontMetric;
import nts.typo.Action;
import nts.typo.BuilderCommand;
import nts.typo.BuilderPrim;
import nts.typo.CharHandler;
import nts.typo.TypoCommand;

public abstract class MathPrim
extends BuilderPrim {
    private static Config config;
    public static final int INTP_MAX_MATH_CODE;
    public static final int INTP_MAX_DEL_CODE;
    public static final Action DOLLAR;
    public static final Action ZERO_KERN;
    public static final MathAction LEFT_BRACE;

    public abstract MathAction mathAction();

    public static void setMathConfig(Config conf) {
        config = conf;
    }

    public static Config getMathConfig() {
        return config;
    }

    public static int scanMathCharCode() {
        return Prim.scanAnyCode(INTP_MAX_MATH_CODE, "BadMathCharCode");
    }

    public static int scanDelimiterCode() {
        return Prim.scanAnyCode(INTP_MAX_DEL_CODE, "BadDelimiterCode");
    }

    public static void setMathChar(MathBuilder bld, CharCode code) {
        Noad noad = MathPrim.getMathConfig().noadForCode(code.mathCode());
        if (noad != null) {
            bld.addNoad(noad);
        } else {
            MathPrim.backActiveChar(code);
        }
    }

    public static void setMathChar(MathBuilder bld, int code) {
        bld.addNoad(MathPrim.getMathConfig().noadForCode(code));
    }

    public static void handleMathCode(int code, Token src) {
        Builder bld = TypoCommand.getBld();
        CharHandler hnd = BuilderCommand.getCharHandler(bld.getClass());
        if (hnd == null) {
            CommandBase.error("CantUseIn", CommandBase.str("character"), bld);
        } else if (hnd instanceof MathCharHandler) {
            ((MathCharHandler)hnd).handleMath(bld, code, src);
        } else {
            MathPrim.insertDollar(src);
        }
    }

    public static Noad makeOrdNoad(Field field) {
        Noad noad = field.ordinaryNoad();
        return noad != null ? noad : new OrdNoad(field);
    }

    public static void insertDollar(Token src) {
        CommandBase.backToken(src);
        CommandBase.insertToken(MathShiftToken.TOKEN);
        CommandBase.error("MissingDollar");
    }

    public static void scanField(TreatField proc) {
        boolean again;
        CharField field = null;
        do {
            again = false;
            Token tok = CommandBase.nextNonRelax();
            Command cmd = CommandBase.meaningOf(tok);
            if (cmd.hasMathCodeValue()) {
                field = MathPrim.getMathConfig().fieldForCode(cmd.getMathCodeValue());
                continue;
            }
            if (cmd.hasDelCodeValue()) {
                field = MathPrim.getMathConfig().fieldForDelCode(cmd.getDelCodeValue());
                continue;
            }
            CharCode code = cmd.charCodeToAdd();
            if (code == null) {
                CommandBase.backToken(tok);
                continue;
            }
            field = MathPrim.getMathConfig().fieldForCode(code.mathCode());
            if (field != null) continue;
            MathPrim.backActiveChar(code);
            again = true;
        } while (again);
        if (field != null) {
            proc.execute(field);
        } else {
            CommandBase.scanLeftBrace();
            CommandBase.pushLevel(new MathGroup(proc));
        }
    }

    private static void backActiveChar(CharCode code) {
        CommandBase.backToken(new ActiveCharToken(code));
    }

    public static Delimiter scanDelimiter() {
        CharCode code;
        Delimiter del = null;
        Token tok = CommandBase.nextNonRelax();
        Command cmd = CommandBase.meaningOf(tok);
        if (cmd.hasDelCodeValue()) {
            del = MathPrim.getMathConfig().delimiterForDelCode(cmd.getDelCodeValue());
        }
        if ((code = cmd.charCodeToAdd()) != null && cmd.charCode() != null) {
            del = MathPrim.getMathConfig().delimiterForDelCode(code.delCode());
        }
        if (del != null) {
            return del;
        }
        CommandBase.backToken(tok);
        CommandBase.error("MissingDelim");
        return Delimiter.VOID;
    }

    public MathPrim(String name) {
        super(name);
    }

    static {
        INTP_MAX_MATH_CODE = CommandBase.newIntParam();
        INTP_MAX_DEL_CODE = CommandBase.newIntParam();
        DOLLAR = new 1();
        ZERO_KERN = new 2();
        LEFT_BRACE = new 3();
    }

    public static class MathCharHandler
    implements CharHandler {
        public void handle(Builder bld, CharCode code, Token src) {
            MathPrim.setMathChar((MathBuilder)bld, code);
        }

        public void handleSpace(Builder bld, Token src) {
        }

        public void handleMath(Builder bld, int code, Token src) {
            MathPrim.setMathChar((MathBuilder)bld, code);
        }
    }

    public static interface MathSpacer {
        public Glue getGlue(byte var1);

        public String getName();
    }

    public static interface Config {
        public void initFormula();

        public void initDisplay(Dimen var1, Dimen var2, Dimen var3);

        public Noad noadForCode(int var1);

        public CharField fieldForCode(int var1);

        public Noad noadForDelCode(int var1);

        public CharField fieldForDelCode(int var1);

        public Delimiter delimiterForDelCode(int var1);

        public FontMetric familyFont(byte var1, byte var2);

        public String familyName(byte var1, byte var2);

        public MathSpacer mathSpacing(byte var1, byte var2);

        public Num mathPenalty(byte var1, byte var2);
    }
}

