/*
 * Decompiled with CFR 0.152.
 */
package nts.align;

import nts.align.AlignGroup;
import nts.align.Alignment;
import nts.base.Dimen;
import nts.base.Num;
import nts.builder.Builder;
import nts.command.CommandBase;
import nts.command.Token;
import nts.math.DisplayGroup;
import nts.math.FormulaGroup;
import nts.node.NodeEnum;

public class DispAlignGroup
extends AlignGroup {
    public static final int INTP_PRE_DISPLAY_PENALTY = DisplayGroup.INTP_PRE_DISPLAY_PENALTY;
    public static final int INTP_POST_DISPLAY_PENALTY = DisplayGroup.INTP_POST_DISPLAY_PENALTY;
    public static final int DIMP_DISPLAY_INDENT = DisplayGroup.DIMP_DISPLAY_INDENT;
    public static final int GLUEP_ABOVE_DISPLAY_SKIP = DisplayGroup.GLUEP_ABOVE_DISPLAY_SKIP;
    public static final int GLUEP_BELOW_DISPLAY_SKIP = DisplayGroup.GLUEP_BELOW_DISPLAY_SKIP;

    public void stop() {
        CommandBase.Config cfg = CommandBase.getConfig();
        Dimen indent = cfg.getDimParam(DIMP_DISPLAY_INDENT);
        NodeEnum nodes = this.align.finish(indent);
        if (DispAlignGroup.expectMathShift()) {
            FormulaGroup.expectAnotherMathShift();
        }
        Builder.pop();
        Builder bld = Builder.top();
        bld.addPenalty(Num.valueOf(cfg.getIntParam(INTP_PRE_DISPLAY_PENALTY)));
        bld.addSkip(cfg.getGlueParam(GLUEP_ABOVE_DISPLAY_SKIP), cfg.getGlueName(GLUEP_ABOVE_DISPLAY_SKIP));
        bld.addNodes(nodes);
        bld.addPenalty(Num.valueOf(cfg.getIntParam(INTP_POST_DISPLAY_PENALTY)));
        bld.addSkip(cfg.getGlueParam(GLUEP_BELOW_DISPLAY_SKIP), cfg.getGlueName(GLUEP_BELOW_DISPLAY_SKIP));
        this.align.copyPrevParameters(bld);
    }

    public void close() {
        CommandBase.killLevel();
        DisplayGroup.resumeAfterDisplay();
    }

    protected static boolean expectMathShift() {
        Token tok = CommandBase.nextNonAssignment();
        if (!CommandBase.meaningOf(tok).isMathShift()) {
            CommandBase.backToken(tok);
            CommandBase.error("MissingFormulaEnd");
            return false;
        }
        return true;
    }

    public DispAlignGroup(Alignment align) {
        super(align);
    }
}

