/*
 * LaTeD Version 1.1
 * (c) Gene Ressler 1993, 94, 97
 *   de8827@trotter.usma.edu
 *
 * LaTeD is a graphical editor for drawings in the LaTeX "picture" 
 * environment.  It runs under MSDOS or in a Windows DOS box.  The
 * distribution includes full sources, including LaTeX source for 
 * its documentation.
 *
 * No warranty of this software is expressed or implied by the author.
 *
 * Copy and use this program freely for any purpose except for sale
 * of the program (including the source code) itself.  That is, 
 * no one can copy this program for the purpose of providing it to 
 * another person in exchange for money or other compensation, even 
 * if this program is only part of the exchange.
 *
 * All copies of computer source code in this distribution, whether
 * copies in whole or in part, must have this notice attached.
 */

/* MAIN.C --- Main function for TED */

#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>
#include <dos.h>
#include "window.h"
#include "settings.h"
#include "canvas.h"
#include "env.h"

enum { IGNORE, RETRY, ABORT };

/* Disk error messages. */
static char *disk_err_msg[] = {
  "write protect",
  "unknown unit",
  "drive not ready",
  "unknown command",
  "data error (CRC)",
  "bad request",
  "seek error",
  "unknown media type",
  "sector not found",
  "printer out of paper",
  "write fault",
  "read fault",
  "general failure",
  "reserved",
  "reserved",
  "invalid disk change"
};

#pragma argsused

/* Handle DOS critical error by returning to program. */
static int handler(int errval, int ax, int bp, int si)
{
  /* Preserve di register at entry. */
   unsigned di = _DI;

  /* Show message for non-disk or disk error. */
  if (ax < 0) 
    message(bit(mOK), root_window, "Non-disk device error.");
  else
    message(bit(mOK), root_window, "Drive %c error: %s.", 
	    'A' + (ax & 0xff), disk_err_msg[di & 0xff]);

  /* Return to code executing when error occured. */
  hardretn(ABORT);

  /* Never executed: make compiler happy without emitting code. */
  return _AX;
}

/* Initialize graphics, window subsystem, critical 
   error vector, then TeD environment.  Run the 
   event loop until it terminates. Close graphics. */
int main(int argc, char *argv[]) 
{
  if (init_graphics() != 0) {
    fprintf(stderr, "Sorry. TeD runs only on a VGA.\n");
    return 1;
  }
  if (!init_events(0, 0, getmaxx()-1, getmaxy())) {
    close_graphics();
    fprintf(stderr, "Sorry. Mouse driver is missing.\n");
    return 1;
  }
  harderr(handler);
  init_settings((argc > 1) ? argv[1] : NULL, argv[0]);
  init_env();
  run();
  close_settings(argv[0]);
  close_graphics();
  return 0;
}
