/* sleep2.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

unsigned __sleep2(unsigned usec)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    int retv;

    p->p_status = PS_SLEEP;
    retv = WaitForSingleObject(p->hEventSignal, usec);
    p->p_status = PS_RUN;

#ifdef EMX_SYS_LIB
    if (retv != WAIT_TIMEOUT)
        _rsxnt_check_signals();
#endif

    return 0;
}
