{$M $2000,0,0}
program mkconfig;
uses Dos;

var p,po,pc,pd,pn:PathStr;
    c,d,dw:DirStr;
    n:NameStr;
    e:ExtStr;
    s:String;
    r:SearchRec;
    t:Text;
    i:Integer;
    w:Word;
    y:Char;
    canasm:boolean;

procedure makedir;
  begin {$I-} MkDir(p); {$I+}
  if IOResult=0 then writeln('created')
  else  begin writeln('can''t be created'); Halt(4);
    end;
  end; {makedir}

procedure testdir(n:NameStr);
  begin p:=d+n; write(p,' '); FindFirst(p,$30,r);
  if DosError=0 then
    begin if r.Attr=$10 then
      begin writeln('already exists'); Exit;
      end;
    writeln('exists as file');
    repeat write('erase ',p,' (y/n)? '); readln(y);
      if (y='n')or(y='N') then Halt(4);
      until (y='y')or(y='Y');
    Assign(t,p); {$I-} Erase(t); {$I+}
    if IOResult<>0 then
      begin writeln('can''t be erased'); Halt(4);
      end;
    write('erased, directory ');
    end;
  makedir;
  end; {testdir}

procedure testtpc;
  procedure deltst;
    begin FindFirst(d+'tmp\mktpctst.*',$20,r);
    while DosError=0 do
      begin Assign(t,d+'tmp\'+r.Name); {$I-} Erase(t); {$I+}
      if IOResult<>0 then
        begin writeln('can''t erase ',d+'tmp\'+r.Name); Halt(4);
        end;
      FindNext(r);
      end;
    end; {deltst}

  begin writeln('Testing/configuring Turbo Pascal compiler'); writeln;
  deltst;
  writeln('Path for tpc.exe'); Assign(t,d+'tmp\tpcpath');
  {$I-} reset(t); readln(t,po); Close(t); {$I+}
  if IOResult<>0 then po:=''; pc:=po;
  if pc<>'' then
    begin pc:=FExpand(pc); writeln('config file specifies: ',pc);
    FindFirst(pc+'tpc.exe',$20,r);
    if DosError<>0 then
      begin writeln('file not found'); pc:='';
      end;
    end;
  pd:=FSearch('tpc.exe',GetEnv('path'));
  if pd<>'' then
    begin FSplit(FExpand(pd),dw,n,e); pd:=dw;
    writeln('searching in Dos path: ',pd);
    end;
  repeat write('select ');
    if pc<>'' then write('Config file or ');
    if pd<>'' then write('Dos path or ');
    write('New path or Quit (');
    if pc<>'' then write('c/');
    if pd<>'' then write('d/');
    write('n/q)? '); pn:=''; readln(y);
    if (y='c')or(y='C') then pn:=pc;
    if (y='d')or(y='D') then pn:=pd;
    if (y='n')or(y='N') then
      begin write('new path: '); readln(pn);
      FSplit(FExpand(pn),dw,n,e); pn:=dw;
      FindFirst(pn+'tpc.exe',$20,r);
      if DosError<>0 then
        begin writeln('file not found'); pn:='';
        end;
      end;
    if (y='q')or(y='Q') then Halt(4);
    until pn<>'';
  writeln; writeln('Testing tpc.exe');
  SwapVectors;
  Exec(GetEnv('comspec'),'/c copy '+c+'mktpctst.pas '+d+'tmp >nul');
  SwapVectors;
  if DosError<>0 then
    begin writeln('can''t copy mktpctst.pas to ',d,'tmp'); Halt(4);
    end;
  writeln('compiling mktpctst ...');
  SwapVectors;
  Exec(GetEnv('comspec'),'/c '+pn+'tpc.exe '+d+'tmp\mktpctst >nul');
  SwapVectors;
  if DosError<>0 then
    begin writeln('can''t execute tpc.exe'); Halt(4);
    end;
  w:=DosExitCode;
  if w<>0 then
    begin writeln('return code ',w,' from tpc.exe'); Halt(4);
    end;
  SwapVectors;
  Exec(d+'tmp\mktpctst.exe','');
  SwapVectors;
  if DosError<>0 then
    begin writeln('can''t execute mktpctst.exe'); Halt(4);
    end;
  if DosExitCode<>0 then Halt(4);
  if pn<>po then
    begin {$I-} rewrite(t); writeln(t,pn); Close(t); {$I+}
    if IOResult<>0 then
      begin writeln('can''t write ',d+'tmp\tpcpath'); Halt(4);
      end;
    end;
  deltst; writeln;
  end; {testtpc}

procedure testasm;
  begin writeln('Testing/configuring assembler');
  writeln('Borland''s tasm will work, Microsoft''s masm might work');
  writeln('  neither is needed unless the ''.asm'' files are modified');
  writeln; writeln('Path and name of assembler');
  Assign(t,d+'tmp\asmpath');
  {$I-} reset(t); readln(t,po); Close(t); {$I+}
  if IOResult<>0 then po:=''; if po='none' then pc:='' else pc:=po;
  if pc<>'' then
    begin pc:=FExpand(pc); writeln('config file specifies: ',pc);
    FindFirst(pc+'.exe',$20,r);
    if DosError<>0 then
      begin writeln('file not found'); pc:='';
      end;
    end;
  repeat write('select ');
    if pc<>'' then write('Config file or ');
    write('New path or Skip assemblies or Quit (');
    if pc<>'' then write('c/');
    write('n/s/q)? '); pn:=''; readln(y);
    if (y='c')or(y='C') then pn:=pc;
    if (y='n')or(y='N') then
      begin write('new path: '); readln(pn);
      FSplit(FExpand(pn),dw,n,e); pn:=dw+n;
      FindFirst(pn+'.exe',$20,r);
      if DosError<>0 then
        begin writeln('file not found'); pn:='';
        end;
      end;
    if (y='s')or(y='S') then pn:='none';
    if (y='q')or(y='Q') then Halt(4);
    until pn<>'';
  if pn<>po then
    begin {$I-} rewrite(t); writeln(t,pn); Close(t); {$I+}
    if IOResult<>0 then
      begin writeln('can''t write ',d+'tmp\asmpath'); Halt(4);
      end;
    end;
  canasm:=(pn<>'none');
  writeln;
  end; {testasm}

procedure testsel;
  function askone(s:String):boolean;
    begin while true do
      begin write(s,' (y/n/q)? '); readln(y);
      if (y='y')or(y='Y') then
        begin askone:=true; Exit;
        end;
      if (y='n')or(y='N') then
        begin askone:=false; Exit;
        end;
      if (y='q')or(y='Q') then Halt(4);
      end;
    end; {askone}

  procedure setone(n:PathStr;s:boolean);
    begin n:=d+'tmp\mk'+n; Assign(t,n);
    {$I-} reset(t); Close(t);
    if IOResult=0 then
      begin if not s then
        begin Erase(t);
        if IOResult<>0 then
          begin writeln('can''t erase file ',n); Halt(4);
          end;
        end;
      end
    else  begin if s then
        begin rewrite(t); Close(t);
        if IOResult<>0 then
          begin writeln('can''t create file ',n); Halt(4);
          end;
        end;
      end;
    {$I+}
    end; {setone}

  var b:boolean;

  procedure selone(n1,n2:NameStr; t1,t2:String; n3:NameStr; t3:String);
    begin FindFirst(c+'\'+n1+'\mk.bat',$20,r);
    if DosError=0 then
      begin writeln(t1); if t2<>'' then writeln('   ',t2);
      b:=askone('   generate'); setone(n2,b);
      if b then setone(n3,askone('   '+t3)) else setone(n3,false);
      writeln;
      end
    else  begin setone(n2,false); setone(n3,false);
      end;
    end; {selone}

  begin writeln('Select components'); writeln; setone('dostp',true);
  if canasm then
    begin setone('asm',askone('Generate OBJ files')); writeln;
    end
  else setone('asm',false);
  FindFirst(c+'\patch\mk.bat',$20,r);
  if DosError=0 then
    begin FindFirst(c+'\web\mk.bat',$20,r);
    if DosError=0 then
      begin writeln('PATCHTGL, PATCHWEB, and PATCHWVE (needed for eTeX)');
      b:=askone('   generate'); setone('web',not b); setone('patch',b);
      writeln;
      end
    else  begin setone('web',false); setone('patch',true);
      end;
    end
  else  begin setone('web',true); setone('patch',false);
    end;
  selone('texware',
         'texwar','DVItype, PATgen, PLtoTF, POOLtype, and TFtoPL',
                  '(needed for (e)TRIP, TRAP, and MTRAP tests)',
         'testte','run tests');
  selone('mfware',
         'mfware','GFtoDVI, GFtoPK, GFtype, MFT, and PKtype',
                  '(needed for TRAP test and to generate PK fonts)',
         'testmf','run tests');
  selone('mpware',
         'mpware','MPtoTEX, DVItoMP, and makeMPX (needed by MetaPost)','',
         'testmp','run tests');
  selone('vfware',
         'vfware','DVIcopy, GFsplit, PKsplit, TFMsplit, VFtoVP, and VPtoVF','',
         'testvf','run tests');
  selone('fontutil',
         'fontut','CHtoPK, PKtoCH, PKtoGF, PKtoPX, and PXtoPK','',
         'testfo','run tests');
  selone('makefont',
         'makefo','various font generation utilities','',
         'testma','run tests');
  selone('bibtex',
         'bibtex','BibTeX','',
         'testbi','run test');
  selone('tex',
         'tex','TeX (VIRTEX and INITEX)','',
         'trip','run TRIP test');
  selone('etex',
         'etex','eTeX (eVIRTEX and eINITEX)','',
         'etrip','run eTRIP test');
  selone('metafont',
         'metafo','METAFONT (VIRMF and INIMF)','',
         'trap','run TRAP test');
  selone('metapost',
         'metapo','MetaPost (VIRMP and INIMP)','',
         'mtrap','run MTRAP test');
  end; {testsel}

begin writeln; writeln; writeln; writeln; writeln;
writeln('Setup/verify configuration for Dos-TP version 2.1'); writeln;
w:=Swap(DosVersion);
write('Dos version: ',Hi(w),'.',Lo(w) div 10,Lo(w) mod 10,' ');
if w<256*3+30 then
  begin writeln('Sorry version 3.30 or later required'); Halt(4);
  end;
writeln('OK'); writeln;
FSplit(FExpand(ParamStr(0)),c,n,e);
d:=FExpand(c+'..\');
writeln('Testing/creating directories'); writeln;
testdir('tmp'); testdir('bin'); testdir('ini'); writeln;
testtpc;
canasm:=false;
FindFirst(c+'asm\mk.bat',$20,r); if DosError=0 then testasm;
testsel;
writeln; writeln('You can now say:');
writeln('   1.  ''mk''           to generate all programs');
writeln('   2.a ''mk install''   to install all programs');
writeln('   2.b ''mk test''      to run a test for all programs');
FindFirst(d+'tmp\mktrip',$20,r);
if DosError=0 then
  writeln('    or ''mk trip''             the TRIP test for TeX');
FindFirst(d+'tmp\mketrip',$20,r);
if DosError=0 then
  writeln('    or ''mk etrip''            the eTRIP test for eTeX');
FindFirst(d+'tmp\mktrap',$20,r);
if DosError=0 then
  writeln('    or ''mk trap''             the TRAP test for METAFONT');
FindFirst(d+'tmp\mkmtrap',$20,r);
if DosError=0 then
  writeln('    or ''mk mtrap''            the MTRAP test for MetaPost');
writeln('   3.  ''mk clean''     to remove most generated files');
writeln('   4.  ''mk realclean'' to remove all generated files');
writeln;
writeln('You should then add ',FExpand(d+'bin'),' to your Dos path');
writeln('   and may remove ',c,'*.* with all subdirectories');
writeln('You might still need to get TeX macros, font files, ...');
writeln;
writeln('***** Happy TeXing *****');
writeln;
end.
