
open XNum;
open Unicode.Types;
open Runtime;
open VM;
open Types;
open ParseState;

value tracing_al_commands        : ref bool;

value execute_ps_command_unknown : string -> unknown -> parse_state -> unit;
value execute_ps_command         : string -> UCStream.istream -> (parse_state -> unit);
value encode_command             : string -> command -> partial_value;
value decode_command             : string -> unknown -> unknown -> command;

value call_at_exit               : parse_state -> unit;

value set_num_global             : parse_state -> uc_string -> num -> unit;
value set_string_global          : parse_state -> uc_string -> uc_string -> unit;

value ps_get_global              : list unknown -> partial_value;
value ps_set_global              : list unknown -> partial_value;
value ps_next_char               : unknown -> unknown -> partial_value;
value ps_get_char                : list unknown -> partial_value;
value ps_remove_chars            : unknown -> unknown -> partial_value;
value ps_insert_string           : unknown -> unknown -> partial_value;
value ps_location                : unknown -> unknown -> partial_value;
value ps_read_arg                : unknown -> unknown -> partial_value;
value ps_arg_expanded            : unknown -> unknown -> partial_value;
value ps_arg_execute             : list unknown -> partial_value;
value ps_arg_num                 : unknown -> unknown -> partial_value;
value ps_arg_int                 : unknown -> unknown -> partial_value;
value ps_arg_skip                : unknown -> unknown -> partial_value;
value ps_arg_dim                 : unknown -> unknown -> partial_value;
value ps_arg_key_val             : unknown -> unknown -> partial_value;
value ps_arg_dict                : list unknown -> partial_value;
value ps_opt_expanded            : list unknown -> partial_value;
value ps_opt_key_val             : unknown -> unknown -> partial_value;
value ps_opt_int                 : list unknown -> partial_value;
value ps_arg_TeX_dim             : unknown -> unknown -> partial_value;
value ps_current_mode            : unknown -> unknown -> partial_value;
value ps_open_node_list          : unknown -> unknown -> partial_value;
value ps_close_node_list         : list unknown -> partial_value;
value ps_add_node                : unknown -> unknown -> partial_value;
value ps_set_default_char_cmd    : list unknown -> partial_value;
value ps_define_command          : list unknown -> partial_value;
value ps_define_pattern          : list unknown -> partial_value;
value ps_define_macro            : list unknown -> partial_value;
value ps_save_command            : unknown -> unknown -> partial_value;
value ps_restore_command         : unknown -> unknown -> partial_value;
value ps_save_pattern            : unknown -> unknown -> partial_value;
value ps_restore_pattern         : unknown -> unknown -> partial_value;
value ps_lookup_command          : list unknown -> partial_value;
value ps_push_env                : list unknown -> partial_value;
value ps_pop_env                 : list unknown -> partial_value;
value ps_set_env_args            : unknown -> unknown -> partial_value;
value ps_top_env                 : list unknown -> partial_value;
value ps_lookup_env              : list unknown -> partial_value;
value ps_define_env              : list unknown -> partial_value;
value ps_shipout_pages           : list unknown -> partial_value;
value ps_new_page_layout         : list unknown -> partial_value;
value ps_new_galley              : list unknown -> partial_value;
value ps_new_area                : list unknown -> partial_value;
value ps_declare_font            : list unknown -> partial_value;
value ps_define_math_symbol      : list unknown -> partial_value;
value ps_define_root_symbol      : list unknown -> partial_value;
value ps_define_math_accent      : list unknown -> partial_value;
value ps_set_colour              : unknown -> unknown -> partial_value;
value ps_set_bg_colour           : unknown -> unknown -> partial_value;
value ps_set_alpha               : unknown -> unknown -> partial_value;
value ps_draw                    : string -> Graphic.path_cmd -> unknown -> unknown -> partial_value;
value ps_set_line_width          : unknown -> unknown -> partial_value;
value ps_set_line_cap            : unknown -> unknown -> partial_value;
value ps_set_line_join           : unknown -> unknown -> partial_value;
value ps_set_miter_limit         : unknown -> unknown -> partial_value;
value ps_page_command            : unknown -> unknown -> partial_value;
value ps_par_command             : unknown -> unknown -> partial_value;
value ps_set_math_code           : list unknown -> partial_value;
value ps_new_counter             : list unknown -> partial_value;
value ps_get_counter             : list unknown -> partial_value;
value ps_set_counter             : list unknown -> partial_value;
value ps_dvi_special             : unknown -> unknown -> partial_value;
value ps_warning                 : unknown -> unknown -> partial_value;
value ps_error                   : unknown -> unknown -> partial_value;
value ps_execute_next_char       : unknown -> unknown -> partial_value;
value ps_execute_stream          : unknown -> unknown -> partial_value;
value ps_execute_argument        : unknown -> partial_value;
value ps_run_parser              : list unknown -> partial_value;

