# Voreinstellungsmen fr Drucker
#
# Copyright (C) 2004  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University


proc prt_select {s1 s2} {# get options after selection according to 
                         # s1 (== prtselstr) and 
                         # s2 (!= "" if landsc./portrait)
                         # return 1 if selection successfull, 0 otherwise
  global vv Wdv Wds drselmax dvsep lpcmd lpopt prtformat prtfmtli prmtext prmsel olsep
  global printer prtdriver prtoptions prtsuf prtpresel prtselstr opsep prtfilperm

  if {![info exists drselmax]} {
    set foid [open_vst printing.vst]
    # read first line, get number of criteris from it
    getscl $foid ein; close $foid; set dvsep [string index [string trim $ein] 0]
    set drselmax 2; while {[getvalue $ein [expr $drselmax+9] $dvsep]!=""} {incr drselmax}
  }

  TestPut 3 "<$s1><$s2>"
  set k $s1
  for {set n $drselmax} {$n>=0} {incr n -1} {
    set p [string last "," $k]
    set kl($n) [string trim [string range $k [expr $p+1] end]]
    set k [string trim [string range $k 0 [expr $p-1]]]
  }
  set oldfmt $prtformat
  set foid [open_vst printing.vst]
  getscl $foid ein; # skip first line
  if {[info exists prtfmtli]} {unset prtfmtli}
  while {[getscl $foid ein]>0} {
    set selected 0
    set z [split $ein $dvsep]
    if {[string trim [lindex $z 0]]==""} continue;# skip pre-selection setting
    if {[string trim [lindex $z 1]]==$kl(1)} {# printer name O.K.
      set prnt $kl(1);  incr selected
      if {"[string trim [lindex $z 2]]:[string trim [lindex $z 3]]"==$kl(2)} {
        incr selected;     # emulation and driver O.K.
        set pdriver  [string trim [lindex $z 3]]
        set psuf     [string trim [lindex $z 4]]
        set poptions [string trim [lindex $z 5]]
        set lcmd     [string trim [lindex $z 6]]
        set lopt     [string trim [lindex $z 7]]
        set plp "";  set pprt ""
        if {[string trim [lindex $z 0]]==$kl(0)} {# printer text O.K.
          set ptext "$kl(0), $kl(1), $kl(2)";  incr selected
          for {set n 3} {$n<=$drselmax} {incr n} {# check next criterium
            set sn [split [string trim [lindex $z [expr $n+8]]] ","]
	    if {$n==3} {# set list of all possible formats for this printer
              set prtfmtli ""
              foreach i $sn {# set list of all possible formats for this printer
                regsub -all "\{" $i " \{" lien
                set prtfmtli "$prtfmtli [lindex $lien 0]"
              }
	    }
	    if {($n==3)&&($s2!="")} {# format change is demanded
              foreach i $sn {# look for old format hit and new format hit
                if {[string first "$kl(3)" [string trim $i]]==0} {# old format hit
                  foreach j $sn {# look for new format hit
                    if {[string first "$s2" [string trim $j]]==0} {# new format hit
                      regsub -all "\{" $j " \{" ss
                      set pprt [string trim [lindex $ss 1]]
                      set plp  [string trim [lindex $ss 2]]
                      set ptext "$ptext, [lindex $ss 0]"
                      incr selected; break
                    }
                  }
                }
	      }
	    } else {# no format change or other criterium than format
              foreach i $sn {
                if {[string first "$kl($n)" [string trim $i]]==0} {
                  regsub -all "\{" $i " \{" ss
                  if {[string first \{ $ss]<0} {set ss "$ss \{\} \{\}"}
		  if {[string last \{ $ss]<[string first \} $ss]} {set ss "$ss \{\}"}
                  set z2 [expr [llength $ss]-1]; set z1 [expr $z2-1]
		  if {$n==3} {
                    set pprt [string trim [lindex $ss $z1]]
                    set plp  [string trim [lindex $ss $z2]]
                  } else {
                    set poptions [string trim "$poptions [lindex $ss $z1]"]
                    set lopt     [string trim "$lopt [lindex $ss $z2]"]
                  }
                  set ptext "$ptext, [string trim [lindex $ss 0]]"
                  incr selected; break
                }
	      }
	    }
          }
        }
        if {![info exists prtfmtli]} \
         {set prtfmtli "$vv(dvns1)\n$vv(dvns2): \"$kl(0)\"\n$vv(xt40)\n$vv(xt42)\n$vv(xt33)"}
      }
    }
    if {$selected==[expr $drselmax+1]} break
  }
  if {![info exists prtfmtli]} \
         {set prtfmtli "$vv(dvns1)\n$vv(dvns3): \"$kl(1)\"\n$vv(xt40)\n$vv(xt42)\n$vv(xt33)"}
  close $foid
  if {$selected==[expr $drselmax+1]} {
    set prtselstr  $ptext
    update_prtformat
    set printer    $prnt
    set prtdriver  $pdriver
    set prtsuf     $psuf
    set lpcmd      $lcmd
    if {$lpcmd==""} {set prtfilperm "$vv(dm19)"}
    if {$s2==""} {
      set prtoptions "$opsep $poptions $opsep $pprt"
      set lpopt      "$olsep $lopt $olsep $plp"
    } else {
      set prtoptions "$opsep [lindex [split $prtoptions $opsep] 1] $opsep $pprt"
      set lpopt      "$olsep [lindex [split $lpopt $olsep] 1] $olsep $plp"
    }
    set prmtext "";  set prmsel ""
    if [winfo exists $Wdv] {dvanzeige "$vv(aus0)"}
    if {($oldfmt!=$prtformat)&&($s2=="")} {format_switch $Wdv.d.tt $prtformat 1}
  }
  if {$selected==[expr $drselmax+1]} {return 1} else {return 0}
}

proc dv  {} {

proc dvsel {s} {
  global Wdv vv
  dvfocus ""
  if {$s!=""} {prt_select "$s" ""} else {writescr0 $Wdv.d.tt "\n $vv(el)\n\n"; mybell 2}
}

proc dvfocus {w} {
  global Wdv dv_foc
  if {$dv_foc==1} {dvopt1} elseif {$dv_foc==2} {dvopt2}
  if {$w!=""} {focus $w} else {focus $Wdv.d.tt}
}

proc dvopt1 {} {
  global Wdv vv prtoptions dv_foc
  set prtoptions  [string trim [$Wdv.cb get]]
  writescr0 $Wdv.d.tt "$vv(dvca1)\n $prtoptions\n"
  set dv_foc 0
}

proc dvopt2 {} {
  global Wdv vv lpopt dv_foc
  set lpopt  [string trim [$Wdv.cd get]]
  writescr0 $Wdv.d.tt "$vv(dvcc1)\n $lpopt\n"
  set dv_foc 0
}

proc dvanzeige {s1} {
  global vv Wdv Wds prtselstr printer prtdriver prtoptions prtsuf lpcmd lpopt prtpresel
  global prtformat drselmax
  $Wdv.cb delete 0 end; $Wdv.cb insert end "$prtoptions"
  $Wdv.cd delete 0 end; $Wdv.cd insert end "$lpopt"
  if {$printer==""} {set t "$vv(dvbad1)"} else {set t "$vv(dvbad2) $prtselstr"}
  $Wdv.b.ad configure -text "$t"
  if {$s1!=""} {  writescr0 $Wdv.d.tt "$s1\n\n$prtselstr\n\n $vv(dv2)  $printer\n" \
	" $vv(dv4)  $prtdriver\n $vv(dv6)  $prtformat\n $vv(dv7)  $prtoptions\n" \
	" $vv(dv10) $prtsuf\n $vv(dv3)  $lpcmd\n $vv(dv8)  $lpopt\n $vv(dv5)  $prtpresel\n\n"
  }
}

proc drlistfill {repeat} {# fills the "printer list" in the "printer settings" menu
			  # by reading file printing.vst, respecting criteria setting
  global vv Wdv Wds printer prtdriver prtpresel prtselstr vst_dir dvlf prtlistsort
  global drselmax drsel drseltit drseln dvsep prtsuf vd drselnm lpcmd drselrep

  if {[winfo exists $Wds]} {$Wds.b.n configure -text "$vv(dsb1)";  update idletasks}

  set foid [open_vst printing.vst]
  # read first line, get separator and titles for selection criteria from it
  getscl $foid ein;  set dvsep [string index [string trim $ein] 0]
  set drseltit(0) [getvalue $ein 1 $dvsep]
  set drseltit(1) "[getvalue $ein 2 $dvsep]:[getvalue $ein 3 $dvsep]"
  set drselmax 2
  while {[getvalue $ein [expr $drselmax+9] $dvsep]!=""} {incr drselmax}
  for {set n 0} {$n<$drselmax} {incr n} {set drsel($n) [lindex $prtpresel $n]}
  for {set n 2} {$n<=$drselmax} {incr n} {set drseltit($n) [getvalue $ein [expr $n+9] $dvsep]}
  # read 2. and following lines
  $Wdv.c.f.f.li delete 0 end; set drseln 0; set liste ""
  while {[getscl $foid ein]>0} {
    set z [split $ein $dvsep]
    if {[string trim [lindex $z 0]]==""} continue;# skip pre-selection setting
    if {[drlistfill1 $z]} {foreach k [array names vd] {lappend liste $vd($k); unset vd($k)}}
  }
  if {$prtlistsort==1} {set liste [lsort $liste]}
  foreach k $liste {$Wdv.c.f.f.li insert end $k; set dvlf "$k"}
  close $foid
  if {[winfo exists $Wds]} {
      $Wds.b.n configure -text "$vv(dsb1)  $drseln  $vv(dsb2)  $drselnm  $vv(dsb3)"
  }
  if {$drseln==0} {
    if {$repeat==1} {
	dvanzeige ""
	writescr $Wdv.d.tt "$vv(dvlf5)\n$vv(dvlf6)\n$vv(dvlf7)\n"
	$Wdv.d.tt yview -pickplace 2
	mybell 3
    } elseif {$repeat==2} {
	for {set i 2;set prtpresel *} {$i<=$drselmax} {incr i} {set prtpresel "$prtpresel *"}
	writescr $Wdv.d.tt "$vv(errf) $vst_dir/printing.vst\n$vv(dvlf5)\n$vv(dvlf1)\n" \
		"$vv(dvlf2) `$prtpresel'\n$vv(dvlf3)\n$vv(dvlf7)\n$vv(adm)\n"
	mybell 3; drlistfill 3
    } elseif {$repeat==3} {
	writescr $Wdv.d.tt "$vv(errf) $vst_dir/printing.vst\n$vv(dvlf4)\n$vv(adm)\n"
	mybell 3
    }
  }
}

proc drlistfill1 {z} {# tests, if a line of file "printing.vst" fits actual
  # criteria and sets global variable vd to the line(s) to be added to the printer list
  global drsel drselmax vd dvsep drseln

  set hs0 [string trim [lindex $z 0]]; set hs1 [string trim [lindex $z 1]]
  if {("$drsel(0)"!="*")&&("$drsel(0)"!="$hs1")} {return 0} else {set vd(0) "$hs0,  $hs1"}
  set hs "[string trim [lindex $z 2]]:[string trim [lindex $z 3]]"
  if {("$drsel(1)"!="*")&&("$drsel(1)"!="$hs")} {return 0} else {set vd(0) "$vd(0), $hs"}
  for {set n 2} {$n<$drselmax} {incr n} {
    set sn [split [string trim [lindex $z [expr $n+9]]] ","]
    foreach k [array names vd] {
      foreach i $sn {
       regsub -all "\{" $i " \{" lien
       set crit [lindex $lien 0]
       if {("$crit"=="$drsel($n)")||("$drsel($n)"=="*")} {set vd($k,"$crit") "$vd($k), $crit"}
      }
      unset vd($k)
    }
  }
  set anz [array size vd]
  if {$anz==0} {unset vd}
  incr drseln $anz
  return $anz
}

proc dvWdvae {} {
  global Wdv Wds
  dvfocus ""
  destros $Wdv; knoepfe; unlock_list; if {[winfo exists $Wds]} {destros $Wds;update idletasks}
}


global vv Wdv drselmax sizeds dv_foc

toplevel_init $Wdv "$vv(dvvor)" 0 0;  set tyh 10

# Bereich a fuer erste Buttons

frame $Wdv.a; pack configure $Wdv.a -anchor w -fill x
frame $Wdv.a.b; pack configure $Wdv.a.b -side right -anchor e -pady 6 -ipadx 10

insertTopButtons $Wdv.a dv_h dvWdvae $Wdv.d.tt
button $Wdv.a.a.g -text "$vv(ag)" -command \
	{dvfocus ""; vstr_printer; dvanzeige "$vv(ausg1)"; drlistfill 2}
Bind3HF $Wdv.a.a.g dv_grund $Wdv.d.tt
pack configure $Wdv.a.a.g -side left -padx 3 -pady 3

button $Wdv.a.b.s -text "$vv(dvas)" -command {
  if {$drselmax==0} {writescr0 $Wdv.d.tt "\n$vv(dsex)\n"; mybell 2} \
  else {if [winfo exists $Wds] {raise $Wds} else {ds}}
}
Bind3HF $Wdv.a.b.s dv_drvsel $Wdv.d.tt
pack configure $Wdv.a.b.s


# Bereich bv fuer eigene Einstellungen

frame $Wdv.bv; pack configure $Wdv.bv -pady 13 -anchor w
label $Wdv.bv.dv -text "$vv(bvdv)"  -width 23 -anchor w
Bind3HF $Wdv.bv.dv z_voreinst1 $Wdv.d.tt
button $Wdv.bv.va -text "$vv(bvva)" -command {dvfocus ""; dvanzeige "$vv(aus0)"}
Bind3HF $Wdv.bv.va z_voreinst1 $Wdv.d.tt
pack configure $Wdv.bv.dv $Wdv.bv.va -side left


# Bereich b fuer Anzeigen

frame $Wdv.b; pack configure $Wdv.b -anchor w
label $Wdv.b.ad -width 100 -anchor w; pack configure $Wdv.b.ad -anchor w
Bind3HF $Wdv.b.ad dv_anzeig $Wdv.d.tt


# Bereich c fuer Wechsel

frame $Wdv.c; pack configure $Wdv.c -anchor w -fill both -expand 1
set p [string first x $sizeds]
set w [string range $sizeds 0 [expr $p-1]]; set h [string range $sizeds [expr $p+1] end]
CreateLSBox $Wdv.c $vv(dvc1dl) top $w $h 2 dv_drusel $Wdv.d.tt "" "" dvsel selxsb dvWdvae
foreach n "0 1" {
 radiobutton $Wdv.c.f.l.$n -text "$vv(sort$n)" -value $n -variable prtlistsort \
		-command "drlistfill 0"
 pack configure $Wdv.c.f.l.$n -side left -padx 5
 Bind3HF $Wdv.c.f.l.$n dv_drusel $Wdv.d.tt
}

# Ausgabe und Veraendern der Optionen-Strings

label $Wdv.ca -text "$vv(dvca)"; pack configure $Wdv.ca -anchor sw
Bind3HF $Wdv.ca dv_optedi $Wdv.d.tt
entry $Wdv.cb -width 100 -relief sunken; pack configure $Wdv.cb -anchor nw
bind $Wdv.cb <Button-1> {dvfocus $Wdv.cb; set dv_foc 1}
Bind3HF $Wdv.cb dv_optedi $Wdv.d.tt
bind $Wdv.cb <Return> {dvopt1; dvfocus ""}

label $Wdv.cc -text "$vv(dvcc)"; pack configure $Wdv.cc -anchor sw
Bind3HF $Wdv.cc dv_droptedi $Wdv.d.tt
entry $Wdv.cd -width 100 -relief sunken; pack configure $Wdv.cd -anchor nw
bind $Wdv.cd <Button-1> {dvfocus $Wdv.cd; set dv_foc 2}
Bind3HF $Wdv.cd dv_droptedi $Wdv.d.tt
bind $Wdv.cd <Return> {dvopt2; dvfocus ""}

InsertTextFrame $Wdv $tyh "" "" ""

dvanzeige ""; drlistfill 1; set dv_foc 0
}
