/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.model;

import java.util.Arrays;
import net.sourceforge.texlipse.TexlipsePlugin;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;

public class TexStyleCompletionManager
implements IPropertyChangeListener {
    private static TexStyleCompletionManager theInstance;
    private String[] STYLETAGS = new String[]{"\\textbf{", "\\textit{", "\\textrm{", "\\textsf{", "\\textsc", "\\textsl{", "\\texttt{", "\\emph{", "{\\huge", "{\\Huge"};
    private String[] STYLELABELS = new String[]{"bold", "italic", "roman", "sans serif", "small caps", "slanted", "teletype", "emphasize", "huge", "Huge"};

    private TexStyleCompletionManager() {
        this.readSettings();
    }

    public static TexStyleCompletionManager getInstance() {
        if (theInstance == null) {
            theInstance = new TexStyleCompletionManager();
            TexlipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)theInstance);
        }
        return theInstance;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("styleCompletionSet")) {
            this.readSettings();
        }
    }

    private void readSettings() {
        Object[] props = TexlipsePlugin.getPreferenceArray("styleCompletionSet");
        Arrays.sort(props);
        this.STYLELABELS = new String[props.length];
        this.STYLETAGS = new String[props.length];
        int i = 0;
        while (i < props.length) {
            String[] pair = ((String)props[i]).split("=");
            this.STYLELABELS[i] = pair[0];
            this.STYLETAGS[i] = pair[1];
            ++i;
        }
    }

    public ICompletionProposal[] getStyleCompletions(String selectedText, Point selectedRange) {
        ICompletionProposal[] result = new ICompletionProposal[this.STYLELABELS.length];
        int i = 0;
        while (i < this.STYLETAGS.length) {
            String tag = this.STYLETAGS[i];
            String replacement = String.valueOf(tag) + selectedText + "}";
            int cursor = tag.length() + selectedText.length() + 1;
            ContextInformation contextInfo = new ContextInformation(null, String.valueOf(this.STYLELABELS[i]) + " Style");
            result[i] = new CompletionProposal(replacement, selectedRange.x, selectedRange.y, cursor, null, this.STYLELABELS[i], (IContextInformation)contextInfo, replacement);
            ++i;
        }
        return result;
    }

    public IContextInformation[] getStyleContext() {
        ContextInformation[] contextInfos = new ContextInformation[this.STYLELABELS.length];
        int i = 0;
        while (i < this.STYLELABELS.length) {
            contextInfos[i] = new ContextInformation(null, String.valueOf(this.STYLELABELS[i]) + " Style");
            ++i;
        }
        return contextInfos;
    }
}

