/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.SpellDictionaryASpell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class GenericSpellDictionary
extends SpellDictionaryASpell {
    private static final int INITIAL_CAPACITY = 16384;
    protected HashMap mainDictionary = new HashMap(16384);
    private File dictFile = null;

    public GenericSpellDictionary(File file) throws FileNotFoundException, IOException {
        this(file, (File)null);
    }

    public GenericSpellDictionary(File file, File file2) throws FileNotFoundException, IOException {
        super(file2);
        this.dictFile = file;
        this.createDictionary(new BufferedReader(new FileReader(file)));
    }

    public void addWord(String string) {
        this.putWord(string);
        if (this.dictFile == null) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(this.dictFile.toString(), true);
            fileWriter.write(string);
            fileWriter.write("\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Error writing to dictionary file");
        }
    }

    protected void createDictionary(BufferedReader bufferedReader) throws IOException {
        String string = "";
        while (string != null) {
            string = bufferedReader.readLine();
            if (string == null) continue;
            string = new String(string.toCharArray());
            this.putWord(string);
        }
    }

    protected void putWord(String string) {
        String string2 = this.getCode(string);
        LinkedList<String> linkedList = (LinkedList<String>)this.mainDictionary.get(string2);
        if (linkedList != null) {
            linkedList.add(string);
        } else {
            linkedList = new LinkedList<String>();
            linkedList.add(string);
            this.mainDictionary.put(string2, linkedList);
        }
    }

    public List getWords(String string) {
        List list = (List)this.mainDictionary.get(string);
        if (list == null) {
            return new Vector();
        }
        return list;
    }

    public boolean isCorrect(String string) {
        List list = this.getWords(this.getCode(string));
        if (list.contains(string)) {
            return true;
        }
        return list.contains(string.toLowerCase());
    }
}

