.TH info 1 "20th March 1993"
.SH NAME
rtf2LaTeX \- Convert RTF (Rich Text Format) to LaTeX
.SH SYNOPSIS
.B rtf2LaTeX
[
.B \-c
]
[
.B \-C filename
]
[
.B \-d
]
[
.B \-g
]
[
.B \-G
]
[
.B \-h
]
[
.B \-H
]
[
.B \-L filename
]
[
.B \-p
]
[
.B \-q
]
[
.B \-r
]
[
.B \-s
]
[
.B \-t
]
[
.B \-T decrease size
]
[
.B \-u
]
[
.B \-v[#]
]
[
.B \-V
]
[
.B RTF-file
]
.SH DESCRIPTION
.LP
.I rtf2LaTeX
is a filter built on Paul DuBois' RTF reader that converts
RTF (Microsoft's Rich Text Format) into LaTeX.
.I rtf2LaTeX
expends a good deal of effort in an attempt to make the resulting
LaTeX maintainable and modifiable.

There are a large number of features that
.I rtf2LaTeX
doesn't support due to a lack of motivation; many could be easily
added without making any major changes to the program, by just
adding short sections of code.

.SH OPTIONS

.TP
.B \-c
Generate LaTeX-file without character-formatting.

.TP
.B \-C filename
Use another translation-file for characters with numbers above 128 (filename without extension).
The translation-file must have the extension .code.
.br
The default translation-file is mac.code, which is for rtf-files made by Macintosh programs.
(This translation-file has the rtf-control-word \\mac at the beginning.)
You have to use the translation-file ansi.code for rtf-files made by DOS or WINDOWS (rtf-control-word \\ansi)
Both of these translation-files comprise the most important characters.
If you need more, you will be able to add more in a very easy way.
You can create your own translation-file as follows:

.br
A comment must be written in the first line of the translation-file.
Then the lines with the characters follows.
The rtf-number of the character (from 128 to 255) is at the beginning of each line.
Then the LaTeX command (a string) follows after a single space.
A comment can be written after the 25th column.
You needn't include all numbers from 128 to 256.
There are no tab stops allowed.

.br
Examples are in the files interna.rtf or interna.tex
For an example of a whole translation-file see mac.code

.TP
.B \-d
Generate no formatting characters within LaTeX commands like section,
footnotes, header, etc.

.TP
.B \-g
Generate german single quotes (this needs
the style option german.sty by H. Partl available on the net)
instead of the english version of single quotes.

.TP
.B \-G
Generate german double quotes (this needs
the style option german.sty by H. Partl available on the net)
instead of the english version of double quotes.

.TP
.B \-h
Print a summary of your options.

.TP
.B \-H
Use LaTeX header and footer. This means, that the page number is in the footer and the header is empty.
If you don't use this flag, the page number will be in the right corner of the header and an attempt will be made to translate the RTF-header.
The RTF-footer is always ignored!

.TP
.B \-L filename
Use another translation-file for special WORD styles like heading, footer, ... . (filename without extension)
The translation-file must have the extension .land.

.br
Some WORD-styles will be translated in LaTeX-commands (e.g. heading 1 to \\section, heading 2 to \\subsection, ...)
Others will be ignored (if the flag -d is off), because LaTeX treats them in a better way than WORD (e.g. footnote reference, footnote text)
The translation-files with the extension .land tells the filter how they should be translated.

.br 
The default translation-file is english.land, which is for rtf-files made by the English versions of WORD and WINWORD.
(This translation-file uses the styles heading 1, heading 2, ... footer, header, footnote text, ...)
You have to use the translation-file german.land for rtf-files made by German versions
of WORD and WINWORD. (style names: Gliederung 1, Fu/3zeile, ...)
Both of these files comprise the most important special WORD styles.
If you need more, you will be able to add more in a very easy way.
You can create your own translation-file as follows:

.br
A comment must be written in the first line of the translation-file.
Then the lines with the styles follows.
The name of the style is at the beginning of each line. (Must be a string of 20 characters)
It may be followed by the LaTeX-begin-command (a string of 20 characters) and the LaTeX-end-command (20 characters).
(If there are no LaTeX commands the style will be ignored.)
A comment can be written after the 60th column. (This comment will be added to the LaTeX output file)
There are no tab stops allowed.
Examples are in the files interna.rtf or interna.tex
For an example of a whole translation-file see english.land.

.TP
.B \-n
Use \\hfil\\break instead of \\\\ for making a new line
.TP
.B \-p
Generate LaTeX-file without paragraph-formatting.

.TP
.B \-q
Count double quotes and replace every second quote with a closing quote
on output. This is useful if you entered only one sort of quotes in the
document and you are sure that you did't forget quotes. Warning: this
option will almost certainly produce junk if the document contains left and
right double quotes.

.TP
.B \-r
Generate no right or left indent.

.TP
.B \-s
Don't generate Tab stops.

.TP
.B \-t
Generate non-formatted tables.

.TP
.B -T f
Use another factor to decrease the cells of all tables; defaults to 0,7.

.TP
.B \-u
Change underlined text to emphasized text. 

.TP
.B -v[#]
Turn on verbose messages; # defaults to one. The larger the value of
the verbosity is, the more messages you'll get. 

.TP
.B -V
Print the current version number.

.TP
.B RTF-file
The RTF file to convert. If you don't specify an input file
.I rtf2LaTeX
will read the standard input.


.SH TROUBLESHOOTING

.I Try this, if LaTeX shows some errors or warnings:

Sometimes you can simply ignore a LaTeX error or warning.
If this doesn't help, look for the error at the following list:

.I Command name ... already used

There is a RTF-style name, which has the same name as a LaTeX 
command.

Change the name of the RTF-style in the RTF-file or the name 
of the new environment in the LaTeX-file.

Or add the style in the file english.land or german.land. (see flag -L)

.I Missing begin{document}

In a LaTeX-file made by rtf2LaTeX there should stay only some 
of the following lines before \\begin{document};

\\documentstyle{article}
.br
\\pagestyle{myheadings}
.br
\\newlength{\\defaultparindent}
.br
\\setlength{\\defaultparindent}{\\parindent}
.br
lines with % at the beginning (These lines are ignored by LaTeX)
.br
and lines, which define a new environment.

If there are any more lines, delete them.

.I Missing $ inserted

In most cases you can ignore this error, because LaTeX has 
already inserted the $ for you.

But nevertheless have a look at the file with the extension ".code" 
you use. (e.g. mac.code, ansi.code, ...)  Some of the LaTeX-commands 
for a special font need the `math mode'. This means that the 
command must be enclosed with $ (e.g.  $\\pounds$, 
$\\ll$, $\\gg$, ...)

Or rtf2LaTeX has put wrong tab stops. You can use the -s flag 
in this case.

.I Something's wrong--perhaps a missing \\item

Try the -r flag.

To make left or right indent in LaTeX, you have to use the ``list'' 
environment (\\begin{list}, \\end{list}). 
This may cause some troubles. The -r flag ignores left or right 
indent and so you don't need any ``list`` environment.

.I There's no line here to end

Try to ignore this LaTeX-error.
If this doesn't help, have a look where this warning appears:

There may be a problem with tab stops.  
Use the -s or -t flag.

Or there may be a problem with making a new line (rtf-control-word \\line).
Use the -n flag to change \\\\ to \\hfil\\break.
\\hfil\\break works always, but the output in centered text is bad.

.I Overfull 
.I hbox ...

This means that a line is too long or that LaTeX can't find a 
good place to break a line. Have a look where  this warning appears:

In a table: Try the -T flag to use another decrease-factor  
for the cell-width. (default is 0.7)

Within underlined lines: LaTeX won't break the line, if it is 
underlined. Use the flag -u to change underline to italics.

Elsewhere: Use the LaTeX-commands \\- or \\hyphenation{...} 
to tell LaTeX where it is allowed to hyphenate 

.I Underfull 
.I hbox ...

Mostly appears in tables. Ignore it!

.I Overfull vbox ...

More text is on a Page than there should be. 

A table may be too long:  End the table (with \\end{tabular}) 
anywhere in the middle and start a new table with the same parameters 
(\\begin{tabular}{p...}

Use \\newpage or \\pagebreak.

.I Underfull vbox ...

A table may be too long and put on the next page. See Overfull 
\\vbox.


.SH SEE ALSO
.BR tex(1)
.BR latex(1)
.BR rtf2TeX (1)

.SH BUGS
Many keywords aren't dealt with, although it would not be hard
to support them.
.br
Tables may cause some troubles. (It's hard to know where the end is.)
.br
.I rtf2LaTeX 
sometimes puts wrong tab stops.
.br
Many spaces are treated as one; black lines are ignored.
.br
.I rtf2LaTeX 
makes justified lines instead of flushleft ones.
.br 
Sometimes incorrect LaTeX is produced.

.SH AUTHOR
.RS
Erwin Wechtl
.br


