/****************************************************************************
  PROJECT: MusixTeX PreProcessor
  FILE   : define.cc
  AUTHOR : J. C. Nieuwenhuizen

  copyright (c) FlowerSoft 1995
--*/

#define max( a, b )            ( ( ( a ) > ( b ) ) ? ( a ) : ( b ) )
#define min( a, b )            ( ( ( a ) < ( b ) ) ? ( a ) : ( b ) )

#include "init.h"
#include "staff.h"
#include "duration.h"
#include "strlist.h"
#include "define.h"
#include "mpp.h"

/****************************************************************************
  class Define
--*/

Define::Define( const char* s ) :
    Macro( s, "",  1 )
{
//    baseSubstitute = s;
} 

Define::~Define()
{
}

void Define::execute( StringList& parameterList, Staff& )
{
    substitute = "\\def\\the";
//    substitute += baseSubstitute;
    substitute += name;
    substitute += "{";
    substitute += parameterList.top();
    substitute += "}%\n";
}
//-- class Define //

/****************************************************************************
  class Meter
--*/

Meter::Meter( const char* s ) :
    Macro( s, "",  1 )
{
} 

Meter::~Meter()
{
}

void Meter::execute( StringList& parameterList, Staff& )
{
    int duration = 0;

                               // this goes wrong!
//    String s = parameterList.top();
                               // eiter this
//    String s( (const char*)parameterList.top() );
                               // or this
    String s;
    s = parameterList.top();

    substitute = "\\generalmeter{";
    if ( s == "C" )
        {
        substitute += "\\meterC";
        Duration whole( 1 );
        duration = whole.duration();
        }
    else if ( s == "C2" )
        {
        substitute += "\\allabreve";
        Duration whole( 1 );
        duration = whole.duration();
        }
    else
        {
        String numerator = String( s.left( s.pos( '/' ) - 1 ) );
        String denomenator = String( s.right( s.len() - s.pos( '/' ) ) );
        ;// monitor << numerator << '/' << denomenator << flush; 
#if 0 // defined( __TURBOC__ )
        Duration d( denomenator.value() );
        duration = numerator.value() * d.duration();
        ;// monitor << '(' << numerator.value() << ',' << d.duration() << flush;
        ;// monitor << ';' << duration << ')' << endl;
#else
        Duration d( char2istream( denomenator ) );
        duration = numerator.value() * d.duration();
        ;// monitor << '(' << numerator.value() << ',' << d.duration() << flush;
        ;// monitor << ';' << duration << ')' << endl;
#endif            
        substitute += "\\meterfrac{";
        substitute += numerator;
        substitute += "}{";
        substitute += denomenator;
        substitute += "}";
        }
    substitute += "}%\n";
    
    if ( duration )
        {
        if ( Staff::barCount && Staff::barDuration )
            {
            Staff::newBarDuration = duration;
            Staff::changeContext = 1;
            }
        else    
            Staff::barDuration = duration;
        }
}
//-- class Meter //

/****************************************************************************
  class Metron
--*/

Metron::Metron( const char* s ) :
    Macro( s, "",  1 )
{
//    baseSubstitute = s;
} 

Metron::~Metron()
{
}

void Metron::execute( StringList& parameterList, Staff& )
{
    ;// monitor << "Metron::execute" << flush;

    substitute = "\\def\\the"; 
//    substitute += baseSubstitute;
    substitute += name;
    substitute += "{";

    String s( parameterList.top() );
#if 0
    String durationString( s );
    char* buf = new char[ durationString.len() + 2 ];
    durationString( buf );
    istrstream ss( buf, durationString.len() );
    Duration duration( ss );
    delete buf;
#else
    Duration duration( char2istream( (const char*)s ) );
#endif

    substitute += "\\";
    substitute += duration.alpha();
    substitute += "u";
    substitute += String( 'p', duration.dots );
    substitute += "{";
    substitute += String( s.right( s.len() - s.pos( '=' ) ) );
    substitute += "}";
    substitute += "}%\n";
}
//-- class Metron //

/****************************************************************************
  class NewLine
--*/

NewLine::NewLine( const char* s, const char* sub ) :
    Macro( s, sub )
{
} 

NewLine::~NewLine()
{
}

void NewLine::execute( StringList& parameterList, Staff& staff )
{
    if ( &parameterList );
    
    staff.newLine = 1;
                               // this is not ok, string should be saved!
//    if ( staff.number + 1 != staff.count )
    if ( staff.number )
        substitute = "";
    else
        substitute = "\\alaligne";
}
//-- class NewLine //

/****************************************************************************
  class Volta
--*/

Volta::Volta( const char* s, const char* base ) :
    Macro( s, base, 1 )
//    baseSubstitute( base )
{
} 

Volta::~Volta()
{
}

void Volta::execute( StringList& parameterList, Staff& staff )
{
    String s;
    
    if ( parameterList.count() )
        s = parameterList.top();

    int volta = s.value();

#if 1
//    if ( staff.number + 1 != staff.count )
    if ( staff.number )
        substitute = "";
    else
        {
        if ( volta )
            {
            substitute = "\\";
            substitute += baseSubstitute;
//            substitute += name;
            substitute += "{";
            substitute += s;
            substitute += "}";
            }
        if ( volta != 1 )
//            substitute += "\\endvoltabox";
            substitute += "\\endvolta";
        }
#else
    if ( staff.number )
        substitute = "";
    else
        {
        substitute = "\\";
        substitute += baseSubstitute;
//        substitute += name;
        if ( volta )
            {
            substitute += "{";
            substitute += s;
            substitute += "}";
            }
        }
#endif
}
//-- class Volta //
