/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config.base.spi;

import com.izforge.izpack.util.config.base.Config;
import com.izforge.izpack.util.config.base.spi.EscapeTool;
import com.izforge.izpack.util.config.base.spi.HandlerBase;
import java.io.PrintWriter;
import java.util.List;

abstract class AbstractFormatter
implements HandlerBase {
    private static final char COMMENT = '#';
    private Config _config = Config.getGlobal();
    private PrintWriter _output;

    AbstractFormatter() {
    }

    @Override
    public void handleEmptyLine() {
    }

    @Override
    public void handleComment(List<String> comment) {
        if (comment != null && this.getConfig().isComment()) {
            for (String singleComment : comment) {
                if (singleComment.startsWith("\u0000")) {
                    this.getOutput().print(this.getConfig().getLineSeparator());
                    continue;
                }
                for (String line : singleComment.split(this.getConfig().getLineSeparator())) {
                    this.getOutput().print('#');
                    this.getOutput().print(line);
                    this.getOutput().print(this.getConfig().getLineSeparator());
                }
            }
        }
    }

    @Override
    public void handleOption(String optionName, String optionValue) {
        String operator = this.getConfig().getOperator();
        if (this.getConfig().isStrictOperator()) {
            if (this.getConfig().isEmptyOption() || optionValue != null) {
                this.getOutput().print(this.escapeFilter(optionName));
                this.getOutput().print(operator);
            }
            if (optionValue != null) {
                this.getOutput().print(this.escapeFilter(optionValue));
            }
            if (this.getConfig().isEmptyOption() || optionValue != null) {
                this.getOutput().print(this.getConfig().getLineSeparator());
            }
        } else {
            String value;
            String string = value = optionValue == null && this.getConfig().isEmptyOption() ? "" : optionValue;
            if (value != null) {
                this.getOutput().print(this.escapeFilter(optionName));
                this.getOutput().print(operator);
                this.getOutput().print(this.escapeFilter(value));
                this.getOutput().print(this.getConfig().getLineSeparator());
            }
        }
    }

    protected Config getConfig() {
        return this._config;
    }

    protected void setConfig(Config value) {
        this._config = value;
    }

    protected PrintWriter getOutput() {
        return this._output;
    }

    protected void setOutput(PrintWriter value) {
        this._output = value;
    }

    String escapeFilter(String input) {
        return this.getConfig().isEscape() ? EscapeTool.getInstance().escape(input) : input;
    }
}

