/* the clear text equivalent names of the metafile elements */
/* first as we will write them */
/* the delimiters */
static char *cc_delim[Delim_Size] = {"",
"BegMF", "EndMF", "BegPic", "BegPicBody", "EndPic"
};
/* now the metafile descriptors */
static char *cc_mfdesc[MfDesc_Size] = {"",
"MFVersion", "MFDesc", "VDCType", "IntegerPrec", "RealPrec", "IndexPrec",
"ColrPrec", "ColrIndexPrec", "MaxColrIndex", "ColrValueExt", "MFElemList",
"MFDefaults", "FontList", "CharSetList", "CharCoding"
};
/* the page descriptors */
static char *cc_pdesc[PDesc_Size] = {"",
"ScaleMode", "ColrMode", "LineWidthMode", "MarkerSizeMode", "EdgeWidthMode",
"VDCExt", "BackColr"
};
/* the control elements */
static char *cc_control[Control_Size] = {"",
"VDCIntegerPrec", "VDCRealPrec", "AuxColr", 
"Transparency", "ClipRect", "Clip"
};
static char *cc_gprim[GPrim_Size] = {"",
"Line", "DisjtLine", "Marker", "Text", "RestrText", "ApndText", "Polygon",
"PolygonSet", "CellArray", "GDP", "Rect", "Circle", "Arc3Pt", "Arc3PtClose",
"ArcCtr", "ArcCtrClose", "Ellipse", "EllipArc", "EllipArcClose",
"IncrLine","IncrDisjLine", "IncrMarker", "IncrPolygon", "IncrPolygonSet"
};
/* the attribute elements */
static char *cc_attr[Att_Size] = {"",
"LineIndex", "LineType", "LineWidth", "LineColr", "MarkerIndex", "MarkerType",
"MarkerSize", "MarkerColr", "TextIndex", "TextFontIndex", "TextPrec", 
"CharExpan", "CharSpace", "TextColr", "CharHeight", "CharOri", "TextPath",
"TextAlign", "CharSetIndex", "AltCharSetIndex", "FillIndex", "IntStyle", 
"FillColr", "HatchIndex", "PatIndex", "EdgeIndex", "EdgeType", "EdgeWidth",
"EdgeColr", "EdgeVis", "FillRefPt", "PatTable", "PatSize", "ColrTable", 
"ASF"
};
/* the escape element */
static char *cc_escape[Esc_Size] = {"",
"Escape"
};
/* the external elements */
static char *cc_external[Ext_Size] = {"",
"Message", "ApplData"
};
/* now the array of pointers that ties them all together */
static char **cc_cptr[8] = {cc_delim, cc_mfdesc, cc_pdesc, cc_control, cc_gprim, 
cc_attr, cc_escape, cc_external};
/* and the associated dimensions (by hand, for convenience) */
static int cc_size[8] = {Delim_Size, MfDesc_Size, PDesc_Size, Control_Size,
GPrim_Size, Att_Size, Esc_Size, Ext_Size};
/* Now as we store them internally for speed */
/* the delimiters */
static char *CC_delim[Delim_Size] = {"",
"BEGMF", "ENDMF", "BEGPIC", "BEGPICBODY", "ENDPIC"
};
/* now the metafile descriptors */
static char *CC_mfdesc[MfDesc_Size] = {"",
"MFVERSION", "MFDESC", "VDCTYPE", "INTEGERPREC", "REALPREC", "INDEXPREC",
"COLRPREC", "COLRINDEXPREC", "MAXCOLRINDEX", "COLRVALUEEXT", "MFELEMLIST",
"MFDEFAULTS", "FONTLIST", "CHARSETLIST", "CHARCODING"
};
/* the page descriptors */
static char *CC_pdesc[PDesc_Size] = {"",
"SCALEMODE", "COLRMODE", "LINEWIDTHMODE", "MARKERSIZEMODE", "EDGEWIDTHMODE",
"VDCEXT", "BACKCOLR"
};
/* the control elements */
static char *CC_control[Control_Size] = {"",
"VDCINTEGERPREC", "VDCREALPREC", "AUXCOLR", 
"TRANSPARENCY", "CLIPRECT", "CLIP"
};
static char *CC_gprim[GPrim_Size] = {"",
"LINE", "DISJTLINE", "MARKER", "TEXT", "RESTRTEXT", "APNDTEXT", "POLYGON",
"POLYGONSET", "CELLARRAY", "GDP", "RECT", "CIRCLE", "ARC3PT", "ARC3PTCLOSE",
"ARCCTR", "ARCCTRCLOSE", "ELLIPSE", "ELLIPARC", "ELLIPARCCLOSE",
"INCRLINE","INCRDISJTLINE","INCRMARKER","INCRPOLYGON","INCRPOLYGONSET"
};
/* the attribute elements */
static char *CC_attr[Att_Size] = {"",
"LINEINDEX", "LINETYPE", "LINEWIDTH", "LINECOLR", "MARKERINDEX", "MARKERTYPE",
"MARKERSIZE", "MARKERCOLR", "TEXTINDEX", "TEXTFONTINDEX", "TEXTPREC", 
"CHAREXPAN", "CHARSPACE", "TEXTCOLR", "CHARHEIGHT", "CHARORI", "TEXTPATH",
"TEXTALIGN", "CHARSETINDEX", "ALTCHARSETINDEX", "FILLINDEX", "INTSTYLE", 
"FILLCOLR", "HATCHINDEX", "PATINDEX", "EDGEINDEX", "EDGETYPE", "EDGEWIDTH",
"EDGECOLR", "EDGEVIS", "FILLREFPT", "PATTABLE", "PATSIZE", "COLRTABLE", 
"ASF"
};
/* the escape element */
static char *CC_escape[Esc_Size] = {"",
"ESCAPE"
};
/* the external elements */
static char *CC_external[Ext_Size] = {"",
"MESSAGE", "APPLDATA"
};
/* now the array of pointers that ties them all together */
static char **CC_cptr[8] = {CC_delim, CC_mfdesc, CC_pdesc, CC_control, 
CC_gprim, CC_attr, CC_escape, CC_external};

/* now the Aspect source flags */
#define NO_ASPS_FLAGS 18
static char *asps_flags[NO_ASPS_FLAGS] = {
"LINETYPE", "LINEWIDTH", "LINECOLR",
"MARKERTYPE", "MARKERSIZE", "MARKERCOLR",
"TEXTFONTINDEX", "TEXTPREC", "CHAREXP",
"CHARSPACE", "TEXTCOLR", "INTSTYLE",
"FILLCOLR", "HATCHINDEX", "PATINDEX",
"EDGETYPE", "EDGEWIDTH", "EDGECOLR"};


/* now some of the special characters and macros */
#define term_char ';'		/* standard termination character */
#define term1_char '/'		/* secondary termination character */
#define is_term(c) (((c) == term_char) || ((c) == term1_char))

#define quote_char '\"'		/* standard quote character */
#define quote1_char '\''	/* secondary quote character */
#define is_quote(c) (((c) == quote_char) || ((c) == quote1_char))

#define sep_char ' '		/* standard separation character */
#define sep1_char '\011'	/* secondary separation character */
#define sep2_char '\012'	/* secondary separation character */
#define sep3_char '\013'	/* secondary separation character */
#define sep4_char '\014'	/* secondary separation character */
#define sep5_char '\015'	/* secondary separation character */

#define is_sep(c) (((c) == sep_char) || (((c) <= sep5_char) \
	&& ((c) >= sep1_char)))

#define null_char '_'		/* primary null character */
#define null1_char '$'		/* secondary null character */

#define is_null(c) (((c) == null_char) || ((c) == null1_char))

#define comment_char '%'	/* comment start */

#define is_comment(c) ((c) == comment_char)
