########################################################################
# SGMLSPL script originated using the script sgmlspl.pl
#
# Document Type: article (gellmu)
# Output Type: text/x-tex (LaTeX)
# Author: William F. Hammond <hammond@math.albany.edu>
# Begun: 19980923
# With-help-from: Tim Kohl <tkohl@it.bu.edu>
# Last-revision: check the file system datestamp or the http header
# Note: This version of the regular LaTeX generator withholds newlines
#       Its output is not easy to read, but it is more efficient and
#       more reliable.
########################################################################
#

###  This writes LaTeX, which, on a given platform, compiles to DVI
###  (or PDF) files consisting of pages sized for the platform.  This
###  script comes from a "letter" paper environment and by default
###  (according to the variable $nocustomlengths) adopts custom length
###  settings for letter paper.  Setting a papersize option for
###  \documentclass may also be helpful.  Otherwise, modify the
###  lengths in the function custom_lengths.

# UTF-8: LaTeX's support of UTF-8 requires fonts for all of the unicode
#        values corresponding to character you use.  Beyond that your
#        fonts must be acceptable for use with the T1 font encoding,
#        which is invoked here if the flag $utf8On is set.
$utf8On = 0;
#  These days the input stream is almost always UTF-8.
$utf8input = 1;
if((exists $ENV{"GELLMU_LaTeXUTF8"}) && ($ENV{"GELLMU_LaTeXUTF8"} == 1)){
    use utf8;
    $utf8input = 1;
    $utf8On = 1;
    print STDERR "  ***  ltxgart.pl: UTF-8 Library\n";
};
use SGMLS;			# Use the SGMLS package.
use SGMLS::Output;		# Use stack-based output.

# Dummies for spawning new element code

# Element: foox
sgml('<foox>', "");
sgml('</foox>', "");

# Element fooy
sgml('<fooy>', sub{
});
sgml('</fooy>', sub{
});

$WhoAmI = "ltxgart.pl";

# Global variables -- strings to think about
#   none here for now (several in the HTML generating code)

# Global variables -- flags and numbers to think about (See the notes
#   about these in the HTML generating code)

# Let's not depend on time zone being cross-platform
# This is keyed on the last entry in the array version of localtime()
@GTimeZone = ("EST", "EDT");

# Month names
@GMonth = ("January", "February", "March", "April", "May", "June",
   "July", "August", "September", "October", "November", "December");

# Abbreviated month names
@GMoY = ("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep",
   "Oct", "Nov", "Dec");

# Abbreviated day-of-week names
@GDoW = ("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat");

@Alphabetic = qw(o A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
		 AA BB CC);
@alphabetic = qw(O a b c d e f g h i j k l m n o p q r s t u v w x y z
		 aa bb cc);
@Roman = qw(0 I II III IV V VI VII VIII IX X XI XII XIII XIV XV XVI
	     XVII XVIII XIX XX XXI XXII XXIII XXIV XXV XXVI XXVII
	     XXVIII XXIX);
@roman = qw(0 i ii iii iv v vi vii viii ix x xi xii xiii xiv xv xvi
	     xvii xviii xix xx xxi xxii xxiii xxiv xxv xxvi xxvii
	     xxviii xxix);

@coordseq = ();    # seq. position of <coord> arg in <vect> at $vectdepth
$csepq = 0;        # csep sequence number (diagnostic)
@csep = ();        # $csep[$j][$k] = k-th field in <csep> at vectdepth $j
@csepn = ();       # number in separator array at $vecdepth
$documentclassopts = "leqno";
# Suppress banner by default; use \nobanner or \banner in preamble to override
$nobanner = 1;
$nogratlinks = 1;
$nobaseprint = 0;
$papertype = "";
$secnumdepth = 3;  # inert, except for name reservation, as this code is now
$slabelprefix = "SU-";
$tocunitlength = 0;  # E.g., in TOC show sec 4.2.3 as 2.3 (with indentation)
$usememoir = 0;
$unknown_elements = 0;

if ((exists $ENV{"GELLMU_PAPER"}) && !($ENV{"GELLMU_PAPER"} eq "")){
    $papertype = $ENV{"GELLMU_PAPER"};
    $documentclassopts = $papertype . "," . $documentclassopts;
};

if ((exists $ENV{"GELLMU_Memoir"})
    && !(($ENV{"GELLMU_Memoir"} eq "") || ($ENV{"GELLMU_Memoir"} eq "0")) ){
    $usememoir = 1;
};

# This formatter sets eqnarray using amsmath constructions and a
# single alignment marker with eqncenter following the alignment
# marker.  What should follow the alignment marker if if eqncenter
# contains no markup?  The following internal default should work when
# eqncenter for the first row is simply "=".  Another possibility is "".
# with per row management of eqncenter.  The following environmental
# makes it possible to change the default on a per article basis.
# Bear in mind that HTML eqnarray output has 3 cells per row.
$defaultemptyeqncenter = " \\qquad ";
if (exists $ENV{"GELLMU_DefaultEmptyEqncenter"}){
    $defaultemptyeqncenter = $ENV{"GELLMU_DefaultEmptyEqncenter"};
};

#
# Document Handlers.
#
sgml('start', sub{
    print STDERR $0, " *** ", $WhoAmI, "\n";
    my $os = "% LaTeX\n";
    output($os);
    $isxml = 0;
});

sgml('end', sub{
    output("\n");
    if(($unknown_elements > 0) && (1)){
	print STDERR "***** WARNING: ", $unknown_elements, " ",
              "unknown elements;\n";
	if($isxml == 0){
	    print STDERR "      Was the document filtered to XML first?\n";
	};
    };
});

sgml('cdata', sub{
    my $os = $_[0];
    my $ev = $_[1];
    my $elt = $ev->element;
    if(!($elt->name eq "anchref")){
	# $os =~ s/\x0A+/ %\x0A/g;
	$os =~ s/\x0A+/ /g;  # tolerate long lines
    }
    else{
	$os =~ s/\x0A+/ /g;
    };
    output($os);
});

sgml('sdata',sub { die "Unknown SDATA: " . $_[0]; });

#   $isxml is almost always true these days.  One could
#   replace each newline in the SGML with " %\n" rather than "\n" in
#   order to (1) avoid triggering a new paragraph (or quote or verse)
#   and (2) keep the LaTeX file more human-readable than it would be
#   if we simply were to output " " (or nothing).

sgml('re',sub{
    my $os = "\n";
    if($isxml == 1){
	$os = "";
    };
    output($os);
});
#
# Things to die for:
#
#sgml('pi',sub { die "Unknown processing instruction: " . $_[0]; });
sgml('pi', sub{
    my $inst = $_[0];
    my $os = "";
    if($inst =~ /^xml/){
	if($isxml == 0){
	    $isxml = 1;
	}
	else{
	    #$os = $os . "%   " . $_[1]->file . ": " . $inst . "\n";
	    ;
	};
	output($os);
    }
    elsif($inst =~ /centralStyled/){
	;
    }
    else{
	print STDERR $WhoAmI,  ": Unknown processing instruction:\n",
	$inst, "\n";
    };
});
sgml('entity',sub { die "Unknown external entity: " . $_[0]->name; });
sgml('start_subdoc',sub { die "Unknown subdoc entity: " . $_[0]->name; });
#
# sgml('end_subdoc','');
# sgml('conforming','');

#
# Element Handlers.
#

# Element: article
sgml('<article>', sub{
    $anchopt = "";
    $anchref = "";
    $arrayrowseq = 0;
    $arrcols = "";
    $arrpos = "";
    @artauthor = ();
    $artbase = "";
    $artdate = "";
    $artsubtitle = "";
    $arttitle = "";
    $asstkey = "";
    $asstser = "";
    $asstname = "";
    $asstid = "";
    # Should these be made 2-dimensional for greater flexibility?
    @auth_addr = ();
#   @auth_email = ();
    @AuthEmail = ();
    $auth_ser = 0;
    $basefile = "";
    $baseloc = "";
    $baseurl = "";
    $biblabel = "";
    $bibkey = "";
#    $binomdepth = 0; not recursive for now
    $binargid = 0;
    $binoml = "";
    $binomu = "";
    $bodymaketitle = 0; #If used, must occur before title, author, or date.
    $thiscitenote = "";
    $thiscitekey = "";
    $thiscitetext = "";
    $compacttitle = 0;
    $copynotice = "";
    $currtocdepth = 0; # for tableofcontents rendering
    @denm = ();
    $docclass_arg = "";
    $docclass_opt = "";
    $eqnamode = 0;
    $eqnarowseq = 0;
    $eqnkey = "";
    $eqntag = "";
    $eqrkey = "";
    $eqrtag = "";
    $fracdepth = 0;
    $fracser = 0;
    @frid = ();
    @haveaddr = ();
    $haveanchopt = 0;
    $haveauthor = 0 ;
    $havebase = 0;
    $havedate = 0 ;
    $havedocclass = 0 ;
    @haveemail = ();
    $havetitle = 0;
    $holdlatextitle = 0; # do not write "\\title", ... to the output
                         #         when "<title>", ... contain footnotes
    $inanch = 0;
    $inanchopt = 0;
    %labelinfo = ();
    @labelkeys=();
    %labelseqs=();
    %labeltypes=();
    %labelsids=();
    %labelsers=();
    %labelserseqs=();
    %labelsecunits=();
    $lastlabelkey = "";
    $lglbl = 0;  # logical for successful opening of label info file as GLBL
    $lgcnt = 0;  # logical for successful opening of contents data as GCNT
    $maketitle = 0;
    $markdraft = 0 ;
    $noanchorfootnote = 0;
###
###
    $nocustomlengths = 0;  # change to 1 for paper not 8.5x11 inches
###                          or modify the function custom_lengths
###                          possibly also output "\documentclass" with
###                          an option for your paper size
###
    $notitle = 0;
    @numr = ();
    $oldlabelflag=0;

    $ousetdepth = 0;  # for mscript, overset, underset, setOf
    @uleft = ();      # mscript pre-super-script
    @lleft = ();      # mscript pre-sub-script
    @lright = ();     # mscript post-sub-script
    @uright = ();     # mscript post-super-script
    @parm = ();       # setOf parameter expression
    @cond = ();       # setOf condition expression

    $plainhdr = 0;  # no bolding of headers if set (Hmmm... ?)
    @radicand=();
    @radx=();
    $sech_os = "";  # output line for current sectional unit
    $sepregexp = '\\\\'; # regexp for field separator in label aux file
    $sopt = "";
    $sprefix = "";
    $sunit = "";
    $sunitflag = 0;
    @sqrtarg=();
    $sqrtdepth = 0;
    @sqrtopt=();
    $stemname="";
    $surtitle="";
    $tabdepth = 0;
    @tabhlen=();
    @tabvlen=();
    @tabarg = ();
    @tabopt = ();
    @tabid = ();
    $tabser = 0;
    @tdcount=();
    @trcount = ();
    @trulecount = ();
    @termnote = ();
    @termnoteseq = 0;
    $tocdepth = "";
    $tocentry = ""; # carrier for value of <tocentry> to <tocitem> handler
    $tocunit = ""; # carrier for value of <tocunit> to <tocitem> handler
    $vectdepth = 0;
    my $stem = $_[0]->attribute("stem")->value;
    if($stem ne ""){
	$stemname = $stem;
	my $flbl = $stemname . ".xlb";
	my $fcnt = $stemname . ".xcn";
	$lglbl = open(GLBL, $flbl);
	$lgcnt = open(GCNT, $fcnt);
	if($lglbl == 0){ # test label file
	    print STDERR "ltxgart.pl WARNING:\n",
                  "  Failed to open label info file \"", $flbl,
                  "\" for reading.\n";
	}
	else{   # Good file -- let's read it.
        # Line format:  key  seq  container  section-id [ series  series-seq ]
	    my $inline = "";
	    my @tarray=();
	    my $tkey = "";
	    while($inline = <GLBL>){
		chomp($inline);
		@tarray = (split(/$sepregexp/, $inline));
		$tkey = shift @tarray;
		# @{labelinfo{$tkey}} = @tarray;
		@{$labelinfo{$tkey}} = @tarray;
		@labelkeys = (keys %labelinfo);
	    };
	    my $nkeys = scalar @labelkeys;
	    if($nkeys > 0){
		#foreach $tkey (@labelkeys){
		#    $labelsids{$tkey} = @{$labelinfo{$tkey}}[2];
		#    $labelsers{$tkey} = @{$labelinfo{$tkey}}[3];
		#    $labelserseqs{$tkey} = @{$labelinfo{$tkey}}[4];
                # # Debug output
		# foreach $tkey (@labelkeys){
		#     print STDERR "Label key \"$tkey\" is in series",
                #       " \"$labelsers{$tkey}\", seq. $labelserseqs{$tkey}\n";
		# };
		my $test = scalar @tarray;
		if(($test == 4) || ($test == 6)){
		    foreach $tkey (@labelkeys){
			$labelsids{$tkey} = @{$labelinfo{$tkey}}[2];
			$labelsecunits{$tkey} = @{$labelinfo{$tkey}}[3];
			$labelsers{$tkey} = @{$labelinfo{$tkey}}[4];
			$labelserseqs{$tkey} = @{$labelinfo{$tkey}}[5];
		    };
		}
		elsif(($test == 3) || ($test == 5)){
		    $oldlabelflag = 1;
		    print STDERR "ltxgart.pl: Old label aux file format\n";
		    foreach $tkey (@labelkeys){
			$labelsids{$tkey} = @{$labelinfo{$tkey}}[2];
			$labelsers{$tkey} = @{$labelinfo{$tkey}}[3];
			$labelserseqs{$tkey} = @{$labelinfo{$tkey}}[4];
		    };
		}
		else{
		    print STDERR
			"ltxgart.pl: Label aux file not in correct format\n";
		};
	    };
            # # Debug output
		# foreach $tkey (@labelkeys){
		#     print STDERR "Label key \"$tkey\" is in series",
                #       " \"$labelsers{$tkey}\", seq. $labelserseqs{$tkey}\n";
		# };
	    
	}; # end of if test label file
	if($lgcnt == 0){  # test contents file
	    print STDERR "ltxgart.pl WARNING:\n",
            "  Failed to open contents info file \"", $fcnt,
            "\" for reading.\n";
	};
    }  # end of case where article has a stem
    else{
	print STDERR
            "ltxgart.pl WARNING: No stem attribute for root element.";
    };
});
sgml('</article>', sub{
    if($lglbl != 0){
	close(GLBL);
    };
    if($lgcnt != 0){
	close(GCNT);
    };
});

sgml('<dbgarticle>', "");
sgml('</dbgarticle>', sub{
    print STDERR "Debugging AuthEmail:\n";
    my $jaut = 1;
    my $jem = 1;
    if($auth_ser > 0){
	while($jaut <= $auth_ser){
	    print STDERR "  Author ", $jaut, "\n";
	    if($haveemail[$jaut] > 0){
		$jem = 1;
		while($jem <= $haveemail[$jaut]){
		    print STDERR "    Email, id ", $jem, ": ",
                                 $AuthEmail[$jaut][$jem], "\n";
		    $jem++;
		};
	    };
	    $jaut++;
	};
    };
});

# Element: preamble
sgml('<preamble>', sub{
    push_output('string');
});
sgml('</preamble>', sub{
    my $pos = pop_output;
    my $os = "";
    my $jauth = 0;
    my $jaddr = 0;
    my $jemail = 0;
    my $as = "";
    my $jem = 0;
    if ($havedocclass == 0){
	if($usememoir == 1){
	    $os = $os . "\\documentclass[article,"
		. $documentclassopts . "]{memoir}\n";
	}
	else{
	    $os = $os . "\\documentclass["
		. $documentclassopts . "]{article}\n";
	};
	if($utf8input){
	    $os = $os . "\\usepackage[utf8]{inputenc}\n";
	};
	if($utf8On == 1){
	    $os = $os . "\\usepackage[TS1,T1]{fontenc}\n";
	    $os = $os . "\\usepackage{textcomp}\n";
	};
	$os = $os . "\\usepackage{url}\n";
	$os = $os . "\\usepackage{graphicx}\n";
	$os = $os . "\\usepackage{amsmath}\n";
	$os = $os . "\\usepackage{amssymb}\n";
	$os = $os . "\\usepackage{amsfonts}\n";
	$os = $os . "\\usepackage{bm}\n";
	# gellmu.sty is needed for "prescript" to support <mscript>
	my $havestyle = 0;
	if(exists $ENV{"GELLMU_HaveStyle"}){
	    $havestyle = $ENV{"GELLMU_HaveStyle"};
	};
	my $gstyle = 0;
	if(exists $ENV{"GELLMU_LaTeXStyle"}){
	    $gstyle = $ENV{"GELLMU_LaTeXStyle"};
	};
	if($havestyle == 1){
	    $os = $os . "\\usepackage{gellmu}\n";
	}
	elsif($gstyle ne "0"){
	    print STDERR $WhoAmI, ": GELLMU_LaTeXStyle = " . $gstyle . "\n";
	    $os = $os . "\\usepackage{" . $gstyle . "}\n";
	}
	else{
	    print STDERR $WhoAmI, ': WARNING: '
		, "LaTeX package gellmu.sty is missing.\n";
	};
	if ($nocustomlengths == 0){
	    # $os = $os . custom_lengths();
	    $os = $os . "\\usepackage[margin=100bp,nohead]{geometry}\n";
	    $os = $os . "\\setlength{\\parskip}{6bp}\n";
	    $os = $os . "\\setlength{\\parindent}{0bp}\n";
	};
	$os = $os . "\\pagestyle{plain}\n";
	$os = $os . "\\thispagestyle{empty}\n";
    };
    $os = $os . $pos; # Should have "\title" and "\author",
                      # and maybe "\documentclass"
    $os = $os . "\\newlength{\\centerskip}\n";
    $os = $os . "\\setlength{\\centerskip}{\\topsep}\n";
# $os = $os . "\\addtolength{\\centerskip}{\\partopsep}\n";
    # Pick up command definitions required by GELLMU
    $os = $os . "\\newcommand{\\hsf}{\\hspace*{\\fill}}\n";
    $os = $os . "\\newcommand{\\tdbc}[1]{\\hsf\\textbf{\#1}\\hsf}\n";
#
# (cough) "menulist" is used in formatting (1) "menu", (2) "addr" (snail),
# and (3) "verblist" (corresponding to the verbatim meta environment)
# It is close to overloaded.
# Basically, a "menulist is a tight list with no item markers.
# Paragraphs get more or less regular vertical spacing
# in a one item "menu".  That is, a one item "menu" is for hanging
# indentation.  A many item "menulist" in which any item has
# more than one paragraph will not be a good thing.  But "Menulist"
# (used for "Menu") _may_ be OK for that.
#
    $os = $os . "\\newenvironment{menulist}{\n";
    $os = $os . "\\begin{list}{}{\n";
    $os = $os . "\\setlength{\\topsep}{0bp}\n";
    $os = $os . "\\setlength{\\labelwidth}{0.03\\linewidth}\n";
    $os = $os . "\\setlength{\\leftmargin}{0.06\\linewidth}\n";
    $os = $os . "\\setlength{\\itemindent}{0bp}\n";
    $os = $os . "\\setlength{\\itemsep}{-6bp}\n";
    $os = $os . "\\setlength{\\parsep}{6bp}}\n";
    $os = $os . "}{\\end{list}}\n";
    $os = $os . "\\newenvironment{Menulist}{\n";
    $os = $os . "\\begin{list}{}{\n";
    $os = $os . "\\setlength{\\topsep}{0bp}\n";
    $os = $os . "\\setlength{\\labelwidth}{0.03\\linewidth}\n";
    $os = $os . "\\setlength{\\leftmargin}{0.06\\linewidth}\n";
    $os = $os . "\\setlength{\\itemindent}{0bp}\n";
    $os = $os . "\\setlength{\\itemsep}{3bp}\n";
    $os = $os . "\\setlength{\\parsep}{6bp}}\n";
    $os = $os . "}{\\end{list}}\n";
    $os = $os . "\\newenvironment{toclist}{\\normalsize\n";
    $os = $os . "\\begin{list}{}{\n";
    $os = $os . "}}{\\end{list}}\n";
    $os = $os . "\\newenvironment{Toclist}{\\large\n";
    $os = $os . "\\begin{list}{}{\n";
    $os = $os . "}}{\\end{list}}\n";
    # Change the lengths below to be relative to \linewidth
    $os = $os . "\\newenvironment{citations}{\n";
    $os = $os . "\\begin{list}{}{\n";
    $os = $os . "\\setlength{\\topsep}{0bp}\n";
    $os = $os . "\\setlength{\\labelwidth}{0bp}\n";
    $os = $os . "\\setlength{\\leftmargin}{0.04\\linewidth}\n";
    $os = $os . "\\setlength{\\labelsep}{0bp}\n";
    $os = $os . "\\setlength{\\itemindent}{-0.2\\leftmargin}\n";
    $os = $os . "\\setlength{\\itemsep}{3bp}\n";
    $os = $os . "\\setlength{\\parsep}{0bp}}\n";
    $os = $os . "}{\\end{list}}\n";
    if($auth_ser > 0){
	$jauth = 1;
        # This code only generates the contents of LaTeX's \author
	while($jauth <= $auth_ser){
	    $as = "\\author{" . $artauthor[$jauth];
	    if($haveaddr[$jauth] > 0){
		$as = $as . "\\\\{}" . $auth_addr[$jauth];

	    }
	    my $jemail = $haveemail[$jauth];
	    if($jemail > 0){
		if ($jemail > 1){
		    $as = $as . "\n\\\\{}Email addresses:\\\\{}\n";
		    $jem = 1;
		    while($jem <= $jemail){
			if($jem > 1){
			    $as = $as . "\\\\\\hsf\\\\{}\n";
			};
			$as = $as . "\\texttt{"
                                  . $AuthEmail[$jauth][$jem] . "}\n";
			$jem++;
		    };
		}
		else{
		    $as = $as . "\n\\\\{}Email: ";
		    $as = $as . "\\texttt{"
                              . $AuthEmail[$jauth][$jemail] . "}\n";
		};
	    };
	    $os = $os . $as . "}\n";
	    $jauth ++;
	};
    };
    output($os);
});

# Element: documentclass
#   This is skeletal; it is not clear to what extent it will be supported.
#   For now we'll just grab any option (at most one) and argument
#   (exactly one) and pass them on, suppressing custom length settings.
sgml('<documentclass>', sub{
    $havedocclass = 1;
    push_output('string');
});
#   Note that if there is a single argument, then it is in popped output.
sgml('</documentclass>', sub{
    my $pos = pop_output;
    my $os = "\\documentclass";
    if($docclass_opt ne ""){
	$os = $os . "[" . $docclass_opt . "]";
    }
    if($docclass_arg ne ""){
	$os = $os . "{" . $docclass_arg . "}\n";
    }
    else{
	$os = $os . "{" . $pos . "}\n";
    }
    output($os);
});

# Element: dclass
sgml('<dclass>', sub{
    push_output('string');
});
sgml('</dclass>', sub{
    $docclass_arg = pop_output;
});

# Element: dstyle
sgml('<dstyle>', sub{
    push_output('string');
});
sgml('</dstyle>', sub{
    $docclass_opt = pop_output;
});

# Element: bodymaketitle
sgml('<bodymaketitle>', sub{
    $bodymaketitle = 1;
});
sgml('</bodymaketitle>', "");

# Element: maketitle
sgml('<maketitle>', sub{
    my $pan = $_[0]->parent->name;
    my $os = "";
    if($pan eq "preamble"){
	$maketitle = 1;
    }
    elsif(($bodymaketitle == 1) &&($pan eq "body")){
	$os = $os . "\\maketitle{}\n";
	if($markdraft == 1){
	    $os = $os . draft_label();
	}
	output($os);
    };
});
sgml('</maketitle>', "");

# Element: title
#
#   In processing to LaTeX we could just slip this through for
#   subsequent rendering with "\maketitle".  This treatment leaves
#   open the possibility of custom titling outside of that.
#   It may be a bit overdone.  Currently there are three ways:
#   (1) GELLMU normal = custom_title(), (2) GELLMU alt = compact_title,
#   and (3) LaTeX normal.  This code presently is inadequate for (3),
#   especially in regard to "\author{ ... }", which cannot simply be
#   written to the output without missing addresses.
#
sgml('<title>', sub{
    $havetitle = 1;
    push_output('string');
});
sgml('</title>', sub{
    $arttitle = pop_output;  # a global string variable
    if(!($holdlatextitle)){
	my $os = "\\title{" . $arttitle . "}\n";
	output($os);
    };
});

# Element: subtitle
sgml('<subtitle>', sub{
    push_output('string');
});
sgml('</subtitle>', sub{
    $artsubtitle = pop_output;  # a global string variable
});

# Element: author
sgml('<author>', sub{
    $haveauthor = 1;
    $auth_ser++;
    $haveaddr[$auth_ser] = 0;
    $auth_addr[$auth_ser] = "";
    $haveemail[$auth_ser] = 0;
    $auth_email[$auth_ser] = "";
    push_output('string');
});
sgml('</author>', sub{
    my $pos = pop_output;
    $artauthor[$auth_ser] = $pos;
});

# Element: address
sgml('<address>', sub{
    push_output('string');
});
sgml('</address>', sub{
    my $pos = pop_output;
    $haveaddr[$auth_ser]++;
    if($haveaddr[$auth_ser] > 1){
	$auth_addr[$auth_ser] = $auth_addr[$auth_ser] . "\n\\\\\\hsf\\\\{}\n";
    };
    $auth_addr[$auth_ser] = $auth_addr[$auth_ser] . $pos;
});

# Element: email
sgml('<email>', sub{
    push_output('string');
});
sgml('</email>', sub{
    my $pos = pop_output;
    $haveemail[$auth_ser]++;
    $AuthEmail[$auth_ser][$haveemail[$auth_ser]] = $pos;
#   if($auth_email[$auth_ser] ne ""){
	# not the first email address (other than an 'eaddr' in 'address')
#	$auth_email[$auth_ser] = $auth_email[$auth_ser] . "\n\\\\\\hsf\\\\{}\n";
#    };
#   $auth_email[$auth_ser] = $auth_email[$auth_ser] . "\\verb|" .$pos . "|";
});

# Element: date
sgml('<date>', sub{
    push_output('string');
});
sgml('</date>', sub{
    my $pos = pop_output;
    my $os = "";
    $havedate = 1;
    $artdate = $pos;
    if(!($holdlatextitle)){
	$os = "\\date{" . $pos . "}\n";
	output($os);
    };
});

# Element: copynotice
sgml('<copynotice>', sub{
    push_output('string');
});
sgml('</copynotice>', sub{
    $copynotice = pop_output;
});

# Element: keywords
sgml('<keywords>', sub{
    push_output('nul');
});
sgml('</keywords>', sub{
    pop_output;
});

# Element: draftlabel
sgml('<draftlabel>', sub{$markdraft = 1;});
sgml('</draftlabel>', "");

# Element: nobanner
sgml('<nobanner>', sub{$nobanner = 1;});
sgml('</nobanner>', "");

# Element: banner
sgml('<banner>', sub{$nobanner = 0;});
sgml('</banner>', "");

# Element: nocustomlengths
sgml('<nocustomlengths>', sub{$nocustomlengths = 1;});
sgml('</nocustomlengths>', "");

# Element: nogratlinks -- Block writing default links; there are none yet.
sgml('<nogratlinks>', "");
sgml('</nogratlinks>', "");

# Element: gratlinks -- Create default links; there are none yet.
sgml('<gratlinks>', "");
sgml('</gratlinks>', "");

# Element: nobaseprint -- Don't show location info in non network formats.
sgml('<nobaseprint>', sub{
$nobaseprint = 1;
});
sgml('</nobaseprint>', "");

# Element: compacttitle
sgml('<compacttitle>', sub{$compacttitle = 1;});
sgml('</compacttitle>', "");

# Element: base
sgml('<base>', sub{
    push_output('string');
# catch the base in verbatim mode for LaTeX since it will be set that way
    $verb_on = 1;
});
sgml('</base>', sub{
    $verb_on = 0;
    $havebase = 1;
    $artbase = pop_output;
    $artbase =~ s/[hi]ref\s*=\s*\"//;
    $artbase =~ s/\"\s*$//;
});

# Element: baseloc
sgml('<baseloc>', sub{
    push_output('string');
    $verb_on = 1;
});
sgml('</baseloc>', sub{
    $verb_on = 0;
    $baseloc = pop_output;
    my $es = "";
    my $event = $_[1];
    $basefile = $event->file;
    $basefile =~ s/  *//g;
    $basefile =~ s|^.*/||;
    $basefile =~ s/\..*$//;
#   print {"STDERR"} "baseloc: ", $baseloc ,"\n";
#   print {"STDERR"} "basefile: ", $basefile, "\n";
});

# Element: body
sgml('<body>', \&open_artbody);
sgml('<document>', \&open_artbody);
sub open_artbody{
    $new_sec = 0; $sec_level = 0; $sec_serial = 0; $subsec_serial = 0;
    $subsubsec_serial = 0; $para_on = 0;
    $gmath_on = 0; $imath_on=0; $dmath_on=0; $emath_on=0;
    $gmath_was_on = 0;
    $verb_on = 0; $verb_was_on = 0; $verb_pn = "";
    $emathstar_on = 0; $sv_gmath_on = 0;
    my $os = "\\begin{document}\n";
    if($havetitle == 0){
	die "A title is required.\n";
    };
    if (($bodymaketitle == 0)&&($maketitle == 0)){
	if($compacttitle == 0){
	    $os = $os . custom_title();
	    $os = $os . "\n\\medskip\n";
	}
	else{
	    $os = $os . compact_title();
	}
    }
    # $maketitle is set if "\maketitle" is found in the preamble;
    #   if so, put "\maketitle" at the top of the body
    elsif($maketitle == 1){
	$os = $os . "\\maketitle{}\n";
        # 19990719
	if($markdraft == 1){
	    $os = $os . draft_label();
	};
    };
# 19990719
#    if (($bodymaketitle == 1)&&($markdraft == 1)){
#	$os = $os . draft_label();
#    }
    output($os);
}
sgml('</body>', \&end_artbody);
sgml('</document>', \&end_artbody);
sub end_artbody{
my $os = "";
my $tmp = "";
my $dvi = "";
my $html = "";
if(($nobaseprint == 0) && (($baseloc ne "") || ($artbase ne "")) ){
    $os = "\n\\bigskip\n";
    $os = $os . "\\setlength{\\parindent}{0bp}\n\n";
    if(($baseloc ne "")&&($basefile ne "")){
	$baseloc =~ s|/$||;
	$tmp = "\\verb|" . $baseloc . "/" . $basefile;
	$dvi = $tmp . ".dvi|";
	$html = $tmp . ".html|";
	$os = $os . "Document network location for HTML:\\\\[2bp]\n";
	$os = $os . "\\setlength{\\tabcolsep}{3bp}\n";
	$os = $os . "\\begin{tabular}{rl}\n";
	$os = $os . "\\ \\  &" . $html . "\n\\end{tabular}\n";
    }
    elsif($artbase ne ""){
	$os = $os . "Document network address for HTML:\\\\{}\n"
                  . "\\ \\ \\verb|" . $artbase . "|\n";
    };
};
if($nobanner == 0){
    $os = $os . "\n\\bigskip\n";
    $os = $os . "\\setlength{\\parindent}{0bp}\n\n";
#    my $ds = `date`;
#    $ds =~ s/\n//;
    my @tv = localtime();
    my $yr = 1900 + $tv[5];
    my $jk = 0;
    while($jk < 3){
	$tv[$jk] = sprintf("%02d", $tv[$jk]);
	$jk++;
    };
    my $timestamp = $tv[2] . ":" . $tv[1] . ":" . $tv[0];
    my $ds = $GDoW[$tv[6]] . " " . $tv[3] . " " . $GMoY[$tv[4]] . " "
              . $yr . " at " . $timestamp . " " . $GTimeZone[$tv[8]];
    if($os ne ""){
	$os = $os . "\\hsf\\\\[0bp]\n";
    }
    $os = $os . " [Processed from GELLMU to \\LaTeX{} on ";
    $os = $os . $ds . "]\n";
}
$os = $os . "\\end{document}\n";
output($os);
}

# Element: Section
sgml('<Section>', sub{
    $new_sec = 1;
    $sec_serial++;
    $sec_level++;
    $sopt = "";
    $sprefix = "";
    $sunit = "";
    $sunitflag = 0;
    $sech_os = "";
});
sgml('</Section>', sub{
    $sec_level--;
});

# Element: section -- content is section-title
sgml('<section>', sub{
    push_output('string');
});
sgml('</section>', sub{
    my $pos = pop_output;
    my $os = "\\section{" . $pos . "}\n";
    output($os);
});

# Element: Subsection
sgml('<Subsection>', sub{
    $new_sec = 1;
    $subsec_serial++;
    $sec_level++;
    $sopt = "";
    $sprefix = "";
    $sunit = "";
    $sunitflag = 0;
    $sech_os = "";
});
sgml('</Subsection>', sub{
    $sec_level--;
});

# Element: subsection -- content is subsection-title
sgml('<subsection>', sub{
    push_output('string');
});
sgml('</subsection>', sub{
    my $pos = pop_output;
    my $os = "\\subsection{" . $pos . "}\n";
    output($os);
});

# Element: Subsubsection
sgml('<Subsubsection>', sub{
    $new_sec = 1;
    $subsubsec_serial++;
    $sec_level++;
    $sopt = "";
    $sprefix = "";
    $sunit = "";
    $sunitflag = 0;
    $sech_os = "";
});
sgml('</Subsubsection>', sub{
    $sec_level--;
});

# Element: Paragraph
sgml('<Paragraph>', sub{
    $new_sec = 1;
    $subsec_serial++;
    $sec_level++;
    $sopt = "";
    $sprefix = "";
    $sunit = "";
    $sunitflag = 0;
    $sech_os = "";
});
sgml('</Paragraph>', sub{
    $sec_level--;
});

# Element: Subparagraph
sgml('<Subparagraph>', sub{
    $new_sec = 1;
    $subsec_serial++;
    $sec_level++;
    $sopt = "";
    $sprefix = "";
    $sunit = "";
    $sunitflag = 0;
    $sech_os = "";
});
sgml('</Subparagraph>', sub{
    $sec_level--;
});

# Element: subsubsection -- content is subsubsection-title
sgml('<subsubsection>', sub{
    push_output('string');
});
sgml('</subsubsection>', sub{
    my $pos = pop_output;
    my $os = "\\subsubsection{" . $pos . "}\n";
    output($os);
});

# This code will still work with some old documents when passed through
# here directly from article/SGML.  Under the new regime all formatting
# through here is done from article/XML, and "ag0" is not part of
# article/XML.
# Element: ag0 -- auto-generated command argument
# NOTE: This code is obsolete because ag0 should not appear in
#       XML versions of "article"
sgml('<ag0>', sub{
    push_output('string');  # in every case
    my $pan = $_[0]->parent->name;
    my $os = "";
    if($pan eq "Section"){
	$sec_name = "section";
    }
    elsif($pan eq "Subsection"){
	$sec_name = "subsection";
    }
    elsif($pan eq "Subsubsection"){
	$sec_name = "subsubsection";
    }
    elsif($pan eq "anch"){
	;
    }
    # The next conditional must match code for the end tag.
    elsif($pan =~ /^table/){
	;
    }
    elsif($pan =~ /^mtable/){
	;
    }
    elsif($pan eq "frac"){
	$frid[$fracdepth]++;
    }
    elsif($pan eq "binom"){
	$binargid++;
    }
    elsif($pan eq "sqrt"){
	;
    }
    elsif($pan eq "documentclass"){
	;
    }
    else{
     output("{ELT " . $_[0]->name . " IN " . $pan);
    };
});
sgml('</ag0>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "";
    # There is no collected "output()" in this code segment.
    # new_sec is set for all section-level elements
    if(($pan eq "Section")||($pan eq "Subsection")||($pan eq "Subsubsection")){
	$new_sec = 0;
	my $ts = $pos;  #mandatory section title
	$sech_os = "\n\\" . $sec_name . "{" . $ts . "}\n";
	output($sech_os);
    }
    elsif($pan eq "anch"){
	output($pos);
    }
    # The next conditional must match code for the start tag.
    elsif($pan =~ /^table/){
    #  Was:  elsif(($pan eq "table")||($pan eq "tablec")){
	my $qos = $pos;
	$qos =~ s/\|//g;
	if($tabdepth <= 0){
	    die "Have table arg without positive table depth";
	};
	$tabhlen[$tabdepth]=length($qos);
        # Are these next lines correct?
	$tabarg[$tabdepth] = '{' . $pos . '}';
    }
    elsif($pan =~ /^mtable/){
	my $qos = $pos;
	$qos =~ s/\|//g;
	if($tabdepth <= 0){
	    die "Have table arg without positive table depth";
	};
	$tabhlen[$tabdepth]=length($qos);
        # Are these next lines correct?
	$tabarg[$tabdepth] = '{' . $pos . '}';
    }
    elsif($pan eq "frac"){
	if($frid[$fracdepth] == 1){
	    $numr[$fracdepth] = $pos;
	}
	elsif($frid[$fracdepth] == 2){
	    $denm[$fracdepth] = $pos;
	}
	else{
	    $os = "Fraction management error in codelets\n"
              . "fraction serial: " . $fracser           . "\n"
              . " fraction depth: " . $fracdepth         . "\n"
              . "    arg. number: " . $frid[$fracdepth]  . "\n"
              . "      numerator: " . $numr[$fracdepth]  . "\n"
              . "    denominator: " . $denm[$fracdepth]  . "\n";
	    die $os;
	}
    }
    elsif($pan eq "binom"){
	if($binargid == 1){
	    $binomu = $pos;
	}
	elsif($binargid == 2){
	    $binoml = $pos;
	}
	else{
	    print STDERR "binom management error in codelets\n";
	    die;
	};
    }
    elsif($pan eq "sqrt"){
	$sqrtarg[$sqrtdepth] = $pos;
    }
    elsif($pan eq "documentclass"){
	$docclass_arg = $pos;
    }
    else{
	output('}');
    };
});

# Element: sopt -- option for Section, Subsection, ...
sgml('<sopt>', sub{
    push_output('string');
});
sgml('</sopt>', sub{
    $sopt = pop_output;
});

# Element: shead -- header for Section, Subsection, ... , the big containers 
#   When formatting from the XML version of article, the end of </shead>
#   is the point where all information about the Section header elements
#   is available.
#
sgml('<shead>', sub{
    push_output('string');
});
sgml('</shead>', sub{
    my $pos = pop_output;  #mandatory section header (or "title")
    $new_sec = 0;
    my $sec_name = "";
    my $sec_num = "";
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $shead = $pos;
    if($pan eq "Section"){
	$sec_name = "section";
    }
    elsif($pan eq "Subsection"){
	$sec_name = "subsection";
    }
    elsif($pan eq "Subsubsection"){
	$sec_name = "subsubsection";
    }
    elsif($pan eq "Paragraph"){
	$sec_name = "paragraph";
    }
    elsif($pan eq "Subparagraph"){
	$sec_name = "subparagraph";
    }
    else{
	print {STDERR}
           "Warning: Logical error in code for tag \"</shead>\"\n";
    };
    $sech_os = "\n\\" . $sec_name . "*{";
    $secdepth = $par->attribute("depth")->value;
    if( ($secdepth > 0) && ($secdepth <= $secnumdepth) ){
	if( ($sunitflag != 0) && ($sunit ne "") ){
	    $sec_num = $sunit;
	}
	elsif(($sunitflag == 0)&&($par->attribute("nonum")->value ne "true")){
	    $sec_num = $par->attribute("sid")->value;
	}
	else{
	    print STDERR "ltxgart.pl: Cannot establish sec_num\n";
	};
    }
    elsif($secdepth <= 0){
	print STDERR "ltxgart.pl: Depth of sectional unit not available ??\n";
    };
    if($sprefix ne ""){
	$sech_os = $sech_os . $sprefix;
	$sech_os =~ s/\s*$/ /;
    };
    if(!($sec_num =~ /^\s*$/)){
	$sech_os = $sech_os . $sec_num . "\\ \\ ";
    }
    elsif($sprefix ne ""){
	$sech_os = $sech_os . "\\ ";
    };
    $sech_os = $sech_os . $shead . "}\n";
    output($sech_os);
});

# This code will still work with some old documents when passed through
# here directly from article/SGML.  Under the new regime all formatting
# through here is done from article/XML, and "op0" is not part of
# article/XML.
# Element: op0 -- auto-generated command option
sgml('<op0>', sub{
    push_output('string');
});
sgml('</op0>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "";
    if($pan eq "anch"){
	$anchopt = $pos;
	$haveanchopt = 1;
    }
    elsif($pan eq "sqrt"){
	$sqrtopt[$sqrtdepth] = $pos;
    }
    elsif($pan eq "documentclass"){
	$docclass_opt = $pos;
    }
    elsif($pan eq "table"){
	$tabopt[$tabdepth] = '[' . $pos . ']';
    }
    else{
	$os = "{ELT " . $_[0]->name . " IN " . $pan . "***". $pos . "*}";
    };
    output($os);
});

sgml('<op00>', sub{
    if($inanch == 1){
      $haveanchopt = 1;
      $inanchopt = 1;
      push_output('string');
}});
sgml('</op00>', sub{
    if ($haveanchopt == 1){
        $anchopt = pop_output;
        $inanchopt = 0;
    };
});

# Element: mtable -- table in math mode
sgml('<mtable>', sub{
    on_table();
});
sgml('</mtable>', sub{
    my ($arg, $rs) = off_table($_[0], $_[1]);
    my $os = "";
    $os = $os . "\\begin{array}" . $arg . "\n";
    $os = $os . $rs;
    $os = $os . "\n\\end{array}";
    output($os);
});
sgml('<mtable0>', sub{
    $tabser++;
    $tabdepth++;
    $tabid[$tabdepth] = $tabser;
    $tabhlen[$tabdepth] = 0;
    $tabvlen[$tabdepth] = 0;
    $tabarg[$tabdepth] = "";
    push_output('string');
});
sgml('</mtable0>', sub{
    my $pos = pop_output;
    my $es = "";
#    my $rs = diag_table($pos, $_[0], $_[1]);
#    print {STDERR} $rs;
    # Check to see if we have an argument
    if($tabhlen[$tabdepth] == 0){
	$es = $es . "Error: cannot find table argument for element \"";
	$es = $es . $_[0]->name . "\"\n with (general) table serial number ";
	$es = $es . $tabid[$tabdepth] . " at table depth " . $tabdepth;
	die $es;
    };
    my $os = "\\begin{array}"
                . $tabarg[$tabdepth] . "\n";
    $os = $os . $pos;
    $os = $os. "\\end{array}\n";
    output($os);
    $tabdepth--;
});

# Element: tabarg
sgml('<tabarg>', sub{
    push_output('string');
});
sgml('</tabarg>', sub{
    my $pos = pop_output;
    my $qos = $pos;
    $qos =~ s/\|//g;
    $qos =~ s/\{[^{}]*\}//g;
    if($tabdepth <= 0){
	die "Have table arg without positive table depth";
    };
    $tabhlen[$tabdepth]=length($qos);
    $tabarg[$tabdepth] = '{' . $pos . '}';
});

# Element: tabopt
sgml('<tabopt>', sub{
    push_output('string');
});
sgml('</tabopt>', sub{
    my $pos =  pop_output;
    $tabopt[$tabdepth] = '[' . $pos . ']';
});

# Element: table -- somewhat like the HTML table model with <tr>, <td>.
#  For sanity in rendition to LaTeX "tabular" we need the "tabular"
#  column argument.
sgml('<table>', sub{
    $tabser++;
    $tabdepth++;
    $trcount[$tabdepth] = 0;
    $trulecount[$tabdepth] = 0;
    $tabid[$tabdepth] = $tabser;
    $tabhlen[$tabdepth] = 0;
    $tabvlen[$tabdepth] = 0;
    $tabopt[$tabdepth] = "";
    $tabarg[$tabdepth] = "";
    push_output('string');
});
# The push/pop should only be across the tabhead
sgml('</table>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "";
    my $tbpw = 0;
    my $tbpws = "";
    my $tbarg = $tabarg[$tabdepth];
    # Check to see if we have an argument
    my $es = "";
    if($tabhlen[$tabdepth] == 0){
	$es = $es . "Error: cannot find table argument for element \"";
	$es = $es . $_[0]->name . "\"\n with (general) table serial number ";
	$es = $es . $tabid[$tabdepth] . " at table depth " . $tabdepth;
	die $es;
    }
    # Assume the user enters linewidth ratios for all p-cells or none
    elsif($tbarg =~ /p\{/){
	$tbarg =~ s/([.0-9]+)/\1\\linewidth\{\}/g;
    }
    else{
	$tbpw = sprintf("%4.3f",0.0 + 1/($tabhlen[$tabdepth]+0.1));
	$tbpws = $tbpw . "\\linewidth{}";
	$tbarg =~ s/p/p{$tbpws}/g;
    };
    if($pan =~ /^(td|tdc|tdp|tdr)$/){
	$os = $os . "\\hspace*{-\\tabcolsep}";
    };
    $os = $os . "\\begin{tabular}";
    if($tabopt[$tabdepth] ne ""){
	$os = $os . $tabopt[$tabdepth];
    };
    $os = $os . $tbarg . "\n";
    $os = $os . $pos;
    if($trulecount[$tabdepth] > 0){
	$os = $os . "\\\\ ";
	while($trulecount[$tabdepth] > 0){
	    $os = $os . "\\hline ";
	    $trulecount[$tabdepth]--;
	};
    };
    $os = $os. "\n\\end{tabular}\n";
    output($os);
    $tabdepth--;
});

# Element: tableb -- somewhat like the early HTML table model with <tr>, <td>.
#  But for sanity in rendition to LaTeX "tabular" we'll need to work in
#  the "tabular" column argument as an option.  This rendition is "boxed"
#  and centered.  (We don't have any blanket centering here, right?)
sgml('<tableb>', sub{
    $tabser++;
    $tabdepth++;
    $trcount[$tabdepth] = 0;
    $trulecount[$tabdepth] = 0;
    $tabid[$tabdepth] = $tabser;
    $tabhlen[$tabdepth] = 0;
    $tabvlen[$tabdepth] = 0;
    $tabarg[$tabdepth] = "";
    push_output('string');
});
sgml('</tableb>', sub{
    my $pos = pop_output;
    # Check to see if we have an argument
    my $es = "";
    if($tabhlen[$tabdepth] == 0){
	$es = $es . "Error: cannot find table argument for element \"";
	$es = $es . $_[0]->name . "\"\n with (general) table serial number ";
	$es = $es . $tabid[$tabdepth] . " at table depth " . $tabdepth;
	die $es;
    };
    my $os = "\\begin{center}\n\\begin{tabular}"
                . $tabarg[$tabdepth] . "\\hline ";
    $os = $os . $pos;
    $os = $os. "\\\\ \\hline ";
    while($trulecount[$tabdepth] > 0){
	$os = $os . "\\hline ";
	$trulecount[$tabdepth]--;
    };
    $os = $os . "\n\\end{tabular}\n\\end{center}";
    output($os);
    $tabdepth--;
});

# Element: tablec -- somewhat like the HTML table model with <tr>, <td>.
#  For sanity in rendition to LaTeX "tabular" we need the "tabular"
#  column argument.  This version is centered but not boxed.
sgml('<tablec>', sub{
    $tabser++;
    $tabdepth++;
    $trcount[$tabdepth] = 0;
    $trulecount[$tabdepth] = 0;
    $tabid[$tabdepth] = $tabser;
    $tabhlen[$tabdepth] = 0;
    $tabvlen[$tabdepth] = 0;
    $tabarg[$tabdepth] = "";
    push_output('string');
});
sgml('</tablec>', sub{
    my $pos = pop_output;
    # Check to see if we have an argument
    my $es = "";
    if($tabhlen[$tabdepth] == 0){
	$es = $es . "Error: cannot find table argument for element \"";
	$es = $es . $_[0]->name . "\"\n with (general) table serial number ";
	$es = $es . $tabid[$tabdepth] . " at table depth " . $tabdepth;
	die $es;
    };
    my $os = "\\begin{center}\n\\begin{tabular}"
                . $tabarg[$tabdepth] . "\n";
    $os = $os . $pos;
    if($trulecount[$tabdepth] > 0){
	$os = $os . "\\\\ ";
	while($trulecount[$tabdepth] > 0){
	    $os = $os . "\\hline ";
	    $trulecount[$tabdepth]--;
	};
    };
    $os = $os. "\n\\end{tabular}\n\\end{center}";
    output($os);
    $tabdepth--;
});

# Element: emprow -- empty table row, mainly for use with "tablec"
sgml('<emprow>', sub{
    $trcount[$tabdepth]++;
    my $os = "";
    if($trcount[$tabdepth] > 1){
	$os = "\n\\\\ ";
    };
    while($trulecount[$tabdepth] > 0){
	$os = $os . "\\hline ";
	$trulecount[$tabdepth]--;
    };
    my $pan = $_[0]->parent->name;
    if($pan eq "tableb"){
	$os = $os . "\\hline ";
    };
    $os = $os . "\\ {}~\\hsf";
    output($os);
});
sgml('</emprow>', "");

# Element: trule -- table-wide horiz. rule, mainly for use with "tablec"
#                   but usable elsewhere
#                   (Rules are presently built into "tr".)
sgml('<trule>', sub{
    $trulecount[$tabdepth]++;
});
sgml('</trule>', "");

# Element: tr -- table row
sgml('<tr>', sub{
    $trcount[$tabdepth]++;
    $tdcount[$tabdepth]=0;
    $tabvlen[$tabdepth]++;
    my $os = "";
    if($trcount[$tabdepth] > 1){
	$os = "\n\\\\ ";
    };
    while($trulecount[$tabdepth] > 0){
	$os = $os . "\\hline ";
	$trulecount[$tabdepth]--;
    };
    my $pan = $_[0]->parent->name;
    if($pan eq "tableb"){
	$os = $os . "\\hline ";
    };
    output($os);
});
sgml('</tr>', "");

# Element: th -- table header cell
sgml('<th>', sub{
    $trcount[$tabdepth]++;
    $tdcount[$tabdepth]++;
    push_output('string');
});
sgml('</th>', sub{
    my $pos = pop_output;
    my $os;
    # Watch out for a first cell that inserts "[ ... ]" following "\\"
    if($tdcount[$tabdepth] == 1){
	$os = "{}";
    };
    $os = $os . "\\textbf{" . $pos . "}";
    if($tdcount[$tabdepth] < $tabhlen[$tabdepth]){
	$os = $os . " & ";
    }
    output($os);
});

# Element: td -- table cell
sgml('<td>', sub{
    $tdcount[$tabdepth]++;
    push_output('string');
});
sgml('</td>', sub{
    my $pos = pop_output;
    my $os = "";
    # Watch out for a first cell that inserts "[ ... ]" following "\\"
    if($tdcount[$tabdepth] == 1){
	$os = "{}";
    };
    $os = $os . $pos;
    if($tdcount[$tabdepth] < $tabhlen[$tabdepth]){
	$os = $os . " & ";
    }
    output($os);
});

# Element: tdp -- table cell
sgml('<tdp>', sub{
    $tdcount[$tabdepth]++;
    push_output('string');
});
sgml('</tdp>', sub{
    my $pos = pop_output;
    my $os = "";
    # Watch out for a first cell that inserts "[ ... ]" following "\\"
    if($tdcount[$tabdepth] == 1){
	$os = "{}";
    };
    $os = $os . $pos;
    if($tdcount[$tabdepth] < $tabhlen[$tabdepth]){
	$os = $os . " & ";
    }
    output($os);
});

# Element: tdr -- table cell
sgml('<tdr>', sub{
    $tdcount[$tabdepth]++;
    push_output('string');
});
sgml('</tdr>', sub{
    my $pos = pop_output;
    my $os = "";
    # Watch out for a first cell that inserts "[ ... ]" following "\\"
    if($tdcount[$tabdepth] == 1){
	$os = "{}";
    };
    $os = $os . $pos;
    if($tdcount[$tabdepth] < $tabhlen[$tabdepth]){
	$os = $os . " & ";
    }
    output($os);
});

# Element: tdbc -- used to bold and center within a table cell
#                  (or whatever); it uses LaTeX newcommands "hsf" and
#                  "tdbc", where "hsf" is \hspace*{\fill} (see above)
sgml('<tdbc>', sub{
    push_output('string');
});
sgml('</tdbc>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "";
    if($pan eq "th"){
	$os = "\\hsf{}" . $pos . "\\hsf{}";
    }
    else{
	$os = "\\tdbc{" . $pos . "}";
    };
    output($os);
});

# Element: tablech -- no border, flush to left margin
#  But for sanity in rendition to LaTeX "tabular" we'll need to work in
#  the "tabular" column argument as an option.  This table is not "boxed"
#   and may have inter-row space.
sgml('<tablech>', sub{
    $tabser++;
    $tabdepth++;
    $trcount[$tabdepth] = 0;
    $trulecount[$tabdepth] = 0;
    $tabid[$tabdepth] = $tabser;
    $tabhlen[$tabdepth] = 0;
    $tabvlen[$tabdepth] = 0;
    $tabarg[$tabdepth] = "";
    push_output('string');
});
sgml('</tablech>', sub{
    my $pos = pop_output;
    # Check to see if we have an argument
    my $es = "";
    if($tabhlen[$tabdepth] == 0){
	$es = $es . "Error: cannot find table argument for element \"";
	$es = $es . $_[0]->name . "\"\n with (general) table serial number ";
	$es = $es . $tabid[$tabdepth] . " at table depth " . $tabdepth;
	die $es;
    };
    # We move left by \tabcolsep to be flush with the left margin.
    my $os = "\\hspace*{-\\parindent}\\hspace*{-\\tabcolsep}\\begin{tabular}"
                . $tabarg[$tabdepth] . "\n";
    $os = $os . $pos;
    $os = $os. "\\end{tabular}";
    output($os);
    $tabdepth--;
});

# Element: trc -- table row for "tablec" and "tablech"
sgml('<trc>', sub{
    $tdcount[$tabdepth]=0;
    $tabvlen[$tabdepth]++;
});
sgml('</trc>', "\\\\{}\n");

# Element: tdc -- table cell
sgml('<tdc>', sub{
    $tdcount[$tabdepth]++;
    push_output('string');
});
sgml('</tdc>', sub{
    my $os = pop_output;
    if($tdcount[$tabdepth] < $tabhlen[$tabdepth]){
	$os = $os . " & ";
    };
    output($os);
});

# Element: bigskip
sgml('<bigskip>', "\\bigskip\n\n");
sgml('</bigskip>', "");

# Element: medskip
sgml('<medskip>', "\\medskip\n\n");
sgml('</medskip>', "");

# Element: smallskip
sgml('<smallskip>', "\\smallskip\n\n");
sgml('</smallskip>', "");

# Element: supsupsuphdr
sgml('<supsupsuphdr>', "\\begin{flushleft}\\Huge\\bfseries{}\n");
sgml('</supsupsuphdr>', "\\end{flushleft}\n");

# Element: supsuphdr
sgml('<supsuphdr>', "\\begin{flushleft}\\LARGE\\bfseries{}\n");
sgml('</supsuphdr>', "\\end{flushleft}\n");

# Element: suphdr
sgml('<suphdr>', "\\begin{flushleft}\\Large\\bfseries{}\n");
sgml('</suphdr>', "\\end{flushleft}\n");

# Element: hdr
sgml('<hdr>', "\\begin{flushleft}\\large\\bfseries{}\n");
sgml('</hdr>', "\\end{flushleft}\n");

# Element: subhdr
sgml('<subhdr>', "\\begin{flushleft}\\normalsize\\bfseries{}\n");
sgml('</subhdr>', "\\end{flushleft}\n");

# Element: subsubhdr
sgml('<subsubhdr>', "\\begin{flushleft}\\small\\bfseries{}\n");
sgml('</subsubhdr>', "\\end{flushleft}\n");

# Element: supsupsuphdrc
sgml('<supsupsuphdrc>', "\\begin{center}\\Huge\\bfseries{}\n");
sgml('</supsupsuphdrc>', "\\end{center}\n");

# Element: supsuphdrc
sgml('<supsuphdrc>', "\\begin{center}\\LARGE\\bfseries{}\n");
sgml('</supsuphdrc>', "\\end{center}\n");

# Element: suphdrc
sgml('<suphdrc>', "\\begin{center}\\Large\\bfseries{}\n");
sgml('</suphdrc>', "\\end{center}\n");

# Element: hdrc
sgml('<hdrc>', "\\begin{center}\\large\\bfseries{}\n");
sgml('</hdrc>', "\\end{center}\n");

# Element: subhdrc
sgml('<subhdrc>', "\\begin{center}\\normalsize\\bfseries{}\n");
sgml('</subhdrc>', "\\end{center}\n");

# Element: subsubhdrc
sgml('<subsubhdrc>', "\\begin{center}\\small\\bfseries{}\n");
sgml('</subsubhdrc>', "\\end{center}\n");


# Element: itemize
sgml('<itemize>', "\\begin{itemize}\n");
sgml('</itemize>', "\\end{itemize}");

# Element: enumerate
sgml('<enumerate>', "\\begin{enumerate}\n");
sgml('</enumerate>', "\\end{enumerate}");

# Element: item
sgml('<item>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    if($pan eq "parlist"){
	$os = "";
    }
    else{
	$os = "\n\\item ";  # \n needed in case line above is <nul/>
	output($os);
    };
});
sgml('</item>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    if($pan eq "parlist"){
	$os = "\\texttt{   }";
    };
    $os = $os . "\n";
    output($os);
});

# Element: today
sgml('<today>', "\\today{} ");
sgml('</today>', "");

# Element: mbox -- as in LaTeX
sgml('<mbox>', sub{
    push_output('string');
});
sgml('</mbox>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "\\mbox{";
    if(($pan eq "sup") || ($pan eq "msup") || ($pan eq "sub") ||
       ($pan eq "msub") || ($pan eq "pow") || ($pan eq "sarg")){
	$os = $os . "\\scriptsize ";
    };
    $os = $os . $pos . "}";
    output($os);
});

# Element: regch -- as in LaTeX
sgml('<regch>', sub{
    push_output('string');
});
sgml('</regch>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "\\mbox{";
    if(($pan eq "sup") || ($pan eq "msup") || ($pan eq "sub") ||
       ($pan eq "msub") || ($pan eq "pow") || ($pan eq "sarg")){
	$os = $os . "\\scriptsize ";
    };
    $os = $os . $pos . "}";
    output($os);
});

# Element: text
sgml('<text>', sub{
    push_output('string');
});
sgml('</text>', sub{
    my $ts = pop_output;
    my $os = $ts;
    if($gmath_on == 1){
	$os = "\\text{" . $ts . "}";
    };
    output($os);
});

# Element: display -- non-math displayed paragraph.
sgml('<displayold>', "\\begin{center}\n");
sgml('</displayold>', "\n\\end{center}");

# Element display
sgml('<display>', sub{
    my $os = "\\begin{center}\n";
    my $frame = $_[0]->attribute("frame")->value;
    if($frame ne ""){
	$os = $os . "\\framebox[" . $frame . "\\width]{";
    }
    output($os);
});
sgml('</display>', sub{
    my $os = "";
    my $frame = $_[0]->attribute("frame")->value;
    if($frame ne ""){
	$os = $os . "}"
    }
    $os = $os . "\n\\end{center}";
    output($os);
});

# Element: quote -- not LaTeX's "quote"; instead a single instance thereof
sgml('<quote>', "\\begin{quote}\n");
sgml('</quote>', "\n\\end{quote}");

# Element: quotation -- LaTeX-like quotation
sgml('<quotation>', "\\begin{quotation}");
sgml('</quotation>', "\\end{quotation}");

# Element: verse -- LaTeX-like verse
sgml('<verse>', "\\begin{verse}");
sgml('</verse>', "\\end{verse}");

# Element: math  -- inline math delimited by "\( ... \)"
#   Automatically precede and follow by a half space.  Ending punctuation
#   should be inside.
sgml('<math>', sub{
    $imath_on = 1;
    &on_gmath ;
    output ("\\,\\(");
});
sgml('</math>', sub{
    output ("\\)\\,");
    &off_gmath ;
    $imath_on = 0;
});

# Element: tmath  -- inline math delimited by "$ ... $" instead of
#                   by "\math{ ... } or by "\( ... \)"
sgml('<tmath>', sub{
    $imath_on = 1;
    &on_gmath ;
    output ("\\(");
});
sgml('</tmath>', sub{
    output ("\\)");
    &off_gmath ;
    $imath_on = 0;
});

# Element: displaymath  -- displayed math
sgml('<displaymath>', \&on_dmath);
sgml('</displaymath>', \&off_dmath);

# Element: sup  -- behavior depends on whether  $gmath_on  is set.
sgml('<sup>', sub{push_output('string');});
sgml('</sup>', sub{
    my $s = pop_output ;
    if($gmath_on == 1){
	output("^{" . $s . "}");
    }
    else{
	output("\$^{\\mbox{" . $s . "}}\$");
    };
});

# Element: sub  -- behavior depends on whether  $gmath_on  is set.
sgml('<sub>', sub{push_output('string');});
sgml('</sub>', sub{
    my $s = pop_output ;
    if($gmath_on == 1){
	output("_{" . $s . "}");
    }
    else{
	output("\$_{\\mbox{" . $s . "}}\$");
    };
});

# Element: frac -- fraction.  For now only the LaTeX (two arg) model.
#   If the input is valid (surviving "nsgmls"), we have $gmath_on = 1.
sgml('<frac>', sub{
    $fracser++;
    $fracdepth++;
    $frid[$fracdepth]=0;  # move to 1 for first arg, to 2 for second
    $numr[$fracdepth]="";
    $denm[$fracdepth]="";
    push_output('string');
});
sgml('</frac>', sub{
    my $pos = pop_output;
    my $os = "\\frac{" . $numr[$fracdepth]
     . "}{" . $denm[$fracdepth] . "}";
    output($os);
    $fracdepth--;
});

# Element: over -- empty fraction divider (deprecated)
sgml('<over>', "\\over{}");
sgml('</over>', "");

# Element: sqrt -- model (op0,ag0) OR (%vline)*
sgml('<sqrt>', sub{
    push_output('string');
    $sqrtdepth++;
    $sqrtopt[$sqrtdepth] = "";
    $sqrtarg[$sqrtdepth] = "";
    $radicand[$sqrtdepth] = "";
    $radx[$sqrtdepth] = "";
});
sgml('</sqrt>', sub{
    my $pos = pop_output;
    my $os = "\\sqrt";
    if(($sqrtopt[$sqrtdepth] eq "") && ($radicand[$sqrtdepth] eq "")){
	$os = $os . "{" . $pos . "}";
    }
    elsif($radicand[$sqrtdepth] ne ""){
	if($radx[$sqrtdepth] ne ""){
	    $os = $os . '[' . $radx[$sqrtdepth] . ']';
	};
	$os = $os . '{' . $radicand[$sqrtdepth] . '}';
    }
    else{
	$os = $os . '[' . $sqrtopt[$sqrtdepth] . ']{'
                  . $sqrtarg[$sqrtdepth] . '}';
    };
    output($os);
    $sqrtdepth--;
});

# With "gellmu.dtd", the commands "sum", "int", & "prod" take a single
# argument (i.e., are simple containers) which may or may not have
# "sub" or "sup" or both as *leading* content.

# Element: sum -- specif.: ((sub)?&(sup)?,(%gmath)*)
#   *required* surrounding braces) that may or may not contain sub/sup.
#          If the input is valid, we have $gmath_on = 1.
sgml('<sum>', "\\sum");
sgml('</sum>', "");

# Element: int -- specif.: ((sub)?&(sup)?,(%gmath)*)
#          If the input is valid, we have $gmath_on = 1.
sgml('<int>', "\\int");
sgml('</int>', "");

# Element: prod -- specif.: ((sub)?&(sup)?,(%gmath)*)
#          If the input is valid, we have $gmath_on = 1.
sgml('<prod>', "\\prod");
sgml('</prod>', "");

# Element: par
sgml('<par>', sub{
    $para_on = 1;
    output("\\par{");
});
sgml('</par>', sub{
    $para_on = 0;
    output("\n}\n");
});

# Element: parb
sgml('<parb>', sub{
    my $pan = $_[0]->parent->name;
    my $os = "";
    if(($pan eq "quote")||($pan eq "quotation")||($pan eq "verse")){
	$os = "\n";
    }
    else{
	$para_on = 1;
	$os = "\\par{";
    }
    output($os);
});
sgml('</parb>', sub{
    my $pan = $_[0]->parent->name;
    my $os = "";
    if(($pan eq "quote")||($pan eq "quotation")||($pan eq "verse")){
	$os = "\n";
    }
    else{
	$para_on = 0;
	$os = "\n}\n";
    }
    output($os);
});

# OBSOLETE Element: bpar -- used as shortref for PARB, the alter ego of PAR
# sgml('<bpar>', "");
# sgml('</bpar>', "");

# Element: aos -- @-end-of-sentence mark if we NOT in math mode
#  Forbidden in a math mode; punt for robustness.
sgml('<aos>', sub{
    if($gmath_on == 1)
     {
      if($dmath_on == 1)
       {output("\\ . \\ ")}
      else
       {output("\\, . \\,")}
     }
   else{output("\\@. \\ ")}
});
sgml('</aos>', "");

# Element: aoq -- @-end-of-question mark
sgml('<aoq>', sub{
    if($gmath_on == 1)
     {
      if($dmath_on == 1)
       {output("\\ ? \\ ")}
      else
       {output("\\, ? \\,")}
     }
   else{output("\\@? \\ ")}
});
sgml('</aoq>', "");

# Element: aoc -- @-comma
sgml('<aoc>', "\\@, ");
sgml('</aoc>', "");

# Element: eos -- end-of-sentence mark if we are not in math mode
#              -- in math mode it's probably a sloppy ldot or a
#              -- decimal point, who knows?
sgml('<eos>', sub{
    if($dmath_on == 1){
	output("\\ \\ .");
    }
    elsif($gmath_on == 1){
	output("\\,.");
    }
    elsif($verb_on > 0){
	output(".");
    }
    else{
	output(". \\ ");
    };
});
sgml('</eos>', "");

# Element: eoq -- end-of-question mark
sgml('<eoq>', sub{
    if(($gmath_on == 1)||($verb_on > 0)){output("?")}else{output("? \\ ");};
});
sgml('</eoq>', "");

# Element: eoe -- end-of-exclamation mark
sgml('<eoe>', sub{
    if(($gmath_on == 1)||($verb_on > 0)){output("!")}else{output("! \\ ");};
});
sgml('</eoe>', "");

# Element: bsl -- abstract char "\"
# For this we really need a better "\backslash".
sgml('<bsl>', sub{
    my $os = "\\textbackslash{}";
    my $par = $_[0]->parent;
    if($verb_on == 1){
	$os = "\\";
    }
    elsif($par->name =~ /^(quostr|qquostr|quochar|nln)$/){
	$os = "}\\verb+\\+\\texttt{";
        # LaTeX's \verb cannot be within a command argument or option
	if($par->within("footnote") ne ""){
	    $os = "\\textbackslash{}";
	}
	elsif($par->within("shead") ne ""){
	    $os = "\\textbackslash{}";
	}
	elsif($par->within("itemlabel") ne ""){
	    $os = "\\textbackslash{}";
	}
	elsif($par->within("term") ne ""){
	    $os = "\\textbackslash{}";
	};  # there may be more for this list
    }
    elsif($par->name =~ /^(path|urlanch)$/){  # which are set with \url
	$os = "\\";
    }
    elsif ($gmath_on == 1){
	$os = "\\backslash{}";
    };
    output($os);
});
sgml('</bsl>', "");

# Element: vbr -- abstract char "|"
sgml('<vbr>', sub{
    my $os = "\\textbar{}";
    my $par = $_[0]->parent;
    my $pan = $par->name;
    if($verb_on == 1){
	$os = "|";
    }
    elsif($pan =~ /^(quostr|qquostr|quochar|nln)$/){
	$os = "\\string|";  # perhaps not necessary from 1998/12/01
    }
    elsif($pan =~ /^(path|urlanch|tabarg|arrcols|csep)$/){
	$os = "|";
    }
    elsif ($gmath_on == 1){
	$os = "\\vert{}";
    };
    output($os);
});
sgml('</vbr>', "");

# Element: mid
sgml('<mid>', "\\mid{}");
sgml('</mid>', "");

# Element: lbr -- abstract char "{"
sgml('<lbr>', sub{
    my $es = "{";
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $ros = "\\" . $es;
    my $os = $ros;
    if($verb_on > 0){
	$os = $es;
    }
    elsif($pan =~ /^(quostr|qquostr|quochar|nln)$/){
	$os = "}\\verb+{+\\texttt{";
        # LaTeX's \verb cannot be within a command argument or option
	if($par->within("footnote") ne ""){
	    $os = $ros;
	}
	elsif($par->within("shead") ne ""){
	    $os = $ros;
	}
	elsif($par->within("itemlabel") ne ""){
	    $os = $ros;
	}
	elsif($par->within("term") ne ""){
	    $os = $ros;
	};  # there may be more for this list
    }
    elsif($pan =~ /^(path|urlanch)$/){
	# We're currently setting these with \url, which does not handle
	#   either '{' or '}' but takes everything else verbatim while
	#   ignoring blank spaces.
	print STDERR "ltxgart.pl WARNING: \"{\" in ", $pan,
	" -- cannot set using \\url -- ignored\n";
	$os = " ";
    };
    output($os);
});
sgml('</lbr>', "");

# Element: rbr -- abstract char "}"
sgml('<rbr>', sub{
    my $es = "}";
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $ros = "\\" . $es;
    my $os = $ros;
    if($verb_on > 0){
	$os = $es;
    }
    elsif($pan =~ /^(quostr|qquostr|quochar|nln)$/){
	$os = "}\\verb+}+\\texttt{";
        # LaTeX's \verb cannot be within a command argument or option
	if($par->within("footnote") ne ""){
	    $os = $ros;
	}
	elsif($par->within("shead") ne ""){
	    $os = $ros;
	}
	elsif($par->within("itemlabel") ne ""){
	    $os = $ros;
	}
	elsif($par->within("term") ne ""){
	    $os = $ros;
	};  # there may be more for this list
    }
    elsif($pan =~ /^(path|urlanch)$/){
	# We're currently setting these with \url, which does not handle
	#   either '{' or '}' but takes everything else verbatim while
	#   ignoring blank spaces.
	print STDERR "ltxgart.pl WARNING: \"}\" in ", $pan,
	" -- cannot set using \\url -- ignored\n";
	$os = " ";
    };
    output($os);
});
sgml('</rbr>', "");

# Element: lsb -- abstract char "["
sgml('<lsb>', "[");
sgml('</lsb>', "");

# Element: rsb -- abstract char "]"
sgml('<rsb>', "]");
sgml('</rsb>', "");

# Element: exc -- abstract exclamation point
sgml('<exc>', "!");
sgml('</exc>', "");

# Element: atc -- abstract "@"
sgml('<atc>', "@");
sgml('</atc>', "");

# Element: hsh -- abstract hash, i.e., "#"
sgml('<hsh>', sub{
    my $es = "#";
    my $os = "\\" . $es;
    if(($verb_on > 0) || ($_[0]->parent->name =~ /^(path|urlanch)$/)){
	$os = $es;
    };
    output($os);
});
sgml('</hsh>', "");

# Element: dol -- abstract dollar sign (needs '\' both for Perl and LaTeX)
sgml('<dol>', sub{
    my $es = "\$";
    my $os = "\\" . $es;
    if(($verb_on > 0) || ($_[0]->parent->name =~ /^(path|urlanch)$/)){
	$os = $es;
    };
    output($os);
});
sgml('</dol>', "");

# Element: pct -- abstract percent sign
#  If one of these shows up in the SGML version of a GELLMU doc it was
#    not a comment.  A "<nul/" in the SGML indicates where a comment was.
sgml('<pct>', sub{
    my $es = "%";
    my $os = "\\" . $es;
    if(($verb_on > 0) || ($_[0]->parent->name =~ /^(path|urlanch)$/)){
	$os = $es;
    };
    output($os);
});
sgml('</pct>', "");

# Element: crt -- abstract char caret
sgml('<crt>', sub{
    my $es = "^";
    my $pan = $_[0]->parent->name;
    my $os = "\\textasciicircum{}";
    if(($verb_on > 0) || ($pan =~ /^(path|urlanch)$/)){
	$os = $es;
    }
    elsif($pan =~ /^(quostr|qquostr|quochar|nln)$/){
	$os = "\\string^";
    }
    elsif($gmath_on == 1){
	$os = "\\wedge";
    };
    output($os);
});
sgml('</crt>', "");

# Element: amp -- abstract ampersand
sgml('<amp>', sub{
    my $es = "&";
    my $os = "\\" . $es;
    if(($verb_on > 0) || ($_[0]->parent->name =~ /^(path|urlanch)$/)){
	$os = $es;
    };
    output($os);
});
sgml('</amp>', "");

# Element: ast -- abstract asterisk
sgml('<ast>', "*");
sgml('</ast>', "");

# Element: und -- abstract underscore
sgml('<und>', sub{
    my $es = "_";
    my $pan = $_[0]->parent->name;
    my $os = "\\" . $es;
    if(($verb_on > 0) || ($pan =~ /^(path|urlanch)$/)){
	$os = $es;
    # }
    # elsif($pan =~ /^(quostr|qquostr|quochar|nln)$/){
	# $os = "\\string_";   ## But why not just plain "\_"
    };
    output($os);
});
sgml('</und>', "");

# Element: eqc -- abstract char "="
sgml('<eqc>', "=");
sgml('</eqc>', "");

# Element: hyp -- abstract hyphen
#   In a math mode this could be either a subtraction (binary) or a
#   negation (unary).
sgml('<hyp>', "-");
# sgml('<hyp>', sub{
#    if($gmath_on == 1){output("\\, - \\,");}
#    else{output("-");}
# });
sgml('</hyp>', "");

# Element: plu -- abstract "+"
# "+" is used with LaTeX "\verb+...+"; escape the "+" when in verb
# by using Gellmu "\plu;".
sgml('<plu>', sub{
    my $os = "";
    if($verb_on > 0){
	$os = "+\\verb-+-\\verb+";
    }
    elsif($gmath_on == 1){
	$os = "\, + \,";
    }
    else{
	$os = "+";
    }
    output($os);
});
sgml('</plu>', "");

# Element: quo -- abstract version of the keyboard double quote '"'
#  This is normally not a character in a properly prepared LaTeX
#  file unless a representation of the keyboard char is wanted.
sgml('<quo>', sub{
    my $pan = $_[0]->parent->name;
    if ( ($inanchopt == 1) || ($pan eq "anchref") ){
	output('"');
    }
    elsif(($pan ne "verb") && ($pan ne "verbatim")){
	output("\\texttt{\"}");
    }
    else{
	output('"');
    }
});
sgml('</quo>', "");

# Element: sol -- abstract "/"
sgml('<sol>', "/");
sgml('</sol>', "");

# Element: lsq -- abstract left single quote
sgml('<lsq>', "`");
sgml('</lsq>', "");

# Element: rsq -- abstract right single quote
sgml('<rsq>', "'");
sgml('</rsq>', "");

# Element: ldq --  abstract left double quote
sgml('<ldq>', "``");
sgml('</ldq>', "");

# Element: rdq -- abstract right double quote
sgml('<rdq>', "''");
sgml('</rdq>', "");

# Element: lpr
sgml('<lpr>', "(");
sgml('</lpr>', "");

# Element: rpr
sgml('<rpr>', ")");
sgml('</rpr>', "");

# Element: ltc  --  outside of gmath, one probably wants this in either
#                   verb, quostr, qquostr, or verbatim; we'll not force
#                   this since some legacy LaTeX may use what just comes
sgml('<ltc>', sub{
    my $pan = $_[0]->parent->name;
    my $os = "\\textless{}";
    if($verb_on == 1){
	$os = "<";
    }
    elsif($gmath_on == 1){
	$os = "<";
    }
    elsif($pan =~ /^(quostr|qquostr|quochar|eaddr|email|nln)$/){
	$os = "\\string<";
    }
    elsif($pan =~ /^(path|urlanch)$/){
	$os = "<";
    };
    output($os);
});
# sgml('<ltc>', "<");
sgml('</ltc>', "");

# Element: gtc
sgml('<gtc>', sub{
    my $pan = $_[0]->parent->name;
    my $os = "\\textgreater{}";
    if($verb_on == 1){
	$os = ">";
    }
    elsif($gmath_on == 1){
	$os = ">";
    }
    elsif($pan =~ /^(quostr|qquostr|quochar|eaddr|email|nln)$/){
	$os = "\\string>";
    }
    elsif($pan =~ /^(path|urlanch)$/){
	$os = ">";
    };
    output($os);
});
# sgml('<gtc>', ">");
sgml('</gtc>', "");

# Element: cln
sgml('<cln>', ":");
sgml('</cln>', "");

# Element: scl
sgml('<scl>', ";");
sgml('</scl>', "");

# Element: per
sgml('<per>', ".");
sgml('</per>', "");

# Element: cma
sgml('<cma>', ",");
sgml('</cma>', "");

# Element: qum
sgml('<qum>', "?");
sgml('</qum>', "");

# Element: nul -- place-holder for whole-line comments in the
#     original .glm; on the one hand, we want to preserve line number
#     alignment between the .glm and the .sgml for author sanity.
#     So if we do and if we allow "\n" to bleed through in PCDATA from
#     there, we need to ** mark the location of former comments for
#     target markups that think blank lines are significant ** .
#
#     Do not use newlines here where PCDATA can appear at the top level.
#     (There's already a newline there, and we don't want to make a blank
#     line.)
#
sgml('<nul>', sub{
    my $pan = $_[0]->parent->name;
    my $os = "%nul";
    if(($pan eq "article")||($pan eq "preamble")||($pan eq "body")||
      ($pan =~ /[Ss]ection/)||($pan eq "abstract")||($pan eq "legalnotice")){
	$os = $os . "\n";
    }
    output($os);
});
sgml('</nul>', "");

# Element: cm0 -- place holder for end-of-line comments
sgml('<cm0>', sub{
    my $pan = $_[0]->parent->name;
    my $os = "%cm0";
    if(($pan eq "article")||($pan eq "preamble")||($pan eq "body")||
      ($pan =~ /[Ss]ection/)||($pan eq "abstract")||($pan eq "legalnotice")){
	$os = $os . "\n";
    }
    output($os);
});
sgml('</cm0>', "");

# Element: cs0 -- place holder for end-of-line comments
sgml('<cs0>', sub{
    my $pan = $_[0]->parent->name;
    my $os = " %cs0";
    if(($pan eq "article")||($pan eq "preamble")||($pan eq "body")||
      ($pan =~ /[Ss]ection/)||($pan eq "abstract")||($pan eq "legalnotice")){
	$os = $os . "\n";
    }
    output($os);
});
sgml('</cs0>', "");

# Element: cw0 -- place holder for end-of-line comments
sgml('<cw0>', sub{
    my $pan = $_[0]->parent->name;
    my $os = " %cw0";
    if(($pan eq "article")||($pan eq "preamble")||($pan eq "body")||
      ($pan =~ /[Ss]ection/)||($pan eq "abstract")||($pan eq "legalnotice")){
	$os = $os . "\n";
    }
    output($os);
});
sgml('</cw0>', "");

# Element: ldots -- abstract "..."
sgml('<ldots>', "\\ldots{}");
sgml('</ldots>', "");

# Element: cdots -- abstract "..."
sgml('<cdots>', "\\cdots{}");
sgml('</cdots>', "");

# Element: nbs -- non-breaking space (LaTeX's "~")
sgml('<nbs>', "~");
sgml('</nbs>', "");

# Element: hsf -- stretchy horizontal fill
sgml('<hsf>', "\\hsf ");  # a macro defined above
sgml('</hsf>', "");

# Element: dotfill
sgml('<dotfill>', "\\dotfill{}");
sgml('</dotfill>', "");

# Element: hrulefill
sgml('<hrulefill>', "\\hrulefill{}");
sgml('</hrulefill>', "");

# Element: tld -- a tilde char as a string
#   There are subtleties.  \textasciitilde does not work inside \url, but
#   "~" itself is OK there.  \url is presently used for <urlanch> and <path>
#   but not for <anchref>.
sgml('<tld>', sub{
    my $es = "~";
    my $pan = $_[0]->parent->name;
    my $os = "\\textasciitilde{}";
    if(($verb_on > 0) || ($pan =~ /^(path|urlanch)$/)){
	$os = $es;
    }
    elsif($pan =~ /^(quostr|qquostr|quochar|nln)$/){
	$os = "\\string~";
    }
    elsif ($gmath_on == 1){
	$os = "\\sim{}";
    };
    output($os);
});
sgml('</tld>', "");

# Element: spc -- styled regular blank space (maybe like LaTeX's "\ ")
sgml('<spc>', sub{
    my $os = "\\ ";
    my $pan = $_[0]->parent->name;
    if($verb_on > 0){
	$os = " ";
    }
    elsif($pan =~ /^(path|urlanch)$/){
	print STDERR "ltxgart.pl WARNING: using %20 for blank in \\url\n";
	$os = "\\%20";
    };
    output($os);
});
sgml('</spc>', "");

# Element: hsp -- thinner regular blank space (maybe like LaTeX's "\,")
sgml('<hsp>', "\\,");
sgml('</hsp>', "");

# Element: Hsp -- thinner regular blank space (maybe like LaTeX's "\,")
#                 use where some positive space is absolutely required
sgml('<Hsp>', "\\,");
sgml('</Hsp>', "");

# Element: abbr -- content is an abbreviation (maybe for smallcaps)
sgml('<abbr>', sub{
    push_output('string');
});
sgml('</abbr>', sub{
    my $pos = pop_output('string');
    my $pan = $_[0]->parent->name;
    my $os = "";
    if( ($pan eq "title") || ($pan eq "surtitle") || ($pan eq "subtitle") ||
       ($pan eq "author") || ($pan eq "date") || ($pan =~ /[Ss].*ection/) ||
       ($pan eq "term") || ($pan eq "shead")){
	$os = $pos;
    }
    else{
	$os = "\\textsc{" . $pos . "}";
    };
    output($os);
});

# Element: softw -- content is a software name
sgml('<softw>', sub{
    push_output('string');
});
sgml('</softw>', sub{
    my $pos = pop_output('string');
    my $pan = $_[0]->parent->name;
    my $os = "";
    if( ($pan eq "title") || ($pan eq "surtitle") || ($pan eq "subtitle") ||
       ($pan eq "author") || ($pan eq "date") || ($pan =~ /[Ss].*ection/) ||
       ($pan eq "term") || ($pan eq "shead") ){
	$os = $pos;
    }
    else{
	$os = "\\textsl{" . $pos . "}";
    };
    output($os);
});

# Element: latex
sgml('<latex>', "\\LaTeX{}");
sgml('</latex>', );

# Element: tex
sgml('<tex>', "\\TeX{}");
sgml('</tex>', );

# Element: texinfo
sgml('<texinfo>', "\\textsl{Texinfo}");
sgml('</texinfo>', );

# Element: bold -- emboldened
sgml('<bold>', "\\textbf{");
sgml('</bold>', "}");

# Element: emph -- lower case emphasized
sgml('<emph>', "\\emph{");
sgml('</emph>', "}");

# Element: Emph -- Capitalized form of emph
sgml('<Emph>', "\\textsf{");
sgml('</Emph>', "}");

# Element: EMPH -- upper case emphasized
sgml('<EMPH>', "\\textbf{\\emph{");
sgml('</EMPH>', "}}");

# Element: emph* -- starred form of emph
sgml('<emph*>', "{\\em ");
sgml('</emph*>', "}");

# Element: invr -- abstract inverse video
sgml('<invr>', "\\textsl{");
sgml('</invr>', "}");

# Element tale -- a French name
sgml('<tale>', "\\textsl{");
sgml('</tale>', "}");

# Element étale -- a French name
sgml('<étale>', "\\textsl{");
sgml('</étale>', "}");

# Element: anch -- visible marked inline area -- cannot be nested
sgml('<anch>', sub{
    $inanch = 1;
    $anchref = "";
    push_output('string');
});
sgml('</anch>', sub{
    my $pan = $_[0]->parent->name;
    $inanch = 0;
    my $os = "";
    my $pos=pop_output;
    my $hrs = "";
    my $elt = $_[0];
    my $alabel = "";
    my $attsr = $elt->attributes;
    my %atts = %$attsr;
    if(exists $atts{"name"}){
	if($elt->attribute(name)->value ne ""){
	    $alabel = $elt->attribute(name)->value;
	};
    };
    if(exists $atts{"href"}){
	if($elt->attribute(href)->value ne ""){
	    $hrs = $hrs . ' href="' . $elt->attribute(href)->value . '" ';
	};
    };
    if($noanchorfootnote == 0){
	if($haveanchopt == 1){
	    $hrs = $hrs . $anchopt;  # reference information, e.g., href
	    $haveanchopt = 0;
	}
	elsif($anchref ne ""){ # these days we should have:
	                       # $haveanchoropt == 0
	                       # any ref info in $anchref
	    $hrs = $hrs . $anchref;
	}
	else{
	    print STDERR "ltxgart.pl: WARNING: \"anch\" has no",
                " reference.\n   Looking at: \"", $pos, "\"\n";
	};
    };
# This next line could effect old docs:
    $hrs =~ s/^\s*//;  # strip initial white space
# And in the next two lines should I be using a marked RE?
#   (This code assumes only a single reference.)
    my $noFnote = 0;
    if($noanchorfootnote == 1){
	$noFnote = 1;
    };
    if($elt->attribute("noprinthref")->value ne ""){
	$noFnote = 1;
    };
    if($hrs =~ /^[Hi]ref\s*=/){
	$noFnote = 1;
    }
    else{
	# Clean $hrs up for use in footnote
	#   Code here for $hrs was simply the next two lines:
	#      $hrs =~ s/[fh]ref\s*=\s*\"//;
	#      $hrs =~ s/\"\s*$//;
	#
	#   Strip trailing white space prior to split on white space
	$trs = $hrs;
	$hrs = "";
	$trs =~ s/\s*$//;
	# We have possibly (1) href=, (2) fref=, or (3) name=
	# my @har = (split(/\s/, $trs));  # No.  This split does not work
	#     if the value string has spaces in it.
	# foreach $subh (@har){
	$subh = $trs;
	    if($subh =~ /fref\s*=/){ # value is a straight footnote
		$subh =~ s/fref\s*=\s*\"//;
		$subh =~ s/\"\s*$//;
	    }
	    elsif($subh =~ /href\s*=/){ # value is web reference
		$subh =~ s/href\s*=\s*\"//;
		$subh =~ s/\"\s*$//;
		if($subh =~ /^\\\#/){
		    $subh =~ s/^\\\#//;
		    $subh = "Reference to internal target with key: " . $subh;
		}
		else{
		    $subh = "URI: " . $subh;
		};
	    }
	    elsif($subh =~ /name\s*=/){ # value is a label
		$subh =~ s/name\s*=\s*//;
		$subh = "Reference target for key: " . $subh;
	    }
	    if($hrs ne ""){
		$subh = "\\\\{}" . $subh;
	    };
	    $hrs = $hrs . $subh;
	# }; #  End of foreach $subh (@har)
    };
    my $act = $pos;
  # "visible" anchor content
    # HTML form: my $os = "<a " . $hrs . ">" . $act . "</a>";
    # For print we have stripped the "href=" stuff out of $hrs
    if( ($noFnote == 1) || ($hrs eq "") ){
	$os = $act;
    }
    elsif(($pan eq "term")||($pan eq "itemlabel")){
	$termnoteseq++;
	$termnote[$termnoteseq] = "\\footnote{" . $hrs . "}";
	$os = $act;
    }
    else{
	$os = $act . "\\footnote{" . $hrs . "}";
    };
    output($os);
});

# Element: footnote -- ordinary LaTeX-style footnote, regular content
sgml('<footnote>', sub{
    my $elt = $_[0];
    if($elt->within("preamble") ne ""){
	$holdlatextitle = 1;
    };
    push_output('string');
});
sgml('</footnote>', sub{
    my $pan = $_[0]->parent->name;
    my $pos = pop_output;
    if(($pan eq "term") || ($pan eq "itemlabel")){
	$termnoteseq++;
	$termnote[$termnoteseq] = "\\footnote{" . $pos . "}";
    }
    else{
	my $os = "\\footnote{" . $pos . "}";
	output($os);
    };
});

# Element: urlanch -- HTML-like anchor with visible = *absolute* URL
sgml('<urlanch>', sub{
    # $verb_on++;
    push_output('string');
});
sgml('</urlanch>', sub{
    my $os = "";
    my $pos = pop_output;
    # $verb_on--;
    if(length($pos) == 0){
	$os = "[Location of empty URL-anchor]";
    }
    else{
	my $url = $pos;
	$url =~ s/^\s*//;
	$url =~ s/\s*$//;
	# $os = "\\verb|" . $url . "|";
	# $os = "\\texttt{" . $url . "}";
        # CAUTION: If the use of \url is reversed, then the code for
	#   several of the non-printable ASCII chars needs to be changed.
	$os = "\\url{" . $url . "}";
    };
    output($os);
});

# Element: urnanch -- Not supported here

# Element: times -- explicit multiplicative operator
sgml('<times>', "\\times{}");
sgml('</times>', "");

# Element: cdot -- explicit multiplicative operator
sgml('<cdot>', "\\cdot{}");
sgml('</cdot>', "");

# Element: pm -- "either-plus-or-minus" binary operator (not associative)
sgml('<pm>', "\\pm{}");
sgml('</pm>', "");

# Element: infty -- "infinity" symbol
sgml('<infty>', "\\infty{}");
sgml('</infty>', "");

# Element: geq
sgml('<geq>', "\\geq{}");
sgml('</geq>', "");

# Element: leq
sgml('<leq>', "\\leq{}");
sgml('</leq>', "");

# Element: neq
sgml('<neq>', "\\neq{}");
sgml('</neq>', "");

#
# Default handlers (uncomment these if needed).  Right now, these are set
# up to gag on any unrecognised elements, sdata, processing-instructions,
# or entities.
#
sgml('start_element', sub{
    push_output('nul');
});
sgml('end_element',sub{
    pop_output;
    my $nam = $_[0]->name;
    my $dos = "**ELT " . $nam . " DEL**";
    my $os = $dos;
    if( ($nam eq "Gamma") || ($nam eq "Delta") || ($nam eq "Phi") || ($nam eq "Theta") || ($nam eq "Lambda") || ($nam eq "Pi") || ($nam eq "Sigma") || ($nam eq "Upsilon") || ($nam eq "Xi") || ($nam eq "Psi") || ($nam eq "Omega") || ($nam eq "alpha")  || ($nam eq "beta")  || ($nam eq "gamma") || ($nam eq "delta")  || ($nam eq "epsilon")  || ($nam eq "varepsilon")  || ($nam eq "zeta") || ($nam eq "eta")  || ($nam eq "theta")  || ($nam eq "vartheta") || ($nam eq "iota")  || ($nam eq "kappa")  || ($nam eq "lambda")  || ($nam eq "mu" || ($nam eq "nu")  || ($nam eq "omicron")  || ($nam eq "pi")  || ($nam eq "varpi") || ($nam eq "rho")  || ($nam eq "sigma")  || ($nam eq "tau") || ($nam eq "upsilon")  || ($nam eq "phi")  || ($nam eq "varphi") || ($nam eq "chi") || ($nam eq "xi") || ($nam eq "psi")  || ($nam eq "omega")   )    ){
	$os = "\\" . $nam . "{}";
    }
    else{
	$unknown_elements++;
	print {STDERR} "Unknown element: ", $_[0]->name, "\n";
    };
    output($os);
});

sub on_gmath{
    if($gmath_on == 1){
	print {STDERR} "WARNING: Cannot enter math mode while in math mode.\n";
    };
    $gmath_on = 1;
};

sub off_gmath{
    if($gmath_on == 0){
	print {STDERR} "WARNING: Cannot leave math mode if not in it.\n";
    }
    $gmath_on = 0;
};

sub on_imath{
    $imath_on = 1;
    &on_gmath ;
    output ("\\(");
};

sub off_imath{
    output ("\\)");
    &off_gmath ;
    $imath_on = 0;
};

sub on_dmath{
    $dmath_on = 1;
    &on_gmath ;
    output("\\[");
};

sub off_dmath{
    output("\\]");
    &off_gmath ;
    $dmath_on = 0;
};

# Separate out the "href =" part of an href and return the URL,
#  which *should* already be a quoted string, using \texttt

sub parse_href{
#    $ts =~ s/href += +// ;
#    $ts;
    0;
};

# Element: quochar
sgml('<quochar>', "\\texttt{`");
sgml('</quochar>', "'}");

# Element: quostr
sgml('<quostr>',  "\\texttt{");
sgml('</quostr>', "}");

# Element: tée -- a French name (text encoding UTF-8)
sgml('<tée>',  "\\texttt{");
sgml('</tée>', "}");

# Element: qquostr
sgml('<qquostr>',  "\\texttt{\"");
sgml('</qquostr>', "\"}");

# Element: quophrase
sgml('<quophrase>', '``');
sgml('</quophrase>', "''");

# Element: squophrase --
sgml('<squophrase>', '`');
sgml('</squophrase>', "'");

# Element: verbatim
sgml('<verbatim>', sub{
    $verb_on++;
    my $os = "\\begin{verbatim}\n";
    output($os);
});
# no newline after writing \end{verbatim} 19990707
sgml('</verbatim>', sub{
    $verb_on--;
    my $os = "\n\\end{verbatim}";
    output($os);
});

# Element: verb
#   The use of GELLMU's \verb is deprecated.
sgml('<verb>', sub{
    $verb_on++;
    push_output('string');
});
sgml('</verb>', sub{
#   my $mn = $_[0]->name;
    my $pan = $_[0]->parent->name;
    my $ts = pop_output;
    my $us = $ts;
    my $os = $us;
    if($verb_on == 1){
	$us = "\\verb+" . $ts . "+";
	$os = $us;
	if(($pan eq "quochar")||($pan eq "quostr")||($pan eq "qquostr")){
	    $os = "}" . $us . "\\texttt{";
	};
    };
    output($os);
#    output($os . "</" . $pan . ":" . $mn . ">");
    $verb_on--;
});

# Element: hrule
sgml('<hrule>', sub{
 my $hsp = "\\hspace*{\\fill}";
 my $ms = "\\medskip\n";
 my $os = "\n\n" . $ms;
 $os = $os . $hsp . "\\rule[1bp]{0.8\\linewidth}{0.3bp}" . $hsp . "\n";
 $os = $os . $ms;
 output($os);
});
sgml('</hrule>', "");

# Element: brk -- forced linebreak
sgml('<brk>', sub{
    my $pan = $_[0]->parent->name;
    my $tdn = 0; my $jj = 0; my $os = " \\\\{}";
    # my $ds = "%% Parent: " . $pan . " tabdepth: " . $tabdepth;
    # $ds = $ds . "\n";
    # output($ds);
    if($pan =~ /(title|author|hdr|head)/){
	$os = "\\\\[0.25\\baselineskip]";
    }
    elsif(($tabdepth == 1) && ($pan =~ /^(td|tdc|tdp|tdr)$/)){
	# $ds = "%% tdcount: " . $tdcount[$tabdepth];
	if($tdcount[$tabdepth] > 1){
	    $tdn = $tdcount[$tabdepth] - 1;
	};
	# $ds = $ds . " tdn: " . $tdn . "\n";
	# output($ds);
	for($jj = 0; $jj < $tdn; $jj++){$os = $os . "& ";};
    }
    elsif($pan eq "desc"){
	$os = "~\\\\{}";
    };
    output($os);
});
sgml('</brk>', "");

# Element: brs -- LaTeX-like suggested line break, strength 3
sgml('<brs>', "\\linebreak[3]");
sgml('</brs>' , "");

# Element: rdash
sgml('<rdash>', "--");
sgml('</rdash>', "");

# Element: pdash
sgml('<pdash>', "---");
sgml('</pdash>', "");

# Element: i -- dotless `i' (and NOT "italic", as in HTML)
sgml('<i>', "\\i{}");
sgml('</i>', "");

# Element: j -- dotless `j'
sgml('<j>', "\\j{}");
sgml('</j>', "");

# Element: ell -- cursive lower case L
sgml('<ell>', sub{
    my $elt = $_[0];
    my $os = "\$\\ell{}\$";
    if($gmath_on == 1){
	if($elt->within("text") eq ""){
	    $os = "\\ell{}";
	};
    };
    output($os);
});
sgml('</ell>', "");

# Element: wp -- cursive lower case L
sgml('<wp>', "\\wp{}");
sgml('</wp>', "");

# Element: cedil
sgml('<cedil>', "\\c{");
sgml('</cedil>', "}");

# Element: umlau
sgml('<umlau>', "\\\"{");
sgml('</umlau>', "}");

# Element: acute
sgml('<acute>', sub{
    push_output('string');
});
sgml('</acute>', sub{
    my $pos = pop_output;
    my $os = "\\'{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\acute{" . $pos . "}";
    };
    output($os);
});

# Element: grave
sgml('<grave>', sub{
    push_output('string');
});
sgml('</grave>', sub{
    my $pos = pop_output;
    my $os = "\\`{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\grave{" . $pos . "}";
    };
    output($os);
});

# Element: hat
sgml('<hat>', sub{
    push_output('string');
});
sgml('</hat>', sub{
    my $pos = pop_output;
    my $os = "\\^{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\hat{" . $pos . "}";
    };
    output($os);
});

# Element: ovhat
sgml('<ovhat>', sub{
    push_output('string');
});
sgml('</ovhat>', sub{
    my $pos = pop_output;
    my $os = "\\^{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\hat{" . $pos . "}";
    };
    output($os);
});

# Element: tilde
sgml('<tilde>', sub{
    push_output('string');
});
sgml('</tilde>', sub{
    my $pos = pop_output;
    my $os = "\\~{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\tilde{" . $pos . "}";
    };
    output($os);
});

# Hmmm ... we should make a function  set_math_sym
# See the handling of 'end_element'
# Element: oalpha
sgml('<oalpha>', sub{
    if($gmath_on == 1){
	output("\\alpha ");
    }
    else{
	output("\$\\,\\alpha\\,\$");
    }
});
sgml('</oalpha>', "");

# See the handling of 'end_element'
# Element: oGamma
sgml('<oGamma>', sub{
    if($gmath_on == 1){
	output("\\Gamma ");
    }
    else{
	output("\$\\,\\Gamma\\,\$");
    }
});
sgml('</oGamma>', "");

# Element: bal
sgml('<bal>', sub{
    push_output('string');
});
sgml('</bal>', sub{
    my $pos = pop_output;
    my $os = "";
    my $pre = "(";
    my $post = ")";
    if($gmath_on == 1){
	$pre = "\\left(";
	$post = "\\right)";
    };
    $os = $pre . $pos . $post;
    output($os);
});

# Element: balbr
sgml('<balbr>', sub{
    push_output('string');
});
sgml('</balbr>', sub{
    my $pos = pop_output;
    my $os = "";
    my $pre = "\\{";
    my $post = "\\}";
    if($gmath_on == 1){
	$pre = "\\left\\{";
	$post = "\\right\\}";
    };
    $os = $pre . $pos . $post;
    output($os);
});

# Element: balsb
sgml('<balsb>', sub{
    push_output('string');
});
sgml('</balsb>', sub{
    my $pos = pop_output;
    my $os = "";
    my $pre = "[";
    my $post = "]";
    if($gmath_on == 1){
	$pre = "\\left[";
	$post = "\\right]";
    };
    $os = $pre . $pos . $post;
    output($os);
});

# Element: balab
sgml('<balab>', sub{
    push_output('string');
});
sgml('</balab>', sub{
    my $pos = pop_output;
    my $os = "";
    my $pre = "<";
    my $post = ">";
    if($gmath_on == 1){
	$pre = "\\left<";
	$post = "\\right>";
    };
    $os = $pre . $pos . $post;
    output($os);
});

# Element: balvbr
sgml('<balvbr>', sub{
    push_output('string');
});
sgml('</balvbr>', sub{
    my $pos = pop_output;
    my $os = "";
    my $pre = "|";
    my $post = "|";
    if($gmath_on == 1){
	$pre = "\\left|";
	$post = "\\right|";
    };
    $os = $pre . $pos . $post;
    output($os);
});

# Element: lbalbr
sgml('<lbalbr>', sub{
    push_output('string');
});
sgml('</lbalbr>', sub{
    my $pos = pop_output;
    my $os = "";
    my $pre = "\\{";
    my $post = "";
    if($gmath_on == 1){
	$pre = "\\left\\{";
	$post = "\\right.";
    };
    $os = $pre . $pos . $post;
    output($os);
});

# Element: rbalbr
sgml('<rbalbr>', sub{
    push_output('string');
});
sgml('</rbalbr>', sub{
    my $pos = pop_output;
    my $os = "";
    my $pre = "";
    my $post = "\\}";
    if($gmath_on == 1){
	$pre = "\\left.";
	$post = "\\right\\}";
    };
    $os = $pre . $pos . $post;
    output($os);
});

# Element: func
sgml('<func>', sub{
    push_output('string');
});
sgml('</func>', sub{
    my $pos = pop_output;
    my $os = "";
    if($gmath_on == 1){
	$os = "\\" . $pos . " ";
    }
    else{
	$os = "\\emph{" . $pos . "}";
    };
    output($os);
});

# Element: doctop
sgml('<doctop>', "");
sgml('</doctop>', "");

# Element: notitle
sgml('<notitle>', sub{
    $notitle = 1;
});
sgml('</notitle>', "");

# Element: surtitle -- motivated by NetScape's border title
sgml('<surtitle>', sub{
    push_output('string');
});
sgml('</surtitle>', sub{
    $surtitle = pop_output;
});

# Element: latexcommand -- for direct verbatim passage
sgml('<latexcommand>', sub{
    $verb_on++;
    if($gmath_on == 1){
	$gmath_was_on = 1;
	$gmath_on = 0;
    };
    push_output('string');
});
sgml('</latexcommand>', sub{
    my $pos = pop_output;
    my $os = "";
    my $elt = $_[0];
    $os = $pos;
    if($elt->within("preamble") ne ""){
	$os = $os . "\n";
    };
    $verb_on--;
    if($gmath_was_on == 1){
	$gmath_on = 1;
	$gmath_was_on = 0;
    };
    output($os);
});

# Element: abstract
sgml('<abstract>', "\\begin{abstract}\n");
sgml('</abstract>', "\\end{abstract}\n");

# Element: copyright
sgml('<copyright>', "\\copyright{}");
sgml('</copyright>', "");

# Element: pounds
sgml('<pounds>', "\\pounds{}");
sgml('</pounds>', "");

# Element: defnlist
sgml('<defnlist>', "\\begin{description}\n");
sgml('</defnlist>', "\\end{description}");

# Element: citations
sgml('<citations>', "\\begin{citations}\n");
sgml('</citations>', "\\end{citations}");

# Element: term
sgml('<term>', sub{
    $termnoteseq = 0;
    push_output('string');
});
sgml('</term>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "";
    if($pan eq "defnlist"){
	$os = "\n\\item[{" . $pos . "}]";
                  # \n needed in case line above is <nul/>
	$jj = 1;
	while($jj <= $termnoteseq){
	    $os = $os . $termnote[$jj];
	    $jj++;
	};
	# $os = $os . "%\n";
	$os = $os . " ";    # tolerate long lines
    }
    else{
	$os = "\n\\item " . $pos. "\n";
    }
    output($os);
});

# Element: desc
sgml('<desc>', sub{
    push_output('string');
});
sgml('</desc>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "";
    my $ln = length($pos);
    # Footnotes on <term> must be in the description item body
    if($pan eq "defnlist"){
	if($termnoteseq > 0){
	    $os = "\n" . $pos . "\n";
	}
	else{
	    $os = "\\par{~}\n\n" . $pos . "\n";
	};
	output($os);
    }
    else{
	if($ln > 0){
	    $os = "\\\\{} " . $pos . "\n";
	    output($os);
	};
    }
});

# Element: menu
sgml('<menu>', "\\begin{menulist}\n");
sgml('</menu>', "\\end{menulist}");

# Element: Menu
sgml('<Menu>', "\\begin{Menulist}\n");
sgml('</Menu>', "\\end{Menulist}");

# Element parlist
sgml('<parlist>', "\n\n");
sgml('</parlist>', "");

# Element: label
sgml('<label>', sub{
    push_output('string');
});
sgml('</label>', sub{
    my $pos = pop_output;
    my $lid = "";
    my $os = "";
    my $lseq = "";
    my $pan = $_[0]->parent->name;
    if($pan eq "biblabel"){
	return;
    }
    elsif($pan eq "eqnrow"){
	$eqrkey = $pos;
	return;
    };
    if($pos ne ""){
	$lid = $pos;
	$lastlabelkey = $pos;
    }
    else{
	$lseq = $_[0]->attribute("lseq")->value;
	if($lseq ne ""){
	    $lid = "label-" . $lseq;
	};
    };
    if($lid ne ""){
	$os = "\\label{" . $lid . "}";
	output($os);
    };
});

# Element: klabel -- Visible key label
sgml('<klabel>', sub{
    push_output('string');
});
sgml('</klabel>', sub{
    my $pos = pop_output;
    my $os = "\\label{" . $pos . "}[" . $pos ."]";
    output($os);
});

# Element: ref
sgml('<ref>', sub{
    push_output('string');
});
sgml('</ref>', sub{
    my $key = pop_output;
    my $os = "";
    $os = "\\ref{" . $key . "}"; # hit or miss reliance on LaTeX is default
    #  Look in  %labelinfo  for a series
    #  Perhaps we could think about a way to create a LaTeX aux file when
    #    the XML is made so that here we could simply use the key
    if($labelsers{$key} ne ""){
	$os = $labelserseqs{$key};
    }
    elsif($labelsecunits{$key} ne ""){
	$os = $labelsecunits{$key};
    }
    elsif($labelsids{$key} ne ""){
	$os = $labelsids{$key};
    }
    # Looks as if the LaTeX default is entirely pre-empted
    else{
	print STDERR "ltxgart.pl -- ref key may not match label: \"$key\"\n";
    };
    output($os);
});

# Element: pageref
sgml('<pageref>', sub{
    push_output('string');
});
sgml('</pageref>', sub{
    my $pos = pop_output;
    my $os = "\\pageref{" . $pos . "}";
    output($os);
});

sub custom_title{
    my $os = "";
    if($arttitle ne ""){
	$os = $os . "\\begin{center}\\LARGE\\bfseries{}\n";
	$os = $os . $arttitle . "\n";
	$os = $os . "\\end{center}\n";
    };
    if($artsubtitle ne ""){
	$os = $os . "\\begin{center}\\large\\bfseries{}\n";
	$os = $os . $artsubtitle . "\n";
	$os = $os . "\\end{center}\n";
    };
    if ($haveauthor == 1){
	my $jaut = 1;
        my $jem = 0;
	while($jaut <= $auth_ser){
	    my $jemail = $haveemail[$jaut];
	    $os = $os . "\\begin{center}\\Large\\bfseries{}\n";
	    $os = $os . "\\textsl{" . $artauthor[$jaut] . "}\n";
	    $os = $os . "\\end{center}\n";
	    if (($haveaddr[$jaut] > 0)&&($auth_addr[$jaut] ne "")){
		$os = $os . "\\begin{center}\\large\n";
		$os = $os . $auth_addr[$jaut] . "\n";
		$os = $os . "\\end{center}\n";
	    }
	    if($jemail == 1){
		$os = $os . "\\begin{center}\n";
		$os = $os . "Email: \\verb|" . $AuthEmail[$jaut][$jemail] . "|\n";
		$os = $os . "\\end{center}\n";
	    };
	    if($jemail > 1){
		$os = $os . "\\begin{center}";
		$jem = 1;
		while($jem <= $jemail){
		    $os = $os . "\n\\verb|" . $AuthEmail[$jaut][$jem]
                              . "|\\\\{}";
		    $jem++;
		};
		$os = $os. "\\end{center}\n";
	    };
#	    if (($haveemail[$jaut] > 0)&&($auth_email[$jaut] ne "")){
#		$os = $os . "\\begin{center}\n";
#		$os = $os . $auth_email[$jaut] . "\n";
#		$os = $os . "\\end{center}\n";
#	    }
	    $jaut++;
	}  # end of while $jaut <= $auth_ser
    }
    if ($havedate == 1){
	$os = $os . "\\begin{center}\n\\large\\bfseries{}\n";
	$os = $os . $artdate . "\n";
	$os = $os . "\\end{center}\n";
    }
    if($copynotice ne ""){
	$os = $os . "\\begin{center}\n\\normalsize\\bfseries{}\n";
	$os = $os . $copynotice . "\n";
	$os = $os . "\\end{center}\n";
    };
    if ($markdraft == 1){
	$os = $os . draft_label();
    }
    return $os;
};
sub compact_title{
    my $os = "";
    $os = $os . "\\begin{center}\n";
    $os = $os . "{\\LARGE\\bfseries{}" . $arttitle . "}\n";
    if($artsubtitle ne ""){
	$os = $os . "\\\\\\hsf\\\\{\\large\\bfseries{}" . $artsubtitle . "}\n";
    };
    if ($haveauthor == 1){
	my $jaut = 1;
	while($jaut <= $auth_ser){
	    $os = $os . "\\\\[4\\partopsep]{\\Large\\bfseries{}\\textsl{"
                      . $artauthor[$jaut] . "}}\n";
	    if (($haveaddr[$jaut] > 0)&&($auth_addr[$jaut] ne "")){
		$os = $os . "\\\\[\\partopsep]{\\large\\bfseries{}"
                          . $auth_addr[$jaut] . "}\n";
	    }
	    my $jemail = $haveemail[$jaut];
	    if($jemail > 0){
		$jem = 1;
		$os = $os . "\\\\[\\partopsep]\n";
		while($jem <= $jemail){
		    $os = $os . "\\verb|" . $AuthEmail[$jaut][$jem] . "|";
		    if($jem < $jemail){
			$os = $os . "\\\\{}\n";
		    };
		    $jem++;
		}
		$os = $os . "\n";
	    };
#	    if (($haveemail[$jaut] > 0)&&($auth_email[$jaut] ne "")){
#		$os = $os . "\\\\[\\partopsep]" . $auth_email[$jaut] . "}\n";
#	    }
	    $jaut++;
	}; # end of while $jaut <= $auth_ser
    };
    if ($havedate == 1){
	$os = $os . "\\\\[4\\partopsep]{\\large\\bfseries{}"
                  . $artdate . "}\n";
    };
    if ($copynotice ne ""){
	$os = $os . "\\\\[4\\partopsep]{\\normalsize\\bfseries{}"
                  . $copynotice . "}\n";
    };
    if ($markdraft == 1){
	$os = $os . "\\\\[4\\partopsep]{\\small\\bfseries{}D R A F T }\n";
    }
    $os = $os . "\\end{center}\n";
    $os = $os . "\\vspace*{-\\centerskip}\n";
    return $os;
};
sub custom_lengths{
    my $os = "";
# I don't like to waste paper.
# I normally don't indent paragraphs since it's pass\'e, but
# doing so here serves to ferret out incorrect paragraphing.
    $os = $os . "\\setlength{\\parindent}{6bp}\n";
    $os = $os . "\\setlength{\\topmargin}{0bp}\n";
    $os = $os . "\\setlength{\\headheight}{0bp}\n";
    $os = $os . "\\setlength{\\headsep}{0bp}\n";
    $os = $os . "\\setlength{\\oddsidemargin}{23bp}\n";
    $os = $os . "\\setlength{\\evensidemargin}{23bp}\n";
    $os = $os . "\\setlength{\\textwidth}{422bp}\n";
    $os = $os . "\\setlength{\\textheight}{612bp}\n";
    $os = $os . "\\setlength{\\parskip}{6bp}\n";
    return $os;
};
sub draft_label{
    my $os = "";
    if ($compacttitle == 0){
	$os = "\\begin{center}\\small\\bfseries{}\n";
	$os = $os . "D R A F T\n";
	$os = $os . "\\end{center}\n";
	$os = $os . "\\medskip\n";
	return $os;
    }
};

# Element: partial -- partial differentiation "d" symbol
sgml('<partial>', "\\partial{}");
sgml('</partial>', "");

# Element: pmod -- as in "\pmod{m}" for "(mod m)"
sgml('<pmod>', sub{
    push_output('string');
});
sgml('</pmod>', sub{
    my $pos = pop_output;
    my $os = "\\pmod{" . $pos . "}";
    output($os);
});

# Element: bmod -- as in "a \mod m" for "a mod m"
sgml('<bmod>', "\\bmod{}");
sgml('</bmod>', "");

# Element: equiv -- LaTeX "equiv" symbol
sgml('<equiv>', "\\equiv{}");
sgml('</equiv>', "");

# Element: sim -- LaTeX "sim" symbol
sgml('<sim>', "\\sim{}");
sgml('</sim>', "");

# Element: simeq -- LaTeX "simeq" symbol
sgml('<simeq>', "\\simeq{}");
sgml('</simeq>', "");

# Element: cong -- LaTeX "cong" symbol
sgml('<cong>', "\\cong{}");
sgml('</cong>', "");

# Element: eaddr -- content is an email address
sgml('<eaddr>', sub{
    push_output('string');
});
sgml('</eaddr>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "";
    if(($pan eq "address")||($pan eq "author")){
	$os = "\\texttt{" . $pos . "}";
    }
    else{
	$os = "\\verb|" . $pos . "|";
    };
    output($os);
});

# Element: cslaa -- LaTeX's \aa
sgml('<cslaa>', "\\aa{}");
sgml('</cslaa>', "");

# Element: csll -- LaTeX's \l
sgml('<csll>', "\\l{}");
sgml('</csll>', "");

# Element: nabla -- gradient symbol
sgml('<nabla>', "\\nabla{}");
sgml('</nabla>', "");

# Element: bar
sgml('<bar>', sub{
    push_output('string');
});
sgml('</bar>', sub{
    my $pos = pop_output;
    my $os = "\\={" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\bar{" . $pos . "}";
    };
    output($os);
});

# Element: ovbar -- over-bar accent
sgml('<ovbar>', sub{
    push_output('string');
});
sgml('</ovbar>', sub{
    my $pos = pop_output;
    my $os = "\\={" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\bar{" . $pos . "}";
    };
    output($os);
});

# Element: unbar -- under-bar accent
sgml('<unbar>', sub{
    push_output('string');
});
sgml('</unbar>', sub{
    my $pos = pop_output;
    my $os = "\\b{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\underbar{" . $pos . "}";
    };
    output($os);
});

# Element: secnumdepth -- depth of the least significant sectional unit
#                        that is to be numbered
sgml('<secnumdepth>', sub{
    push_output('string');
});
sgml('</secnumdepth>', sub{
    my $pos = pop_output;
    $secnumdepth = $pos;
    # This next line needs to be moved if the default value of $secnumdepth
    # at the top of this file is to be other than LaTeX's default (3)
    my $os = "\\setcounter{secnumdepth}{" . $secnumdepth . "}\n";
    output($os);
});

# Element: circ -- LaTeX circ as with composition of functions
sgml('<circ>', "\\circ ");
sgml('</circ>', "");

# Element: rightarrow -- LaTeX rightarrow
sgml('<rightarrow>', "\\rightarrow{}");
sgml('</rightarrow>', "");

# Element: longrightarrow -- LaTeX longrightarrow
sgml('<longrightarrow>', "\\longrightarrow{}");
sgml('</longrightarrow>', "");

# Element: leftarrow -- LaTeX leftarrow
sgml('<leftarrow>', "\\leftarrow{}");
sgml('</leftarrow>', "");

# Element: longleftarrow -- LaTeX longleftarrow
sgml('<longleftarrow>', "\\longleftarrow{}");
sgml('</longleftarrow>', "");

# Element: leftrightarrow -- LaTeX leftrightarrow
sgml('<leftrightarrow>', "\\leftrightarrow{}");
sgml('</leftrightarrow>', "");

# Element: noanchorfootnote
sgml('<noanchorfootnote>', sub{
    $noanchorfootnote = 1;
});
sgml('</noanchorfootnote>', "");

# Element: wedge -- LaTeX wedge
sgml('<wedge>', "\\wedge ");
sgml('</wedge>', "");

# Element: oplus -- LaTeX oplus (direct sum math symbol)
sgml('<oplus>', "\\oplus ");
sgml('</oplus>', "");

# Element: ominus -- LaTeX ominus (circled minus math symbol)
sgml('<ominus>', "\\ominus ");
sgml('</ominus>', "");

# Element: otimes -- LaTeX otimes (tensor product math symbol)
sgml('<otimes>', "\\otimes ");
sgml('</otimes>', "");

# Element: in -- LaTeX in (math set membership symbol)
sgml('<in>', "\\in{}");
sgml('</in>', "");

# Element: not -- LaTeX in (math set not-a-member-of symbol)
sgml('<not>', sub{
    push_output('string');
});
sgml('</not>', sub{
    my $pos = pop_output;
    $pos =~ s/\ //g;
    my $os = "\\not" . $pos;
    if($pos =~ /^\\(parallel|mid|vbr)/){
	$os = "\\not\\," . $pos;
    };
    output($os);
});

# Element: lg0 -- brace-delimited logical group
sgml('<lg0>', "{");
sgml('</lg0>', "}");

# Element: norm -- math norm
sgml('<norm>', "\\left\\lVert{}");
sgml('</norm>', "\\right\\rVert{}");

# Element: absval -- math absolute value
sgml('<absval>', "\\left|");
sgml('</absval>', "\\right|");

# Element: transp -- matrix transpose
sgml('<transp>', sub{
    push_output('string');
});
sgml('</transp>', sub{
    my $pos = pop_output;
    # my $os = "\\,{{\\vphantom{" . $pos . "}}^{t}" . $pos . "}";
    my $os = "\\prescript{t}{}{" . $pos . "}";
    output($os);
});

# Element: vdots -- LaTeX-like vdots (in math)
sgml('<vdots>', "\\vdots{}");
sgml('</vdots>', "");

# Element: ddots -- LaTeX-like ddots (in math)
sgml('<ddots>', "\\ddots{}");
sgml('</ddots>', "");

# Element: mapsto -- LaTeX name
sgml('<mapsto>', " \\mapsto{}");
sgml('</mapsto>', "");

# Element: longmapsto -- LaTeX name
sgml('<longmapsto>', " \\longmapsto{}");
sgml('</longmapsto>', "");

# Element: angle -- LaTeX name
sgml('<angle>', " \\angle{}");
sgml('</angle>', "");

# Element: perp -- LaTeX name
sgml('<perp>', " \\perp{}");
sgml('</perp>', "");

# Element: ssec -- LaTeX's \S
sgml('<ssec>', "\\S{}");
sgml('</ssec>', "");

# Element: spar -- LaTeX's \P
sgml('<spar>', "\\P{}");
sgml('</spar>', "");

# Element: feed
sgml('<feed>', "\\pagebreak\n");
sgml('</feed>', "");

# Element: bref
sgml('<bref>', sub{
    push_output('string');
});
sgml('</bref>', sub{
    my $pos = pop_output;
    my $os = "\\  p. \\pageref{" . $pos . "}";
    output($os);
});

# Element: kref
sgml('<kref>', sub{
    push_output('string');
});
sgml('</kref>', sub{
    my $pos = pop_output;
    my $os = "[" . $pos . "]";
    output($os);
});

# Element: cap -- e.g., the symbol for intersection of sets
sgml('<cap>', "\\cap ");
sgml('</cap>', "");

# Element: cup -- e.g., the symbol for union of sets
sgml('<cup>', "\\cup ");
sgml('</cup>', "");

# Element: nwarrow -- e.g., the symbol for union of sets
sgml('<nwarrow>', "\\nwarrow ");
sgml('</nwarrow>', "");

# Element: nearrow -- e.g., the symbol for union of sets
sgml('<nearrow>', "\\nearrow ");
sgml('</nearrow>', "");

# Element: searrow -- e.g., the symbol for union of sets
sgml('<searrow>', "\\searrow ");
sgml('</searrow>', "");

# Element: swarrow -- e.g., the symbol for union of sets
sgml('<swarrow>', "\\swarrow ");
sgml('</swarrow>', "");

# Element: backslash
sgml('<backslash>', "\\backslash ");
sgml('</backslash>', "");

# Element: lessdot -- e.g., the symbol for union of sets
sgml('<lessdot>', "\\lessdot ");
sgml('</lessdot>', "");

# Element: gtrdot -- e.g., the symbol for union of sets
sgml('<gtrdot>', "\\gtrdot ");
sgml('</gtrdot>', "");

# Element: emptyset -- e.g., the symbol for union of sets
sgml('<emptyset>', "\\emptyset ");
sgml('</emptyset>', "");

# Element: subset
sgml('<subset>', "\\subset{}");
sgml('</subset>', "");

# Element: supset
sgml('<supset>', "\\supset{}");
sgml('</supset>', "");

# Element: subseteq
sgml('<subseteq>', "\\subseteq{}");
sgml('</subseteq>', "");

# Element: supseteq
sgml('<supseteq>', "\\supseteq{}");
sgml('</supseteq>', "");

# Element: parallel
sgml('<parallel>', "\\parallel{}");
sgml('</parallel>', "");

# Element: bullet
sgml('<bullet>', sub{
    my $elt = $_[0];
    my $os = "\$\\bullet{}\$";
    if($gmath_on == 1){
	if($elt->within("text") eq ""){
	    $os = "\\bullet{}";
	};
    };
    output($os);
});
sgml('</bullet>', "");

# Element: langle
sgml('<langle>', "\\langle{}");
sgml('</langle>', "");

# Element: rangle
sgml('<rangle>', "\\rangle{}");
sgml('</rangle>', "");

# Element: iseq -- item label for inline list
sgml('<iseq>', sub{
    push_output('string');
});
sgml('</iseq>', sub{
    my $pos = pop_output;
    my $os = "  " . $pos . " ";
    output($os);
});

# Element: slnt -- "slanted" emphasis
sgml('<slnt>', sub{
    push_output('string');
});
sgml('</slnt>', sub{
    my $pos = pop_output;
    my $os = "\\textsl{" . $pos . "}";
    output($os);
});

# Element: kcite -- citation with key = visible label
sgml('<kcite>', sub{
    push_output('string');
});
sgml('</kcite>', sub{
    my $pos = pop_output;
#    my $os = "\\cite[" . $pos . "]{" . $pos . "}";
    my $os = "\\cite{" . $pos . "}";
    output($os);
});

###
sgml('<citekey0>', sub{
    push_output('string');
});
sgml('</citekey0>', sub{
    my $pos = pop_output;
#    my $os = "{" . $pos . "}";
    $thiscitekey = $pos;
});
sgml('<citenote0>', sub{
    push_output('string');
});
sgml('</citenote0>', sub{
    my $pos = pop_output;
#    my $os = "\[" . $pos . "\]";
    $thiscitenote = $pos;
});
###

# Element: citekey -- citation with key = visible label
sgml('<citekey>', sub{
    push_output('string');
});
sgml('</citekey>', sub{
    $thiscitekey = pop_output;
});

# Element: citenote
sgml('<citenote>', sub{
    push_output('string');
});
sgml('</citenote>', sub{
    $thiscitenote = pop_output;
});

# Element: citetext
sgml('<citetext>', sub{
    push_output('string');
});
sgml('</citetext>', sub{
    $thiscitetext = pop_output;
});

# Element: cite
sgml('<cite>', sub{
    $thiscitenote = "";
    $thiscitekey = "";
    $thiscitetext = "";
    push_output('string');
});
sgml('</cite>', sub{
    my $pos = pop_output;
    if($pos ne ""){
	print STDERR "ltxgart.pl WARNING: loose output in <cite>\n";
    };
    my $os = "\\cite";
    if($thiscitenote ne ""){
	$os = $os . "\[{" . $thiscitenote . "}\]";
    };
    $os = $os . "{" . $thiscitekey . "}";
    output($os);
});

# Element: check
sgml('<check>', sub{
    push_output('string');
});
sgml('</check>', sub{
    my $pos = pop_output;
    my $os = "\\v{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\check{" . $pos . "}";
    };
    output($os);
});

# Element: ovvee -- citation with key = visible label
sgml('<ovvee>', sub{
    push_output('string');
});
sgml('</ovvee>', sub{
    my $pos = pop_output;
    my $os = "\\v{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\check{" . $pos . "}";
    };
    output($os);
});

# Element: vec -- arrow above (math only)
sgml('<vec>', sub{
    push_output('string');
});
sgml('</vec>', sub{
    my $pos = pop_output;
    $os = "\\textbf{vec}(" . $pos . ")";
    if($gmath_on == 1){
	$os = "\\vec{" . $pos . "}";
    }
    else{
	print STDERR $WhoAmI, ": WARNING -- Found <vec> outside of math\n";
    };
    output($os);
});

# Element: thebibliography -- citation with key = visible label
sgml('<thebibliography>', "\\begin{thebibliography}{MM}\n");
sgml('</thebibliography>', "\\end{thebibliography}\n");

# Element: bibentry
sgml('<bibentry>', "");
sgml('</bibentry>', "");

# Element: bibhead
sgml('<bibhead>', sub{
    $biblabel = "";
    $bibkey = "";
    push_output('string');
});
sgml('</bibhead>', sub{
    my $pos = pop_output;
    my $os = "\\bibitem";
    if ($biblabel ne ""){
	$os = $os . "\[{" . $biblabel . "}\]";
    };
    $os = $os . "{" . $bibkey . "}" . $pos;
    $os = $os . "\n";
    output($os);
});

# Element: biblabel
sgml('<biblabel>', sub{
    push_output('string');
});
sgml('</biblabel>', sub{
    $biblabel = pop_output;
});

# Element: bibkey
sgml('<bibkey>', sub{
    push_output('string');
});
sgml('</bibkey>', sub{
    $bibkey = pop_output;
});

# Element: bibbody
sgml('<bibbody>', "");
sgml('</bibbody>', "");

# Element: vbibitem -- citation with key = visible label
sgml('<vbibitem>', sub{
    push_output('string');
});
sgml('</vbibitem>', sub{
    my $pos = pop_output;
    my $os = "\\bibitem[" . $pos . "]{" . $pos . "}\n";
    output($os);
});

# Element: hy0 -- hyphenation hint
sgml('<hy0>', "\\-");
sgml('</hy0>', "");

# Element: binom
sgml('<binom>', sub{
    $binargid = 0;
    $binoml = 0;
    $binomu = 0;
    push_output('string');
});
sgml('</binom>', sub{
    my $pos = pop_output;
    my $os = "";
    $os = " \\binom{$binomu}{$binoml} ";
    output($os);
});

# Element binl
sgml('<binl>', sub{
    push_output('string');
});
sgml('</binl>', sub{
    $binoml = pop_output;
});

# Element binu
sgml('<binu>', sub{
    push_output('string');
});
sgml('</binu>', sub{
    $binomu = pop_output;
});

# Element: equation
sgml('<equation>', sub{
    push_output('string');
    $emath_on = 1;
    &on_gmath;
    $eqnkey = "";
    $eqntag = "";
    output("\\begin{gather*}");
});
sgml('</equation>', sub{
    &off_gmath;
    $emath_on = 0;
    my $pos = pop_output;
    my $os = $pos;
    $os = $os . "\n\\end{gather*}";
    output($os);
});

# Element: numr
sgml('<numr>', sub{
    push_output('string');
});
sgml('</numr>', sub{
    my $pos = pop_output;
    $numr[$fracdepth] = $pos;
});

# Element: denm
sgml('<denm>', sub{
    push_output('string');
});
sgml('</denm>', sub{
    my $pos = pop_output;
    $denm[$fracdepth] = $pos;
});

# Element: anchref
sgml('<anchref>', sub{
    push_output('string');
});
sgml('</anchref>', sub{
    $anchref = pop_output;
});

# Element: anchv
sgml('<anchv>', sub{
    push_output('string');
});
sgml('</anchv>', sub{
    my $pos = pop_output;
    output($pos);
});

# Element: lgg
sgml('<lgg>', sub{
    push_output('string');
});
sgml('</lgg>', sub{
    my $pos = pop_output;
    my $os = "{" . $pos . "}";
    output($os);
});

# Element: mlg
sgml('<mlg>', sub{
    push_output('string');
});
sgml('</mlg>', sub{
    my $pos = pop_output;
    my $os = "{" . $pos . "}";
    output($os);
});

# Element: msub
sgml('<msub>', sub{
    push_output('string');
});
sgml('</msub>', sub{
    my $pos = pop_output;
    my $os = "_{" . $pos . "}";
    output($os);
});

# Element: lower
sgml('<lower>', sub{
    push_output('string');
});
sgml('</lower>', sub{
    my $pos = pop_output;
    my $os = "_{" . $pos . "}";
    output($os);
});

# Element: msup
sgml('<msup>', sub{
    push_output('string');
});
sgml('</msup>', sub{
    my $pos = pop_output;
    my $os = "^{" . $pos . "}";
    output($os);
});

# Element: upper
sgml('<upper>', sub{
    push_output('string');
});
sgml('</upper>', sub{
    my $pos = pop_output;
    my $os = "^{" . $pos . "}";
    output($os);
});

# Element: pow
sgml('<pow>', sub{
    push_output('string');
});
sgml('</pow>', sub{
    my $pos = pop_output;
    my $os = "^{" . $pos . "}";
    output($os);
});

# Element: sarg
sgml('<sarg>', sub{
    push_output('string');
});
sgml('</sarg>', sub{
    my $pos = pop_output;
    my $os = "_{" . $pos . "}";
    output($os);
});

# Element: plus
sgml('<plus>', "+");
sgml('</plus>', "");

# Element: minus
sgml('<minus>', "-");
sgml('</minus>', "");

# Element: quotient
sgml('<quotient>', "/");
sgml('</quotient>', "");

# Element: equals
sgml('<equals>', sub{
    my $pan = $_[0]->parent->name;
    if($pan eq "not"){
	output("=");
    }
    elsif( (($dmath_on == 1) || ($emath_on == 1)) && ($inanchopt ==0)
	   && ($pan ne "anchref") && ($pan ne "msub") && ($pan ne "msup")
	   && ($pan ne "lower") && ($pan ne "upper")){
	output("\\ = \\ ");
    }
    elsif(($imath_on == 1) && ($inanchopt == 0) && ($pan ne "anchref")
	  && ($pan ne "msub") && ($pan ne "msup") && ($pan ne "lower")
	  && ($pan ne "upper")){
	output("\\, = \\,");
    }
    else{
	output("=");
    };
});
sgml('</equals>', "");

# Element neg -- unary negation (math)
sgml('<neg>', sub{
    push_output('string');
});
sgml('</neg>', sub{
    my $pos = pop_output;
    my $os = "-{" . $pos . "}";
    output($os);
});

# Element: radicand
sgml('<radicand>', sub{
    push_output('string');
});
sgml('</radicand>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    if ($sqrtdepth > 0){
	$radicand[$sqrtdepth] = $pos;
    }
    else{
	print STDERR
              "ltxgart.pl: ERROR (radicand) sqrtdepth not positive in",
              $pan, "\n";
    };
});

# Element: radx
sgml('<radx>', sub{
    push_output('string');
});
sgml('</radx>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    if ($sqrtdepth > 0){
	$radx[$sqrtdepth] = $pos;
    }
    else{
	print STDERR "ltxgart.pl: ERROR (radx) sqrtdepth not positive in",
              $pan, "\n";
    };
});

# Element: path -- a filesystem pathname
# sgml('<path>', "\\texttt{");
sgml('<path>', "\\url{");
sgml('</path>', "}");

# Element: dummy -- replaceable part of code
sgml('<dummy>', "\\emph{\$\\langle\$");
sgml('</dummy>', "\$\\rangle\$}");

# Element: csss -- LaTeX's \ss (lowercase German ss)
sgml('<csss>', "\\ss{}");
sgml('</csss>', "");

# Element: cslae -- LaTeX's \ae (lower case ae ligature)
sgml('<cslae>', "\\ae{}");
sgml('</cslae>', "");

# Element: csuae -- LaTeX's \AE (upper case ae ligature)
sgml('<csuae>', "\\AE{}");
sgml('</csuae>', "");

# Element: legalnotice
sgml('<legalnotice>',
     "\\begin{center}\\large\\textbf{Permission}\\end{center}\n");
sgml('</legalnotice>', "\n");

# Element: citetitle -- an external title citation
sgml('<citetitle>', "\\emph{");
sgml('</citetitle>', "}");

# Element: boq -- beginning of question mark
sgml('<boq>', ">");
sgml('</boq>', "");

# Element: Sym -- declared math symbol wrapper
sgml('<Sym>', "");
sgml('</Sym>', "");

# Element: mathsym -- markup for declaring math symbol
sgml('<mathsym>', sub{
    push_output('nul');
});
sgml('</mathsym>', sub{
    pop_output;
});

# Element: TableOfContents
sgml('<TableOfContents>', sub{
    my $os = "\\section*{Table of Contents}\n\\begin{Toclist}\n";
    output($os);
    $currtocdepth = 0;
});
sgml('</TableOfContents>', sub{
    my $os = "";
    while($currtocdepth > 1){
	$os = $os . "\\end{toclist}\n";
	$currtocdepth--;
    }
    $os = $os . "\\end{Toclist}\n";
    output($os);
});

# Element: tocitem
sgml('<tocitem>', sub{
    my $elt = $_[0];
    my $depth = $elt->attribute("depth")->value;
    my $diff = $currtocdepth - $depth;
    my $os = "";
    if($depth <= 0){
	print STDERR "ltxgart.pl WARNING: Attribute \"depth\" of\n",
	"  \"tocitem\" is not positive, element seq. $eltser \n";
	return;
    };
    if($depth == $currtocdepth){
	# No change in menu level
	$os = "\n\\item\["; # Close old and open new item in same menu
                   # \n needed in case line above is <nul/>
    }
    elsif($diff < 0){
	# Need to subdivide menu
	if($diff != -1){
	    print STDERR
		"ltxgart.pl WARNING: Cannot descend more than one section",
		"\n level at a time -- elt. ", $_[0]->name, "seq. $eltser \n";
	    return;
	}
	else{     # Begin new menu -- no item to close
	    $currtocdepth++;
	    if($depth == 1){  # first item in ToC,  Toclist already open
		$os = "\n\\item\[";
	    }
	    else{             # use toclist (leaving previous item open)
		$os = "\\begin{toclist}\\normalsize\n\\item\[";
	    };
	};
    }
    else{
	# $diff > 0  -- Need to go back up before opening current item
	while($diff > 0){
	    # Because there's a new item this cannot be the end
	    #    of the level 1 Toclist
	    # Close last item and the toclist
	    $os = $os . "\\end{toclist}\n";
	    $currtocdepth--;
	    $diff--;
	};
	# Open current item
	$os = $os . "\n\\item\[";
    };
    output($os);
    push_output('string');
});
sgml('</tocitem>', sub{
    my $pos = pop_output;
    # Maybe it's better not to use an item label
    my $os = "\]{" . $tocunit . "\\ \\ " . $tocentry . "}\n";
    output($os);
});

# Element: tocunitlength
sgml('<tocunitlength>', sub{
    push_output('string');
});
sgml('</tocunitlength>', sub{
    my $pos = pop_output;
    $tocunitlength = $pos;
});

# Element: tocunit
sgml('<tocunit>', sub{
    push_output('string');
});
sgml('</tocunit>', sub{
    my $pos = pop_output;
    my @tunitarray = split(/\./, $pos);
    my $len = scalar @tunitarray;
    my $tcu = $pos;
    if(($tocunitlength > 0) && ($len > $tocunitlength)){
	while($len > $tocunitlength){
	    shift @tunitarray;
	    $len--;
	};
	$tcu = join(".", @tunitarray);
    };
    $tcu = $tcu . "";
    $tocunit = $tcu;
});

# Element: tocentry
sgml('<tocentry>', sub{
    push_output('string');
});
sgml('</tocentry>', sub{
    $tocentry = pop_output;
});

# Element: tocdepth
sgml('<tocdepth>', sub{
    push_output('string');
});
sgml('</tocdepth>', sub{
    $tocdepth = pop_output;
});

# Element: sprefix
sgml('<sprefix>', sub{
    push_output('string');
});
sgml('</sprefix>', sub{
    $sprefix = pop_output;
});

# Element: sunit
sgml('<sunit>', sub{
    $sunitflag = 1;
    push_output('string');
});
sgml('</sunit>', sub{
    $sunit = pop_output;
});

# Element series
sgml('<series>', sub{
    push_output('string');
});
sgml('</series>', sub{
    my $pos = pop_output;
    my $os = "";
    my $typeatt = $_[0]->attribute("type")->value;
    if(($pos =~ /[1-9][0-9]?/) && ($pos < 30)){
	if($typeatt eq "A"){
	    $os = $Alphabetic[$pos];
	}
	elsif($typeatt eq "a"){
	    $os = $alphabetic[$pos];
	}
	elsif($typeatt eq "I"){
	    $os = $Roman[$pos];
	}
	elsif($typeatt eq "i"){
	    $os = $roman[$pos];
	}
	else{
	    $os = $pos;
	};
    }
    else{
	print STDERR "ltxgart.pl: Cannot perform series conversion on \"",
	$pos, "\"\n";
	$os = $pos;
    };
    output($os);
});

# Element logo
sgml('<logo>', sub{
    push_output('string');
});
sgml('</logo>', sub{
    my $pos = pop_output;
    my $os = "\\" . $pos . "{}";
    output($os);
});

# Element insas
sgml('<insas>', "");
sgml('</insas>', "");

# Element booklist
sgml('<booklist>', "\\begin{citations}");
sgml('</booklist>', "\\end{citations}");

# Element description
sgml('<description>', "\\begin{description}\n");
sgml('</description>', "\\end{description}");

# Element ditem
sgml('<ditem>', "\n\\item");  # \n needed in case line above is <nul/>
sgml('</ditem>', "");

# Element itemlabel
sgml('<itemlabel>', sub{
    push_output('string');
    $termnoteseq = 0;
});
sgml('</itemlabel>', sub{
    my $pos = pop_output;
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $gpan = $par->parent->name;
    my $os = "[{" . $pos . "}]";
    if($gpan eq "booklist"){
	$os = "[{\\textsl{" . $pos . "}}]";
    };
    $jj = 1;
    while($jj <= $termnoteseq){
	$os = $os . $termnote[$jj];
	$jj++;
    };
    if($gpan eq "booklist"){
	$os = $os . "\n\\ ";
    }
    else{
	$os = $os . "\n";
    };
    output($os);
});

# Element itembody
sgml('<itembody>', " ");
sgml('</itembody>', "");

# Element addr
sgml('<addr>', "\\begin{menulist}\n");
sgml('</addr>', "\\end{menulist}");

# Element aln
sgml('<aln>', "\\item\\ ");
sgml('</aln>', "\n");

# Element verblist
sgml('<verblist>', "\\begin{menulist}\n");
sgml('</verblist>', "\\end{menulist}");

# Element nln
sgml('<nln>', "\\item\\texttt{");
sgml('</nln>', "}\n");

# Element: acc0 -- for cloning accent code
sgml('<acc0>', sub{
    push_output('string');
});
sgml('</acc0>', sub{
    my $pos = pop_output;
    my $os = "\\X{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\Y{" . $pos . "}";
    };
    output($os);
});

# Element: dot -- over-dot accent
sgml('<dot>', sub{
    push_output('string');
});
sgml('</dot>', sub{
    my $pos = pop_output;
    my $os = "\\.{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\dot{" . $pos . "}";
    };
    output($os);
});

# Element: ovdot -- over-dot accent
sgml('<ovdot>', sub{
    push_output('string');
});
sgml('</ovdot>', sub{
    my $pos = pop_output;
    my $os = "\\.{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\dot{" . $pos . "}";
    };
    output($os);
});

# Element: undot -- under-dot accent
sgml('<undot>', sub{
    push_output('string');
});
sgml('</undot>', sub{
    my $pos = pop_output;
    my $os = "\\d{" . $pos . "}";
    output($os);
});

# Element: ddot -- double over-dot accent (math only)
sgml('<ddot>', sub{
    push_output('string');
});
sgml('</ddot>', sub{
    my $pos = pop_output;
    my $os = "\\textbf{ddot}(" . $pos . ")";
    if($gmath_on == 1){
	$os = "\\ddot{" . $pos . "}";
    }
    else{
	print STDERR $WhoAmI, ": WARNING -- Found ddot outside of math\n";
    };
    output($os);
});

# Element: breve -- over cup accent (math only)
sgml('<breve>', sub{
    push_output('string');
});
sgml('</breve>', sub{
    my $pos = pop_output;
    my $os = "\\u{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\breve{" . $pos . "}";
    };
    output($os);
});

# Element: ovcup -- over cup accent (math only)
sgml('<ovcup>', sub{
    push_output('string');
});
sgml('</ovcup>', sub{
    my $pos = pop_output;
    my $os = "\\u{" . $pos . "}";
    if($gmath_on == 1){
	$os = "\\breve{" . $pos . "}";
    };
    output($os);
});

# Element: overline -- overline as in LaTeX
sgml('<overline>', sub{
    push_output('string');
});
sgml('</overline>', sub{
    my $pos = pop_output;
    my $os = "\\overline{" . $pos . "}";
    output($os);
});

# Element: underline -- underline as in LaTeX
sgml('<underline>', sub{
    push_output('string');
});
sgml('</underline>', sub{
    my $pos = pop_output;
    my $os = "\\underline{" . $pos . "}";
    output($os);
});

# Element: overbrace -- overbrace as in LaTeX
sgml('<overbrace>', sub{
    push_output('string');
});
sgml('</overbrace>', sub{
    my $pos = pop_output;
    my $os = "\\overbrace{" . $pos . "}";
    output($os);
});

# Element: underbrace -- underbrace as in LaTeX
sgml('<underbrace>', sub{
    push_output('string');
});
sgml('</underbrace>', sub{
    my $pos = pop_output;
    my $os = "\\underbrace{" . $pos . "}";
    output($os);
});

# Element empty
sgml('<empty>', " ");
sgml('</empty>', "");

# Element assertion
sgml('<assertion>', "\\begin{trivlist}\n\\item ");
sgml('</assertion>', "\\end{trivlist}\n");

# Element assthead
sgml('<assthead>', sub{
    push_output('string');
});
sgml('</assthead>', sub{
    my $pos=pop_output;
    my $os;
    if($asstname =~ /^\s*$/){
	$os = "";
    }
    elsif($asstid =~ /^\s*$/){
	$os = "\\textbf{" . $asstname . ".}\\ ";
    }
    else{
	$os = "\\textbf{" . $asstname . "~" . $asstid . ".}\\ ";
    };
    output($os);
});

# Element asstbody
sgml('<asstbody>', sub{
    my $elt = $_[0];
    my $par = $elt->parent;
    my $os = "";
    my $style= "";
    $style = $par->attribute("style")->value;
    if (!($style eq "definition")){
	$os = $os . "\\begin{em}";
    };
    output($os);
});
sgml('</asstbody>', sub{
    my $elt = $_[0];
    my $par = $elt->parent;
    my $os = "";
    my $style= "";
    $style = $par->attribute("style")->value;
    if (!($style eq "definition")){
	$os = $os . "\\end{em}";
    };
    output($os);
});

# Element asstkey
sgml('<asstkey>', sub{
    push_output('string');
});
sgml('</asstkey>', sub{
    $asstkey = pop_output;
});

# Element asstser
sgml('<asstser>', sub{
    push_output('string');
});
sgml('</asstser>', sub{
    $asstser = pop_output;
});

# Element asstname
sgml('<asstname>', sub{
    push_output('string');
});
sgml('</asstname>', sub{
    $asstname = pop_output;
});

# Element asstid
sgml('<asstid>', sub{
    push_output('string');
});
sgml('</asstid>', sub{
    $asstid = pop_output;
});

# Element eqnline -- content of equation after eqnkey, eqnser
sgml('<eqnline>', sub{
    $eqrtag = "";
});
sgml('</eqnline>', sub{
    my $os = "";
    my $nonum = 0;
    my $par = $_[0]->parent;
    if($par->attribute("nonum")->value eq "true"){
	$nonum = 1;
    };
    # This is the better way:
    if(($eqnkey ne "") && ($labelsers{$eqnkey} ne "")){
	if($eqntag ne ""){
	    $os = $os . "\\tag{" . $eqntag . "} ";
	}
	else{
	    $os = $os . "\\tag{" . $labelserseqs{$eqnkey} . "} ";
	};
    }
    # or the old way:
    elsif($eqrtag ne ""){
	$os = $os . "\\tag{" . $eqrtag . "} ";
    }
    elsif(($lastlabelkey ne "") && ($labelsers{$lastlabelkey}) && !($nonum)){
	$os = $os . "\\tag{" . $labelserseqs{$lastlabelkey} . "} ";
    };
    output($os);
});

# Element eqnarray
sgml('<eqnarray>', sub{
    my $os = "";
    $emath_on = 1;
    &on_gmath;
    $eqnkey = "";
    $eqntag = "";
    $eqnamode = 0;
    my $mode = $_[0]->attribute("mode")->value;
    if($mode > 0){$eqnamode = $mode;};
    if(($eqnamode > 1) && ($eqnamode%2 == 0)){
	$os = $os . "\\begin{gather*}";
    }
    else{
	$os = $os . "\\begin{align*}";
    };
    output($os);
});
sgml('</eqnarray>', sub{
    my $os = "";
    if(($eqnamode > 1) && ($eqnamode%2 == 0)){
	$os = $os . "\\end{gather*}";
    }
    else{
	$os = $os . "\\end{align*}";
    };
    $emath_on = 0;
    &off_gmath;
    output($os);
});

# Element eqnkey -- content of equation or of eqnarray
sgml('<eqnkey>', sub{
    push_output('string');
});
sgml('</eqnkey>', sub{
    $eqnkey = pop_output;
});

# Element eqnser -- content of equation or of eqnarray
sgml('<eqnser>', sub{
    push_output('nul');
});
sgml('</eqnser>', sub{
    pop_output;
});

# Element eqnabody -- content of eqnarray after eqnkey, eqnser
sgml('<eqnabody>', sub{
    $eqnarowseq = 0;
    my $os = "";
#   Put this next off to </eqnrow> code in order to pick up an eqrtag
#    if(($eqnamode > 1) && ($eqnamode%2 == 0)){
#	$os = $os . "\\begin{aligned}\n";
#	output($os);
#    };
});
sgml('</eqnabody>', sub{
    if(($eqnamode > 1) && ($eqnamode%2 == 0)){
	output("\\end{aligned}");
    };
});

# Element eqnrow -- content of eqnabody
sgml('<eqnrow>', sub{
    $eqrkey = "";
    $eqnarowseq++;
    $eqrtag = "";
    my $os = "";
    if($eqnarowseq > 1){
	$os = $os . "\\\\ {}";
    };
    output($os);
    push_output('string');
});
sgml('</eqnrow>', sub{
    my $pos = pop_output;
    my $os = "";
    my $tag = 0;
    if(($eqnarowseq == 1) && ($eqnamode > 1) && ($eqnamode%2 == 0)){
	if($eqnkey ne ""){
	    $tag = $labelserseqs{$eqnkey};
	    if(!($tag > 0)){
		print STDERR "ltxgart.pl WARNING: No series value for\n",
		"   eqnarray key ", $eqnkey, " eqseq=",
		$_[0]->parent->attribute("eqseq")->value, "\n";
	    };
	}
	else{
	    print STDERR "ltxgart.pl WARNING: No key for eqnarray\n",
	    "   with mode ", $eqnamode, " eqseq=",
	    $_[0]->parent->attribute("eqseq")->value, "\n";
	};
	if($eqntag ne ""){
	    $tag = $eqntag;
	}
	elsif($eqrtag ne ""){
	    $tag = $eqrtag;
	};
	$os = $os . "\\tag{" . $tag . "} ";
	$os = $os . "\\begin{aligned}\n";
    }
    elsif($eqrkey ne ""){
	if($eqrtag ne ""){
	    $os = $os . "\\tag{" . $eqrtag . "}\\label{" . $eqrkey . "} ";
	}
	else{
	    $tag = $labelserseqs{$eqrkey};
	    if($tag > 0){
		$os = $os . "\\tag{" . $tag . "}\\label{" . $eqrkey . "} ";
	    };
	};
    }
    else{
	if($eqrtag ne ""){
	    $os = $os . "\\tag{" . $eqrtag . "}";
	};
    };
    $os = $os . $pos;
    output($os);
});

# Element eqnleft -- content of eqnrow
sgml('<eqnleft>', "");
sgml('</eqnleft>', "");

# Element eqncenter -- content of eqnrow
sgml('<eqncenter>', sub{
    push_output('string');
});
sgml('</eqncenter>', sub{
    my $pos = pop_output;
    my $os = " & ";
    if($pos =~ /^\s*$/){
	$os = $os . $defaultemptyeqncenter;
    }
    else{
	$os = $os . $pos;
    };
    output($os);
});

# Element eqnright -- content of eqnrow
sgml('<eqnright>', "");
sgml('</eqnright>', "");

# Element mathbb
sgml('<mathbb>', "\\mathbb{");
sgml('</mathbb>', "}");

# Element mathcal
sgml('<mathcal>', "\\mathcal{");
sgml('</mathcal>', "}");

# Element mathfrak
sgml('<mathfrak>', "\\mathfrak{");
sgml('</mathfrak>', "}");

# Element mathbf
sgml('<mathbf>', "\\bm{");
sgml('</mathbf>', "}");

# Element apos
sgml('<apos>', "'");
sgml('</apos>', "");

# Element array
sgml('<array>', sub{
    $tabdepth++;
    output("\\begin{array}");
});
sgml('</array>', sub{
    output("\\end{array}");
    $tabdepth--;
});

# Element arrhead
sgml('<arrhead>', sub{
    $tabopt[$tabdepth] = "";
    $tabarg[$tabdepth] = "";
    push_output('string');
});
sgml('</arrhead>', sub{
    pop_output;
    my $os = "";
    if($tabopt[$tabdepth] ne ""){
	$os = $os . "[" . $tabopt[$tabdepth] . "]";
    };
    $os = $os . "{" . $tabarg[$tabdepth] . "}";
    $os = $os . "\n";
    output($os);
});

# Element arrpos
sgml('<arrpos>', sub{
    push_output('string');
});
sgml('</arrpos>', sub{
    $tabopt[$tabdepth] = pop_output;
});

# Element arrcols
sgml('<arrcols>', sub{
    push_output('string');
});
sgml('</arrcols>', sub{
    $tabarg[$tabdepth] = pop_output;
});

# Element arrbody
sgml('<arrbody>', sub{
    $trcount[$tabdepth] = 0;
});
sgml('</arrbody>', "");

# Element arrayrow
sgml('<arrayrow>', sub{
    $trcount[$tabdepth]++;
    if($trcount[$tabdepth] > 1){
	output("\\\\{}\n");
    };
});
sgml('</arrayrow>', "");

# Element firstacell
sgml('<firstacell>', "");
sgml('</firstacell>', "");

# Element arraycell
sgml('<arraycell>', sub{
    output("& ");
});
sgml('</arraycell>', "");

# Element overset -- as in amsmath
sgml('<overset>', "\\overset");
sgml('</overset>', "");

# Element underset -- as in amsmath
sgml('<underset>', "\\underset");
sgml('</underset>', "");

# Element deco -- first arg in overset or underset
sgml('<deco>', "{");
sgml('</deco>', "}");

# Element expr -- second arg i overset or underset
sgml('<expr>', "{");
sgml('</expr>', "}");

# Element includegraphics
sgml('<includegraphics>', sub{
    push_output('string');
});
sgml('</includegraphics>', sub{
    my $stem = pop_output;
    my $scale = $_[0]->attribute("scale")->value;
    my $os = "\\includegraphics";
    if($scale ne ""){
	$os = $os . "[width=" . $scale . "\\textwidth]";
    };
    $os = $os . "{" . $stem . "}";
    output($os);
});

# Element lgcdata
sgml('<lgcdata>', "");
sgml('</lgcdata>', "");

# Element vect -- vector with coord args (<coord>) and
#                 separator string (<csep>)
#    separator string is space-delimited
#    fields: open, close, between [...]
#    default: open="(", close=")", between=","
#    empty csep means open, close, between are all ""
# Begin rendering with csep
sgml('<vect>', sub{
    $vectdepth++;
    $coordseq[$vectdepth] = 0;
    $csep[$vectdepth][0] = "";
    $csepn[$vectdepth] = -1;   # means no <csep> found
    push_output('string');
});
sgml('</vect>', sub{
    my $os = "";
    my $pos = pop_output;
    if($csepn[$vectdepth] == -1){
	$os = $os . "(" . $pos . ")";
    }
    elsif($csepn[$vectdepth] == 0){
	$os = $pos;
    }
    elsif($csepn[$vectdepth] > 0){
	$os = $csep[$vectdepth][1] . $pos . $csep[$vectdepth][2];
    }
    else{
	print STDERR $WhoAmI, ": WARNING: cannot format <vect>\n";
    };
    output($os);
    $vectdepth--;
});

# Element csep -- coordinate separation string for <vect>
sgml('<csep>', sub{
    $csepq++;
    push_output('string');
});
sgml('</csep>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    # print STDERR "<csep> no. ", $csepq, " found ", $pos, "\n";
    my $os = "";
    my @seps = split('', $pos);
    my $sepn = scalar(@seps);
    $csepn[$vectdepth] = 0;
    if($sepn > 0){
	my $jj = 0;
	my $kk = 0;
	my $glean = "";
	my @tout = ();
	my $tc = "";
	while($jj < $sepn){
	    $glean = "";
	    $kk++;
	    $tc = $seps[$jj];
	    $jj++;
	    $glean = $glean . $tc;
		# expect one of ( ) [ ] / | < > @ ; : , . or
                #        else preset LaTeX:  \{ or \}
	    if($tc eq "\\"){
		if($jj >= $sepn){
		    print STDERR "*** Error: Illegal \\ in vect spec at line "
			. $ev->line . "\n";
		    print STDERR "    Could be an error in ", $WhoAmI,
		    " or in source markup\n";
		    print STDERR "    Character \\ discarded\n\n";
		    $glean="";
		    last;
		};
		$tc = $seps[$jj];
		$jj++;
		if(($tc eq "{") || ($tc eq "}")){
		    ; # Character OK
		    $glean = $glean . $tc;
		}
		else{
		    print STDERR "*** Error: illegal character following "
			. "\\" . " in vect spec at line " . $ev->line . "\n";
		    print STDERR "    Character " . $tc . " discarded\n\n";
		    $glean = "";
		    last;
		};
	    }
	    elsif($tc =~ /^(\(|\)|\[|\]|\||\/|[ <>@;:,.])$/){
		;  # Character OK in csep
	    }
	    else{
		print STDERR "*** Error: Illegal character in vect spec"
		    . " at line " . $ev->line . "\n";
		print STDERR "    character " . $tc . " discarded\n\n";
		last;
	    };
	    $csep[$vectdepth][$kk] = $glean;
	    $tout[$kk] = $glean;
	};
	# $csep[$vectdepth][$kk] begins with $kk = 1
	$csepn[$vectdepth] = $kk;
	# print STDERR "<csep> no. ",$csepq," writing ",join("+", @tout),"\n";
    };
});

# Element coord -- coordinate argument in <vect>
sgml('<coord>', sub{
    $coordseq[$vectdepth]++;
    push_output('string');
});
sgml('</coord>', sub{
    my $pos = pop_output;
    my $os = "";
    my $ns = $csepn[$vectdepth];
    my $k = $coordseq[$vectdepth];
    if(($k > 1) && ($ns > 2)){
	if($k + 1 < $ns){
	    $os = $os . $csep[$vectdepth][$k + 1];
	}
	else{
	    $os = $os . $csep[$vectdepth][$ns];
	};
    }
    elsif(($k > 1) && ($ns == -1)){
	$os = $os . ', ';
    };
    $os = $os . $pos;
    output($os);
});

# Element quad -- same as LaTeX's quad
sgml('<quad>', "\\quad{}");
sgml('</quad>', "");

# Element: aF -- "applyFunction" (for weak semantics)
#   I do not use this in source except when it's not obvious in context
#   from explicit or implicit expression types.  It's inconsequential for
#   LaTeX output.
sgml('<aF>', "");
sgml('</aF>', "");

# Element: icomma -- invisible comma (for weak semantics)
#   I generally avoid this using \vect[]{}{}{}...
sgml('<icomma>', "");
sgml('</icomma>', "");

# Element: itimes -- invisible times (for weak semantics)
sgml('<itimes>', "");
sgml('</itimes>', "");

# Element mscript -- 4 corner super- and subscripts
sgml('<mscript>', sub{
    $ousetdepth++;
    my $d = $ousetdepth;
    $uleft[$d] = "";
    $lleft[$d] = "";
    $lright[$d] = "";
    $uright[$d] = "";
    push_output('string');
});
sgml('</mscript>', sub{
    my $pos = pop_output;  # braced <expr>, which is not push/popped
    my ($elt, $ev) = @_;
    my $os = "";
    my $d = $ousetdepth;
    if(($lleft[$d] ne "") || ($uleft[$d] ne "")){
	$os = $os ."\\prescript{". $uleft[$d] ."}{". $lleft[$d] ."}". $pos;
    }
    else{
	$os = $os . $pos;
    };
    if($lright[$d] ne ""){
	$os = $os . "_{" . $lright[$d] . "}";
    };
    if($uright[$d] ne ""){
	$os = $os . "^{" . $uright[$d] . "}";
    };
    output($os);
    $ousetdepth--;
});

# Element uleft
sgml('<uleft>', sub{
    push_output('string');
});
sgml('</uleft>', sub{
    $uleft[$ousetdepth] = pop_output;
});

# Element lleft
sgml('<lleft>', sub{
    push_output('string');
});
sgml('</lleft>', sub{
    $lleft[$ousetdepth] = pop_output;
});

# Element lright
sgml('<lright>', sub{
    push_output('string');
});
sgml('</lright>', sub{
    $lright[$ousetdepth] = pop_output;
});

# Element uright
sgml('<uright>', sub{
    push_output('string');
});
sgml('</uright>', sub{
    $uright[$ousetdepth] = pop_output;
});

# Element aTs -- LaTeX's "\@"
sgml('<aTs>', "\\@");
sgml('</aTs>', "");

# Element iTc -- LaTeX's "\/"
sgml('<iTc>', "\\/");
sgml('</iTc>', "");

# Element setOf -- setbuilder notation
sgml('<setOf>', sub{
    $ousetdepth++;
    $parm[$ousetdepth] = "";
    $cond[$ousetdepth] = "";
    push_output('string');
});
sgml('</setOf>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    my $cnd = $cond[$ousetdepth];
    $os = $os . "\\left\\{";
    if($cnd ne ""){
	$os = $os . "\\left.";
    };
    $os = $os . $parm[$ousetdepth];
    if($cnd ne ""){
	$os = $os . "\\,\\right|\\," . $cnd ;
    };
    $os = $os . "\\right\\}";
    output($os);
    $ousetdepth--;
});

# Element parm -- setbuilder notation: parameter expression
sgml('<parm>', sub{
    push_output('string');
});
sgml('</parm>', sub{
    my $pos = pop_output;
    $parm[$ousetdepth] = $pos;
});

# Element cond -- setbuilder notation: condition expression
sgml('<cond>', sub{
    push_output('string');
});
sgml('</cond>', sub{
    my $pos = pop_output;
    $cond[$ousetdepth] = $pos;
});

# Element: vee --
sgml('<vee>', "\\vee{}");
sgml('</vee>', "");

# Element: setminus --
sgml('<setminus>', "\\setminus{}");
sgml('</setminus>', "");

# Element: triangle --
sgml('<triangle>', "\\triangle{}");
sgml('</triangle>', "");

# Element: ll --
sgml('<ll>', "\\ll{}");
sgml('</ll>', "");

# Element: gg --
sgml('<gg>', "\\gg{}");
sgml('</gg>', "");

# Element: asymp --
sgml('<asymp>', "\\asymp{}");
sgml('</asymp>', "");

# Element: approx --
sgml('<approx>', "\\approx{}");
sgml('</approx>', "");

# Element: implies --
sgml('<implies>', "\\Rightarrow{}");
sgml('</implies>', "");

# Element: revimplies --
sgml('<revimplies>', "\\Leftarrow{}");
sgml('</revimplies>', "");

# Element: iff --
sgml('<iff>', "\\Leftrightarrow{}");
sgml('</iff>', "");

# Element: uparrow --
sgml('<uparrow>', "\\uparrow{}");
sgml('</uparrow>', "");

# Element: downarrow --
sgml('<downarrow>', "\\downarrow{}");
sgml('</downarrow>', "");

# Element: abuts --
sgml('<abuts>', "\\Rightarrow{}");
sgml('</abuts>', "");

# Element: ltimes --
sgml('<ltimes>', "\\ltimes{}");
sgml('</ltimes>', "");

# Element: rtimes --
sgml('<rtimes>', "\\rtimes{}");
sgml('</rtimes>', "");

# Element: mp -- "either-minus-or-plus" binary operator (not associative)
sgml('<mp>', "\\mp{}");
sgml('</mp>', "");

# Element: tag
sgml('<tag>', sub{
    push_output('string');
});
sgml('</tag>', sub{
    $eqrtag = pop_output;
});

# Element: eqntag
sgml('<eqntag>', sub{
    push_output('string');
});
sgml('</eqntag>', sub{
    $eqntag = pop_output;
});

# Element: prime -- emulates \prime in LaTeX; usually use in a script
sgml('<prime>', "{\\prime}");
sgml('</prime>', "");

# Element: backprime -- emulates \backprime in LaTeX; usually use in a script
sgml('<backprime>', "{\\backprime}");
sgml('</backprime>', "");

# Element: sprime -- should flow to normal single prime accent: U-2032
sgml('<sprime>', "\\prime{}");
sgml('</sprime>', "");

# Element: dprime -- should flow to normal double prime accent: U-2033
sgml('<dprime>', "\\prime\\prime{}");
sgml('</dprime>', "");

# Element: tprime -- should flow to normal triple prime accent: U-2034
sgml('<tprime>', "\\prime\\prime\\prime{}");
sgml('</tprime>', "");

# Element: qprime -- should flow to normal quadruple prime accent: U-2057
sgml('<qprime>', "\\prime\\prime\\prime\\prime{}");
sgml('</qprime>', "");

# Element: bprime -- should flow to normal reversed prime accent: U-2035
sgml('<bprime>', "^{\\backprime}");
sgml('</bprime>', "");

# Element: rtq --
sgml('<rtq>', "'''");
sgml('</rtq>', "");

# Element: rqq --
sgml('<rqq>', "''''");
sgml('</rqq>', "");

# Element: dag
sgml('<dag>', "\\dag{}");
sgml('</dag>', "");

# Element: ddag
sgml('<ddag>', "\\ddag{}");
sgml('</ddag>', "");

# Element: reg
sgml('<reg>', "\\textregistered{}");
sgml('</reg>', "");

# Element: trade
sgml('<trade>', "\\texttrademark{}");
sgml('</trade>', "");

# Element: nobr
sgml('<nobr>', sub{
    push_output('string');
});
sgml('</nobr>', sub{
    my $pos = pop_output;
    my $os = "\\mbox{" . $pos . "}";
    output($os);
});

# Element sipbody -- body of sum, int, or prod
sgml('<sipbody>', " {");
sgml('</sipbody>', "}");

# General table processing routines -- under construction
sub on_table{
    $tabser++;
    $tabdepth++;
    $trcount[$tabdepth] = 0;
    $trulecount[$tabdepth] = 0;
    $tabid[$tabdepth] = $tabser;
    $tabhlen[$tabdepth] = 0;
    $tabvlen[$tabdepth] = 0;
    $tabarg[$tabdepth] = "";
    push_output('string');
};

sub off_table{
    my ($elt, $evt) = @_;
    my $name = $elt->name;
    my $pos = pop_output;
    my $es = "";
    my $rs = "";
    if($tabhlen[$tabdepth] == 0){
	$es = $es . "Error: cannot find table argument for element \"";
	$es = $es . $name . "\"\n with (general) table serial number ";
	$es = $es . $tabid[$tabdepth] . " at table depth " . $tabdepth;
	die $es;
    };
    $arg = $tabarg[$tabdepth];
    $rs = $rs . $pos;
    $tabdepth--;
    return ($arg, $rs);
};

sub diag_table{
    my ($pos, $elt, $evt) = @_;
    my $name = $elt->name;
    my $fn = $evt->file;
    my $es = "";
    my $rs = "";
    $rs = $rs . "REPORT on " . $name . " in file " . $name . "\n\n";
    $rs = $rs . "\\begin{" . $name . "}" . $tabarg[$tabdepth] . "\n";
    $rs = $rs . $pos;
    $rs = $rs. "\\end{" . $name . "}\n\n";
    return $rs;
};
1;
