/*
 * SlideOrderCache.java
 *
 */


/**
 *
 * The SlideOrderCache uses elements of SlideOrderRecord.
 * To avoid repeatedly calling the data base engine the slideorder is cached.
 * While only read-operations to the slideordertable are performed redundant
 * calls are avoided.
 *
 * @author  Olle Nebendahl
 */

class SlideOrderCache
{
    static java.util.TreeMap cache=new java.util.TreeMap();
    
    static synchronized SlideOrderRecord getSlideOrder(int slideId) //  replaces getCachedSlide
    {
        SlideOrderRecord result = (SlideOrderRecord)cache.get(new Integer(slideId));
        if(null==result)
        {
            result=new SlideOrderRecord(SlideConnection.getPredSlides(slideId),SlideConnection.getSuccSlides(slideId));
            cache.put(new Integer(slideId),result);
        }
        return result;
    }
    
    static synchronized void empty()
    {
        cache = new java.util.TreeMap();
    }
   
    static synchronized void cacheSlide(SlideOrderRecord sor,int slideId)
    {
        cache.put(new Integer(slideId),sor);
    }
   
    public static void main(String[] a)
    {
        System.out.println(getSlideOrder(Integer.decode(a[0]).intValue()));
    }
   
}
