unit ch_chess;

interface

const
  max_moves = 400;

type
  squaretype = record
                color : char;
                rank : char;
              end;

  piecearraytype  = array[0..31] of string[3];

  squarearraytype = array[0..10,0..10] of squaretype;

  movetype = string[10];

  move_histtype = array[0..max_moves] of movetype;

  boardtype = record
                square : squarearraytype;
                w_cast_short : boolean;
                w_cast_long : boolean;
                b_cast_short : boolean;
                b_cast_long : boolean;
                ep_file : byte;
                white_to_move : boolean;
                move_hist : move_histtype;
                move_numb : word;
                piece : piecearraytype;
                illegal_move : boolean;
              end;

procedure init_board(VAR board : boardtype);

function legal_move(VAR board: boardtype; x1, y1, x2, y2 : integer) : boolean;

function cb_gen_moves(VAR board:boardtype; square : string): string;

function nic_gen_moves(VAR board:boardtype; square : string): string;

procedure print_board(VAR board : boardtype);

procedure cb_print_legal_moves(VAR board : boardtype);

procedure nic_print_legal_moves(VAR board : boardtype);

procedure parse_move_string(VAR board: boardtype; VAR move:movetype);

procedure do_move(VAR board:boardtype; move:movetype);

procedure do_move_string(VAR board : boardtype; move: movetype);

function in_check_after(board : boardtype; move: movetype): boolean;

function giving_check_after(board : boardtype; move: movetype): boolean;

implementation


procedure init_board(VAR board : boardtype);
const
  init_board_piece : piecearraytype =
  ('Qd1','Nb1','Ng1','Ra1','Rh1','Bc1','Bf1','Ke1',
   'Pa2','Pb2','Pc2','Pd2','Pe2','Pf2','Pg2','Ph2',
   'Qd8','Nb8','Ng8','Ra8','Rh8','Bc8','Bf8','Ke8',
   'Pa7','Pb7','Pc7','Pd7','Pe7','Pf7','Pg7','Ph7');

var
  i,j: integer;

begin
  board.w_cast_short:=true;
  board.w_cast_long:=true;
  board.b_cast_short:=true;
  board.b_cast_long:=true;
  board.white_to_move:=true;
  board.ep_file:=0;
  board.illegal_move:=false;
  for i:=1 to max_moves do
    board.move_hist[i]:='';
  board.move_numb:=0;
  board.move_hist[0]:='';
  board.piece:=init_board_piece;
  board.square[1,1].color:='W';
  board.square[1,1].rank:='R';
  board.square[2,1].color:='W';
  board.square[2,1].rank:='N';
  board.square[3,1].color:='W';
  board.square[3,1].rank:='B';
  board.square[4,1].color:='W';
  board.square[4,1].rank:='Q';
  board.square[5,1].color:='W';
  board.square[5,1].rank:='K';
  board.square[6,1].color:='W';
  board.square[6,1].rank:='B';
  board.square[7,1].color:='W';
  board.square[7,1].rank:='N';
  board.square[8,1].color:='W';
  board.square[8,1].rank:='R';
  for i:=1 to 8 do
  begin
    board.square[i,2].color:='W';
    board.square[i,2].rank:='P';
  end;

  board.square[1,8].color:='B';
  board.square[1,8].rank:='R';
  board.square[2,8].color:='B';
  board.square[2,8].rank:='N';
  board.square[3,8].color:='B';
  board.square[3,8].rank:='B';
  board.square[4,8].color:='B';
  board.square[4,8].rank:='Q';
  board.square[5,8].color:='B';
  board.square[5,8].rank:='K';
  board.square[6,8].color:='B';
  board.square[6,8].rank:='B';
  board.square[7,8].color:='B';
  board.square[7,8].rank:='N';
  board.square[8,8].color:='B';
  board.square[8,8].rank:='R';
  for i:=1 to 8 do
  begin
    board.square[i,7].color:='B';
    board.square[i,7].rank:='P';
  end;
  for j:=3 to 6 do
  begin
    for i:=1 to 8 do
    begin
      board.square[i,j].color:='.';
      board.square[i,j].rank:='.';
    end;
  end;
end;

function legal_move(VAR board: boardtype;
                        x1, y1, x2, y2 : integer) : boolean;
var
  bool : boolean;

begin
  bool:=not board.illegal_move;
  bool:=bool and (not ((x1<1) or (x1>8)));
  bool:=bool and (not ((y1<1) or (y1>8)));
  bool:=bool and (not ((x2<1) or (x2>8)));
  bool:=bool and (not ((y2<1) or (y2>8)));
  if bool then
  begin
    if (board.square[x2,y2].color=board.square[x1,y1].color) then
      bool:=false;
    if (board.square[x1,y1].color='.') or
       (board.square[x1,y1].rank='.') then
      bool:=false;
  end;
  legal_move:=bool;
end;

function nic_gen_moves(VAR board:boardtype; square : string): string;
var
  x1, y1 : integer;

  function add_move(x, y: integer): string;
  var
    move: string;
  begin
    if legal_move(board,x1,y1,x,y) then
    begin
      move:=chr(96+x)+chr(48+y)+' ';
    end
    else
      move:='';
    add_move:=move;
  end;

  function add_promotion(x,y:integer): string;
  var
    move1: string;
    move2: string;
  begin
    if legal_move(board,x1,y1,x,y) then
    begin
      move1:=chr(96+x)+chr(48+y);
      move2:=move1+'Q'+' '+
             move1+'R'+' '+
             move1+'B'+' '+
             move1+'N'+' ';
    end
    else
      move2:='';
    add_promotion:=move2;
  end;

  function long_moves(dx,dy : integer) : string;
  var
    moves : string;
    stop : boolean;
    i, x2, y2 : integer;
  begin
    moves:='';
    stop:=false;
    i:=1;
    x2:=x1+i*dx; y2:=y1+i*dy;
    while not stop and legal_move(board,x1,y1,x2,y2) do
    begin
      moves:=moves+add_move(x2,y2);
      stop:=((board.square[x1,y1].color='W') and
            (board.square[x2,y2].color='B')) OR
            ((board.square[x1,y1].color='B') and
            (board.square[x2,y2].color='W'));
      inc(i);
      x2:=x1+i*dx; y2:=y1+i*dy;
    end;
    long_moves:=moves;
  end;

var
  x2, y2 : integer;
  moves : string;

begin
  x1:=ord(upcase(square[1]))-64;
  y1:=ord(upcase(square[2]))-48;
  moves:='';
  if not ((x1<0) or (x1>8) or (y1<0) or (y1>8) or board.illegal_move) then
  begin
    if ((board.square[x1,y1].color<>'.') and
       (board.square[x1,y1].rank<>'.')) and
       ((board.white_to_move and (board.square[x1,y1].color='W')) OR
        (not board.white_to_move and (board.square[x1,y1].color='B')))
        then
    begin
      moves:=board.square[x1,y1].rank+chr(x1+96)+chr(48+y1)+'-';
      if board.square[x1,y1].rank='N' then
      begin
        moves:=moves+add_move(x1-1,y1-2);
        moves:=moves+add_move(x1-2,y1-1);
        moves:=moves+add_move(x1-2,y1+1);
        moves:=moves+add_move(x1-1,y1+2);
        moves:=moves+add_move(x1+1,y1+2);
        moves:=moves+add_move(x1+2,y1+1);
        moves:=moves+add_move(x1+2,y1-1);
        moves:=moves+add_move(x1+1,y1-2);
      end;

      if board.square[x1,y1].rank='K' then
      begin
        moves:=moves+add_move(x1-1,y1+1);
        moves:=moves+add_move(x1  ,y1+1);
        moves:=moves+add_move(x1+1,y1+1);
        moves:=moves+add_move(x1+1,y1  );
        moves:=moves+add_move(x1+1,y1-1);
        moves:=moves+add_move(x1  ,y1-1);
        moves:=moves+add_move(x1-1,y1-1);
        moves:=moves+add_move(x1-1,y1  );

        if board.white_to_move (*and board.w_cast_short*)
        and (y1=1) and (x1=5) and
           (board.square[6,y1].color='.') and
           (board.square[7,y1].color='.') and
           (board.square[8,y1].color='W') and
           (board.square[8,y1].rank='R') then
        begin
          moves:=moves+add_move(7,y1);
        end;

        if board.white_to_move (*and board.w_cast_long*)
        and (y1=1) and (x1=5) and
           (board.square[2,y1].color='.') and
           (board.square[4,y1].color='.') and
           (board.square[3,y1].color='.') and
           (board.square[1,y1].color='W') and
           (board.square[1,y1].rank='R') then
        begin
          moves:=moves+add_move(3,y1);
        end;


        if (not board.white_to_move) (*and board.b_cast_short*)
        and (y1=8) and (x1=5) and
           (board.square[6,y1].color='.') and
           (board.square[7,y1].color='.') and
           (board.square[8,y1].color='B') and
           (board.square[8,y1].rank='R') then
        begin
          moves:=moves+add_move(7,y1);
        end;

        if (not board.white_to_move) (*and board.b_cast_long*)
        and (y1=8) and (x1=5) and
           (board.square[2,y1].color='.') and
           (board.square[4,y1].color='.') and
           (board.square[3,y1].color='.') and
           (board.square[1,y1].color='B') and
           (board.square[1,y1].rank='R') then
        begin
          moves:=moves+add_move(3,y1);
        end;

      end;

      if board.square[x1,y1].rank='B' then
      begin
        moves:=moves+long_moves(-1,1);
        moves:=moves+long_moves(1,1);
        moves:=moves+long_moves(1,-1);
        moves:=moves+long_moves(-1,-1);
      end;

      if board.square[x1,y1].rank='R' then
      begin
        moves:=moves+long_moves(0,1);
        moves:=moves+long_moves(1,0);
        moves:=moves+long_moves(0,-1);
        moves:=moves+long_moves(-1,0);
      end;

      if board.square[x1,y1].rank='Q' then
      begin
        moves:=moves+long_moves(-1,1);
        moves:=moves+long_moves(0,1);
        moves:=moves+long_moves(1,1);
        moves:=moves+long_moves(1,0);
        moves:=moves+long_moves(1,-1);
        moves:=moves+long_moves(0,-1);
        moves:=moves+long_moves(-1,-1);
        moves:=moves+long_moves(-1,0);
      end;

      if board.square[x1,y1].rank='P' then
      begin
        if board.square[x1,y1].color='W' then
        begin
          x2:=x1; y2:=y1+1;
          if (board.square[x2,y2].color='.') then
            if y2<8 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;

          x2:=x1-1;y2:=y1+1;
          if (board.square[x2,y2].color='B') then
            if y2<8 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;

          x2:=x1+1;y2:=y1+1;
          if (board.square[x2,y2].color='B') then
            if y2<8 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;


          x2:=x1-1;y2:=y1+1;
          if  (board.move_hist[board.move_numb]=
              'P'+chr(x2+96)+chr(y2+48+1)+chr(x2+96)+chr(y2+48-1)) then
          begin
            moves:=moves+add_move(x2,y2);
          end;

          x2:=x1+1;y2:=y1+1;
          if  (board.move_hist[board.move_numb]=
              'P'+chr(x2+96)+chr(y2+48+1)+chr(x2+96)+chr(y2+48-1)) then
          begin
            moves:=moves+add_move(x2,y2);
          end;

          x2:=x1; y2:=y1+2;
          if (y1=2) and (board.square[x2,y1+1].color='.') and
             (board.square[x2,y2].color='.') then
            moves:=moves+add_move(x1,y1+2);
        end
        else
        if board.square[x1,y1].color='B' then
        begin
          x2:=x1; y2:=y1-1;
          if (board.square[x2,y2].color='.') then
            if y2>1 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;

          x2:=x1-1;y2:=y1-1;
          if (board.square[x2,y2].color='W') then
            if y2>1 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;

          x2:=x1+1;y2:=y1-1;
          if (board.square[x2,y2].color='W') then
            if y2>1 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;

          x2:=x1-1;y2:=y1-1;
          if  (board.move_hist[board.move_numb]=
              'P'+chr(x2+96)+chr(y2+48-1)+chr(x2+96)+chr(y2+48+1)) then
          begin
            moves:=moves+add_move(x2,y2);
          end;

          x2:=x1+1;y2:=y1-1;
          if  (board.move_hist[board.move_numb]=
              'P'+chr(x2+96)+chr(y2+48-1)+chr(x2+96)+chr(y2+48+1)) then
          begin
            moves:=moves+add_move(x2,y2);
          end;


          x2:=x1; y2:=y1-2;
          if (y1=7) and (board.square[x2,y1-1].color='.') and
             (board.square[x2,y2].color='.') then
            moves:=moves+add_move(x1,y1-2);
        end;
      end;
    end
    else
      moves:='';
  end;
  if length(moves)<=4 then
  begin
    moves:='';
  end;
  nic_gen_moves:=moves;
end;

function cb_gen_moves(VAR board:boardtype; square : string): string;
var
  x1, y1 : integer;

  function add_move(x, y: integer): string;
  var
    move: string;
  begin
    if legal_move(board,x1,y1,x,y) then
    begin
      move:=chr(96+x)+chr(48+y)+' ';
    end
    else
      move:='';
    add_move:=move;
  end;

  function add_promotion(x,y:integer): string;
  var
    move1: string;
    move2: string;
  begin
    if legal_move(board,x1,y1,x,y) then
    begin
      move1:=chr(96+x)+chr(48+y);
      move2:=move1+'Q'+' '+
             move1+'R'+' '+
             move1+'B'+' '+
             move1+'N'+' ';
    end
    else
      move2:='';
    add_promotion:=move2;
  end;

  function long_moves(dx,dy : integer) : string;
  var
    moves : string;
    stop : boolean;
    i, x2, y2 : integer;
  begin
    moves:='';
    stop:=false;
    i:=1;
    x2:=x1+i*dx; y2:=y1+i*dy;
    while not stop and legal_move(board,x1,y1,x2,y2) do
    begin
      moves:=moves+add_move(x2,y2);
      stop:=((board.square[x1,y1].color='W') and
            (board.square[x2,y2].color='B')) OR
            ((board.square[x1,y1].color='B') and
            (board.square[x2,y2].color='W'));
      inc(i);
      x2:=x1+i*dx; y2:=y1+i*dy;
    end;
    long_moves:=moves;
  end;

var
  x2, y2: integer;
  moves : string;
  old_move, old_move2: string;

begin
  old_move:=board.move_hist[board.move_numb];
  if board.move_numb>0 then
    old_move2:=board.move_hist[board.move_numb-1]
  else
    old_move2:='';
  x1:=ord(upcase(square[1]))-64;
  y1:=ord(upcase(square[2]))-48;
  moves:='';
  if not ((x1<0) or (x1>8) or (y1<0) or (y1>8) or board.illegal_move) then
  begin
    if ((board.square[x1,y1].color<>'.') and
       (board.square[x1,y1].rank<>'.')) and
       ((board.white_to_move and (board.square[x1,y1].color='W')) OR
        (not board.white_to_move and (board.square[x1,y1].color='B')))
        then
    begin
      moves:=board.square[x1,y1].rank+chr(x1+96)+chr(48+y1)+'-';

      if board.square[x1,y1].rank='N' then
      begin
        moves:=moves+add_move(x1-2,y1-1);
        moves:=moves+add_move(x1-2,y1+1);
        moves:=moves+add_move(x1+2,y1-1);
        moves:=moves+add_move(x1+2,y1+1);
        moves:=moves+add_move(x1-1,y1-2);
        moves:=moves+add_move(x1-1,y1+2);
        moves:=moves+add_move(x1+1,y1-2);
        moves:=moves+add_move(x1+1,y1+2);
      end;

      if board.square[x1,y1].rank='K' then
      begin
        moves:=moves+add_move(x1-1,y1-1);
        moves:=moves+add_move(x1-1,y1  );
        moves:=moves+add_move(x1-1,y1+1);
        moves:=moves+add_move(x1  ,y1-1);
        moves:=moves+add_move(x1  ,y1+1);
        moves:=moves+add_move(x1+1,y1-1);
        moves:=moves+add_move(x1+1,y1  );
        moves:=moves+add_move(x1+1,y1+1);

        if board.white_to_move and (y1=1) and (x1=5) and
           (board.square[8,1].color='W') and (board.square[8,1].rank='R') and
           (board.square[6,y1].color='.') and
           (board.square[7,y1].color='.') then
        begin
          moves:=moves+add_move(7,y1);
        end;

        if board.white_to_move and (y1=1) and (x1=5) and
           (board.square[1,1].color='W') and (board.square[1,1].rank='R') and
           (board.square[2,y1].color='.') and
           (board.square[4,y1].color='.') and
           (board.square[3,y1].color='.') then
        begin
          moves:=moves+add_move(3,y1);
        end;


        if (not board.white_to_move) and (y1=8) and (x1=5) and
           (board.square[8,8].color='B') and (board.square[8,8].rank='R') and
           (board.square[6,y1].color='.') and
           (board.square[7,y1].color='.') then
        begin
          moves:=moves+add_move(7,y1);
        end;

        if (not board.white_to_move) and (y1=8) and (x1=5) and
           (board.square[1,8].color='B') and (board.square[1,8].rank='R') and
           (board.square[2,y1].color='.') and
           (board.square[4,y1].color='.') and
           (board.square[3,y1].color='.') then
        begin
          moves:=moves+add_move(3,y1);
        end;

      end;

      if board.square[x1,y1].rank='B' then
      begin
        moves:=moves+long_moves(-1,-1);
        moves:=moves+long_moves( 1,-1);
        moves:=moves+long_moves( 1, 1);
        moves:=moves+long_moves(-1, 1);
      end;

      if board.square[x1,y1].rank='R' then
      begin
        moves:=moves+long_moves(-1,0);
        moves:=moves+long_moves(0,-1);
        moves:=moves+long_moves(1,0);
        moves:=moves+long_moves(0,1);
      end;

      if board.square[x1,y1].rank='Q' then
      begin
        moves:=moves+long_moves(-1,-1);
        moves:=moves+long_moves( 1,-1);
        moves:=moves+long_moves( 1, 1);
        moves:=moves+long_moves(-1, 1);

        moves:=moves+long_moves(-1,0);
        moves:=moves+long_moves(0,-1);
        moves:=moves+long_moves(1,0);
        moves:=moves+long_moves(0,1);
      end;

      if board.square[x1,y1].rank='P' then
      begin
        if board.square[x1,y1].color='W' then
        begin
          x2:=x1; y2:=y1+2;
          if (y1=2) and (board.square[x2,y1+1].color='.') and
             (board.square[x2,y2].color='.') then
            moves:=moves+add_move(x1,y1+2);

          x2:=x1; y2:=y1+1;
          if (board.square[x2,y2].color='.') then
            if y2<8 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;

          x2:=x1-1;y2:=y1+1;
          if (board.square[x2,y2].color='B') then
            if y2<8 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;

          x2:=x1+1;y2:=y1+1;
          if (board.square[x2,y2].color='B') then
            if y2<8 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;


          x2:=x1-1;y2:=y1+1;
          if  (board.ep_file=x2) and (y1=5) then
          begin
            moves:=moves+add_move(x2,y2);
          end;

          (****** WARNING!!! Pa5xh6 e.p.!!!!!!   ******);

          if (x1=1) and (y1=5) and (board.ep_file=0) then
          begin
            x2:=8; y2:=6;
            moves:=moves+chr(x2+96)+chr(y2+48)+' ';
          end;

          x2:=x1+1;y2:=y1+1;
          if  (board.ep_file=x2) and (y1=5) then
          begin
            moves:=moves+add_move(x2,y2);
          end;
        end
        else
        if board.square[x1,y1].color='B' then
        begin
          x2:=x1; y2:=y1-2;
          if (y1=7) and (board.square[x2,y1-1].color='.') and
             (board.square[x2,y2].color='.') then
            moves:=moves+add_move(x1,y1-2);

          x2:=x1; y2:=y1-1;
          if (board.square[x2,y2].color='.') then
            if y2>1 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;

          x2:=x1-1;y2:=y1-1;
          if (board.square[x2,y2].color='W') then
            if y2>1 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;

          x2:=x1+1;y2:=y1-1;
          if (board.square[x2,y2].color='W') then
            if y2>1 then
               moves:=moves+add_move(x2,y2)
            else
            begin
              moves:=moves+add_promotion(x2,y2);
            end;

          x2:=x1-1;y2:=y1-1;
          if  (board.ep_file=x2) and (y1=4) then
          begin
            moves:=moves+add_move(x2,y2);
          end;

          (****** WARNING!!! Pa4xh3 e.p.!!!!!!   ******);
          if (x1=1) and (y1=4) and (board.ep_file=0) then
          begin
            x2:=8; y2:=3;
            moves:=moves+chr(x2+96)+chr(y2+48)+' ';;
          end;

          x2:=x1+1;y2:=y1-1;
          if  (board.ep_file=x2) and (y1=4) then
          begin
            moves:=moves+add_move(x2,y2);
          end;
        end;
      end;
    end
    else
      moves:='';
  end;
  if length(moves)<=4 then
  begin
    moves:='';
  end;
  cb_gen_moves:=moves;
end;

procedure do_move_string(VAR board : boardtype; move: movetype);
var
  ep : boolean;
  x1, y1, x2, y2 : integer;

begin
  x1:=ord(upcase(move[2]))-64;
  y1:=ord(upcase(move[3]))-48;
  x2:=ord(upcase(move[4]))-64;
  y2:=ord(upcase(move[5]))-48;
  if (legal_move(board,x1,y1,x2,y2)) and (length(move)>=5) and
     (board.illegal_move=false) then
  begin

    inc(board.move_numb);
    ep:=(board.square[x1,y1].rank='P') and
        (board.square[x2,y2].rank='.') and
        (x1<>x2);

    if (board.square[x1,y1].rank='K') and
       (board.square[x1,y1].color='W') then
    begin
      board.w_cast_short:=false;
      board.w_cast_long:=false;
    end;
    if (board.square[x1,y1].rank='K') and
       (board.square[x1,y1].color='B') then
    begin
      board.b_cast_short:=false;
      board.b_cast_long:=false;
    end;

    if ((x1=1) and (y1=1)) or ((x2=1) and (y2=1)) then
      board.w_cast_long:=false;
    if ((x1=8) and (y1=1)) or ((x2=8) and (y2=1)) then
      board.w_cast_short:=false;
    if ((x1=1) and (y1=8)) or ((x2=1) and (y2=8)) then
      board.b_cast_long:=false;
    if ((x1=8) and (y1=8)) or ((x2=8) and (y2=8)) then
      board.b_cast_short:=false;

    if (board.square[x1,y1].rank='P') and
       (abs(y2-y1)=2) then
       board.ep_file:=x1
    else if not ((board.square[x1,y1].rank='K') and
            (abs(x2-x1)=2)) then
       board.ep_file:=0;


    if (y1=1) and (y2=1) and (x1=5) and (x2=3) and
       (board.square[x1,y1].rank='K') then
    begin
      board.square[4,y1]:=board.square[1,y1];
      board.square[1,y1].color:='.';
      board.square[1,y1].rank:='.';
    end;
    if (y1=1) and (y2=1) and (x1=5) and (x2=7) and
       (board.square[x1,y1].rank='K') then
    begin
      board.square[6,y1]:=board.square[8,y1];
      board.square[8,y1].color:='.';
      board.square[8,y1].rank:='.';
    end;
    if (y1=8) and (y2=8) and (x1=5) and (x2=3) and
       (board.square[x1,y1].rank='K') then
    begin
      board.square[4,y1]:=board.square[1,y1];
      board.square[1,y1].color:='.';
      board.square[1,y1].rank:='.';
    end;
    if (y1=8) and (y2=8) and (x1=5) and (x2=7) and
       (board.square[x1,y1].rank='K') then
    begin
      board.square[6,y1]:=board.square[8,y1];
      board.square[8,y1].color:='.';
      board.square[8,y1].rank:='.';
    end;
    if ep then
    begin
      board.square[x2,y1].color:='.';
      board.square[x2,y1].rank:='.';
    end;

    board.square[x2,y2]:=board.square[x1,y1];
    board.square[x1,y1].color:='.';
    board.square[x1,y1].rank:='.';

    if (length(move)>5) and (pos(move[length(move)],'NBRQ')>0) then
      board.square[x2,y2].rank:=move[length(move)];

    board.white_to_move:=not board.white_to_move;
    board.move_hist[board.move_numb mod max_moves]:=move;
  end
  else
    board.illegal_move:=true;
end;

procedure print_board(VAR board : boardtype);
var
  i, j : byte;

begin
  writeln;
  for j:=8 downto 1 do
  begin
    write(j:2,'  ');
    for i:=1 to 8 do
    begin
      write(board.square[i,j].color,board.square[i,j].rank,' ');
    end;
    writeln;
  end;
  write('    ');
  for i:=1 to 8 do
  begin
    write(' ',chr(i+64),' ');
  end;
  writeln;
end;

procedure nic_print_legal_moves(VAR board : boardtype);
var
  i, j: integer;
begin
  for j:=1 to 8 do
  begin
    for i:=1 to 8 do
    begin
      write(nic_gen_moves(board,chr(i+96)+chr(48+j)));
    end;
  end;
end;




procedure cb_print_legal_moves(VAR board : boardtype);
var
  i, j: integer;
begin
  for i:=1 to 8 do
  begin
    for j:=1 to 8 do
    begin
      write(cb_gen_moves(board,chr(i+96)+chr(48+j)));
    end;
  end;
end;

procedure parse_move_string(VAR board: boardtype; VAR move:movetype);
var
  i,x1,y1,x2,y2:integer;
  castling : byte;
  new_move_str : string;

begin
  if board.illegal_move=false then
  begin
    for i:=1 to length(move) do
    begin
      if move[i]='0' then
        move[i]:='O';
      move[i]:=upcase(move[i]);
    end;
    if pos('O',move)>0 then
    begin
      i:=1; castling:=0;
      repeat
        if move[i]='O' then
          inc(castling);
        inc(i);
      until i>length(move);
      if castling=2 then
      begin
        x1:=5;
        x2:=7;
        if board.white_to_move then
        begin
          y1:=1;
          y2:=1;
        end
        else
        begin
          y1:=8;
          y2:=8;
        end;
      end
      else
      begin
        x1:=5;
        x2:=3;
        if board.white_to_move then
        begin
          y1:=1;
          y2:=1;
        end
        else
        begin
          y1:=8;
          y2:=8;
        end;
      end;
    end
    else
    begin
      i:=length(move);
      while (pos(move[i],'12345678')=0) and (i>0) do
        dec(i);
      if i>=4 then
      begin
        y2:=ord(move[i])-48;
        dec(i);
        x2:=ord(upcase(move[i]))-64;
        dec(i);
        while (pos(move[i],'12345678')=0) and (i>0) do
        dec(i);
        if i>=2 then
        begin
          y1:=ord(move[i])-48;
          dec(i);
          x1:=ord(upcase(move[i]))-64;
          dec(i);
        end;
      end;
    end;
    if legal_move(board,x1,y1,x2,y2) then
    begin
      new_move_str:=board.square[x1,y1].rank+
                     chr(96+x1)+chr(48+y1)+chr(96+x2)+chr(48+y2);
      if (pos(move[length(move)],'NBRQ')>0) and
         (board.square[x1,y1].rank='P') and ((y2=1) or (y2=8)) then
      begin
        new_move_str:=new_move_str+move[length(move)];
      end
      else
      if (pos(move[length(move)-1],'NBRQ')>0) and
         (board.square[x1,y1].rank='P') and ((y2=1) or (y2=8)) then
      begin
        new_move_str:=new_move_str+move[length(move)-1];
      end
      else
      if (board.square[x1,y1].rank='P') and ((y2=1) or (y2=8)) then
        new_move_str:=new_move_str+'Q';

      move:=new_move_str;
    end
    else
    begin
      writeln('  move: ',board.move_numb,'.',move,' illegal!!');
      board.illegal_move:=true;
      move:='';
    end;
  end
  else
    move:='';
end;


procedure do_move(VAR board:boardtype; move:movetype);
begin
  parse_move_string(board,move);
  do_move_string(board,move);
end;

function in_check_after(board : boardtype; move: movetype): boolean;
var
  in_check : boolean;
  i, j,k : integer;
  move_color, king_color : char;
  king_square, tempstr : string[255];
  square_str : array[1..3] of string[255];


begin
  do_move_string(board,move);
  i:=1; j:=1; k:=1;
  square_str[1]:='';
  in_check:=false;
  if (board.white_to_move) then
  begin
    move_color:='W';
    king_color:='B';
  end
  else
  begin
    move_color:='B';
    king_color:='W';
  end;
  while (i<=8) and (j<=8) do
  begin
    if (board.square[i,j].rank='K') and
       (board.square[i,j].color=king_color) then
    begin
      king_square:=chr(i+96)+chr(j+48);
    end;
    if (board.square[i,j].color=move_color) and
       (board.square[i,j].rank<>'P') then
    begin
      tempstr:=nic_gen_moves(board,chr(i+96)+chr(j+48));
      tempstr:=copy(tempstr,5,length(tempstr)-4);
      if (length(square_str[k])+length(tempstr)<255) then
        square_str[k]:=square_str[k]+tempstr
      else
      begin
        inc(k);
        square_str[k]:=tempstr;
      end;
    end;
    inc(i);
    if i=9 then
    begin
      i:=1;
      inc(j);
    end;
  end;
  for i:=1 to k do
  begin
    in_check:=in_check or (pos(king_square,square_str[i])>0);
  end;

  in_check_after:=in_check;
end;

function giving_check_after(board : boardtype; move: movetype): boolean;
var
  in_check : boolean;
  i, j,k, x2, y2 : integer;
  move_color, king_color : char;
  king_square, tempstr : string[255];
  square_str : array[1..3] of string[255];


begin
  do_move(board,move);
  i:=1; j:=1; k:=1;
  square_str[1]:='';
  in_check:=false;

  if (board.white_to_move) then
  begin
    move_color:='B';
    king_color:='W';
  end
  else
  begin
    move_color:='W';
    king_color:='B';
  end;
  board.white_to_move:=not board.white_to_move;
  while (i<=8) and (j<=8) do
  begin
    if (board.square[i,j].rank='K') and
       (board.square[i,j].color=king_color) then
    begin
      king_square:=chr(i+96)+chr(j+48);
    end;
    if (board.square[i,j].color=move_color) then
    begin
      if (board.square[i,j].rank<>'P') then
      begin
        tempstr:=nic_gen_moves(board,chr(i+96)+chr(j+48));
        tempstr:=copy(tempstr,5,length(tempstr)-4);

      end
      else
      begin
        if move_color='W' then
        begin
          tempstr:='';
          x2:=i-1; y2:=j+1;
          if legal_move(board,i,j,x2,y2) then
            tempstr:=tempstr+chr(x2+96)+chr(y2+48)+' ';
          x2:=i+1; y2:=j+1;
          if legal_move(board,i,j,x2,y2) then
            tempstr:=tempstr+chr(x2+96)+chr(y2+48)+' ';
        end
        else
        begin
          tempstr:='';
          x2:=i-1; y2:=j-1;
          if legal_move(board,i,j,x2,y2) then
            tempstr:=tempstr+chr(x2+96)+chr(y2+48)+' ';
          x2:=i+1; y2:=j-1;
          if legal_move(board,i,j,x2,y2) then
            tempstr:=tempstr+chr(x2+96)+chr(y2+48)+' ';
        end
      end;
      if (length(square_str[k])+length(tempstr)<255) then
          square_str[k]:=square_str[k]+tempstr
      else
      begin
        inc(k);
        square_str[k]:=tempstr;
      end;
    end;
    inc(i);
    if i=9 then
    begin
      i:=1;
      inc(j);
    end;
  end;
  for i:=1 to k do
  begin
    in_check:=in_check or (pos(king_square,square_str[i])>0);
  end;

  giving_check_after:=in_check;
end;



begin
end.