program cb2nic;
{$m 65520,0,600000}
uses
  crt,dos, ch_files, ch_chess, ch_parse;

const
  omit_deleted: longint = 0;
  omit_fragment: longint = 0;
  omit_illegal: longint = 0;


var
  not_printed_games, temp : longint;
  i : integer;
  numb_of_games, game_numb : longint;
  source, target, target2 : sourcetype;
  game : gametype;
  target_idx, t_game_numb : longint;
  log_fil : text;

{mainprogram}
begin
  io_test;
  writeln;
  writeln('Carsten Hansen, CH0506@HDC.HHA.DK, any comment welcome');
  writeln;
  writeln('SYNTAX: CB2NIC source-file target-file');
  writeln;
  writeln('The following games will be omitted: ');
  writeln;
  writeln('- deleted, and overwritten games');
  writeln('- game fragments (games starting with a position)');
  writeln;
  writeln;
  source.name:='';
  target.name:='';
  not_printed_games:=0;
  if paramcount=0 then
  begin
    write('ChessBase-file to be converted to NicBase:    ');
    readln(source.name);
    write('Name of new NicBase file:                     ');
    readln(target.name);
    if length(target.name)=0 then
      target.name:=source.name;
  end
  else
  if paramcount=1 then
  begin
    source.name:=paramstr(1);
    target.name:=source.name;
  end
  else
  begin
    source.name:=paramstr(1);
    target.name:=paramstr(2);
  end;
  remove_ext(source.name);
  remove_ext(target.name);
  find_path(source.name,source.path);
  find_path(target.name,target.path);

  if file_exist(source.path+source.name+'.CBI') and
     file_exist(source.path+source.name+'.CBF') then
  begin
    open_file_for_write(target.index,target.path+target.name+'.I30');
    open_file_for_write(target.game,target.path+target.name+'.G30');
    io_test;
    open_file_for_read(source.index  ,source.path+source.name+'.CBI');
    open_file_for_read(source.game   ,source.path+source.name+'.CBF');
    if not io_error then
    begin
      target_idx:=0;
      t_game_numb:=0;
      game.game_format:='CB';
      numb_of_games:=get_index_val(source.index)-1;
      game.beg:=get_index_val(source.index)-2;

      writeln(numb_of_games:6,' Games to examine');
      put_index_val(target.index,target_idx);
      game_numb:=1;
      while (game_numb<=numb_of_games) and (not io_error) and
            (not keypressed) do
      begin
        while (source.game.pos+1<game.beg) do
          temp:=get_next_byte(source.game);
        game.beg_next:=get_index_val(source.index)-game_numb-2;
        game.len:=game.beg_next-game.beg;
        if game.len<0 then
        begin
          write('game.len<0');
          halt;
        end;

        i:=0;
        while (i<game.len) and (not io_error) do
        begin
          game.bytes[i]:=get_next_byte(source.game);
          inc(i);
        end;
        game.bytes[game.len]:=-1;
        parse_cb_gamehead(game);
        if not (game.skip) then
        begin
          write_nic_gamehead(game);
          if not game.illegal_move then
          begin
            inc(t_game_numb);
            target_idx:=target_idx+game.len;
            put_index_val(target.index,target_idx);
            for i:=0 to game.len-1 do
            begin
              put_next_byte(target.game,game.bytes[i]);
            end;
          end
          else
          begin
            inc(not_printed_games);
            inc(omit_illegal);
            if omit_illegal=1 then
            begin
              assign(log_fil,source.path+source.name+'.log');
              rewrite(log_fil);
            end;
            writeln(log_fil,game_numb+1:6,'':4,game.cb_players);
          end;
        end
        else
        begin
          inc(not_printed_games);
          if (game.deleted) or (game.overwritten) then
            inc(omit_deleted)
          else if game.position then
            inc(omit_fragment)
          else if game.illegal_move then
          begin
            inc(omit_illegal);
          end;
        end;
        game.beg:=game.beg_next;
        gotoxy(1,wherey);
        write(game_numb:6,' Games Examined ',not_printed_games:6,
              ' Games omitted');
        inc(game_numb);
      end;
    end;
    close_read_file(source.index);
    close_read_file(source.game);
    close_write_file(target.index);
    close_write_file(target.game);
    writeln;
    if omit_illegal>0 then
      close(log_fil);
    if not_printed_games>0 then
    begin
      writeln;
      writeln('Omitted games due to deletion/overwrite:    ',omit_deleted);
      writeln('Omitted games due to game fragments:        ',omit_fragment);
      writeln('Omitted games due to illegal moves          ',omit_illegal);
    end;
  end
  else
  begin
    writeln(source.path+source.name,'  Does not exist');
  end;
  writeln;
end.
