/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import de.nm.ant.ipdf.AbstractPdfTask;
import java.io.File;
import java.io.IOException;

public class PdfSecureTask
extends AbstractPdfTask {
    private boolean aes = true;
    private boolean allow_assembly = false;
    private boolean allow_copy = false;
    private boolean allow_degraded_printing = false;
    private boolean allow_file_in = false;
    private boolean allow_modify_annotations = false;
    private boolean allow_modify_contents = false;
    private boolean allow_printing = false;
    private boolean allow_screenreaders = false;
    private boolean do_not_ecncrypt_metadata = false;
    private String newpwowner = null;
    private String newpwuser = null;

    public void execute() {
        try {
            int encryptionType;
            File input = this.getInputFile("pdf", this.usesrcfile);
            File output = this.getOutputFile("pdf");
            this.logVerboseHeader(input);
            PdfReader reader = this.createPdfReaderFromFile(input);
            PdfStamper stamper = new PdfStamper(reader, this.createOutputStream(output), this.version);
            int n = encryptionType = this.aes ? 2 : 1;
            if (this.do_not_ecncrypt_metadata) {
                encryptionType |= 8;
            }
            int permissions = 0;
            if (this.allow_printing) {
                permissions |= 0x804;
            }
            if (this.allow_degraded_printing) {
                permissions |= 4;
            }
            if (this.allow_modify_contents) {
                permissions |= 8;
            }
            if (this.allow_assembly) {
                permissions |= 0x400;
            }
            if (this.allow_copy) {
                permissions |= 0x10;
            }
            if (this.allow_screenreaders) {
                permissions |= 0x200;
            }
            if (this.allow_modify_annotations) {
                permissions |= 0x20;
            }
            if (this.allow_file_in) {
                permissions |= 0x100;
            }
            stamper.setEncryption(encryptionType, this.newpwowner, this.newpwuser, permissions);
            stamper.close();
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
        catch (DocumentException e) {
            this.throwBuildException((Exception)((Object)e));
        }
    }

    public void setAes(boolean aes) {
        this.aes = aes;
    }

    public void setAllow_assembly(boolean allowAssembly) {
        this.allow_assembly = allowAssembly;
    }

    public void setAllow_copy(boolean allowCopy) {
        this.allow_copy = allowCopy;
    }

    public void setAllow_degraded_printing(boolean allowDegradedPrinting) {
        this.allow_degraded_printing = allowDegradedPrinting;
    }

    public void setAllow_file_in(boolean allowFileIn) {
        this.allow_file_in = allowFileIn;
    }

    public void setAllow_modify_annotations(boolean allowModifyAnnotations) {
        this.allow_modify_annotations = allowModifyAnnotations;
    }

    public void setAllow_modify_contents(boolean allowModifyContents) {
        this.allow_modify_contents = allowModifyContents;
    }

    public void setAllow_printing(boolean allowPrinting) {
        this.allow_printing = allowPrinting;
    }

    public void setAllow_screenreaders(boolean allowScreenreaders) {
        this.allow_screenreaders = allowScreenreaders;
    }

    public void setDo_not_ecncrypt_metadata(boolean doNotEcncryptMetadata) {
        this.do_not_ecncrypt_metadata = doNotEcncryptMetadata;
    }

    public void setNewpwowner(String newpwowner) {
        this.newpwowner = newpwowner;
    }

    public void setNewpwuser(String newpwuser) {
        this.newpwuser = newpwuser;
    }
}

