;;
;; XEmacs configuration file
;; Author: Fabrice Popineau <Fabrice.Popineau@supelec.fr>
;; Date: 
;;
;; Debugging of .emacs
(setq debug-on-signal nil)
(setq debug-on-error nil)
(setq debug-on-quit nil)

(message "Loading default configuration...")

;; Hopefully this bug in Mule XEmacs will be fixed !
;; (defconst locale nil)

;; Requirements.

; Lisp routines to make everything easier.
(require 'cl)                                   ; For mapcar* and other things

; General XEmacs UI improvements.

(require 'winring)			; The `window ring' is *very* useful
(require 'scroll-in-place)		; We want to scroll nicely
(require 'uniquify)			; This really is deeply deeply nifty
(require 'icomplete)			; So too is this
(require 'balloon-help)			; Tooltips are go!
(require 'iso-insert)			; I often need international characters.
(require 'imenu)

;; We are working on native win32
(require 'pc-select)
(pc-select-mode)

;; Turn on the function menu, and commence flashing brackets.

(add-hook 'find-file-hooks 'fume-setup-buffer)
(add-hook 'Manual-mode-hook 'turn-on-fume-mode)
(paren-set-mode 1 t)                            ; Flick on paren blinking.

;; Lazy-lock is good enough for some, but I want lazy-shot, with
;; config changes to ensure that even with the fanatical crazy cc-mode
;; fontification, the delays are minimal.

(remove-hook 'font-lock-mode-hook 'turn-on-lazy-lock)
(add-hook 'font-lock-mode-hook 'turn-on-lazy-shot)
(setq lazy-shot-stealth-lines 50
      lazy-shot-stealth-nice 0.5
      lazy-shot-step-size 512)

;; Beat AUC-TeX and preview-LaTeX into functioning properly.

(setq-default text-mode-hook 'turn-on-auto-fill)
(setq-default fill-adapt-mode t)
(require 'filladapt)

;; DTD mode
(autoload 'dtd-mode "tdtd" "Major mode for SGML and XML DTDs." t)
(autoload 'dtd-etags "tdtd"
  "Execute etags on FILESPEC and match on DTD-specific regular expressions."
  t)
(autoload 'dtd-grep "tdtd" "Grep for PATTERN in files matching FILESPEC." t)

;; Turn on font lock when in DTD mode
(add-hook 'dtd-mode-hooks
	  'turn-on-font-lock)

(setq auto-mode-alist
      (append
       (list
	'("\\.dcl$" . dtd-mode)
	'("\\.dec$" . dtd-mode)
	'("\\.dtd$" . dtd-mode)
	'("\\.ele$" . dtd-mode)
	'("\\.ent$" . dtd-mode)
	'("\\.mod$" . dtd-mode))
       auto-mode-alist))

(require 'tex-site)
(require 'tex-fptex)

(setq auto-mode-alist
      (append
       (list
	'("\\.\\(?:sty\\|cls\\|bbl\\)\\'" . latex-mode) 
	'("\\.[tT]e[xX]\\'" . tex-mode) 
	'("\\.ltx\\'" . latex-mode))
       auto-mode-alist))

;; (add-hook 'LaTeX-mode-hook
;;           (function
;;            (lambda ()
;;              (make-local-variable 'imenu-generic-expression)
;;              (setq imenu-generic-expression LaTeX-imenu-generic-expression)
;;              (imenu-add-to-menubar "Imenu"))))

(setq TeX-auto-save t
      TeX-parse-self t
      LaTeX-item-indent -6
      TeX-macro-private (list (expand-file-name "~/texmf/auctex/styles/"))
      TeX-style-private (list (expand-file-name "~/texmf/auctex/auto"))
      TeX-auto-local "~/texmf/auctex/auto/"
      TeX-debug-bad-boxes t
      preview-auto-reveal t
      LaTeX-section-hook '(LaTeX-section-heading
                           LaTeX-section-title
                           LaTeX-section-toc
                           LaTeX-section-section
                           LaTeX-section-label))
(setq-default TeX-master nil)

(defconst xemtex-root-directory 
  (file-name-as-directory (paths-construct-path '(".." "..") exec-directory)))

;;
;; Info mode
;;
(setq Info-directory-list 
      (append (list (file-name-as-directory (paths-construct-path '("info") xemtex-root-directory)))
	      Info-directory-list))

;;; Man pages
(setenv "MANPATH" (paths-construct-path '("man") xemtex-root-directory))

(autoload 'woman "woman"
          "Decode and browse a UN*X man page." t)
(autoload 'woman-find-file "woman"
          "Find, decode and browse a specific UN*X man-page file." t)

(custom-set-variables
 '(TeX-command-list 
   (quote
    (
     ("TeX" "tex -interaction=nonstopmode %t" TeX-run-TeX nil t)
     ("TeX Interactive" "tex %t" TeX-run-interactive nil t)
     ("PDFTeX" "pdftex -interaction=nonstopmode %t" TeX-run-TeX nil t)
     ("PDFTeX Interactive" "pdftex %t" TeX-run-interactive nil t)
     ("LaTeX" "%l -interaction=nonstopmode %t" TeX-run-LaTeX nil t)
     ("LaTeX Interactive" "%l %t" TeX-run-interactive nil t)
     ("PDFLaTeX" "pdflatex -interaction=nonstopmode %t" TeX-run-LaTeX nil t)
     ("PDFLaTeX Interactive" "pdflatex %t" TeX-run-interactive nil t)
     ("View DVI" "%v " TeX-run-silent t nil)
     ("View PDF" "pdfopen --file=%s.pdf" TeX-run-silent t nil)
     ("Print" "%p " TeX-run-command t nil)
     ("Queue" "%q" TeX-run-background nil nil)
     ("File" "dvips %d -o %f " TeX-run-command t nil)
     ("BibTeX" "bibtex %s" TeX-run-BibTeX nil nil)
     ("Index" "makeindex %s" TeX-run-command nil t)
     ("Check" "lacheck %s" TeX-run-compile nil t)
     ("Spell" "<ignored>" TeX-run-ispell-on-document nil nil)
     ("Other" "" TeX-run-command t t)
     ("Makeinfo" "makeinfo %t" TeX-run-compile nil t)
     ("AmSTeX" "amstex -interaction=nonstopmode %t" TeX-run-TeX nil t))
    t)
   )
 '(auto-save-directory "~\\.autosave")
 '(browse-url-generic-program "c:\\Program Files\\Internet Explorer\\iexplore.exe")
 '(c-default-style (quote ((java-mode . "java")
			   (other . "stroustrup")))
   )
 '(default-frame-plist (quote (width 132 height 84 menu-bar-lines 0)))
;; '(efs-ftp-program-name "ftp32")
 '(lazy-shot-mode t)
 '(load-home-init-file nil)
 '(lookup-package t)
 '(paren-mode (quote blink-paren nil (paren)))
 '(ps-lpr-command "gswin32c")
 '(ps-lpr-switches '("-dNOPAUSE" "-sDEVICE=mswinpr2" "-q")
)
 '(ps-paper-type (quote a4))
 '(Info-auto-generate-directory (quote always))
 '(sgml-live-element-indicator t)
 '(sgml-set-face t)
 '(efs-disable-netrc-security-check t)
 '(package-get-require-signed-base-updates nil)
)

;;;
;;; TeXLive initialization

; Unconditionally set GSLIB
(setenv "GS_LIB" (concat
		 (paths-construct-path (list xemtex-root-directory "xemtex" "gsfonts")) ";"
		 (paths-construct-path (list xemtex-root-directory "xemtex" "gslib"))))
; Unconditionally set PERL5LIB
(setenv "PERL5LIB" (concat
		 (paths-construct-path (list xemtex-root-directory "xemtex" "perl" "lib")) ";"
		 (paths-construct-path (list xemtex-root-directory "xemtex" "perl" "site" "lib"))))
; Unconditionally set MAGICK_HOME
(setenv "MAGICK_HOME" (paths-construct-path (list xemtex-root-directory "bin" "win32")))

;;;
;;; If TeXLive is run from the cdrom 
;;;
(defvar TeXLive-configuration-files
    '(("web2c\\texmf.cnf" . "web2c\\texmf.cnf")
      ("web2c\\mktex.cnf" . "web2c\\mktex.cnf")
      ("web2c\\updmap.cfg" . "web2c\\updmap.cfg")
      ("web2c\\fmtutil.cnf" . "web2c\\fmtutil.cnf")
      ("tex\\generic\\config\\language.dat" . "tex\\generic\\config\\language.dat")
      ("dvips\\config\\config.ps" . "dvips\\config\\config.ps")
      ("dvipdfm\\config\\config-win32" . "dvipdfm\\config\\config")
      ("pdftex\\config\\pdftex.cfg" . "pdftex\\config\\pdftex.cfg")
      ("tex4ht\\base\\tex4ht-win32.env" . "tex4ht\\base\\tex4ht.env")
      ("fonts\\map\\dvipdfm\\updmap\\dvipdfm_ndl14.map" . "fonts\\map\\dvipdfm\\updmap\\dvipdfm.map")
      ("fonts\\map\\dvips\\updmap\\psfonts_t1.map" . "fonts\\map\\dvips\\updmap\\psfonts.map")
      ("fonts\\map\\pdftex\\updmap\\pdftex_dl14.map" . "fonts\\map\\pdftex\\updmap\\pdftex.map")
)
    "Configuration files installed locally for the TeXLive system")

(defun TeXLive-safe-copy-file (source destination)
  (let ((destination-directory (file-name-directory destination)))
    (unless (file-exists-p destination)
      (unless (file-directory-p destination-directory)
	(make-directory-path destination-directory))
      (copy-file source destination t))))
  
(defun TeXLive-from-cdrom ()
  (let ((tempdir (temp-directory)))
  ;; Check that (temp-directory) is taken from GetTempPath !
    (setenv "TEXMFCNF" (paths-construct-path (list tempdir "texmf" "web2c")))
    (setenv "TEXMFMAIN" (paths-construct-path (list xemtex-root-directory "texmf")))
    (setenv "VARTEXMF" (paths-construct-path (list tempdir "texmf")))
    ;; Automagically build formats
    (setenv "MKTEXFMT" "1")
    ;; Build needed directories
    (mapcar #'(lambda (destination-directory)
		(unless (file-directory-p destination-directory)
		  (make-directory-path destination-directory)))
	    '("~/texmf/auctex/auto" "~/texmf/auctex/style"))
    ;; Filter PATH for other occurences of tex.exe
    (let ((newpath (concat (getenv "PATH") ";" 
			   (paths-construct-path (list xemtex-root-directory "bin" "win32")))))
      (setenv "PATH" newpath))
    ;; Copy files to the right place
    (mapc
     #'(lambda (x)
	 (TeXLive-safe-copy-file
	  (paths-construct-path (list xemtex-root-directory "texmf" (car x)))
	  (paths-construct-path (list tempdir "texmf" (cdr x))))) TeXLive-configuration-files)
    ;; Generate map files ? 
    
    ;; Generate language.dat ?
    

    ;; Regenerate ls-R file for $VARTEXMF
    (call-process "mktexlsr" nil nil nil (getenv "VARTEXMF"))

    ;; Add hook to ask if we should remove everything when exiting
    (add-hook 'kill-emacs-hook #'TeXLive-cleanup-from-cdrom t)
    (message "Initialization to run from CDRom done.")
    ))

;;;
;;; From dired.el, but better not assume it is loaded
;;;
(defun TeXLive-recursive-delete-directory (fn)
  ;; Recursively deletes directory FN, and all of its contents.
  (let* ((fn (expand-file-name fn)))
    (or (file-exists-p fn)
	(signal
	 'file-error
	 (list "Removing old file name" "no such directory" fn)))
    (let ((files (directory-files fn t)))
      (while files
	(let ((file (car files)))
	  (if (not (member (file-name-nondirectory file)
			   '("." "..")))
	      ;; This test is equivalent to
	      ;; (and (file-directory-p fn)
	      ;;      (not (file-symlink-p fn)))
	      ;; but more efficient
	      (if (eq t (car (file-attributes file)))
		  (TeXLive-recursive-delete-directory file)
		(delete-file file)))
	  (setq files (cdr files))))
      (delete-directory fn))))

(defun TeXLive-cleanup-from-cdrom ()
  (let ((tempdir (temp-directory)))
    (if (yes-or-no-p-dialog-box "Remove temporary files generated by using\nTeXLive directly from CDRom ?")
	(TeXLive-recursive-delete-directory 
	 (paths-construct-path (list tempdir "texmf"))))))
  
;; To use resize-minibuffer-mode, uncomment this and include in your .emacs:
(resize-minibuffer-mode)

(put 'eval-expression 'disabled nil)

(message "Done.")

