import three;
settings.render=0;
settings.prc=false; 

import Header;

unitsize(x=1.25cm);
currentprojection=orthographic(0.5, 1.0, 0.25);

thinpen;
currentpen += roundcap;
currentpen += roundjoin;

real r  = 5.0;
real re = 0.3*r;
real ra = 0.25*r;

triple vA1  =   dir(35, 25);
triple vA2  =   dir(35, 80);

transform3 Rr1 =  rotate(130,vA1);
transform3 Rr2 =  rotate(100,vA2);

triple vV   = r*dir(50, 10);
triple vVr  =   Rr1*vV;
triple vVrr =   Rr2*vVr;

triple vRo1 = dot(vA1,vV) * vA1;
triple vRo2 = dot(vA2,vVr) * vA2;

triple vR1  = vV-vRo1;
triple vR2  = vVr-vRo2;

real   rr1  = length(vR1);
real   rr2  = length(vR2);

draw(O--vRo1, dashed);
draw(O--vRo2, dashed);

draw(circle(vRo1, rr1, vA1));
draw(circle(vRo2, rr2, vA2));

draw(Label("$\aS{a}_1$",1,UnFill(1)), O--re*vA1, uvecpen, Arrow3(HookHead3, size=Asize));
draw(Label("$\aS{a}_2$",1,UnFill(1)), O--re*vA2, uvecpen, Arrow3(HookHead3, size=Asize));
     
draw(                               O--vV,   uvecpen, Arrow3(HookHead3, size=Asize));
draw(Label("$\aS{x}_R$",   0.8,W),  O--vVr,  uvecpen, Arrow3(HookHead3, size=Asize));
draw(Label("$\aS{x}_{RR}$",0.9,2E), O--vVrr, uvecpen, Arrow3(HookHead3, size=Asize));

draw(Label("$\aS{x}$",  1), vRo1--vV);
draw(vRo1--vVr);
draw(vRo2--vVr);
draw(vRo2--vVrr);

dot(vRo1);
dot(vRo2);
dot(vV);
dot(vVr);
dot(vVrr);

draw(Label("$\vartheta_1$",     align=O,UnFill(1)), arc(vRo1, 0.75*(vV-vRo1)+vRo1, 0.75*(vVr-vRo1)+vRo1), Arrow3(HookHead3, size=Asize));
draw(Label("$\vartheta_2$",0.4, align=O,UnFill(1)), arc(vRo2, 0.75*(vVr-vRo2)+vRo2, 0.75*(vVrr-vRo2)+vRo2), Arrow3(HookHead3, size=Asize));

draw(Label("$s_1$",1), O--2.0*ra*X);
draw(Label("$s_2$",1), O--1.0*ra*Y);
draw(Label("$s_3$",1), O--1.5*ra*Z);

