Program Help_processor (Input,Output) ;
 
{
 
 
Program description: 
 
    Help pre-processor
 
 
Author :                      Krish Singh
 
Written:                      8th Oct 1991
 
Version:                      1.0

Limitations: The program doesn't examine the contents of !<...|...>
constructions, to see if there are any `...' within them.  Also, it seems
impossible to include the string !<...|...> within the file it processes - this
makes documenting the system itself rather difficult!
 
}

LABEL 
    terminate;
VAR
    inchar,nextchar,outchar,dummychar :CHAR;
    input_file,output_file,verbstring,
    instring,outstring,boldon,boldoff: VARYING [132] OF CHAR;
    i,istatus,il:integer;
    infile,outfile:text;
    bold,verbold:boolean;

FUNCTION 
cli$get_value(com1:VARYING [a] OF CHAR;VAR com2:VARYING [b] OF CHAR;VAR i:integer):INTEGER;EXTERNAL;

{---------------------------------------------------------------------------}
Begin {Main program}
 
    boldon:='E[1m';
    boldoff:='E[0m';
    boldon[1]:=chr(27);
    boldoff[1]:=chr(27);
    verbold:=true;

    istatus:=cli$get_value('INFILE',input_file,il);
    { writeln('reading from ',input_file); }
    istatus:=cli$get_value('OUTFILE',output_file,il);
    { writeln('and writing to ',output_file); }


    {
    write('Input file>');
    readln(input_file);

    write('Output file>');
    readln(output_file);
    }
    
    OPEN(infile,input_file,default:='.help',history:=old);
    reset(infile);
    OPEN(outfile,output_file,default:=input_file,history:=new); 
    extend(outfile);

    writeln (outfile,'! File produced by PPhlp/Helpproc from input file ',
	input_file);
    
    While not(eof(infile)) do
	Begin
	    readln(infile,instring);

	    IF ((length(instring)>0) and (instring[1]='!')) then begin
		{ It might be an instruction to this program.  In any case, }
		{ don't write it out to the output, as it would be ignored  }
		{ by the help librarian					    }

		IF (instring='!helpproc{stop}') then goto terminate;
		IF (instring='!helpproc{verb_bold}') then verbold:=true;
		IF (instring='!helpproc{verb_nobold}') then verbold:=false;

		IF (instring='!begin{verbatim}') and (verbold)
						 then instring:=boldon;
		IF (instring='!end{verbatim}')   and (verbold)
						 then instring:=boldoff;
		End

	    Else Begin
		{ Check the line for special characters, writing it out as  }
		{ we go.						    }

		i:=1;
		while (i<=length(instring)) do begin
		    inchar:=instring[i];
		    If (inchar<>'''') AND (inchar<>'`') AND (inchar<>'!') then begin
			write(outfile,inchar);
		    End
		    Else begin

			IF (inchar='!') then begin
			    nextchar:='Q';
			    IF (i<>length(instring)) then nextchar:=instring[i+1];
			    IF (nextchar='<') then begin
				while (instring[i]<>'|') AND (i<=length(instring)) do 
				    begin 
					i:=i+1;
				    End;
				i:=i+1;
				while (instring[i]<>'>') AND (i<=length(instring))
							    do begin
				    write(outfile,instring[i]);
				    i:=i+1;
				End;
			    End
			    Else begin
				write(outfile,inchar);
			    End;
			End;

			IF (inchar='`') then begin
			    bold:=true;
			    write(outfile,boldon);
			End; 
			IF (inchar='''') then begin
			    IF not(bold) then write(outfile,'''');
			    IF bold then write(outfile,boldoff);
			    bold:=false;
			End; 
		    End;
		    i:=i+1;
		End { while (i<=length(instring)) };
		writeln(outfile);
	    End;    { if (instring[1] = '!') }
       End;
terminate:       close(infile);close(outfile);
End.  {Main program}
{---------------------------------------------------------------------------}
