/* myopen.c */

#include <stdio.h>
#ifndef AIX
#   include <stdlib.h>
#endif
#include <string.h>
#include "defines.h"
#include "myopen.h"
#include "mymalloc.h"
#include "myerror.h"

#ifdef __STDC__
FILE * my_open (char * file_name, char * extension , char * mode)
#else
FILE * my_open (file_name, extension, mode)
char * file_name, * extension, * mode;
#endif
{
	char * tmp_file_name;
	int i, lastext;
	FILE * out_file;

	tmp_file_name = (char *) my_malloc (sizeof (char)
					    * (strlen (file_name) + 5));
	strcpy (tmp_file_name, file_name);
	lastext = -1;
	for (i = 0; tmp_file_name [i]; i ++)
	    if (tmp_file_name [i] == '.') lastext = i;
	    else
	        if (tmp_file_name [i] == '/') lastext = -1;
	if (lastext == -1) strcat (tmp_file_name, extension);
	if ((out_file = fopen (tmp_file_name, mode)) == NULL)
	{
		fprintf (stderr, "Cannot open %s for %s\n", tmp_file_name,
			 mode [0] == 'r' ? "reading" : "writing");
		exit (UNSUCCESSFUL);
	}
	free (tmp_file_name);
	return (out_file);
}

