.TH BBFIG LOCAL
.SH NAME
bbfig \- calculate bounding boxes in PostScript
.SH SYNTAX
.B bbfig
[
.B \-m
] file
.SH USAGE
.I Bbfig
should be piped into 
.I psprint
or the equivalant.
.SH DESCRIPTION
.I Bbfig
prepends code that
calculates the bounding box of a 
.I file,
and places both
on standard output. The actual
calculation is done in the PostScript printer, so the output is
in the form of a dashed line demarcating the bounding box and
the numerical value of
its four coordinates. 
.PP
The 
.B \-m
option indicates the file is from a macintosh, and the mac prolog
is added (-m should not be given to 
.I psprint
if it is given to bbfig).
.PP
Once the bounding box is given by the printer, a line of the form
.nf
.sp
	%%BoundingBox: a b c d
.sp
.fi
where `a' ... `d' are the four numbers representing the bounding box,
should be added to the header of the PostScript file.
.SH BUGS
.I Bbfig
is known to be confused by images, and cliping paths. If the box
around the figure clearly is not the minimal one, a ruler is the
best bet for calculating the correct box. Remember that the 
bounding box values are in PostScript points (72 to the inch)
relative to an origin at the lower left corner of the page, and 
that (a,b) is the lower left hand corner of the bounding box, and
(c,d) is the upper right corner.
.SH Author
Ned Batchelder
