# -*- python -*-
# $Id: gtkgoods.py,v 1.6 2001/03/07 20:47:07 yotam Exp $
import time;
import gtk;
import osgoods;

# Constants
MaxScreenSize = 2**16 - 1;

def gflush():
   while gtk.events_pending():
      gtk.mainiteration();
   gtk.gdk_flush();


def getTextRect(font, text, spacePerRow=0, spacePerCol=0):
   width = 0;
   height = 0;
   nRows = 0;
   l = len(text)
   if l != 0:
      if text[l-1] != '\n':
         text = text + '\n'; # so every line has new line.
      currWidth = 0;
      for c in text:
         if c == '\n':
            nRows = nRows + 1;
            currWidth = currWidth + font.width(' ');
            # print "nRows=", nRows, ", currWidth=", currWidth;
            if width < currWidth:
               width = currWidth;
            currWidth = 0;
         charWidth = font.width(c);
         leftBearing = font.extents(c)[0]
         currWidth = currWidth + charWidth + leftBearing + spacePerCol;
         #print "c=", c, ", w=", \
         #   charWidth, ", ext=", font.extents(c), " +=", currWidth;
      height = nRows * (font.ascent + font.descent + spacePerRow);
   return (width, height);


class MyNoteBook(gtk.GtkNotebook):
   def __init__(self):
      gtk.GtkNotebook.__init__(self)
   def newPage(self, label):
      pg = gtk.GtkFrame();
      pg.set_border_width(2);
      # pg.show();
      self.append_page(pg, gtk.GtkLabel(label));
      return pg;

# Kludge to get fixed fonts 
_fixedfont = None
def getFixedFont():
   global _fixedfont;
   if _fixedfont == None:
      _fixedfont = gtk.load_font("-*-fixed-*-r-*-*-*-*-*-*-c-*-iso8859-1");
   return _fixedfont;

def widgetSetFixedFont(w):
   ff = getFixedFont();
   style = w.get_style().copy();
   style.font = ff;
   w.set_style(style);

_ffStyle = None;
def getFFStyleFrom(clist):
   global _ffStyle;
   if _ffStyle == None:
      clist.ensure_style();
      genStyle = clist.get_style();
      _ffStyle = genStyle.copy();
      # print "genStyle=", genStyle, "ffStyle=", _ffStyle;
      _ffStyle.font = getFixedFont();
   return _ffStyle;


def clistSetFixedFont(clist):
   ff = getFixedFont();
   style = clist.get_style();
   # style.font = ff;
   # clist.set_style(style);


def clistSelectShowRow(clist, ri):
   clist.select_row(ri, 1);
   if not clist.row_is_visible(ri):
      clist.moveto(row=ri);

def destroy_keep(w, *extra):
   # print "destroy_keep, w=", w, ", e=", e
   print "destroy_keep, w=", w, ", extra=", extra;
   w.unmap();
   return 1;

def delete_keep(w, e):
   # print "delete_keep, w=", w, ", e=", e
   w.unmap();
   return 1;


# pack a widget in a vbox ion centered and compact way
def PackCenteredInVBox(vbox, w, ypad=0, xpad=1):
   hbox = gtk.GtkHBox();hbox.show();
   hbox.pack_start(w, expand=1, fill=0, padding=xpad);
   vbox.pack_start(hbox, expand=0, fill=4, padding=ypad);

# Snapshot Using ImageMagick's import
# Add Winodw-Manager-Title !!
def snapshot(shellfile, widget, base):
   win = widget.get_window();
   win._raise();
   widget.map();
   widget.show();
   gflush();
   # time.sleep(1);
   xid = win.xid;
   # print "xid = %d = 0x%x" % (xid, xid);
   # gtk.gdk_beep();
   # -delay 200
   shellfile.write("import -frame -window 0x%x %s.jpeg\n" % 
		   (xid, base));
