/* psparse.h */

char * PS_header_commands [] =
{
	"/FontInfo",
	"/FontName",
	"/Encoding",
	"/PaintType",
	"/FontType",
	"/FontMatrix",
	"/FontBBox",
	"/UniqueID",
	"/Metrics",
	"/StrokeWidth",
	"/Private",
	"/CharStrings",
	"/FID",
	"/version",
	"/Notice",
	"/FullName",
	"/FamilyName",
	"/Weight",
	"/ItalicAngle",
	"/isFixedPitch",
	"/UnderlinePosition",
	"/UnderlineThickness",
	"/BlueFuzz",
	"/BlueScale",
	"/BlueShift",
	"/BlueValues",
	"/ExpansionFactor",
	"/FamilyBlues",
	"/FamilyOtherBlues",
	"/ForceBold",
	"/LanguageGroup",
	"/lenIV",
	"/MinFeature",
	"/ND",
	"/NP",
	"/OtherBlues",
	"/OtherSubrs",
	"/password",
	"/RD",
	"/RndStemUp",
	"/StdHW",
	"/StdVW",
	"/StemSnapH",
	"/StemSnapV",
	"/Subrs",
	NULL
};

#define FontInfo (0)
#define FontName (1)
#define Encoding (2)
#define PaintType (3)
#define FontType (4)
#define FontMatrix (5)
#define FontBBox (6)
#define UniqueID (7)
#define Metrics (8)
#define StrokeWidth (9)
#define Private (10)
#define CharStrings (11)
#define FID (12)
#define version (13)
#define Notice (14)
#define FullName (15)
#define FamilyName (16)
#define Weight (17)
#define ItalicAngle (18)
#define isFixedPitch (19)
#define UnderlinePosition (20)
#define UnderlineThickness (21)
#define BlueFuzz (22)
#define BlueScale (23)
#define BlueShift (24)
#define BlueValues (25)
#define ExpansionFactor (26)
#define FamilyBlues (27)
#define FamilyOtherBlues (28)
#define ForceBold (29)
#define LanguageGroup (30)
#define lenIV (31)
#define MinFeature (32)
#define ND (33)
#define NP (34)
#define OtherBlues (35)
#define OtherSubrs (36)
#define password (37)
#define RD (38)
#define RndStemUp (39)
#define StdHW (40)
#define StdVW (41)
#define StemSnapH (42)
#define StemSnapV (43)
#define Subrs (44)
#define not_a_PS_header_command (-1)

char * charstring_commands [] =
{
	"hstem",
	"vstem",
	"vmoveto",
	"rlineto",
	"hlineto",
	"vlineto",
	"rrcurveto",
	"closepath",
	"callsubr",
	"return",
	"escape",
	"hsbw",
	"endchar",
	"rmoveto",
	"hmoveto",
	"vhcurveto",
	"hvcurveto",
	"dotsection",
	"vstem3",
	"hstem3",
	"seac",
	"sbw",
	"div",
	"callothersubr",
	"pop",
	"setcurrentpoint",
	NULL
};

#define hstem (0)
#define vstem (1)
#define vmoveto (2)
#define rlineto (3)
#define hlineto (4)
#define vlineto (5)
#define rrcurveto (6)
#define closepath (7)
#define callsubr (8)
#define return_command (9) /* return is a reserved word !!!! */
#define escape (10)
#define hsbw (11)
#define endchar (12)
#define rmoveto (13)
#define hmoveto (14)
#define vhcurveto (15)
#define hvcurveto (16)
#define dotsection (17)
#define vstem3 (18)
#define hstem3 (19)
#define seac (20)
#define sbw (21)
#define div (22)
#define callothersubr (23)
#define pop_command (24)
#define setcurrentpoint (25)
#define not_a_charstring_command (-1)
#define charstring_command_numeric (-2)
#define charstring_command_char (-3)
#define charstring_commands_end (-4)

#define MAX_Subrs_entries 1000
#define MAX_Subrs_stack 11
bool processing_Subr;
int current_Subr;

typedef struct Subrs_entry
{
	char * token;
	struct Subrs_entry * next;
} Subrs_entry_tp;
Subrs_entry_tp * Subrs_entries [MAX_Subrs_entries],
               * Subrs_stack [MAX_Subrs_stack];

char coding_vector [MAX_CHARACTERS][35];

#define MAX_stack 1500
float stack [MAX_stack];
int top_of_stack;
float numeric_val;
char current_char [35];
int current_AFM_num;
bool after_hint;
float the_sbx;

int active_path, path_number;
bool active_flex;
typedef struct Flex
{
	float x [7], y [7];
	int n;
} Flex_tp;
Flex_tp flex;
typedef struct cartesian
{
	float x;
	float y;
} cartesian_tp;
cartesian_tp current_point;
bool processing_seacs, have_found_seacs;
long charstring_position;

#define MAX_blue_values 7
#define MAX_other_blues 5
typedef struct blue_pairs
{
	int overshoot;
	int position;
} blue_pairs_tp;
blue_pairs_tp blue_values [MAX_blue_values], other_blues [MAX_other_blues];
int num_of_blue_values, num_of_other_blues;
float blue_scale;
int blue_shift;
int blue_fuzz;

#ifdef MSDOS
#   define MAXOUTLINEPART 125
#else
#   define MAXOUTLINEPART 512
#endif 

typedef struct outline_spec
{
	struct outline_spec * next;
	char * outline_part;
} outline_spec_tp;

outline_spec_tp * this_outline;
outline_spec_tp * start_of_this_outline;
int current_point_number;

bool first_time_generating;
int linepos;
bool we_are_writing_curls, use_seacs;
AFM_info_tp * current_ai;
bool current_char_is_composite_char;

char * month_name [] =
{
	"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep",
	"Oct", "Nov", "Dec", NULL
};

#define LINETO "\n  -- z%d"
#define DRAW "FuF (z%d"
#define CURL "\n  .. {%d,%d}z%d"
#define BEZIER1 "\n  .. controls z%db"
#define BEZIER2 " and z%db"
#define CURVETO "\n  .. z%d"
#define OSX (current_ai -> needed_for_composite_char) ? "+os_x" : ""
#define OSY (current_ai -> needed_for_composite_char) ? "+os_y" : ""

bool candidate_for_seac __P((void));
int charstring_command __P((char * s));
void do_callothersubr __P((int othersubr, int n));
void do_callsubr __P((int subr_no));
void do_closepath __P((void));
void do_div __P((float num1, float num2));
void do_dotsection __P((void));
void do_endchar __P((void));
void do_hlineto __P((float dx));
void do_hmoveto __P((float dx));
void do_hsbw __P((float sbx, float wx));
void do_hstem __P((float y, float dy));
void do_hstem3 __P((float y0, float dy0, float y1, float dy1, float y2,
                    float dy2));
void do_hvcurveto __P((float dx1, float dx2, float dy2, float dy3));
float do_pop __P((void));
void do_rcurveto __P((float dx1, float dy1, float dx2, float dy2, float dx3,
                      float dy3));
void do_return __P((void));
void do_rlineto __P((float dx, float dy));
void do_rmoveto __P((float dx, float dy));
void do_rrcurveto __P((float dx1, float dy1, float dx2, float dy2, float dx3,
                       float dy3));
void do_sbw __P((float sbx, float sby, float wx, float wy));
void do_seac __P((float asb, float adx, float ady, int bchar, int achar));
void do_setcurrentpoint __P((float x, float y));
void do_vhcurveto __P((float dy1, float dx2, float dy2, float dx3));
void do_vlineto __P((float dy));
void do_vmoveto __P((float dy));
void do_vstem __P((float x, float dx));
void do_vstem3 __P((float x0, float dx0, float x1, float dx1, float x2,
                    float dx2));
void eat_this_character __P((void));
void get_blue_scale __P((void));
void get_blue_shift __P((void));
void get_blue_fuzz __P((void));
void get_blue_values __P((void));
void get_font_matrix __P((void));
void get_font_type __P((void));
void get_is_fixed_pitch __P((void));
void get_italic_angle __P((void));
void get_other_blues __P((void));
void get_paint_type __P((void));
outline_spec_tp * new_outline_part __P((void));
Subrs_entry_tp * new_Subrs_entry __P((void));
char * next_param_string __P((void));
void parse_PS_header __P((void));
void parse_charstrings_dictionary __P((void));
float pop __P((void));
void process_callothersubr __P((void));
void process_callsubr __P((void));
void process_char __P((AFM_info_tp * ai));
void process_closepath __P((void));
void process_composite_char __P((AFM_info_tp * ai));
void process_composite_chars_and_seacs __P((void));
void process_div __P((void));
void process_dotsection __P((void));
void process_endchar __P((void));
void process_escape __P((void));
void process_hlineto __P((void));
void process_hmoveto __P((void));
void process_hsbw __P((void));
void process_hstem __P((void));
void process_hstem3 __P((void));
void process_hvcurveto __P((void));
void process_one_Subrs_entry __P((void));
float process_pop __P((void));
void process_return __P((void));
void process_rlineto __P((void));
void process_rmoveto __P((void));
void process_rrcurveto __P((void));
void process_sbw __P((void));
void process_seac __P((void));
void process_setcurrentpoint __P((void));
void process_Subrs_entries __P((void));
void process_vhcurveto __P((void));
void process_vlineto __P((void));
void process_vmoveto __P((void));
void process_vstem __P((void));
void process_vstem3 __P((void));
int PS_header_command __P((void));
void push __P((float fl));
float skip_copyright __P((void));
void start_char __P((char * name));
void write_MF_header __P((void));
void write_MF_trailer __P((void));
void write_the_outline __P((void));
