%&plain

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% This is the file testmatp.mk, part of the MathKit package
%% (version 0.7, January , 1998) for math font 
%% generation.  (Author: Alan Hoenig, ajhjj@cunyvm.cuny.edu)
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\font\TTT=cmr7 \newcount\cno
\def\TT{\T\setbox0=\hbox{\char\cno}\ifdim\wd0>0pt
   \box0\lower4pt\hbox{\TTT\the\cno}\else
   \ifdim\ht0>0pt \box0\lower4pt\hbox{\TTT\the\cno}\fi\fi
   \global\advance\cno by1
}
\def\showfont#1{\font\T=#1 at 10pt\global\cno=0
 \tabskip1pt plus2pt minus1pt\halign to\hsize{&\hss\TT ##\hss\cr
 \multispan{16}\hfil \tt Font #1\hfil\cr\noalign{\smallskip}
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
 &&&&&&&&&&&&&&&\cr
}}

%% This is a `plain tex-ified' version of Alan Jeffrey's 
%% testmath.tex.

\input z<mock><fam>
\advance\hsize by -4pc


\centerline{\bf A Plain Math Test Document}\medskip
\centerline{for fonts installed by MathKit}\bigskip
\centerline{\it <currdate>}

\raggedbottom 

\def\framebox[#1]#2{%
  \setbox0=\hbox{#2}\dimen0=\wd0
  \vbox{\hrule\hbox to#1\dimen0{\vrule\vrule width0pt height8pt depth2pt
     #2\vrule}\hrule}}
\def\testsize#1{ 
   {\tt\string#1}: $a_{c_e}, b_{d_f}, C_{E_G}, 0_{1_2}, X^{X^X}_{X_X},
      a_{0_a}, 0_{a_0}, E=mc^2, X_{E=mc^2}, X_{X_{E=mc^2}}, 
      \sum_{i=0}^\infty$ 
} 

\def\testdelims#1#2#3{\sqrt{ 
   #1|#1\|#1\uparrow 
   #1\downarrow#1\updownarrow#1\Uparrow#1\Downarrow 
   #1\Updownarrow#1\lfloor#1\lceil 
   #1(#1\{#1[#1\langle 
      #3 
   #2\rangle#2]#2\}#2) 
   #2\rceil#2\rfloor#2\Updownarrow#2\Downarrow 
   #2\Uparrow#2\updownarrow#2\downarrow#2\uparrow 
   #2\|#2| 
}\cr} 

\def\testglyphs#1{ 
\endgraf
\bgroup\narrower\noindent
   #1a#1b#1c#1d#1e#1f#1g#1h#1i#1j#1k#1l#1m 
   #1n#1o#1p#1q#1r#1s#1t#1u#1v#1w#1x#1y#1z 
   #1A#1B#1C#1D#1E#1F#1G#1H#1I#1J#1K#1L#1M 
   #1N#1O#1P#1Q#1R#1S#1T#1U#1V#1W#1X#1Y#1Z 
   #10#11#12#13#14#15#16#17#18#19 
   #1\Gamma#1\Delta#1\Theta#1\Lambda#1\Xi 
   #1\Pi#1\Sigma#1\Upsilon#1\Phi#1\Psi#1\Omega 
   #1\alpha#1\beta#1\gamma#1\delta#1\epsilon 
   #1\varepsilon#1\zeta#1\eta#1\theta#1\vartheta 
   #1\iota#1\kappa#1\lambda#1\mu#1\nu#1\xi#1\omicron 
   #1\pi#1\varpi#1\rho#1\varrho 
   #1\sigma#1\varsigma#1\tau#1\upsilon#1\phi 
   #1\varphi#1\chi#1\psi#1\omega 
   #1\partial#1\ell#1\imath#1\jmath#1\wp 
\endgraf
\egroup
} 

\def\sidebearings#1{ $|#1|$ } 
\def\subscripts#1{ $#1_\circ$ } 
\def\supscripts#1{ $#1^\circ$ } 
\def\scripts#1{ $#1^\circ_\circ$ } 
\def\vecaccents#1{ $\vec#1$ } 
\def\tildeaccents#1{ $\tilde#1$ } 

\ifx\omicron\undefined 
   \let\omicron=o 
\fi 

\beginsection Introduction 

This document (based on a similar document created by Alan Jeffrey)  
tests the math capabilities of a math package for plain \TeX.  The math 
package combines the {\tt <mock>} math fonts with the {\tt <fam>}
text fonts.

\showfont{<fam>r<m>7t}
\smallskip			     
\showfont{<fam>r<m>7m}
\smallskip
\showfont{<mock>sy10}
\smallskip
\showfont{<mock>ex10}

\beginsection Fonts 

Math italic: 
$$ 
   ABCDEFGHIJKLMNOPQRSTUVWXYZ 
   abcdefghijklmnopqrstuvwxyz 
$$ 
Text italic: 
$$ 
   {\it ABCDEFGHIJKLMNOPQRSTUVWXYZ 
      abcdefghijklmnopqrstuvwxyz} 
$$ 
Roman: 
$$ 
   {\rm ABCDEFGHIJKLMNOPQRSTUVWXYZ 
      abcdefghijklmnopqrstuvwxyz} 
$$ 
[tt]Typewriter: 
[tt]$$ 
[tt]   {\tt ABCDEFGHIJKLMNOPQRSTUVWXYZ 
[tt]	  abcdefghijklmnopqrstuvwxyz} 
[tt]$$
Bold: 
$$ 
   {\bf ABCDEFGHIJKLMNOPQRSTUVWXYZ 
      abcdefghijklmnopqrstuvwxyz} 
$$ 
[b]{\boldface 
[b]$$ 
[b]   \Gamma\Delta\Theta\Lambda\Xi\Pi\Sigma\Upsilon\Phi\Psi\Omega 
[b]$$ 
[b]}
Calligraphic: 
$$ 
   A{\cal ABCDEFGHIJKLMNOPQRSTUVWXYZ}Z
$$
Sans:
$$
   A{\sf ABCDEFGHIJKLMNOPQRSTUVWXYZ}Z\       a{\sf abcdefghijklmnopqrstuvwxyz}z
$$
[fr]Fraktur:
[fr]$$
[fr] A{\frak ABCDEFGHIJKLMNOPQRSTUVWXYZ}Z\ a{\frak abcdefghijklmnopqrstuvwxyz}z
[fr]$$
[bb]Blackboard Bold:
[bb]$$
[bb]  A{\bb ABCDEFGHIJKLMNOPQRSTUVWXYZ}Z
[bb]$$
Greek: 
$$ 
   \Gamma\Delta\Theta\Lambda\Xi\Pi\Sigma\Upsilon\Phi\Psi\Omega 
  \alpha\beta\gamma\delta\epsilon\varepsilon\zeta\eta\theta\vartheta 
   \iota\kappa\lambda\mu\nu\xi\omicron\pi\varpi\rho\varrho 
   \sigma\varsigma\tau\upsilon\phi\varphi\chi\psi\omega 
$$ 
Do these line up appropriately? 
$$ 
   \forall {\cal B} \Gamma {\bf D} \exists 
[tt]{\tt F} 
   G {\cal H} \Im {\bf J} {\sf K} \Lambda 
   M \aleph \emptyset \Pi {\it Q} \Re \Sigma 
[tt]{\tt T}
  \Upsilon {\cal V} {\bf W} \Xi 
   {\sf Y} Z 
   \quad 
   a {\bf c} \epsilon 
[tt]{\tt i} 
   \kappa {\bf m} \nu o \varpi {\sf r} 
   s \tau {\it u} v {\sf w} z 
   \quad 
[tt]{\tt g} 
   j {\sf q} \chi y 
   \quad 
   b \delta {\bf f} 
[tt]{\tt h} 
   k {\sf l} \phi 
$$ 

\beginsection Glyph dimensions 

These glyphs should be optically centered: 
   \testglyphs\sidebearings 
\noindent These subscripts should be correctly placed: 
   \testglyphs\subscripts 
\noindent These superscripts should be correctly placed: 
   \testglyphs\supscripts 
\noindent These subscripts and superscripts should be correctly placed: 
   \testglyphs\scripts 
\noindent These accents should be centered: 
   \testglyphs\vecaccents 
\noindent As should these: 
   \testglyphs\tildeaccents 
\noindent And here are accents in general:
   \'o \`o \^o \"o \~o \=o \.o \u o \v o \H o 
   \t oo \c o \d o \b o \quad
   $\hat o \check o \tilde o \acute o \grave o \dot o 
   \ddot o \breve o \bar o \vec o \vec h \hbar$

\beginsection Symbols 

These arrows should join up properly: 
$$ 
   a \hookrightarrow b \hookleftarrow c \longrightarrow d 
   \longleftarrow e \Longrightarrow f \Longleftarrow g 
   \longleftrightarrow h \Longleftrightarrow i 
   \mapsto j 
$$ 
These symbols should of similar weights: 
$$ 
   \pm + - \mp = / \backslash ( \langle [ \{ \} ] \rangle ) < \leq >  \geq 
$$ 
Are these the same size? 
$$\textstyle 
   \oint \int \quad 
   \bigodot \bigoplus \bigotimes \sum \prod 
   \bigcup \bigcap \biguplus \bigwedge \bigvee \coprod 
$$ 
Are these? 
$$ 
   \oint \int \quad 
   \bigodot \bigoplus \bigotimes \sum \prod 
   \bigcup \bigcap \biguplus \bigwedge \bigvee \coprod 
$$ 


\beginsection Sizing 

$$
    abcde + x^{abcde} + 2^{x^{abcde}}
$$

The subscripts should be appropriately sized: 

{\narrower\noindent\bodyfonts
\testsize\bodyfonts \endgraf
}

\beginsection Delimiters 

Each row should be a different size, but within each row the delimiters 
should be the same size.  First with {\tt\string\big}, etc: 
$$\vbox{\halign{\hfil$#$\hfil\cr
   \testdelims\relax\relax{a} 
   \testdelims\bigl\bigr{a} 
   \testdelims\Bigl\Bigr{a} 
   \testdelims\biggl\biggr{a} 
   \testdelims\Biggl\Biggr{a} 
}}$$ 
Then with {\tt\string\left} and {\tt\string\right}: 
$$\vbox{\halign{\hfil$#$\hfil\cr
   \testdelims\left\right{\vcenter{{\halign{\hss$#$\hss\cr a \cr}}}} 
   \testdelims\left\right{\vcenter{{\halign{\hss$#$\hss\cr a\cr a \cr}}}} 
   \testdelims\left\right{\vcenter{{\halign{\hss$#$\hss\cr a\cr a\cr a \cr}}}} 
   \testdelims\left\right{\vcenter{{\halign{\hss$#$\hss\cr a\cr a\cr a\cr a \cr}}}}  
}}$$ 

\beginsection Spacing 

This paragraph should appear to be a monotone grey texture. 
Suppose $f \in {\cal S}_n$ and $g(x) = (-1)^{|\alpha|}x^\alpha 
f(x)$.  Then $g \in {\cal S}_n$; now ({\bf c}) implies that $\hat 
g = D_\alpha \hat f$ and $P \cdot D_\alpha\hat f = P \cdot \hat g = 
(P(D)g)\hat{}$, which is a bounded function, since $P(D)g \in 
L^1(R^n)$.  This proves that $\hat f \in {\cal S}_n$.  If $f_i 
\rightarrow f$ in ${\cal S}_n$, then $f_i \rightarrow f$ in 
$L^1(R^n)$.  Therefore $\hat f_i(t) \rightarrow \hat f(t)$ for all $t 
\in R^n$.  That $f \rightarrow \hat f$ is a {\it continuous\/} mapping 
of ${\cal S}_n$ into ${\cal S}_n$ follows now from the closed 
graph theorem.  And thus for $x_1$ through $x_i$.
{\bf Functional Analysis}, W.~Rudin, McGraw--Hill, 
1973. 

[b]{\boldface
[b]This paragraph should appear to be a monotone dark texture. 
[b]Suppose $f \in {\cal S}_n$ and $g(x) = (-1)^{|\alpha|}x^\alpha 
[b]f(x)$.  Then $g \in {\cal S}_n$; now (c) implies that $\hat 
[b]g = D_\alpha \hat f$ and $P \cdot D_\alpha\hat f = P \cdot \hat g = 
[b](P(D)g)\hat{}$, which is a bounded function, since $P(D)g \in 
[b]L^1(R^n)$.  This proves that $\hat f \in {\cal S}_n$.  If $f_i 
[b]\rightarrow f$ in ${\cal S}_n$, then $f_i \rightarrow f$ in 
[b]$L^1(R^n)$.  Therefore $\hat f_i(t) \rightarrow \hat f(t)$ for all $t 
[b]\in R^n$.  That $f \rightarrow \hat f$ is a {\it continuous} mapping 
[b]of ${\cal S}_n$ into ${\cal S}_n$ follows now from the closed 
[b]graph theorem.  And thus for $x_1$ through $x_i$.
[b]{\it Functional Analysis}, W.~Rudin, McGraw--Hill, 1973. 
[b]}
[b]
{\it This paragraph should appear to be a monotone grey texture. 
Suppose $f \in {\cal S}_n$ and $g(x) = (-1)^{|\alpha|}x^\alpha 
f(x)$.  Then $g \in {\cal S}_n$; now ({\bf c}) implies that $\hat 
g = D_\alpha \hat f$ and $P \cdot D_\alpha\hat f = P \cdot \hat g = 
(P(D)g)\hat{}$, which is a bounded function, since $P(D)g \in 
L^1(R^n)$.  This proves that $\hat f \in {\cal S}_n$.  If $f_i 
\rightarrow f$ in ${\cal S}_n$, then $f_i \rightarrow f$ in 
$L^1(R^n)$.  Therefore $\hat f_i(t) \rightarrow \hat f(t)$ for all $t 
\in R^n$.  That $f \rightarrow \hat f$ is a {\bi continuous} mapping 
of ${\cal S}_n$ into ${\cal S}_n$ follows now from the closed 
graph theorem.  {\bi Functional Analysis}, W.~Rudin, McGraw--Hill, 
1973.} 

The text in these boxes should spread out as much as the math does: 
$$\vbox{\halign{\hfil#\hfil\cr
   \framebox[.95]{For example $x+y = \min\{x,y\} 
      + \max\{x,y\}$ is a formula.} \cr 
   \framebox[.975]{For example $x+y = \min\{x,y\} 
      + \max\{x,y\}$ is a formula.} \cr  
   \framebox[1]{For example $x+y = \min\{x,y\} 
      + \max\{x,y\}$ is a formula.} \cr  
   \framebox[1.025]{For example $x+y = \min\{x,y\} 
      + \max\{x,y\}$ is a formula.} \cr  
   \framebox[1.05]{For example $x+y = \min\{x,y\} 
      + \max\{x,y\}$ is a formula.} \cr  
   \framebox[1.075]{For example $x+y = \min\{x,y\} 
      + \max\{x,y\}$ is a formula.} \cr  
   \framebox[1.1]{For example $x+y = \min\{x,y\} 
      + \max\{x,y\}$ is a formula.} \cr  
   \framebox[1.125]{For example $x+y = \min\{x,y\} 
      + \max\{x,y\}$ is a formula.} \cr  
\cr}}$$ 
\bye
