#include "dviout.h"
#include <CommCtrl.h>
#include <io.h>
#include "misc_dialog.h"
#include "help_id.h"
#include "err.h"
#include "option.h"

void ShowWinHelp(int id);
void SetMargin(HWND hwnd);
char *print10mm(int);
int GetAddTotal(void);
int GetAddMemory(char *, char *, int);

int id_hist;

BOOL CALLBACK AutoSaveDlgProc( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	HWND hTemplateWnd = (HWND)GetDlgItem( hdwnd, IDC_EDIT_AUTOSAVE_TEMPLATE );
	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDOK:
					GetWindowText( hTemplateWnd, autosavebmp.sz_template, MAX_PATH );
					if( IsDlgButtonChecked(hdwnd,IDC_RADIO_SAVE_AS_BMP) == BST_CHECKED )
						autosavebmp.f_bmp = 0;
					else if( IsDlgButtonChecked(hdwnd,IDC_RADIO_SAVE_AS_EMF) == BST_CHECKED )
						autosavebmp.f_bmp = 1;
					else if( IsDlgButtonChecked(hdwnd,IDC_RADIO_SAVE_AS_BMC) == BST_CHECKED )
						autosavebmp.f_bmp = 2;
				case IDCANCEL:
					EndDialog(hdwnd, LOWORD(wParam));
					return TRUE;
				case ID_MYHELP:
					ShowWinHelp(IDH_AUTOSAVE);
					return TRUE;
			}
			break;

		case WM_INITDIALOG:
			SetMargin((HWND)GetDlgItem(hdwnd, IDC_EDIT_AUTOSAVE_TEMPLATE));
			CheckRadioButton( hdwnd, IDC_RADIO_SAVE_AS_BMP, IDC_RADIO_SAVE_AS_EMF,
				IDC_RADIO_SAVE_AS_BMP + autosavebmp.f_bmp );
			SetWindowText( hTemplateWnd, autosavebmp.sz_template );
			return TRUE;
		
		case WM_DESTROY:
			break;
		
	}
	return FALSE;
}

#ifdef	USE_ETF
extern BOOL f_make_etf;
extern BOOL f_make_pketf;
extern BOOL f_make_vfetf;
extern BOOL f_make_mapetf;
extern BOOL f_make_jttetf;
extern BOOL f_make_wjtetf;
extern BOOL f_make_imgetf;
extern char *f_make_dpi;

BOOL CALLBACK DlgInitETF( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_ETFPK:
					EnableWindow(GetDlgItem(hdwnd, IDC_DPI), 
						IsDlgButtonChecked(hdwnd, IDC_ETFPK));
					break;
				case IDOK:
					f_make_etf    = IsDlgButtonChecked(hdwnd, IDC_ETFCMTT);
					f_make_pketf  = IsDlgButtonChecked(hdwnd, IDC_ETFPK);
					f_make_vfetf  = IsDlgButtonChecked(hdwnd, IDC_ETFVF);
					f_make_wjtetf = 
					f_make_mapetf = IsDlgButtonChecked(hdwnd, IDC_ETFMAP);
					f_make_jttetf = IsDlgButtonChecked(hdwnd, IDC_ETFJTT);
					f_make_imgetf = IsDlgButtonChecked(hdwnd, IDC_ETFIMG);
					GetDlgItemText(hdwnd, IDC_DPI, common_work, 0x1000);
					Free0(f_make_dpi);
					f_make_dpi = dup_string(common_work);
				case IDC_ETFSTRIP:
				case IDC_ETFDEL:
				case IDCANCEL:
					EndDialog(hdwnd, LOWORD(wParam));
					return TRUE;
				case IDC_PHELP:
					ShowWinHelp(IDH_ETF);
					break;
			}
			break;

		case WM_INITDIALOG:
			sprintf(common_work, "%d", GetXDpi());
			SetDlgItemText(hdwnd, IDC_DPI, common_work);
			EnableWindow(GetDlgItem(hdwnd, IDC_DPI), 0);
			if(GetAddMemory("dviout.etf", NULL, 0) < 1)
				EnableWindow(GetDlgItem(hdwnd, IDC_ETFDEL), 0);
			if(!GetAddTotal())
				EnableWindow(GetDlgItem(hdwnd, IDC_ETFSTRIP), 0);
			return TRUE;
		
		case WM_DESTROY:
			break;
	}
	return FALSE;
}
#endif


// CallBack from File/Page History Dialog

void SetIdHist( int id )
{
	id_hist = id;
}

BOOL CALLBACK DlgHFunct( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	int his, pos;
	static int mrk;
	POINT	pt;
	char tmp[MAX_PATH + 32];
	static HWND hedit;

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case ID_HIS_JUMP:
						goto jmp;

				case ID_HIS_LIST:
					if(HIWORD(wParam) == LBN_DBLCLK){
jmp:					pos = SendDlgItemMessage(hdwnd, ID_HIS_LIST, 
							LB_GETCURSEL, 0, 0L);
						if(pos >= 0){
							EndDialog(hdwnd, 0);
							if(id_hist == ID_P_HISTORY){
								if(mrk != 0 && pos-- == 0)
									pos = MAX_H_HIST;
								else if((pos = h_hist_n - pos) < 0)
									pos += MAX_H_HIST;
							}else
								pos = MAKEWPARAM(f_hist_pt - pos - 1, TRUE);
							SendMessage(g_winData.dviwin.hWnd, WM_USER_HISTORY_OPEN, 
								pos, 0L);
						}
					}
					return TRUE;

				case IDC_ERACE:
					pos = SendDlgItemMessage(hdwnd, ID_HIS_LIST, 
						LB_GETCURSEL, 0, 0L);
					if(pos < 0)
						return TRUE;
					EraceHistory(f_hist_pt - pos - 1);
					SendDlgItemMessage(hdwnd, ID_HIS_LIST,
						LB_RESETCONTENT, 0, 0L);
					if(f_hist_pt > f_hist0)
						goto reset;

				case ID_HIS_CANCEL:
				case IDCANCEL:
					EndDialog(hdwnd, 0);
					return TRUE;
			}
			break;

		case WM_INITDIALOG:
			hedit = GetDlgItem( hdwnd, ID_HIS_LIST );
			SetFont( 10, hedit, IsJapanese()?"lr SVbN":"Courier New", IsJapanese() );
			if(id_hist == ID_P_HISTORY){
				SetWindowText(hdwnd, "Page Jump History");
				pt.x = GetTextXSize();
				pt.y = GetTextYSize();
				if(	 h_hist[PAGE_MARK].id == id_dvi
				  && h_hist[PAGE_MARK].page > 0){
					mrk = 1;
					wsprintf(tmp, "page %3d(%3d) :(0.%d,0.%d) %s", 
						h_hist[PAGE_MARK].page, 
						TransPage(h_hist[PAGE_MARK].page),
						h_hist[PAGE_MARK].x*100/pt.x, 
						h_hist[PAGE_MARK].y*100/pt.y, "<- Marked");
					SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_ADDSTRING, 0,
						(LPARAM)&tmp[0]);
				}else
					mrk = 0;
				for(his = h_hist_n; his > h_hist_n - MAX_H_HIST; his--){
					pos = (his >= 0)?his:his + MAX_H_HIST;
					if(h_hist[pos].id != id_dvi)
						break;
					wsprintf(tmp, "page %3d(%3d) :(0.%d,0.%d) %s", 
						h_hist[pos].page, TransPage(h_hist[pos].page),
						h_hist[pos].x*100/pt.x, h_hist[pos].y*100/pt.y,
						hist_msg[h_hist[pos].flag]);
					SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_ADDSTRING, 0,
						(LPARAM)&tmp[0]);
				}
				SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_SETCURSEL, mrk+1, 0);
				EnableWindow(GetDlgItem(hdwnd, IDC_ERACE), 0);
			}else{
				SetWindowText(hdwnd, "File History");
reset:			for(his = f_hist_pt; 
					--his >= f_hist0 && his >= f_hist_pt - MAX_F_HIST; ){
					wsprintf(tmp, "%s (%d page)",
						f_hist[his & (MAX_F_HIST - 1)].name,
						f_hist[his & (MAX_F_HIST - 1)].page);
					SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_ADDSTRING, 0,
						(LPARAM)&tmp[0]);
				}
				if(f_hist_pt > f_hist0)
					SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_SETCURSEL, 0, 0);
				SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_SETHORIZONTALEXTENT,
					1536, 0);
			}
			return TRUE;
		
		case WM_DESTROY:
			ReSetFont(hedit);
			break;
	}
	return FALSE;
}

BOOL CALLBACK ModeDlgProc( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	char tmp[32], key[8];
	int pos, mode;
	static HWND hcombo, hstatic;

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					mode = SendDlgItemMessage(hdwnd, IDC_MODE_NEW, 
						CB_GETCURSEL, 0, 0);
					SetParaSection(mode);
					RestoreRegistry();

				case IDCANCEL:
					EndDialog(hdwnd, 0);
					return 1;

				case IDC_HMODE:
					ShowWinHelp(IDH_PCMODE);
					break;
			}
			break;

		case WM_INITDIALOG:
			hcombo = GetDlgItem( hdwnd, IDC_MODE_NEW );
			hstatic = GetDlgItem( hdwnd, IDC_MODE_NNAME );
			SetFontJE(hcombo);
			SetFontJE(hstatic);
			mode = SetParaSection(-1);
			for(pos=0; pos < 10; pos++){
				wsprintf(key, "para%d", pos);
				wsprintf(tmp, "%d:", pos);
				tmp[31] = 0;
				RestoreString(tmp+2, 28, key, "mode", "");
				SendDlgItemMessage(hdwnd, IDC_MODE_NEW, CB_ADDSTRING,
					0, (LPARAM)tmp);
				if(pos == mode)
					SetDlgItemText(hdwnd, IDC_MODE_NNAME, tmp);
			}
			SendDlgItemMessage(hdwnd, IDC_REG_DEF, CB_SETCURSEL, mode, 0); // ???
			SendDlgItemMessage(hdwnd, IDC_MODE_NEW, CB_SETCURSEL, mode, 0);
			return TRUE;

		case WM_DESTROY:
			ReSetFont(hcombo);
			ReSetFont(hstatic);
			break;
	}
	return FALSE;
}

BOOL CALLBACK NoMoreDlgProc( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	char tmp[32];
	static int pos, cur, c_multi;
	static HWND hstatic;

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					if( IsDlgButtonChecked(hdwnd, IDC_NOMORE) == FALSE )
						cur = 0;
					if(pos != cur)
						ReserveInt("Settings", "multi", cur);

				case IDCANCEL:
					EndDialog(hdwnd, 0);
					return TRUE;

				case IDC_NOMORE:
					if(IsDlgButtonChecked(hdwnd, IDC_NOMORE)){
						if( c_multi != cur )
							CheckDlgButton(hdwnd, IDC_MULTI, FALSE);
					}else
						CheckDlgButton(hdwnd, IDC_MULTI, TRUE);
					break;

				case IDC_MULTI:
					if(IsDlgButtonChecked(hdwnd, IDC_MULTI)){
					   if( c_multi != cur )
							CheckDlgButton(hdwnd, IDC_NOMORE, FALSE);
					}else
						CheckDlgButton(hdwnd, IDC_NOMORE, TRUE);
					break;

				case IDC_HNOMORE:
					ShowWinHelp(IDH_NOMORE);
			}
			break;

		case WM_INITDIALOG:
			hstatic = GetDlgItem( hdwnd, IDC_NOMORE_STATE );
			SetFont( 0, hstatic, "Times New Roman", FALSE );
			pos = RestoreInt("Settings", "multi", 0);
			if(pos != 0)
				wsprintf(tmp, "'No more dviout' is set at %d.", pos);
			else
				wsprintf(tmp, "'No more dviout' is not set.");
			SetDlgItemText(hdwnd, IDC_NOMORE_STATE, tmp);
			cur = g_winData.szAppName[6] - '0';
			if(cur < 0) cur = 1;
			wsprintf(tmp, "%d", cur);
			SetDlgItemText(hdwnd, IDC_NOMORE_AT, tmp);
			if( !(c_multi = RestoreInt( "Settings", "cmulti", 0)) )
				c_multi = g_fMultiDviout;
			wsprintf(tmp, "%d", c_multi);
			SetDlgItemText(hdwnd, IDC_MULTI_UPTO, tmp);
			if(!pos)
				CheckDlgButton(hdwnd, IDC_MULTI, TRUE);
			if(pos == cur)
				CheckDlgButton(hdwnd, IDC_NOMORE, TRUE);
			return TRUE;
		
		case WM_DESTROY:
			ReSetFont(hstatic);
			break;
		
	}
	return FALSE;
}

BOOL CALLBACK GlidScaleDlgProc( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	int val;
	static int ww;
	static BOOL f_change;
	static HWND hdWnd;

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					if(f_change){	
						val = GetDlgItemInt( hdwnd, IDC_PW, &val, TRUE);
						if(IsDlgButtonChecked( hdwnd, IDC_INCH ))
							ww = (IN_TO_SP( ((double)val)/1000 ));
						else
							ww = (MM_TO_SP( ((double)val)/100 ));
					}
					f_gridO = !IsDlgButtonChecked( hdwnd, IDC_PH );
					if(ww < 200000)
						ww = 200000;
					if(ww > 100000000)
						ww = 100000000;
					w_grid = ww;

				case IDCANCEL:
					EndDialog(hdwnd, 0);
					return TRUE;

				case IDC_INCH:
					val = GetDlgItemInt( hdwnd, IDC_PW, &val, TRUE);
					if(IsDlgButtonChecked( hdwnd, IDC_INCH )){
						if(!f_inch){
							f_inch = 1;
							if(f_change){
								f_change = 0;
								ww = (MM_TO_SP( ((double)val)/100 ));
							}
							SetDlgItemText( hdwnd, IDC_HS, "/1000 inch");
							SendMessage( hdWnd, UDM_SETPOS, 0, 
								(int)(SP_TO_IN(ww*1000)+0.5));
						}
					}else{
						if(f_inch){
							f_inch = 0;
							if(f_change){
								ww = (IN_TO_SP( ((double)val)/1000 ));
							}
							SetDlgItemText( hdwnd, IDC_HS, "/1000 cm");
							SendMessage( hdWnd, UDM_SETPOS, 0, 
								(int)(SP_TO_MM(ww*100)+0.5));
						}
					}
					f_change = 0;
			}
			if( HIWORD(wParam) == EN_CHANGE )
			  f_change = 1;
			break;

		case WM_INITDIALOG:
			SetMargin((HWND)GetDlgItem(hdwnd, IDC_PW));
			ww = w_grid;
			hdWnd = CreateUpDownControl(
				WS_CHILD | WS_VISIBLE | WS_BORDER | UDS_ARROWKEYS
				| UDS_SETBUDDYINT | UDS_ALIGNRIGHT | UDS_NOTHOUSANDS,
				50, 22, 20, 20, 
				hdwnd,
				ID_UPDOWN,
				g_winData.hInstance,
				(HWND)GetDlgItem( hdwnd, IDC_PW),
				50, 20000, 
				f_inch?(int)(SP_TO_IN(ww*1000)+0.5):(int)(SP_TO_MM(ww*100)+0.5));
			f_change = 0;
			CheckDlgButton(hdwnd, IDC_PH, !f_gridO);
			CheckDlgButton(hdwnd, IDC_INCH, f_inch);
			if(!f_inch)
				SetDlgItemText( hdwnd, IDC_HS, "/1000 cm");
			return TRUE;

		case WM_DESTROY:
			break;
	}
	return FALSE;
}

BOOL CALLBACK PaperSizeDlgProc( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	int i, val, val0, val1;
	static HWND hdWnd[2];

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					val0 = GetDlgItemInt( hdwnd, IDC_PW, &val, TRUE);
					val1 = GetDlgItemInt( hdwnd, IDC_PH, &val, TRUE);
					if(IsDlgButtonChecked( hdwnd, IDC_INCH )){
						val0 = (val0*254+50)/100;
						val1 = (val1*254+50)/100;
					}
					if(val0 < 20)
						val0 = 20;
					if(val0 > 20000)
						val0 = 20000;
					if(val1 < 20)
						val1 = 20;
					if(val1 > 20000)
						val1 = 20000;
					common_work[0] = 'F';
					sprintf(common_work+1,"%s:",  print10mm(val0));
					sprintf(common_work + strlen(common_work), 
						print10mm(val1));

				case IDCANCEL:
					EndDialog(hdwnd, 0);
					return TRUE;

				case IDC_INCH:
					val0 = GetDlgItemInt( hdwnd, IDC_PW, &val, TRUE);
					val1 = GetDlgItemInt( hdwnd, IDC_PH, &val, TRUE);
					if(IsDlgButtonChecked( hdwnd, IDC_INCH )){
						SetDlgItemText( hdwnd, IDC_HS, "/100 inch");
						SetDlgItemText( hdwnd, IDC_VS, "/100 inch");
						SendMessage( hdWnd[0], UDM_SETPOS, 0, 
							(val0*100 + 127)/254 );
						SendMessage( hdWnd[1], UDM_SETPOS, 0, 
							(val1*100 + 127)/254 );
					}else{
						SetDlgItemText( hdwnd, IDC_HS, "/100 cm");
						SetDlgItemText( hdwnd, IDC_VS, "/100 cm");
						SendMessage( hdWnd[0], UDM_SETPOS, 0, 
							(val0*254+50)/100 );
						SendMessage( hdWnd[1], UDM_SETPOS, 0, 
							(val1*254+50)/100 );
					}
			}
			break;

		case WM_INITDIALOG:
			common_work[0] = 0;
			SetMargin((HWND)GetDlgItem(hdwnd, IDC_PW));
			SetMargin((HWND)GetDlgItem(hdwnd, IDC_PH));
			for(i = 0; i < 2; i++){
				if(!i){
					val = (double)GetTextXSize()/GetXDpi()*254 + 0.5;
					if(!val)
						val = 2100;
				}else{
					val = GetYDpi();
					if(val == 0)
						val = GetXDpi();
					val = (double)GetTextYSize()/val*254 + 0.5;
					if(!val)
						val = 2970;
				}
				hdWnd[i] = CreateUpDownControl(
					WS_CHILD | WS_VISIBLE | WS_BORDER | UDS_ARROWKEYS
					| UDS_SETBUDDYINT | UDS_ALIGNRIGHT | UDS_NOTHOUSANDS,
					50, 22, 20, 20, 
					hdwnd,
					ID_UPDOWN,
					g_winData.hInstance,
					(HWND)GetDlgItem( hdwnd, (!i)?IDC_PW:IDC_PH),
					20, 20000, val );
			}
			return TRUE;
		
		case WM_DESTROY:
			break;
		
	}
	return FALSE;
}

BOOL CALLBACK DlgPresenProc(HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	int id;
	static int mode;

	switch(message){
		case WM_INITDIALOG:
			mode = g_winData.dviwin.cover_sheet.fOn?(g_winData.dviwin.cover_sheet.bOnForPause?0:1):2;
			CheckRadioButton(hdwnd, IDC_NLINE,IDC_NBOX, IDC_NLINE+g_winData.draw_style);
			CheckRadioButton(hdwnd, IDC_NRED, IDC_NGREEN, IDC_NRED+(g_winData.draw_color&7));
			CheckRadioButton(hdwnd, IDC_NCONP, IDC_NCOFF, IDC_NCONP+mode);
			CheckDlgButton(hdwnd, IDC_NCSEAM, f_seamless);
			CheckDlgButton(hdwnd, IDC_NCSCRP, g_winData.dviwin.cover_sheet.bScrollToPause);
			CheckDlgButton(hdwnd, IDC_NOFF, f_rectcut);
			CheckDlgButton(hdwnd, ID_DTHICK, g_winData.draw_color&F_DTHICK);
			CheckDlgButton(hdwnd, IDC_KSTOP, !f_kill);
resume:		for(id = IDC_NLINE; id <= IDC_NGREEN; id++)
				EnableWindow(GetDlgItem(hdwnd, id), f_rectcut);
			EnableWindow(GetDlgItem(hdwnd, ID_DTHICK), f_rectcut);
//			SetFocus(g_winData.dviwin.hWnd);		<- No effect
			break;

		case WM_COMMAND:
			switch(id = LOWORD(wParam)){
				case ID_PMLOC:
					GetWindowRect(g_winData.hWndPresenMenu, &pmenu);
				case ID_SHAPE:
post:				PostMessage(g_winData.dviwin.hWnd, WM_COMMAND, id, 0);
					return TRUE;
				case ID_UPPAGE:
					if(f_rev_movebutton)
						id = ID_DOWNPAGE;
					goto post;
				case ID_DOWNPAGE:
					if(f_rev_movebutton)
						id = ID_UPPAGE;
					goto post;
				case IDC_NOFF:
					f_Pen = f_rectcut = IsDlgButtonChecked(hdwnd, IDC_NOFF);
					goto resume;
				case IDC_NLINE:
				case IDC_NBOX:
					g_winData.draw_style = id - IDC_NLINE;
					return TRUE;
				case IDC_NRED:
				case IDC_NBLACK:
				case IDC_NBLUE:
				case IDC_NGREEN:
					g_winData.draw_color = (id - IDC_NRED)|(g_winData.draw_color&F_DTHICK);
					CheckMenuSet(ID_DRRED+(g_winData.draw_color&7), ID_DRRED, ID_DRGREEN);
					return TRUE;
				case ID_DTHICK:
					g_winData.draw_color ^= F_DTHICK;
					CheckMenu(ID_DTHICK, g_winData.draw_color&F_DTHICK);
					return TRUE;
				case IDC_NCONP:
				case IDC_NCON:
				case IDC_NCOFF:
					id += (ID_COVERON - IDC_NCON);
					CheckMenuSet(id, ID_COVERSHEET, ID_COVEROFF);
					PostMessage( g_winData.dviwin.hWnd, WM_COMMAND, id, 0);
					return TRUE;
				case IDC_NCSCRP:
					g_winData.dviwin.cover_sheet.bScrollToPause = IsDlgButtonChecked(hdwnd, IDC_NCSCRP);
					CheckMenu(ID_SCROL2PAUSE, g_winData.dviwin.cover_sheet.bScrollToPause);
					return TRUE;
				case IDC_KSTOP:
					f_kill = !IsDlgButtonChecked(hdwnd, IDC_KSTOP);
					CheckMenu(ID_KSTOP, f_kill);
					if(*g_szFileName)
						PostMessage( g_winData.dviwin.hWnd, WM_COMMAND, ID_REOPEN, 0);
					return TRUE;
				case IDC_NCSEAM:
					f_seamless = IsDlgButtonChecked(hdwnd, IDC_NCSEAM);
					CheckMenu(ID_SEAMLESS, f_seamless);
					return TRUE;
				case IDCANCEL:
					GetWindowRect(g_winData.hWndPresenMenu, &pmenu);
					g_winData.hWndPresenMenu = NULL;
					f_pmshow = FALSE;
					DestroyWindow(hdwnd);
					return TRUE;
			}
			break;
		}
	return 0;
}

BOOL CALLBACK DlgSaveParaProc(HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	static HWND hedit1, hedit2, hedit3;
	unsigned char ch;
	FILE *fp;
	char *msg, *pt, *pt2;
	BOOL flg;
#define	buf0	common_work
#define	buf1	(common_work+0x400)
#define	buf2	(common_work+0x500)
#define	buf3	(common_work+0x600)
#define    issjis1(x)      ((x)>=0x81&&(x)<=0xfc&&((x)<=0x9f||(x)>=0xe0))

	switch(message){
		case WM_INITDIALOG:
			hedit1 = GetDlgItem( hdwnd, IDC_EDIT1 );
			hedit2 = GetDlgItem( hdwnd, IDC_EDIT2 );
			hedit3 = GetDlgItem( hdwnd, IDC_EDIT3 );
			msg = (flg = IsJapanese())?"lr SVbN":"Courier New";
			SetFont( 10, hedit1, msg, flg );
			SetFont( 10, hedit2, msg, flg );
			SetFont( 10, hedit3, msg, flg );
			break;

		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_PHELP:
					ShowWinHelp(IDH_PREPARA);
					break;
				case IDC_NOFF:
					CheckDlgButton(hdwnd, IDC_ALLSET, FALSE);
					break;
				case IDC_ALLSET:
					CheckDlgButton(hdwnd, IDC_NOFF, FALSE);
					break;
				case IDOK:
					strcpy(buf1, "^x\\par\\$");
					GetDlgItemText(hdwnd, IDC_EDIT1, buf1+8, 0x10);	// filename
					GetDlgItemText(hdwnd, IDC_EDIT2, buf2, 0x100);	// title
					GetDlgItemText(hdwnd, IDC_EDIT3, buf3, 0x400);	// massage
					if(!strlen(buf2)){
						error(ERRPAUSE, "No Title!");
						break;
					}
					ch = IsDlgButtonChecked(hdwnd, IDC_NOFF)?'`':';';
					SetPath(buf0, buf1);
					strcat(buf0, ".par");
					if(!access(buf0, 0) && 
					  !AskYes("The file exists!\nOverwite it?", buf0))
						goto quit;
					if((fp = fopenf(buf0,"wt")) == NULL){
						error(ERRPAUSE, "Cannot make %s", buf0);
						break;
					}
					msg = "";
					if(IsJapanese()){
						for(pt = buf2; *pt; pt++){
							if(issjis1(*pt)){
								msg = "j";
								break;
							}
						}
					}
					fprintf(fp, ";#%s %s\n", msg, buf2);
					for(msg = pt = buf3; *msg; ){
						while(*pt && *pt != 0x0a && *pt != 0x0d)
							pt++;
						if(!*pt)
							pt2 = pt;
						else if(!pt[1] || pt[0] == pt[1])
							pt2 = pt + 1;
						else
							pt2 = pt+2;
						*pt = 0;
						fprintf(fp, ";%c %s\n", ch, msg);
						pt = msg = pt2;
					}
					fprintf(fp, "%s", msg = 
					  PrintAllPara(IsDlgButtonChecked(hdwnd, IDC_ALLSET)?1:0));
					fclose(fp);
					error(C_MSG, "%s", msg);
					error(DATATITLE, "Saved:%s", buf2);

				case IDCANCEL:
quit:				EndDialog(hdwnd, 0);
					return TRUE;
			}
			break;

		case WM_DESTROY:
			ReSetFont(hedit1);
			ReSetFont(hedit2);
			ReSetFont(hedit3);
			break;
	}
	return 0;
}

/* misc.c */
char *FindFirstW32(char *);
char *FindNextW32(void);
BOOL CALLBACK DlgReadParaProc(HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
#define	MAX_MACRO	256
#define	MAX_MSG		256
	int i, j;
	char msg[MAX_MSG];
	char *s;
	FILE *fp;
	static int max_macro;
	static char path[MAX_PATH];
	static char *mac;
	static HWND hcombo;
	static int mode;

	switch(message){
		case WM_INITDIALOG:
			mode = 0;
			hcombo = GetDlgItem( hdwnd, IDC_LISTBOX1 );
			SetFont( 10, hcombo, IsJapanese()?"lr SVbN":"Courier New", IsJapanese() );
			// SetFontJE(hcombo);
renew:		SetPath(path, mode?"^x\\par\\*.pas":"^x\\par\\*.par");
			max_macro = 0;
			common_work[0]=0;
			SendDlgItemMessage(hdwnd, IDC_LISTBOX1, LB_RESETCONTENT, 0, 0); 
			for(s = FindFirstW32(path); s != NULL && max_macro < MAX_MACRO;
			  s = FindNextW32()){
				sprintf(path, "^x\\par\\%s", s);
				if((fp = fopenf(path, "r")) != NULL){
					*msg = i = 0;
					while(!i && fgets(msg, MAX_PATH, fp) && *msg==';'){
						if(msg[1]=='#'){
							switch(msg[2]){
								case 'j':
									i = f_English?0:3;
									break;
								case 'e':
									i = f_English?3:0;
									break;
								default:
									i = 2;
							}
						}
					}
					fclose(fp);
					if(i){
						if(msg[i] == ' ')
							i++;
						strcat(common_work, s);
						strcat(common_work, "\n");
						j = strlen(msg);
						while(j > 0 && msg[--j] <= ' ' && msg[j] > 0)
							msg[j] = 0;
						SendDlgItemMessage(hdwnd, IDC_LISTBOX1, LB_ADDSTRING, 0,
						  (LPARAM)msg+i); 
						max_macro++;
					}
				}
			}
			if(max_macro >= MAX_MACRO)
				error(WARNING, "Too many (> %d) %s parameter files\nSome of them are ignored", 
					MAX_MACRO, mode?"Hidden":"");
			FindFirstW32(NULL);
			if(mac)
				Free0(mac);
			mac = dup_string(common_work);
			SendDlgItemMessage(hdwnd, IDC_LISTBOX1, LB_SETCURSEL, 0, 0);
			SetFocus(GetDlgItem(hdwnd, IDC_LISTBOX1));
			break;

		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_PHELP:
					ShowWinHelp(IDH_PREPARA);
					break;

				case IDC_HIDDEN:	// <-> Current
					mode = 1-mode;
					SetDlgItemText(hdwnd, IDC_HIDDEN, mode? "->Curr&ent":"->Hidd&en");
					SetDlgItemText(hdwnd, IDC_ERACE, mode? "&Appear":"Hi&de");
					SetDlgItemText(hdwnd, ID_SAVE, mode? "Ki&ll":"&Save");
					goto renew;

				case ID_SAVE:		// <-> Kill
					if(!mode){
						DialogBox(g_winData.hInstance,
							MAKEINTRESOURCE(IDD_SAVEPARA),
							hdwnd, DlgSaveParaProc);
						goto renew;
					}
				case IDC_EDIT10:
				case IDC_ERACE:		// <-> Appear
				case IDOK:
					i = SendDlgItemMessage(hdwnd, IDC_LISTBOX1,
						LB_GETCURSEL, 0, 0L);
					if(!max_macro)
						return TRUE;
					if(i<0 && i >= max_macro)
						break;
					s = mac;
					while(i--){
						while(*s && *s++ != '\n');
					}
					i = 0;
					while(s[i] && s[i] != '\n')
						i++;
					s[i] = 0;
					j = (s[0] == '$' && s[1] == '_')?0x1000:0;
					sprintf(common_work, "^x\\par\\%s", s);
					s[i] = '\n';
					strncpy(common_work+0x800, common_work, MAX_PATH);
					SetPath(common_work+0x1000, common_work+0x800);
					if(LOWORD(wParam) == IDC_ERACE){			// Hide/Appear
						strcpy(common_work, common_work+0x1000);
						common_work[strlen(common_work)-1] =
							mode?'r':'s';
						if(rename(common_work+0x1000, common_work)){
							if(!access(common_work, 0) && MessageBox( g_winData.hMainWnd, 
							  common_work, 
							  "Duplicate file exists!\nErace the above?", 
							  MB_OKCANCEL) == IDOK ){
								unlink(common_work);
								if(!rename(common_work+0x1000, common_work))
									goto renew;
							}
							error(WARNING, "Cannot rename %s", common_work+0x1000);
							break;
						}
						goto renew;
					}else if(LOWORD(wParam) == ID_SAVE){		// Kill
						CheckParaFile(common_work+0x1000, "\nErace the above parameter file?");
						j = MessageBox( g_winData.hMainWnd, 
							common_work, common_work+0x1000, MB_OKCANCEL);
						if(j == IDOK){
							unlink(common_work+0x1000);
							goto renew;
						}
					}else if(LOWORD(wParam) == IDC_EDIT10){		// Edit0
						EditFile(common_work+0x1000);
						break;
					}else{										// Ok
						j |= CheckParaFile(common_work+0x800, NULL);
						if(!mode & !(j&0x1f)){
							if(j & 0x1000)
								goto instreg;
							goto readpara;
						}
						j = MessageBox( g_winData.hMainWnd, 
								common_work, common_work+0x1000, (j&0x1000)?
								MB_YESNOCANCEL:MB_OKCANCEL);
						if(j == IDYES){
instreg:					Install2Reg(common_work+0x1000);
							goto quit;
						}else if(j == IDNO || j == IDOK){
readpara:					set_config(common_work+0x1000);
							goto quit;
						}
					}
					break;

				case IDCANCEL:
quit:				Free0(mac);
					mac=NULL;
					EndDialog(hdwnd, 0);
					return TRUE;
			}
			break;

		case WM_DESTROY:
			ReSetFont(hcombo);
			break;

	}
	return 0;
}
