
; Datei: DVIPKCH.S
; Autor: Ingo Eichenseher
; Letzte Aenderung: 09.04.1991 07:29


nyb_ptr		equ		a6
nyb_sub		equ		a5
addr		equ		a4
laddr		equ		a3
lmask		equ		a2
base		equ		a1

r			equ		d0
count		equ		d1
count1		equ		d2
dyn_f		equ		d3
xx			equ		d4
state		equ		d5
mask		equ		d6
ww			equ		d7

paddr		equ		nyb_ptr
pmask		equ		dyn_f
yy			equ		xx

c_dyn_f		equ		4
c_state		equ		6
c_w			equ		28
c_h			equ		32
c_hoff		equ		36
c_voff		equ		40
c_data		equ		44


			import		frame_buffer
			import		frame_width
			import		frame_height
			import		frame_size
			
			export		draw_char
			export		draw_rule
			export		ldraw_char
			
			code

get_hnyb:	move.b	(nyb_ptr),d0
			lea.l	get_lnyb(pc),nyb_sub
			lsr.b	#4,d0
			rts
get_lnyb:	move.b	(nyb_ptr)+,d0
			lea.l	get_hnyb(pc),nyb_sub
			and.b	#$0f,d0
			rts

pk_pnum:	clr.w	d0
			jsr		(nyb_sub)
			bne.b	pk_pnz
			moveq	#-1,count
pk_pzlop:	addq	#1,count
			jsr		(nyb_sub)
			beq.b	pk_pzlop
			clr.w	count1
			move.b	d0,count1
pk_pzlop1:	jsr		(nyb_sub)
			lsl.w	#4,count1
			or.b	d0,count1
			dbra	count,pk_pzlop1
			sub.w	#15,count1
			add.w	dyn_f,count1
			move.w	#13,d0
			sub.w	dyn_f,d0
			lsl.w	#4,d0
			add.w	count1,d0			
			bra.b	pk_end

pk_pnz:		cmp.b	dyn_f,d0
			ble.b	pk_end

pk_pod:		cmp.b	#14,d0
			blt.b	pk_plt14
			
			bne.b	pk_peq15
			bsr.b	pk_pnum
			move.w	d0,rep_cnt(base)
			bra.b	pk_pnum
			
pk_peq15:	move	#1,rep_cnt(base)
			bra.b	pk_pnum

pk_plt14:	subq.w	#1,d0
			sub.w	dyn_f,d0
			lsl		#4,d0
			move.w	d0,d1
			jsr		(nyb_sub)
			or.b	d1,d0
			add.w	dyn_f,d0
			addq.w	#1,d0
pk_end:		rts


; void draw_char(pk_char *c, int x, int y)

draw_char:	movem.l	d2-d7/a1-a6,-(sp)
			lea.l	base_addr,base
			sub.w	c_hoff+2(a0),d0
			sub.w	c_voff+2(a0),d1
			move.w	c_dyn_f(a0),dyn_f		; set dyn_f register

macro		calc_laddr	draw_end
			local	draw_px,draw_nx,draw_l3
			move.w	d1,y(base)
			cmp.w	frame_height,d1
			bge		draw_end
			muls	frame_width,d1			; length * y
			ext.l	d0
			bpl.b	draw_px

			subq	#7,d0					; x-7
			divs	#8,d0					; (x-7)/8
			swap	d0
			addq.w	#7,d0					; (x-7)%8+7
			swap	d0
			bra.b	draw_nx
			
draw_px:	divs	#8,d0					; x / 8
draw_nx:	move.w	d0,x(base)
			move.l	frame_buffer,laddr		; laddr = frame_buffer
			adda.l	d1,laddr				; laddr += length * 8
			adda.w	d0,laddr				; laddr += x/8
			swap	d0
			tst.w	d0						; x % 8
			bne.b	draw_l3
			subq.l	#1,laddr
			subq.w	#1,x(base)
draw_l3:	moveq	#1,mask
			ror.b	d0,mask
			move.w	mask,lmask

endm
			calc_laddr draw_end
			move.w	c_w+2(a0),w(base)
			subq.w	#1,w(base)
			bmi		draw_end
			move.w	c_h+2(a0),h(base)
			
			cmp.w	#14,dyn_f
			bne.b	draw_packd

			lea		c_data(a0),paddr
			moveq	#7,pmask
draw_p1:	subq.w	#1,h(base)
			bmi		draw_end
			move.w	w(base),ww
			move.w	x(base),xx
			move.l	laddr,addr
			move.w	lmask,mask
draw_p2:	ror.b	#1,mask
			bcc.b	draw_p3
			addq	#1,addr
			addq.w	#1,xx
draw_p3:	btst.b	pmask,(paddr)
			beq.b	draw_p4
			tst.w	y(base)
			bmi.b	draw_p4
			tst.w	xx
			bmi.b	draw_p4
			cmp.w	frame_width,xx
			bge.b	draw_p4
			or.b	mask,(addr)
draw_p4:	subq	#1,pmask
			bpl.b	draw_p5
			moveq	#7,pmask
			addq	#1,paddr
draw_p5:	dbra	ww,draw_p2
			adda.w	frame_width,laddr
			addq.w	#1,y(base)
			move.w	y(base),xx
			cmp.w	frame_height,xx
			bge		draw_end
			bra.b	draw_p1


draw_packd:	lea		c_data(a0),nyb_ptr		; nyb_ptr = data
			lea.l	get_hnyb(pc),nyb_sub	; Get hi-nyble next
			moveq	#-1,state
			tst.w	c_state(a0)				; Get state
			bne.b	draw_l4
			neg.w	state
draw_l4:	clr.w	rep_mode(base)
			clr.w	rep_cnt(base)
			clr.w	r

draw_lop1:	tst.w	h(base)
			ble		draw_end
			clr.w	rep_cnt(base)
			move.w	lmask,mask
			move.l	laddr,addr
			move.w	w(base),ww
			move.w	x(base),xx
			movem.w	state/r,(base)
			movem.l	nyb_sub/nyb_ptr,save2(base)
			
			tst.w	state
			bmi.b	draw_w1
			bra.b	draw_b1
						
draw_bw:	bsr		pk_pnum
			neg.w	state
			bmi.b	draw_w1
			
draw_b1:	subq.w	#1,r
			bmi.b	draw_bw
			ror.b	#1,mask
			bcc.b	draw_b2
			addq	#1,addr
			addq.w	#1,xx
draw_b2:	tst.w	y(base)
			bmi.b	draw_b2a
			tst.w	xx
			bmi.b	draw_b2a
			cmp.w	frame_width,xx
			bge.b	draw_b2a
			or.b	mask,(addr)
draw_b2a:	dbra	ww,draw_b1
			bra.b	draw_lend
			
draw_w1:	subq	#1,r
			bmi.b	draw_bw
			ror.b	#1,mask
			bcc.b	draw_w2
			addq	#1,addr
			addq.w	#1,xx
draw_w2:	dbra	ww,draw_w1

draw_lend:	adda.w	frame_width,laddr
			addq.w	#1,y(base)
			move.w	y(base),xx
			cmp.w	frame_height,xx
			bge		draw_end
			subq.w	#1,h(base)
			tst.w	rep_mode(base)
			bne.b	draw_l1
			tst.w	rep_cnt(base)
			beq		draw_lop1
			move.w	rep_cnt(base),rep_mode(base)
			addq.w	#1,rep_mode(base)
draw_l1:	subq.w	#1,rep_mode(base)
			beq		draw_lop1
			movem.w	(base),state/r
			movem.l	save2(base),nyb_sub/nyb_ptr
			bra		draw_lop1
			
draw_end:	movem.l	(sp)+,d2-d7/a1-a6
			rts	

; void draw_rule(int x, int y, int w, int h)

h_off		equ		52

draw_rule:	movem.l d2-d7/a1-a6,-(sp)
			lea.l	base_addr,base
			subq.w	#1,d2
			move.w	h_off(sp),h(base)
			move.w	d2,w(base)
			calc_laddr draw_rend

draw_r1:	subq.w	#1,h(base)
			bmi		draw_rend
			move.w	w(base),ww
			move.w	x(base),xx
			move.l	laddr,addr
			move.w	lmask,mask
draw_r2:	ror.b	#1,mask
			bcc.b	draw_r3
			addq	#1,addr
			addq.w	#1,xx
draw_r3:	tst.w	y(base)
			bmi.b	draw_r4
			tst.w	xx
			bmi.b	draw_r4
			cmp.w	frame_width,xx
			bge.b	draw_r4
			or.b	mask,(addr)
draw_r4:	dbra	ww,draw_r2
			adda.w	frame_width,laddr
			addq.w	#1,y(base)
			move.w	y(base),xx
			cmp.w	frame_height,xx
			blt.b	draw_r1
			
draw_rend:	movem.l	(sp)+,d2-d7/a1-a6
			rts	

ldraw_char:	movem.l	d2-d7/a1-a6,-(sp)
			lea.l	base_addr,base
			add.w	c_voff+2(a0),d0
			sub.w	c_hoff+2(a0),d1
			move.w	c_dyn_f(a0),dyn_f		; set dyn_f register

			move.w	d1,y(base)
			cmp.w	frame_height,d1
			bge		ldraw_end
			muls	frame_width,d1			; length * y
			ext.l	d0
			bpl.b	ldraw_px

			subq	#7,d0					; x-7
			divs	#8,d0					; (x-7)/8
			swap	d0
			addq.w	#7,d0					; (x-7)%8+7
			swap	d0
			bra.b	ldraw_nx
			
ldraw_px:	divs	#8,d0					; x / 8
ldraw_nx:	move.w	d0,x(base)
			bmi		ldraw_end
			move.l	frame_buffer,laddr		; laddr = frame_buffer
			adda.l	d1,laddr				; laddr += length * 8
			adda.w	d0,laddr				; laddr += x/8
			swap	d0
			tst.w	d0						; x % 8
			move.b	#128,mask
			ror.b	d0,mask
			move.w	mask,lmask

			move.w	c_w+2(a0),w(base)
			subq.w	#1,w(base)
			bmi		ldraw_end
			move.w	c_h+2(a0),h(base)
			
			cmp.w	#14,dyn_f
			bne.b	ldraw_packd

			lea		c_data(a0),paddr
			moveq	#7,pmask
ldraw_p1:	subq.w	#1,h(base)
			bmi		ldraw_end
			move.w	w(base),ww
			move.l	laddr,addr
			move.w	y(base),yy
ldraw_p2:	btst.b	pmask,(paddr)
			beq.b	ldraw_p4
			tst.w	yy
			bmi.b	ldraw_p4
			cmp.w	frame_height,yy
			bge.b	ldraw_p4
			move.w	x(base),count
			cmp.w	frame_width,count
			bge.b	ldraw_p4
			or.b	mask,(addr)
ldraw_p4:	subq	#1,pmask
			bpl.b	ldraw_p5
			moveq	#7,pmask
			addq	#1,paddr
ldraw_p5:	adda.w	frame_width,addr
			addq	#1,yy
			dbra	ww,ldraw_p2
			rol.b	#1,mask
			bcc.b	ldraw_p1
			subq	#1,laddr
			subq	#1,x(base)
			bpl.b	ldraw_p1
			bra		ldraw_end
			
ldraw_packd:lea		c_data(a0),nyb_ptr		; nyb_ptr = data
			lea.l	get_hnyb(pc),nyb_sub	; Get hi-nyble next
			moveq	#-1,state
			tst.w	c_state(a0)				; Get state
			bne.b	ldraw_l4
			neg.w	state
ldraw_l4:	clr.w	rep_mode(base)
			clr.w	rep_cnt(base)
			clr.w	r

ldraw_lop1:	tst.w	h(base)
			ble		ldraw_end
			clr.w	rep_cnt(base)
			move.l	laddr,addr
			move.w	w(base),ww
			move.w	y(base),yy
			movem.w	state/r,(base)
			movem.l	nyb_sub/nyb_ptr,save2(base)
			
			tst.w	state
			bmi.b	ldraw_w1
			bra.b	ldraw_b1
			
ldraw_bw:	bsr		pk_pnum
			neg.w	state
			bmi.b	ldraw_w1
			
ldraw_b1:	subq.w	#1,r
			bmi.b	ldraw_bw
			tst.w	yy
			bmi.b	ldraw_b2a
			cmp.w	frame_height,yy
			bge.b	ldraw_b2a
			move.w	x(base),count
			cmp.w	frame_width,count
			bge.b	ldraw_b2a
			or.b	mask,(addr)
ldraw_b2a:	adda.w	frame_width,addr
			addq	#1,yy
			dbra	ww,ldraw_b1
			bra.b	ldraw_lend

ldraw_w1:	subq.w	#1,r
			bmi.b	ldraw_bw
			adda.w	frame_width,addr
			addq	#1,yy
			dbra	ww,ldraw_w1

ldraw_lend:	rol.b	#1,mask
			bcc.b   ldraw_l2
			subq	#1,laddr
			subq.w	#1,x(base)
			bmi.b	ldraw_end
ldraw_l2:	subq.w	#1,h(base)
			tst.w	rep_mode(base)
			bne.b	ldraw_l1
			tst.w	rep_cnt(base)
			beq		ldraw_lop1
			move.w	rep_cnt(base),rep_mode(base)
			addq.w	#1,rep_mode(base)
ldraw_l1:	subq.w	#1,rep_mode(base)
			beq		ldraw_lop1
			movem.w	(base),state/r
			movem.l	save2(base),nyb_sub/nyb_ptr
			bra		ldraw_lop1
			
ldraw_end:	movem.l	(sp)+,d2-d7/a1-a6
			rts	

			offset

save1:		ds.w	2
save2:		ds.l	2
rep_mode:	ds.w	1
rep_cnt:	ds.w	1
w:			ds.w	1
h:			ds.w	1
x:			ds.w	1
y:			ds.w	1
size:		ds.w	0

			bss

base_addr:	ds.w	size/2

			end
