
#include "stat.h"

static void translate(int ver, struct stat *kernel, struct stat *app0)
{
	switch(ver){
	case 0:
#define STATSTRUCT stat0
#include "translation.h"

	case 1:
#define STATSTRUCT stat1
#include "translation.h"

	default:
		fprintf(stderr,"Stat type %d not yet supported\n", ver);
		fprintf(stderr,
			"Please define this stat type in your zlibc/stat.h\n");
		errno = EINVAL;
		return -1;
	}
}

int _xstat(int ver, __const char *name, struct stat *buf)
{
	struct stat buf0;
	int ret;

	if ( ver == LINUX_STAT_VERSION){
		return zlibc_stat(name, buf);
	} else {
		ret = zlibc_stat(name, &buf0);
		translate(ver,&buf0, buf);
		return ret;
	}
}

int _lxstat(int ver, __const char *name, struct stat *buf)
{
	struct stat buf0;
	int ret;

	if ( ver == LINUX_STAT_VERSION){
		return zlibc_lstat(name, (struct stat *)buf);
	} else {
		ret = zlibc_lstat(name, &buf0);
		translate(ver,&buf0, buf);
		return ret;
	}
