/*
 *   Copyright (C) 2000 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <mysql.h>
#include <string.h>
#include <stdlib.h>

#include <salloc.h>
#include <server.h>
#include <sqlutil.h>

static webbase_hook_params_t* hook = 0;

int server_hook(webbase_hook_params_t* hook_arg)
{
  hook = hook_arg;
  return 1;
}


static char* url2server(const char* url)
{
  if(hook && hook->url2server) {
    return hook->url2server(hook, url);
  } else {
    static uri_t* url_object = 0;
    int url_length = strlen(url);

    if(!url_object) {
      url_object = uri_alloc((char*)url, url_length);
    } else {
      uri_realloc(url_object, (char*)url, url_length);
    }

    return strdup(uri_netloc(url_object));
  }
}

int server_id(webbase_t* base, const char* url)
{
  static char* query = 0;
  static int query_size = 0;
  char* server = url2server(url);
  char rowid_string[WEBBASE_INTEGER_VALUE_SIZE + 1];
  int ret = 0;

  static_alloc(&query, &query_size, strlen(server) + 256);
  sprintf(query, "select rowid from servers where server = '%s'", server);
  if(sql_select_value(&base->mysql, query, rowid_string, WEBBASE_INTEGER_VALUE_SIZE)) {
    ret = atoi(rowid_string);
  } else {
    fprintf(stderr, "server_id: failed to retrieve record in servers for server %s\n", server);
  }

  free(server);
  return ret;
}

int server_add(webbase_t* base, const char* url)
{
  static char* query = 0;
  static int query_size = 0;
  char* server = url2server(url);
  char rowid_string[WEBBASE_INTEGER_VALUE_SIZE + 1];

  static_alloc(&query, &query_size, strlen(server) + 256);
  sprintf(query, "select rowid from servers where server = '%s'", server);
  if(sql_select_value(&base->mysql, query, rowid_string, WEBBASE_INTEGER_VALUE_SIZE)) {
    sprintf(query, "update servers set refcount = refcount + 1 where rowid = %s\n", rowid_string);
    smysql_query(&base->mysql, query);
    return atoi(rowid_string);
  } else {
    sprintf(query, "insert into servers (server, refcount) values ('%s', 1)", server);
    smysql_query(&base->mysql, query);
    return mysql_insert_id(&base->mysql);
  }
}

int server_remove(webbase_t* base, const char* url)
{
  static char* query = 0;
  static int query_size = 0;
  char* server = url2server(url);
  MYSQL_RES *res;
  MYSQL_ROW row;
  int ret = 1;
  
  static_alloc(&query, &query_size, strlen(server) + 256);
  sprintf(query, "select rowid,refcount from servers where server = '%s'", server);
  smysql_query(&base->mysql, query);
  res = smysql_store_result(&base->mysql);

  if(mysql_num_rows(res) > 0) {
    if((row = mysql_fetch_row(res))) {
      if(!row[0] || !row[1]) {
	fprintf(stderr, "server_remove: unexpectd null value for rowid or refcount at server %s\n", server);
	ret = 0;
      } else {
	int refcount = atoi(row[1]);
	if(refcount <= 1) {
	  sprintf(query, "delete from servers where rowid = %s", row[0]);
	} else {
	  sprintf(query, "update servers set refcount = refcount - 1 where rowid = %s", row[0]);
	}
	smysql_query(&base->mysql, query);
      }
    }
  } else {
    fprintf(stderr, "server_remove: failed to drop entry for server %s because no row found in servers table\n", server);
    ret = 0;
  }

  mysql_free_result(res);
  free(server);

  return ret;
}
