/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#include <stdio.h>
#if HAVE_STRING_H
# include <string.h>
# include <memory.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif

#ifndef HAVE_STRNCASECMP
#include <strncasecmp.h>
#endif /* HAVE_STRNCASECMP */
#include <salloc.h>
#include <regex.h>
#include <string2time.h>

/*
 * To test the expression go in emacs, lisp-interaction and copy something
 * like 
 *
 * (re-search-forward "^\\w+,\\W+\\([0-9]+\\)\\W+\\(\\w+\\)\\W+\\(19[0-9][0-9]\\|20[0-9][0-9]\\|[0-9][0-9]\\)\\W+\\([0-9]+\\):\\([0-9]+\\):\\([0-9]+\\)")
 * 
 * Fri, 12 Dec 1997 08:38:18 GMT
 * 
 * (re-search-forward "^\\w+,\\W+\\(\\w+\\)\\W+\\([0-9]+\\)\\W*,\\W+\\(19[0-9][0-9]\\|20[0-9][0-9]\\|[0-9][0-9]\\)\\W+\\([0-9]+\\):\\([0-9]+\\):\\([0-9]+\\)")
 *
 * Wednesday, April 01, 1998 16:00:05 GMT
 *
 * in the buffer. Go at the end of the re-search line and type ^j. If it
 * beeps, it failed. Otherwise it prints a number at the end of the match.
 * The only (but important difference is that in emacs ()| should be \'ed.
 */

#define STRING2TIME_MDAY	1
#define STRING2TIME_MONTH	2
#define STRING2TIME_YEAR	3
#define STRING2TIME_HOUR	4
#define STRING2TIME_MIN		5
#define STRING2TIME_SEC		6

#define STRING2TIME_NSUB	6

#define TIME_REGEXP_SIZE 2

static int time_pos_tables[TIME_REGEXP_SIZE][STRING2TIME_NSUB + 1] = {
#define TIME_REGEXP "^\\w+,\\W+([0-9]+)\\W+(\\w+)\\W+(19[0-9][0-9]|20[0-9][0-9]|[0-9][0-9])\\W+([0-9]+):([0-9]+):([0-9]+)"
  { 0, STRING2TIME_MDAY, STRING2TIME_MONTH, STRING2TIME_YEAR, STRING2TIME_HOUR, STRING2TIME_MIN, STRING2TIME_SEC },

#define TIME_REGEXP1 "^\\w+,\\W+(\\w+)\\W+([0-9]+)\\W*,\\W+(19[0-9][0-9]|20[0-9][0-9]|[0-9][0-9])\\W+([0-9]+):([0-9]+):([0-9]+)"
  { 0, STRING2TIME_MONTH, STRING2TIME_MDAY, STRING2TIME_YEAR, STRING2TIME_HOUR, STRING2TIME_MIN, STRING2TIME_SEC }
};

static regmatch_t matches[STRING2TIME_NSUB + 1];

static char* time_regexp_string[] = {
  TIME_REGEXP,
  TIME_REGEXP1
};
static regex_t* time_regexp[TIME_REGEXP_SIZE];

time_t string2time(char* string)
{
  struct tm t;
  int code;
  int i;
  int found = 0;
  int* time_pos = 0;

  if(strlen(string) <= 0) return 0;

  memset((char*)&t, '\0', sizeof(struct tm));
  if(time_regexp[0] == 0) {
    for(i = 0; i < TIME_REGEXP_SIZE; i++) {
      time_regexp[i] = (regex_t*)smalloc(sizeof(regex_t));
      memset((char*)time_regexp[i], '\0', sizeof(regex_t));
      if((code = regcomp(time_regexp[i], time_regexp_string[i], REG_EXTENDED)) != 0) {
	char error[10240];
	regerror(code, time_regexp[i], error, 10240);
	fprintf(stderr, "string2time: compilation of regexp failed : %s\n", error);
	regfree(time_regexp[i]);
	return 0;
      }
      if(time_regexp[i]->re_nsub != STRING2TIME_NSUB) {
	fprintf(stderr, "string2time: nsub != 6 : %d\n", time_regexp[i]->re_nsub);
	return 0;
      }
    }
  }

  for(i = 0; i < TIME_REGEXP_SIZE; i++) {
    if((code = regexec(time_regexp[i], string, STRING2TIME_NSUB + 1, matches, 0)) == 0) {
      time_pos = time_pos_tables[i];
      found = 1;
      break;
    }
  }

  if(!found) {
    fprintf(stderr, "string2time: cannot match %s\n", string);
    return 0;
  }

  {
    int i;
    for(i = 1; i <= STRING2TIME_NSUB; i++)
      string[matches[i].rm_eo] = '\0';
  }
  t.tm_mday = atoi(&string[matches[time_pos[STRING2TIME_MDAY]].rm_so]);
  {
    char* p = string + matches[time_pos[STRING2TIME_MONTH]].rm_so;
#define moncmp(m, n) \
    } else if(!strncasecmp(p, (m), 3)) { \
      t.tm_mon = (n)
    if(!strncasecmp(p, "jan", 3)) {
      t.tm_mon = 0;
      moncmp("feb", 1);
      moncmp("mar", 2);
      moncmp("apr", 3);
      moncmp("may", 4);
      moncmp("jun", 5);
      moncmp("jul", 6);
      moncmp("aug", 7);
      moncmp("sep", 8);
      moncmp("oct", 9);
      moncmp("nov", 10);
      moncmp("dec", 11);
    } else {
      fprintf(stderr, "string2time: unknown month %s\n", p);
    }
  }
  {
    char* p = string + matches[time_pos[STRING2TIME_YEAR]].rm_so;
    if(strlen(p) > 2) {
      if(!strncmp(p, "20", 2)) {
	t.tm_year += 100;
      }
      p += 2;
    }
    t.tm_year += atoi(p);
  }
  t.tm_hour = atoi(&string[matches[time_pos[STRING2TIME_HOUR]].rm_so]);
  t.tm_min = atoi(&string[matches[time_pos[STRING2TIME_MIN]].rm_so]);
  t.tm_sec = atoi(&string[matches[time_pos[STRING2TIME_SEC]].rm_so]);

  return mktime(&t);
}
