/* swcommon0.h - lowest level common header file
  
   COPYING TERMS AND CONDITIONS:
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef swcommon0_200212j_h
#define swcommon0_200212j_h

#include "swuser_config.h"
#include "swuser_assert_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef DEFAULT_PAX_W 
#define DEFAULT_PAX_W "pax"
#endif
#ifndef DEFAULT_PAX_R 
#define DEFAULT_PAX_R "pax"
#endif

volatile int global_lastsig;

#define PAX_READ_COMMANDS_LEN	10
#define PAX_WRITE_COMMANDS_LEN	10
#define SW_UTILNAME		"swutility"
#define REPORT_BUGS		"<bug-swbis@gnu.org>"
#define SWC_PID_ARRAY_LEN	30
#define SWC_TARGET_FD_ARRAY_LEN	10
#define SWC_SCRIPT_SLEEP_DELAY	0 /* Seconds to sleep a the end of the script */
				/* in order to help ssh not drop any bytes. */
				/* Using recent GNU/Linux releases this can be */
				/* set to zero '0' */

#define CMD_TAINTED_CHARS  "'|\"*?;&<>`$"
#define SW_FAILED_ALL_TARGETS		1
#define SW_FAILED_SOME_TARGETS		2
#define SIGNER_PGP5_BIN			"pgps"
#define SIGNER_PGP26_BIN		"pgp"
#define SIGNER_GPG_BIN			"gpg"

#define SWBIS_TARGET_CTL_MSG_125 	"125 target script started"
#define SWBIS_TARGET_CTL_MSG_128 	"128 catalog path determined"
#define SWBIS_TARGET_CTL_MSG_508 	"508 target script error"

#define SWINSTALL_DO_SOURCE_CTL_MESSAGE		(swutil_x_mode && local_stdin == 0)
#define SWBIS_SWINSTALL_SOURCE_CTL_ARCHIVE	"130 source is from archive"
#define SWBIS_SWINSTALL_SOURCE_CTL_DIRECTORY 	"140 source is from directory"

#define SWCOPY_DO_SOURCE_CTL_MESSAGE		(swutil_x_mode && local_stdin == 0)
#define SWBIS_SWCOPY_SOURCE_CTL_ARCHIVE		"130 source is from archive"
#define SWBIS_SWCOPY_SOURCE_CTL_DIRECTORY 	"140 source is from directory"


#define SWPARSE_AT_LEVEL	0
#define VERBOSE_LEVEL2		2
#define VERBOSE_LEVEL3		3
#define LCEXIT(arg)		swc_lc_exit(G, __FILE__, __LINE__, arg)
#define LC_RAISE(arg)		swc_lc_raise(G, __FILE__, __LINE__, arg)
#define LOCAL_RSH_BIN 			"rsh"
#define REMOTE_RSH_BIN 			"rsh"
#define LOCAL_SSH_BIN 			"ssh"
#define REMOTE_SSH_BIN 			"ssh"
#define SWC_PID_ARRAY_LEN			30
#define MAX_CONTROL_MESG_LEN			2000

struct g_pax_write_command {
	char * idM;
	char * commandM;
};

struct g_pax_read_command {
	char * idM;
	char * commandM;
	char * verbose_commandM;
	char * keep_commandM;
};

typedef struct {
	int codeM;
} ERRORCODE;

ERRORCODE * createErrorCode(void);
void destroyErrorCode(ERRORCODE * EC);
void swc_setErrorCode(ERRORCODE * EC, int code, char *);
int swc_getErrorCode(ERRORCODE * EC);

int swc0_set_arf_format(char * optarg, int * format_arf, int * do_gnutar,
	int * do_bsdpax3, int * do_oldgnuposix);
  
int swc0_process_w_option(STROB * tmp, CPLOB * w_arglist, char * i_optarg,
	int * w_argc_p);

void swc0_create_parser_buffer(void);

#endif
