/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 dialog.h - dialogs for displaying messages and getting simple input

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef DIALOG_H
#define DIALOG_H

void dialog_error(const char *wintitle, const char *title, const char *text,
		  const char *opt);
void dialog_warning(const char *wintitle, const char *title, const char *text,
		    const char *opt);
void dialog_message(const char *wintitle, const char *title, const char *text,
		    const char *opt);
int dialog_confirm(const char *wintitle, const char *title, const char *text1,
		   const char *text2, const char *text3);

char *dialog_input_opendir(const char *title, const char *startpath);
int dialog_input_select_string(const char *title, const char *text,
			       struct srcinst_string_list *s);

int dialog_input_package2(const char *title, char **filename,
			  char **packagename);

int dialog_configure(struct srcinst_configure_sets *opts, char **prefix,
		     struct srcinst_string_list *s, char *old_configure);

char *dialog_input_export_info(const char *title, char *defaultname,
			       SRCINST_EXPORT * fmt);

char *dialog_input_export_bin(const char *title, char *defaultname,
			      SRCINST_COMP fmt);

#endif				/* DIALOG_H */
