/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 src_stdinc.h - common header inclusions

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef SRC_STDINC_H
#define SRC_STDINC_H

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

#ifdef HAVE_CTYPE_H
# include <ctype.h>
#endif

#ifdef HAVE_STRING_H
# include <string.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif

#ifdef HAVE_SIGNAL_H
# include <signal.h>
#endif

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#ifdef HAVE_DIRENT_H
# include <dirent.h>
#else
# define dirent direct
# ifdef HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# ifdef HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# ifdef HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
#endif

#ifdef HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif

#include "getopt.h"
#include "fnmatch.h"
#include "regex.h"
#include "assert.h"

#include "dirname.h"
#include "exit.h"
#include "getcwd.h"
#include "inttostr.h"
#include "lstat.h"
#include "pipe.h"
#include "stat-macros.h"
#include "strdup.h"
#include "strstr.h"

#include "gettext.h"
#define _(msgid)            dgettext (PACKAGE, msgid)
#define N_(msgid)           gettext_noop (msgid)
#define S_(msg1, msg2, num) dngettext (PACKAGE, msg1, msg2, num)

#if SIZEOF_OFF_T == SIZEOF_INT
# define OFF_FMT "%d"
#elif SIZEOF_OFF_T == SIZEOF_LONG
# define OFF_FMT "%ld"
#else
# define OFF_FMT "%lld"
#endif

#include "srcinst_internal.h"

#endif				/* SRC_STDINC_H */
