/* Source Installer, Copyright (c) 2005 Claudio Fontana

   preferences.h - user choices saved in the preferences file

   This program is free software; you can redistribute it and/or modify
       it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
       (at your option) any later version.

   This program is distributed in the hope that it will be useful,
       but WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
       GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
       along with this program (look for the file called COPYING);
       if not, write to the Free Software Foundation, Inc.,
           51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

       You can contact the author (Claudio Fontana) by sending a mail
       to claudio@gnu.org
*/

#ifndef SRCINST_PREFERENCES_H
#define SRCINST_PREFERENCES_H

struct _preferences {
  char* add_directory;
  char* prefix;
  SRCINST_COMP src_compress;
  char manual_configure;
  char install;
  char quiet;
  char keep_source;
  char strip;
};

#define SRCINST_PREFERENCES_NKEYS 8
enum {
  SRCINST_PKEY_ADD_DIRECTORY,
  SRCINST_PKEY_INSTALL,
  SRCINST_PKEY_KEEP_SOURCE,
  SRCINST_PKEY_MANUAL_CONFIGURE,
  SRCINST_PKEY_PREFIX,
  SRCINST_PKEY_QUIET,
  SRCINST_PKEY_SRC_COMPRESS,
  SRCINST_PKEY_STRIP
};

extern struct srcinst_parsed_data _keywords_preferences[];

/* initialize a preferences structure with the default values. */
void _init_preferences(struct _preferences* p);

/* free memory allocated inside the structure */
void _free_preferences(struct _preferences* p);

/* the preferences-specific parse function. Referenced by the load function */

int _parse_preferences(struct _preferences* p, char* k, char* s);

/* the preferences file load function.
   It calls the generic srcinst_load_parse_file() function */

int _load_preferences(struct _preferences* p);
int _save_preferences(struct _preferences* p);

#endif /* SRCINST_PREFERENCES_H */


