/* Source Installer, Copyright (c) 2006 Claudio Fontana

 mf_features.c - makefile features

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "src_stdinc.h"
#include "mf_features.h"
#include "actions.h"

struct _makefile_features* _detect_makefile_features(void) {
  int rv;
  char* makefile;
  struct _makefile_features* mf;

  if (!(makefile = _get_makefile()))
    return 0;

  mf = srcinst_malloc(sizeof(struct _makefile_features));
  /* init unnecessary, as it is performed by _test_makefile_features_rec */
    
  rv = _test_makefile_features_rec(mf, makefile);
  mf->makefile = makefile;

  if (!rv) {
    _free_makefile_features(mf);
    return 0;
  }
  
  return mf;
}

void _init_makefile_features(struct _makefile_features* mf) {
  mf->makefile = 0;
  mf->features[SRCINST_FEATURE_DESTDIR].pattern = "\\$[({]?DESTDIR[)}]?";
  mf->features[SRCINST_FEATURE_DESTDIR].supported = 0;
  mf->features[SRCINST_FEATURE_INSTALL_ROOT].pattern = "\\$[({]?INSTALL_ROOT[)}]?";
  mf->features[SRCINST_FEATURE_INSTALL_ROOT].supported = 0;
  mf->features[SRCINST_FEATURE_UNINSTALL].pattern = "uninstall *:";
  mf->features[SRCINST_FEATURE_UNINSTALL].supported = 0;
  mf->features[SRCINST_FEATURE_STRIP].pattern = "install-strip *:";
  mf->features[SRCINST_FEATURE_STRIP].supported = 0;
}

int _test_makefile_features(struct _makefile_features* mf, char* mfile) {
  int i; FILE* m; off_t m_size;
  char* buffer;
  
  _init_makefile_features(mf);

  if ((m_size = srcinst_file_size(mfile)) == (off_t) -1) {
    return 0;
  }

  buffer = srcinst_malloc(m_size + 1);

  if (!(m = fopen(mfile, "r")))
    { free(buffer); return 0; }
    
  if ((fread(buffer, 1, m_size, m)) != m_size)
    { free(buffer); fclose(m); return 0; }

  fclose(m); buffer[m_size] = 0;

  for (i = 0; i < SRCINST_FEATURE_N; i++) {
    SRCINST_REGEX preg;
    preg = srcinst_init_regex(mf->features[i].pattern, -1);
    mf->features[i].supported = srcinst_exec_regex(preg, buffer, 0);
    srcinst_free_regex(preg);
  }
  
  free(buffer);
  return 1;
}

int _test_makefile_features_rec(struct _makefile_features* mf, char* makefile) {

  if (!(_test_makefile_features(mf, makefile)))
    return 0;

  if (!mf->features[SRCINST_FEATURE_DESTDIR].supported &&
      !mf->features[SRCINST_FEATURE_INSTALL_ROOT].supported) {
    struct srcinst_string_list makefiles;
    char* makefile_names[2];

    srcinst_init_string_list(&makefiles);
    makefile_names[0] = makefile; makefile_names[1] = 0;
    
    if (_find_files_aux(&makefiles, ".", makefile_names)) {
      struct _makefile_features mf2; int i;
      
      for (i = 0; i < makefiles.count; i++) {
	if (!_test_makefile_features(&mf2, makefiles.strings[i]))
	  break;
	if (mf2.features[SRCINST_FEATURE_DESTDIR].supported)
	  { mf->features[SRCINST_FEATURE_DESTDIR].supported = 1; break; }
	if (mf2.features[SRCINST_FEATURE_INSTALL_ROOT].supported)
	  { mf->features[SRCINST_FEATURE_INSTALL_ROOT].supported = 1; break; }
      }
    }
    srcinst_free_string_list(&makefiles);
  }
  return 1;
}

void _free_makefile_features(struct _makefile_features* mf) {

  if (mf->makefile)
    { free(mf->makefile); mf->makefile = 0; }
  
  free(mf);
}


