#ifndef Threads_H
#define Threads_H

#include "RTETypes.h"
#include "events.h"

#define DEFAULT_PRIORITY 1  /* The default priority */

/* Global Functions for the threading system */

/*
  Initialize_Threads
  
  This function must be called before any of the other threading
  functions are called. It 'boots' the cpu up to the threading
  mechanisim.
  
 */
void Initialize_Threads();

/*
  Create_Thread

  This function creates a new threads, in the address space of the current
  system. The priority defines which order the threads are run, eg higher
  priorities are always run before lower priority threads. The start point
  is the address of a function which the thread will start on.

 */
Handle Create_Thread(int priority, int processor, 
		     void (*StartPoint) (void));

/*
  Suspend

  This function suspends the current thread, allowing for other threads
  to use the cpu. If there are no other (important) threads then it
  will simply return to the currently executing thread.

 */

void Suspend();
/*
 * Wait
 *
 * This function suspends the current thread until the specified event
 * occurs, at which time the event is returned to the queue.
 * */
void Wait( EventID event );

#endif
