/*
 *  Queue load balancing system
 *  $Revision: 1.2 $
 *
 *  Copyright (C) 1998 Werner G. Krebs
 *  
 *
 *  werner.krebs@yale.edu 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  If you make modifications to the source, I would be happy to have
 *  them to include in future releases.  Feel free to send them to:
 *      Werner G. Krebs	      				
 *	werner.krebs@yale.edu
 *
 **************************************************************************/


#include "queue.h"

#define min(a,b) (a < b ? a : b)


void donothing(){} /*Signal handler.*/



int compar_wk(struct wkstruct *one, struct wkstruct *two) {
if (one->load == two->load) return(0);
return( (one->load < two->load ? -1 : 1));
}

/*Wake up daemon if sleeping*/
int w_fd;

int con_daemon(char *hostname)
{int count=0;
 int status,w_fd;
struct sockaddr_in hello, *incoming;

struct hostent *myhost;
int len;
 bzero((char *) &hello, sizeof(hello));
/*hello.sin_addr.s_addr = htonl( 0 |127 >> IN_CLASSA_NSHIFT |  0 >> IN_CLASSB_NSHIFT| 0 >> IN_CLASSC_NSHIFT |  1 >> IN_CLASSD_NSHIFT); */
hello.sin_port = htons(WAKEUP_PORT);

/*printf("Connecting to %s\n",hostname);*/

myhost = gethostbyname(hostname);
if(myhost==0) {
  perror("gethostbyname");
  exit(2);
}
bcopy(myhost->h_addr_list[0], (caddr_t) &hello.sin_addr,myhost->h_length);
hello.sin_family = myhost->h_addrtype;

/* We try to connect five times to prevent an overloaded system from
keeping us down.*/
 again:
if((w_fd = socket(AF_INET,SOCK_STREAM,0))<0) {
  perror("socket");
  exit(2);
}
 status = connect(w_fd,(const void*) &hello,sizeof(hello));
 if(status <0) {
   if(count < 5) {
/*     sleep(1);*/
     count++;
        close(w_fd);
     goto again;
   }
   perror("con_daemon: connect");
   fprintf(stderr,"QueueD down on %s?\n",hostname);
   close(w_fd);
   return(0);
 }
close(w_fd);
return(1);
}

float getrldavg(char *hostname, char *queuename)
{int count=0;
 int status,w_fd;
struct sockaddr_in hello, *incoming;
float load;
FILE *argh;

struct hostent *myhost;
int len;
 bzero((char *) &hello, sizeof(hello));
/*hello.sin_addr.s_addr = htonl( 0 |127 >> IN_CLASSA_NSHIFT |  0 >> IN_CLASSB_NSHIFT| 0 >> IN_CLASSC_NSHIFT |  1 >> IN_CLASSD_NSHIFT); */
hello.sin_port = htons(QUERY_PORT);

myhost = gethostbyname(hostname);
if(myhost==0) {
  perror("gethostbyname");
  exit(2);
}
bcopy(myhost->h_addr_list[0], (caddr_t) &hello.sin_addr,myhost->h_length);
hello.sin_family = myhost->h_addrtype;

/* We try to connect five times to prevent an overloaded system from
keeping us down.*/
 again2:
if((w_fd = socket(AF_INET,SOCK_STREAM,0))<0) {
  perror("socket");
  exit(2);
}
 again:
 status = connect(w_fd,(const void*) &hello,sizeof(hello));
 if(status <0) {
#if 0
   /* doesn't work, w_fd is in error state and cannot be reused anyway. */
   if(count < 1) {
     sleep(1);
     count++;
     goto again;
   }
#endif
   perror("getrldavg: connect");
   fprintf(stderr,"QueueD down on %s?\n",hostname);
   close(w_fd);
   return(1e08);
 }

/*WK: Quick hack to get queueload from other host.*/

argh = fdopen(w_fd,"r+");
fprintf(argh,"%s\n",queuename);
fflush(argh);
load = 1e09;
/*SIGALRM will interrupt the fread.*/
signal(SIGALRM,donothing);
alarm(5);
fread(&load,sizeof(load),1,argh);
alarm(0);
fclose(argh);
 close(w_fd); /*Make sure it is closed.*/
if(load == 1e09) {
  count++;
  if(count < 5) goto again2;
}
/*printf("%s returned load %f\n",hostname,load);*/
return(load);
}

int wakeup(queuename)
char *queuename;
{
int status;
char buf[255];
FILE* message;
register int i;

sethostent(1);
for (i=0;i<NHosts;++i) {
  Hosts[i].load = getrldavg(Hosts[i].host,queuename);
}
qsort(Hosts,NHosts,sizeof(struct wkstruct),compar_wk);

con_daemon(Hosts[0].host);
sleep(1);
for (i=1;i<NHosts;++i) {
  con_daemon(Hosts[i].host);
}
endhostent();
return(0);
}


