/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.OptionInfo;
import gnu.text.SourceMessages;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Options {
    public static final int BOOLEAN_OPTION = 1;
    public static final int STRING_OPTION = 2;
    Options previous;
    OptionInfo first;
    OptionInfo last;
    Hashtable valueTable;
    Hashtable infoTable;
    public static final String UNKNOWN = "unknown option name";

    public Options() {
    }

    public Options(Options options) {
        this.previous = options;
    }

    public void add(String string, int n, String string2) {
        if (this.infoTable == null) {
            this.infoTable = new Hashtable();
        } else if (this.infoTable.get(string) != null) {
            throw new RuntimeException("duplicate option key: " + string);
        }
        OptionInfo optionInfo = new OptionInfo();
        optionInfo.key = string;
        optionInfo.kind = n;
        optionInfo.documentation = string2;
        if (this.first == null) {
            this.first = optionInfo;
        } else {
            this.last.next = optionInfo;
        }
        this.last = optionInfo;
        this.infoTable.put(string, optionInfo);
    }

    static Object valueOf(OptionInfo optionInfo, String string) {
        if ((optionInfo.kind & 1) != 0) {
            if (string == null || string.equals("1") || string.equals("on") || string.equals("yes") || string.equals("true")) {
                return Boolean.TRUE;
            }
            if (string.equals("0") || string.equals("off") || string.equals("no") || string.equals("false")) {
                return Boolean.FALSE;
            }
            return null;
        }
        return string;
    }

    private void error(String string, SourceMessages sourceMessages) {
        if (sourceMessages == null) {
            throw new RuntimeException(string);
        }
        sourceMessages.error('e', string);
    }

    public void set(String string, Object object2) {
        this.set(string, object2, null);
    }

    public void set(String string, Object object2, SourceMessages sourceMessages) {
        OptionInfo optionInfo = this.getInfo(string);
        if (optionInfo == null) {
            this.error("invalid option key: " + string, sourceMessages);
            return;
        }
        if ((optionInfo.kind & 1) != 0) {
            if (object2 instanceof String) {
                object2 = Options.valueOf(optionInfo, (String)object2);
            }
            if (!(object2 instanceof Boolean)) {
                this.error("value for option " + string + " must be boolean or yes/no/true/false/on/off/1/0", sourceMessages);
                return;
            }
        } else if (object2 == null) {
            object2 = "";
        }
        if (this.valueTable == null) {
            this.valueTable = new Hashtable();
        }
        this.valueTable.put(string, object2);
    }

    public void reset(String string, Object object2) {
        if (this.valueTable == null) {
            this.valueTable = new Hashtable();
        }
        if (object2 == null) {
            this.valueTable.remove(string);
        } else {
            this.valueTable.put(string, object2);
        }
    }

    public String set(String string, String string2) {
        OptionInfo optionInfo = this.getInfo(string);
        if (optionInfo == null) {
            return UNKNOWN;
        }
        Object object2 = Options.valueOf(optionInfo, string2);
        if (object2 == null && (optionInfo.kind & 1) != 0) {
            return "value of option " + string + " must be yes/no/true/false/on/off/1/0";
        }
        if (this.valueTable == null) {
            this.valueTable = new Hashtable();
        }
        this.valueTable.put(string, object2);
        return null;
    }

    public OptionInfo getInfo(String string) {
        OptionInfo optionInfo;
        OptionInfo optionInfo2 = optionInfo = this.infoTable == null ? null : (OptionInfo)this.infoTable.get(string);
        if (optionInfo == null && this.previous != null) {
            optionInfo = this.previous.getInfo(string);
        }
        return optionInfo;
    }

    public Object get(String string, Object object2) {
        Object var3_3;
        Object v0 = var3_3 = this.valueTable == null ? null : this.valueTable.get(string);
        if (var3_3 != null) {
            return var3_3;
        }
        if (this.previous != null) {
            return this.previous.get(string, object2);
        }
        OptionInfo optionInfo = this.getInfo(string);
        if (optionInfo == null) {
            throw new RuntimeException("invalid option key: " + string);
        }
        return object2;
    }

    public Object getLocal(String string) {
        return this.valueTable == null ? null : this.valueTable.get(string);
    }

    public boolean getBoolean(String string) {
        return (Boolean)this.get(string, Boolean.FALSE);
    }

    public boolean getBoolean(String string, boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        return (Boolean)this.get(string, bl2);
    }

    public void pushOptionValues(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2++);
            Object e = vector.elementAt(n2);
            vector.setElementAt(e, n2++);
            this.set(string, vector.elementAt(n2++));
        }
    }

    public void popOptionValues(Vector vector) {
        int n = vector.size();
        while ((n -= 3) >= 0) {
            String string = (String)vector.elementAt(n);
            Object e = vector.elementAt(n + 1);
            vector.setElementAt(null, n + 1);
            this.reset(string, e);
        }
    }

    public Vector keys() {
        Vector vector = new Vector();
        Options options = this;
        while (options != null) {
            if (options.infoTable != null) {
                Enumeration enumeration = options.infoTable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    if (vector.contains(k)) continue;
                    vector.add(k);
                }
            }
            options = options.previous;
        }
        return vector;
    }

    public String getDoc(String string) {
        OptionInfo optionInfo = this.getInfo(string);
        if (string == null) {
            return null;
        }
        return optionInfo.documentation;
    }
}

