/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.kawa.reflect.OccurrenceType;
import gnu.mapping.Values;

public class SingletonType
extends ObjectType {
    static final SingletonType instance = new SingletonType("singleton");

    public SingletonType(String string) {
        super(string);
    }

    public static final SingletonType getInstance() {
        return instance;
    }

    public Class getReflectClass() {
        return this.getImplementationType().getReflectClass();
    }

    public Type getImplementationType() {
        return Type.pointer_type;
    }

    public int compare(Type type) {
        int n = OccurrenceType.itemCountRange(type);
        int n2 = n & 0xFFF;
        int n3 = n >> 12;
        if (n3 == 0 || n2 > 1) {
            return -3;
        }
        if (n2 == 1 && n3 == 1) {
            return Type.pointer_type.compare(type);
        }
        int n4 = Type.pointer_type.compare(type);
        if (n4 == 0 || n4 == -1) {
            return -1;
        }
        return -2;
    }

    public static Object coerceToSingleton(Object object2) {
        if (object2 instanceof Values) {
            object2 = ((Values)object2).canonicalize();
        }
        if (object2 == null || object2 instanceof Values) {
            throw new ClassCastException("value is not a singleton");
        }
        return object2;
    }

    public Object coerceFromObject(Object object2) {
        return SingletonType.coerceToSingleton(object2);
    }

    public void emitCoerceFromObject(CodeAttr codeAttr) {
        codeAttr.emitInvokeStatic(ClassType.make("gnu.kawa.reflect.SingletonType").getDeclaredMethod("coerceToSingleton", 1));
    }

    public boolean isInstance(Object object2) {
        return object2 != null && !(object2 instanceof Values);
    }
}

