/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel.generated;

import gnu.jel.debug.Debug;
import java.io.EOFException;
import java.io.IOException;

public class CharStream {
    private String expr;
    private int[] bufline;
    private int[] bufcolumn;
    private int pos = -1;
    private int tokenpos = -1;

    public CharStream(String expr) {
        this.expr = expr;
        this.bufline = new int[expr.length() + 1];
        this.bufcolumn = new int[expr.length() + 1];
        int column = 0;
        int line = 1;
        boolean prevCharIsCR = false;
        boolean prevCharIsLF = false;
        int i = 0;
        while (i < expr.length()) {
            char c = expr.charAt(i);
            ++column;
            if (prevCharIsLF) {
                prevCharIsLF = false;
                column = 1;
                ++line;
            } else if (prevCharIsCR) {
                prevCharIsCR = false;
                if (c == '\n') {
                    prevCharIsLF = true;
                } else {
                    column = 1;
                    ++line;
                }
            }
            switch (c) {
                case '\r': {
                    prevCharIsCR = true;
                    break;
                }
                case '\n': {
                    prevCharIsLF = true;
                    break;
                }
                case '\t': {
                    --column;
                    column += 8 - (column & 7);
                    break;
                }
            }
            this.bufline[i] = line;
            this.bufcolumn[i] = column;
            ++i;
        }
    }

    public char readChar() throws IOException {
        try {
            return this.expr.charAt(++this.pos);
        }
        catch (IndexOutOfBoundsException e) {
            if (this.pos > 0) {
                --this.pos;
            } else {
                this.tokenpos = this.pos;
            }
            throw new EOFException();
        }
    }

    public int getEndColumn() {
        return this.bufcolumn[this.pos];
    }

    public int getEndLine() {
        return this.bufline[this.pos];
    }

    public int getBeginColumn() {
        return this.bufcolumn[this.tokenpos];
    }

    public int getBeginLine() {
        return this.bufline[this.tokenpos];
    }

    public void backup(int amount) {
        Debug.assert(this.pos - this.tokenpos + 1 >= amount);
        this.pos -= amount;
    }

    public char BeginToken() throws IOException {
        char c = this.readChar();
        this.tokenpos = this.pos;
        return c;
    }

    public String GetImage() {
        return this.expr.substring(this.tokenpos, this.pos + 1);
    }

    public char[] GetSuffix(int len) {
        return this.expr.substring(this.tokenpos, this.tokenpos + len).toCharArray();
    }

    public void Done() {
    }
}

