/*
   NSDPSContextOps - Translate method calls to PS ops.

   Copyright (C) 1999 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@boulder.colorado.edu>
   Date: Apr 1999

   This file is part of the GNU Objective C User Interface Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

#include <math.h>
#include <gnustep/xdps/NSDPSContextWindow.h>
#include <DPS/psops.h>
#include "SharedX/xrtools.h"
#include "extensions.h"

#define XDPY (((RContext *)context)->dpy)
#define XSCR (((RContext *)context)->screen_number)

@implementation NSDPSContext (Ops)

/* ----------------------------------------------------------------------- */
/* Color operations */
/* ----------------------------------------------------------------------- */
- (void)DPScurrentblackgeneration
{
  PScurrentblackgeneration();
}

- (void)DPScurrentcmykcolor: (float *)c : (float *)m : (float *)y : (float *)k 
{
  PScurrentcmykcolor(c, m, y, k);
}

- (void)DPScurrentcolorscreen
{
  PScurrentcolorscreen();
}

- (void)DPScurrentcolortransfer
{
  PScurrentcolortransfer();
}

- (void)DPScurrentundercolorremoval
{
  PScurrentundercolorremoval();
}

- (void)DPSsetblackgeneration
{
  PSsetblackgeneration();
}

- (void)DPSsetcmykcolor: (float)c : (float)m : (float)y : (float)k 
{
  PSsetcmykcolor(c, m, y, k);
}

- (void)DPSsetcolorscreen
{
  PSsetcolorscreen();
}

- (void)DPSsetcolortransfer
{
  PSsetcolortransfer();
}

- (void)DPSsetundercolorremoval
{
  PSsetundercolorremoval();
}

/* ----------------------------------------------------------------------- */
/* Data operations */
/* ----------------------------------------------------------------------- */
- (void)DPSclear
{
  PSclear();
}

- (void)DPScleartomark
{
  PScleartomark();
}

- (void)DPScopy: (int)n
{
  PScopy(n);
}

- (void)DPScount: (int *)n
{
  PScount(n);
}

- (void)DPScounttomark: (int *)n
{
  PScounttomark(n);
}

- (void)DPSdup
{
  PSdup();
}

- (void)DPSexch
{
  PSexch();
}

- (void)DPSexecstack
{
  PSexecstack();
}

- (void)DPSget
{
  PSget();
}

- (void)DPSindex: (int)i
{
  PSindex(i);
}

- (void)DPSmark
{
  PSmark();
}

- (void)DPSmatrix
{
  PSmatrix();
}

- (void)DPSnull
{
  PSnull();
}

- (void)DPSpop
{
  PSpop();
}

- (void)DPSput
{
  PSput();
}

- (void)DPSroll: (int)n : (int)j
{
  PSroll(n, j);
}

/* ----------------------------------------------------------------------- */
/* Font operations */
/* ----------------------------------------------------------------------- */
- (void)DPSFontDirectory
{
  PSFontDirectory();
}

- (void)DPSISOLatin1Encoding
{
  PSISOLatin1Encoding();
}

- (void)DPSSharedFontDirectory
{
  PSSharedFontDirectory();
}

- (void)DPSStandardEncoding
{
  PSStandardEncoding();
}

- (void)DPScachestatus: (int *)bsize : (int *)bmax : (int *)msize 
{
  //PScachestatus();
}

- (void)DPScurrentcacheparams
{
  PScurrentcacheparams();
}

- (void)DPScurrentfont
{
  PScurrentfont();
}

- (void)DPSdefinefont
{
  PSdefinefont();
}

- (void)DPSfindfont: (const char *)name 
{
  PSfindfont(name);
}

- (void)DPSmakefont
{
  PSmakefont();
}

- (void)DPSscalefont: (float)size 
{
  PSscalefont(size);
}

- (void)DPSselectfont: (const char *)name : (float)scale 
{
  PSselectfont(name, scale);
}

- (void)DPSsetcachedevice: (float)wx : (float)wy : (float)llx : (float)lly : (float)urx : (float)ury 
{
  PSsetcachedevice(wx, wy, llx, lly, urx, ury);
}

- (void)DPSsetcachelimit: (float)n 
{
  PSsetcachelimit(n);
}

- (void)DPSsetcacheparams
{
  PSsetcacheparams();
}

- (void)DPSsetcharwidth: (float)wx : (float)wy 
{
  PSsetcharwidth(wx, wy);
}

- (void)DPSsetfont: (int)f 
{
  PSsetfont(f);
}

- (void)DPSundefinefont: (const char *)name 
{
  PSundefinefont(name);
}

/* ----------------------------------------------------------------------- */
/* Gstate operations */
/* ----------------------------------------------------------------------- */
- (void)DPSconcat: (const float *)m
{
  PSconcat(m);
}

- (void)DPScurrentdash
{
  PScurrentdash();
}

- (void)DPScurrentflat: (float *)flatness 
{
  PScurrentflat(flatness);
}

- (void)DPScurrentgray: (float *)gray 
{
  PScurrentgray(gray);
}

- (void)DPScurrentgstate: (int)gst 
{
  PScurrentgstate(gst);
}

- (void)DPScurrenthalftone
{
  PScurrenthalftone();
}

- (void)DPScurrenthalftonephase: (float *)x : (float *)y 
{
  PScurrenthalftonephase(x, y);
}

- (void)DPScurrenthsbcolor: (float *)h : (float *)s : (float *)b 
{
  PScurrenthsbcolor(h, s, b);
}

- (void)DPScurrentlinecap: (int *)linecap 
{
  PScurrentlinecap(linecap);
}

- (void)DPScurrentlinejoin: (int *)linejoin 
{
  PScurrentlinejoin(linejoin);
}

- (void)DPScurrentlinewidth: (float *)width 
{
  PScurrentlinewidth(width);
}

- (void)DPScurrentmatrix
{
  PScurrentmatrix();
}

- (void)DPScurrentmiterlimit: (float *)limit 
{
  PScurrentmiterlimit(limit);
}

- (void)DPScurrentpoint: (float *)x : (float *)y 
{
  PScurrentpoint(x, y);
}

- (void)DPScurrentrgbcolor: (float *)r : (float *)g : (float *)b 
{
  PScurrentrgbcolor(r, g, b);
}

- (void)DPScurrentscreen
{
  PScurrentscreen();
}

- (void)DPScurrentstrokeadjust: (int *)b 
{
  PScurrentstrokeadjust(b);
}

- (void)DPScurrenttransfer
{
  PScurrenttransfer();
}

- (void)DPSdefaultmatrix
{
  PSdefaultmatrix();
}

- (void)DPSgrestore
{
  PSgrestore();
}

- (void)DPSgrestoreall
{
  PSgrestoreall();
}

- (void)DPSgsave
{
  PSgsave();
}

- (void)DPSgstate
{
  PSgstate();
}

- (void)DPSinitgraphics
{
  PSinitgraphics();
}

- (void)DPSinitmatrix
{
  PSinitmatrix();
}

- (void)DPSrotate: (float)angle 
{
  PSrotate(angle);
}

- (void)DPSscale: (float)x : (float)y 
{
  PSscale(x, y);
}

- (void)DPSsetdash: (const float *)pat : (int)size : (float)offset 
{
  PSsetdash(pat, size, offset);
}

- (void)DPSsetflat: (float)flatness 
{
  PSsetflat(flatness);
}

- (void)DPSsetgray: (float)gray 
{
  PSsetgray(gray);
}

- (void)DPSsetgstate: (int)gst 
{
  PSsetgstate(gst);
}

- (void)DPSsethalftone
{
  PSsethalftone();
}

- (void)DPSsethalftonephase: (float)x : (float)y 
{
  PSsethalftonephase(x, y);
}

- (void)DPSsethsbcolor: (float)h : (float)s : (float)b 
{
  PSsethsbcolor(h, s, b);
}

- (void)DPSsetlinecap: (int)linecap 
{
  PSsetlinecap(linecap);
}

- (void)DPSsetlinejoin: (int)linejoin 
{
  PSsetlinejoin(linejoin);
}

- (void)DPSsetlinewidth: (float)width 
{
  PSsetlinewidth(width);
}

- (void)DPSsetmatrix
{
  PSsetmatrix();
}

- (void)DPSsetmiterlimit: (float)limit 
{
  PSsetmiterlimit(limit);
}

- (void)DPSsetrgbcolor: (float)r : (float)g : (float)b 
{
  PSsetrgbcolor(r, g, b);
}

- (void)DPSsetscreen
{
  PSsetscreen();
}

- (void)DPSsetstrokeadjust: (int)b 
{
  PSsetstrokeadjust(b);
}

- (void)DPSsettransfer
{
  PSsettransfer();
}

- (void)DPStranslate: (float)x : (float)y 
{
  PStranslate(x, y);
}

/* ----------------------------------------------------------------------- */
/* I/O operations */
/* ----------------------------------------------------------------------- */
- (void)DPSflush
{
  PSflush();
}

/* ----------------------------------------------------------------------- */
/* Matrix operations */
/* ----------------------------------------------------------------------- */
- (void)DPSconcatmatrix
{
  PSconcatmatrix();
}

- (void)DPSdtransform: (float)x1 : (float)y1 : (float *)x2 : (float *)y2 
{
  PSdtransform(x1, y1, x2, y2);
}

- (void)DPSidentmatrix
{
  PSidentmatrix();
}

- (void)DPSidtransform: (float)x1 : (float)y1 : (float *)x2 : (float *)y2 
{
  PSidtransform(x1, y1, x2, y2);
}

- (void)DPSinvertmatrix
{
  PSinvertmatrix();
}

- (void)DPSitransform: (float)x1 : (float)y1 : (float *)x2 : (float *)y2 
{
  PSitransform(x1, y1, x2, y2);
}

- (void)DPStransform: (float)x1 : (float)y1 : (float *)x2 : (float *)y2 
{
  PStransform(x1, y1, x2, y2);
}

/* ----------------------------------------------------------------------- */
/* Opstack operations */
/* ----------------------------------------------------------------------- */

- (void)DPSdefineuserobject
{
  PSdefineuserobject();
}

- (void)DPSexecuserobject: (int)index
{
  PSexecuserobject(index);
}

- (void)DPSundefineuserobject: (int)index
{
  PSundefineuserobject(index);
}

- (void)DPSgetboolean: (int *)it 
{
  PSgetboolean(it);
}

- (void)DPSgetchararray: (int)size : (char *)s 
{
  PSgetchararray(size, s);
}

- (void)DPSgetfloat: (float *)it 
{
  PSgetfloat(it);
}

- (void)DPSgetfloatarray: (int)size : (float *)a 
{
  PSgetfloatarray(size, a);
}

- (void)DPSgetint: (int *)it 
{
  PSgetint(it);
}

- (void)DPSgetintarray: (int)size : (int *)a 
{
  PSgetintarray(size, a);
}

- (void)DPSgetstring: (char *)s 
{
  PSgetstring(s);
}

- (void)DPSsendboolean: (int)it 
{
  PSsendboolean(it);
}

- (void)DPSsendchararray: (const char *)s : (int)size 
{
  PSsendchararray(s, size);
}

- (void)DPSsendfloat: (float)it 
{
  PSsendfloat(it);
}

- (void)DPSsendfloatarray: (const float *)a : (int)size 
{
  PSsendfloatarray(a, size);
}

- (void)DPSsendint: (int)it 
{
  PSsendint(it);
}

- (void)DPSsendintarray: (const int *)a : (int)size 
{
  PSsendintarray(a, size);
}

- (void)DPSsendstring: (const char *)s 
{
  PSsendstring(s);
}

/* ----------------------------------------------------------------------- */
/* Paint operations */
/* ----------------------------------------------------------------------- */
- (void)DPSashow: (float)x : (float)y : (const char *)s 
{
  PSashow(x, y, s);
}

- (void)DPSawidthshow: (float)cx : (float)cy : (int)c : (float)ax : (float)ay : (const char *)s 
{
  PSawidthshow(cx, cy, c, ax, ay, s);
}

- (void)DPScopypage
{
  PScopypage();
}

- (void)DPSeofill
{
  PSeofill();
}

- (void)DPSerasepage
{
  PSerasepage();
}

- (void)DPSfill
{
  PSfill();
}

- (void)DPSimage
{
  PSimage();
}

- (void)DPSimagemask
{
  PSimagemask();
}

- (void)DPScolorimage
{
  PScolorimage();
}

- (void)DPSalphaimage
{
  if (ext_flags & ALPHAIMAGE_EXT)
    PSWalphaimage();
  else
    NSDebugLLog(@"NSDPSContext", @"DPS does not support alphaimage op\n");
}

- (void)DPSkshow: (const char *)s 
{
  PSkshow(s);
}

- (void)DPSrectfill: (float)x : (float)y : (float)w : (float)h 
{
  PSrectfill(x, y, w, h);
}

- (void)DPSrectstroke: (float)x : (float)y : (float)w : (float)h 
{
  PSrectstroke(x, y, w, h);
}

- (void)DPSshow: (const char *)s 
{
  PSshow(s);
}

- (void)DPSshowpage
{
  PSshowpage();
}

- (void)DPSstroke
{
  PSstroke();
}

- (void)DPSstrokepath
{
  PSstrokepath();
}

- (void)DPSueofill: (const char *)nums : (int)n : (const char *)ops : (int)l 
{
  PSueofill(nums, n, ops, l);
}

- (void)DPSufill: (const char *)nums : (int)n : (const char *)ops : (int)l 
{
  PSufill(nums, n, ops, l);
}

- (void)DPSustroke: (const char *)nums : (int)n : (const char *)ops : (int)l 
{
  PSustroke(nums, n, ops, l);
}

- (void)DPSustrokepath: (const char *)nums : (int)n : (const char *)ops : (int)l 
{
  PSustrokepath(nums, n, ops, l);
}

- (void)DPSwidthshow: (float)x : (float)y : (int)c : (const char *)s 
{
  PSwidthshow(x, y, c, s);
}

- (void)DPSxshow: (const char *)s : (const float *)numarray : (int)size 
{
  PSxshow(s, numarray, size);
}

- (void)DPSxyshow: (const char *)s : (const float *)numarray : (int)size 
{
  PSxyshow(s, numarray, size);
}

- (void)DPSyshow: (const char *)s : (const float *)numarray : (int)size 
{
  PSyshow(s, numarray, size);
}

/* ----------------------------------------------------------------------- */
/* Path operations */
/* ----------------------------------------------------------------------- */
- (void)DPSarc: (float)x : (float)y : (float)r : (float)angle1 : (float)angle2 
{
  PSarc(x, y, r, angle1, angle2);
}

- (void)DPSarcn: (float)x : (float)y : (float)r : (float)angle1 : (float)angle2 
{
  PSarcn(x, y, r, angle1, angle2);
}

- (void)DPSarct: (float)x1 : (float)y1 : (float)x2 : (float)y2 : (float)r 
{
  PSarct(x1, y1, x2, y2, r);
}

- (void)DPSarcto: (float)x1 : (float)y1 : (float)x2 : (float)y2 : (float)r : (float *)xt1 : (float *)yt1 : (float *)xt2 : (float *)yt2 
{
  PSarcto(x1, y1, x2, y2, r, xt1, yt1, xt2, yt2);
}

- (void)DPScharpath: (const char *)s : (int)b 
{
  PScharpath(s, b);
}

- (void)DPSclip
{
  PSclip();
}

- (void)DPSclippath
{
  PSclippath();
}

- (void)DPSclosepath
{
  PSclosepath();
}

- (void)DPScurveto: (float)x1 : (float)y1 : (float)x2 : (float)y2 : (float)x3 : (float)y3 
{
  PScurveto(x1, y1, x2, y2, x3, y3);
}

- (void)DPSeoclip
{
  PSeoclip();
}

- (void)DPSeoviewclip
{
  PSeoviewclip();
}

- (void)DPSflattenpath
{
  PSflattenpath();
}

- (void)DPSinitclip
{
  PSinitclip();
}

- (void)DPSinitviewclip
{
  PSinitviewclip();
}

- (void)DPSlineto: (float)x : (float)y 
{
  PSlineto(x, y);
}

- (void)DPSmoveto: (float)x : (float)y 
{
  PSmoveto(x, y);
}

- (void)DPSnewpath
{
  PSnewpath();
}

- (void)DPSpathbbox: (float *)llx : (float *)lly : (float *)urx : (float *)ury 
{
  PSpathbbox(llx, lly, urx, ury);
}

- (void)DPSpathforall
{
  PSpathforall();
}

- (void)DPSrcurveto: (float)x1 : (float)y1 : (float)x2 : (float)y2 : (float)x3 : (float)y3 
{
  PSrcurveto(x1, y1, x2, y2, x3, y3);
}

- (void)DPSrectclip: (float)x : (float)y : (float)w : (float)h 
{
  PSrectclip(x, y, w, h);
}

- (void)DPSrectviewclip: (float)x : (float)y : (float)w : (float)h 
{
  PSrectviewclip(x, y, w, h);
}

- (void)DPSreversepath
{
  PSreversepath();
}

- (void)DPSrlineto: (float)x : (float)y 
{
  PSrlineto(x, y);
}

- (void)DPSrmoveto: (float)x : (float)y 
{
  PSrmoveto(x, y);
}

- (void)DPSsetbbox: (float)llx : (float)lly : (float)urx : (float)ury 
{
  PSsetbbox(llx, lly, urx, ury);
}

- (void)DPSsetucacheparams
{
  PSsetucacheparams();
}

- (void)DPSuappend: (const char *)nums : (int)n : (char *)ops : (int)l 
{
  PSuappend(nums, n, ops, l);
}

- (void)DPSucache
{
  PSucache();
}

- (void)DPSucachestatus
{
  PSucachestatus();
}

- (void)DPSupath: (int)b 
{
  PSupath(b);
}

- (void)DPSviewclip
{
  PSviewclip();
}

- (void)DPSviewclippath
{
  PSviewclippath();
}

/* ----------------------------------------------------------------------- */
/* X operations */
/* ----------------------------------------------------------------------- */
- (void)DPScurrentXdrawingfunction: (int *)function 
{
  PScurrentXdrawingfunction(function);
}

- (void)DPScurrentXgcdrawable: (int *)gc : (int *)draw : (int *)x : (int *)y 
{
  PScurrentXgcdrawable(gc, draw, x, y);
}

- (void)DPScurrentXgcdrawablecolor: (int *)gc : (int *)draw : (int *)x : (int *)y 
				      : (const int *)colorInfo
{
  PScurrentXgcdrawablecolor(gc, draw, x, y, colorInfo);
}

- (void)DPScurrentXoffset: (int *)x : (int *)y 
{
  PScurrentXoffset(x, y);
}

- (void)DPSsetXdrawingfunction: (int)function 
{
  PSsetXdrawingfunction(function);
}

- (void)DPSsetXgcdrawable: (int)gc : (int)draw : (int)x : (int)y 
{
  PSsetXgcdrawable(gc, draw, x, y);
}

- (void)DPSsetXgcdrawablecolor: (int)gc : (int)draw : (int)x : (int)y 
				  : (const int *)colorInfo
{
  PSsetXgcdrawablecolor(gc, draw, x, y, colorInfo);
}

- (void)DPSsetXoffset: (short int)x : (short int)y 
{
  PSsetXoffset(x, y);
}

- (void)DPSsetXrgbactual: (double)r : (double)g : (double)b : (int *)success 
{
  PSsetXrgbactual(r, g, b, success);
}

- (void)DPSsetgcdrawable: (void *)gc : (void *)draw : (int)x : (int)y 
{
  PSsetXgcdrawable(XGContextFromGC(gc), (int)draw, x, y);
}

- (void)DPSsetgcdrawablecolor: (void *)gc : (void *)draw : (int)x : (int)y 
				  : (const int *)colorInfo
{
  PSsetXgcdrawablecolor(XGContextFromGC(gc), (int)draw, x, y, colorInfo);
}

/*-------------------------------------------------------------------------*/
/* Graphics Extension Ops */
/*-------------------------------------------------------------------------*/
- (void) DPScomposite: (float)x : (float)y : (float)w : (float)h : (int)gstateNum : (float)dx : (float)dy : (int)op
{
  if (ext_flags & COMPOSITE_EXT)
    PSWcomposite(x, y, w, h, gstateNum, dx, dy, op);
  else
    {
      NSRect s = NSMakeRect(x, y, w, h);
      NSPoint d = NSMakePoint(dx, dy);
      NSDebugLLog(@"NSDPSContext", @"DPS does not support composite op\n");
      [self wait];
      NSCopyBits(gstateNum, s, d);
    }
}

- (void) DPScompositerect: (float)x : (float)y : (float)w : (float)h : (int)op
{
  if (ext_flags & COMPOSITERECT_EXT)
    PSWcompositerect(x, y, w, h, op);
  else
    {
      /* Try to emulate this */
      float gray;
      XGCValues gcv;
      NSWindow *window;
      gswindow_device_t *windev;
      
      PScurrentgray(&gray);
      if (fabs(gray - 0.667) < .002)
	PSsetgray(0.333);
      else    
	PSsetrgbcolor(0.121, 0.121, 0);
      
      switch (op)
	{
	case   NSCompositeClear:
	  gcv.function = GXclear;
	  break;
	case   NSCompositeCopy:
	  gcv.function = GXcopy;
	  break;
	case   NSCompositeSourceOver:
	  gcv.function = GXcopy;
	  break;
	case   NSCompositeSourceIn:
	  gcv.function = GXcopy;
	  break;
	case   NSCompositeSourceOut:
	  gcv.function = GXcopy;
	  break;
	case   NSCompositeSourceAtop:
	  gcv.function = GXcopy;
	  break;
	case   NSCompositeDestinationOver:
	  gcv.function = GXcopy;
	  break;
	case   NSCompositeDestinationIn:
	  gcv.function = GXcopy;
	  break;
	case   NSCompositeDestinationOut:
	  gcv.function = GXcopy;
	  break;
	case   NSCompositeDestinationAtop:
	  gcv.function = GXcopy;
	  break;
	case   NSCompositeXOR:
	  gcv.function = GXcopy;
	  break;
	case   NSCompositePlusDarker:
	  gcv.function = GXcopy;
	  break;
	case   NSCompositeHighlight:
	  gcv.function = GXxor;
	  break;
	case   NSCompositePlusLighter:
	  gcv.function = GXcopy;
	  break;
	default:
	  gcv.function = GXcopy;
	  break;
	}
      
      window = [[self focusView] window];
      windev = [NSDPSContext _windowWithTag: [window windowNumber]];
      [self wait];
      XChangeGC(XDPY, windev->gc, GCFunction, &gcv);
      PSrectfill(x, y, w, h);
      [window flushWindow];
      gcv.function = GXcopy;
      XChangeGC(XDPY, windev->gc, GCFunction, &gcv);
      PSsetgray(gray);
    }
}

- (void) DPSdissolve: (float)x : (float)y : (float)w : (float)h : (int)gstateNum
 : (float)dx : (float)dy : (float)delta
{
  if (ext_flags & DISSOLVE_EXT)
    PSWdissolve(x, y, w, h, gstateNum, dx, dy, delta);
  else
    NSDebugLLog(@"NSDPSContext", @"DPS does not support dissolve op\n");
}

- (void) DPSreadimage
{
  if (ext_flags & READIMAGE_EXT)
    PSWreadimage();
  else
    NSDebugLLog(@"NSDPSContext", @"DPS does not support readimage op\n");
}

- (void) DPSsetalpha: (float)a
{
  if (ext_flags & SETALPHA_EXT)
    PSWsetalpha(a);
  else
    NSDebugLLog(@"NSDPSContext", @"DPS does not support setalpha op\n");
}

- (void) DPScurrentalpha: (float *)alpha
{
  if (ext_flags & SETALPHA_EXT)
    PSWcurrentalpha(alpha);
  else
    NSDebugLLog(@"NSDPSContext", @"DPS does not support currentalpha op\n");
}

- (void) DPSflushpage
{
  if (ext_flags & FLUSHPAGE_EXT)
    PSWflushpage();
}

@end
